

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateEntitySetting.sp] ---------- 

--  +===================================================================================================+
--  |		 		 Name:  AppUpdateEntitySetting()
--  | Description:   Support create/update the following entity setting
--  |                - Company property
--  |                - Additional setting at smart client group level
--  |                - Additional setting at client level
--  +===================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateEntitySetting')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateEntitySetting <<<'
	drop procedure AppUpdateEntitySetting
END
IF EXISTS (select * from GxQscripts where name='AppUpdateEntitySetting')
	delete from GxQscripts where name = 'AppUpdateEntitySetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateEntitySetting')
	delete from GXDBVersions where aliasname = 'AppUpdateEntitySetting'
GO
print '... Creating Procedure: AppUpdateEntitySetting'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateEntitySetting
  @xmlString XML OUTPUT,
  @localeId INT = 0
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @errCode INT = 0
	DECLARE @errString	VARCHAR(1024) = '' -- error string
	-- Get entityType
	DECLARE @entityType INT = ISNULL((SELECT ISNULL(ref.value('@entityType', 'INT'), 0) AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest') R ( ref )), 0)
	-- Get entityId
	DECLARE @entityId INT = ISNULL((SELECT ISNULL(ref.value('@entityId', 'INT'), 0) AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest') R ( ref )), 0)
	-- Get company property name
DECLARE @companyPropName NVARCHAR(256) =
ISNULL((SELECT ISNULL(ref.value('@name', 'NVARCHAR(256)'), '') AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/companyProp') R ( ref )), '')
	-- Get registry key name
DECLARE @regName NVARCHAR(256) =
ISNULL((SELECT ISNULL(ref.value('@keyName', 'NVARCHAR(256)'), '') AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/registryKey') R ( ref )), '')
	IF @regName != ''
	BEGIN
		-- Get registry key info
DECLARE @regType NVARCHAR(256) =
ISNULL((SELECT ISNULL(ref.value('@type', 'NVARCHAR(256)'), '') AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/registryKey') R ( ref )), '')
DECLARE @regValue NVARCHAR(256) =
ISNULL((SELECT ISNULL(ref.value('@value', 'NVARCHAR(256)'), '') AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/registryKey') R ( ref )), '')
DECLARE @regRelativePath NVARCHAR(2048) =
ISNULL((SELECT ISNULL(ref.value('@relativepath', 'NVARCHAR(2048)'), '') AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/registryKey') R ( ref )), '')
		DECLARE @regDeleted INT = ISNULL((SELECT ISNULL(ref.value('@deleted', 'INT'), 0) AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/registryKey') R ( ref )), 0)
		DECLARE @regEnabled INT = ISNULL((SELECT ISNULL(ref.value('@enabled', 'INT'), 0) AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/registryKey') R ( ref )), 0)
DECLARE @regComment NVARCHAR(256) =
ISNULL((SELECT ISNULL(ref.value('@comment', 'NVARCHAR(256)'), '') AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/registryKey') R ( ref )), '')
		DECLARE @regHidden INT = ISNULL((SELECT ISNULL(ref.value('@hidden', 'INT'), 0) AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/registryKey') R ( ref )), 0)
	END
	DECLARE @errCodeTable table (errCode int)
IF @entityType = 28 OR @entityType = 3
	BEGIN
		INSERT INTO @errCodeTable
		EXEC AppSetAdditionalSettingsForEntity @entityId, @entityType, @regName, @regRelativePath, @regType, @regValue, @regHidden, @regComment
		SELECT @errCode = errCode FROM @errCodeTable
		IF @errCode = 0
			UPDATE App_AdvanceSettings SET enabled = @regEnabled
				WHERE entityId = @entityId AND keyName = @regName AND entityType = @entityType AND relativePath = @regRelativePath AND type = @regType AND enabled <> @regEnabled
	END
ELSE IF @entityType = 61
	BEGIN
		-- Get company property name
		DECLARE @companyPropValue NVARCHAR(max) =
			ISNULL((SELECT ISNULL(ref.value('@value', 'NVARCHAR(max)'), '') AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/companyProp') R ( ref )), '')
		-- Get company property type
		DECLARE @companyPropType INT = ISNULL((SELECT ISNULL(ref.value('@type', 'INT'), 0) AS name FROM @xmlString.nodes('App_UpdateEntitySettingRequest/companyProp') R ( ref )), 0)
		-- Company property type has to be either 1 (PROPERTY_STRING) or 7 (PROPERTY_INTEGER)
IF @companyPropType = 0 OR (@companyPropType <> 1 AND @companyPropType <> 7)
		BEGIN
SET @errCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO SCRIPT_EXIT
		END
		DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
		MERGE App_CompanyProp AS target
		USING (SELECT @entityId, @companyPropName, @companyPropType, @companyPropValue) AS source (entityId, propName, propType, propValue)
		ON target.componentNameid = source.entityId AND target.attrName = source.propName
		WHEN MATCHED AND target.attrVal <> source.propValue
			THEN UPDATE SET target.attrVal = source.propValue
		WHEN NOT MATCHED
			THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
				 VALUES (@entityId, @companyPropName, @companyPropType, @companyPropValue, @nowTime, 0);
		-- If registry key info is available, then need to add additional setting at smart client group
		IF @regName != ''
		BEGIN
			DECLARE @companyClientGroupId INT = (SELECT CG.id FROM APP_ClientGroup CG
				INNER JOIN App_CompanyProp C ON C.attrValInt = CG.id
WHERE C.componentNameId = @entityId AND C.attrName = 'Associated Smart Client Group' AND C.cs_attrName = CHECKSUM('Associated Smart Client Group') AND C.modified = 0)
			INSERT INTO @errCodeTable
EXEC AppSetAdditionalSettingsForEntity @companyClientGroupId, 28, @regName, @regRelativePath, @regType, @regValue, @regHidden, @regComment
			SELECT @errCode = errCode FROM @errCodeTable
			IF @errCode = 0
				UPDATE App_AdvanceSettings SET enabled = @regEnabled
WHERE entityId = @companyClientGroupId AND keyName = @regName AND entityType = 28 AND relativePath = @regRelativePath AND type = @regType AND enabled <> @regEnabled
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
	IF @errCode <> 0 AND @errString <> ''
	BEGIN
		SET @errString = (SELECT Message FROM EvLocaleMsgs WHERE EvLocaleMsgs.MessageId = @errCode AND [localeId] = @localeId)
	END
	SET @xmlString = ( SELECT
					(
						SELECT @errCode  AS '@errCode', @errString AS '@errorMessage'
							FOR    XML PATH('error'), TYPE
					)
                 FOR XML PATH('App_UpdateEntityPropertyResponse'), TYPE
                )
	SELECT @xmlString
SET NOCOUNT OFF
RETURN @errCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateEntitySetting')
	delete from GxQscripts where name = 'AppUpdateEntitySetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateEntitySetting')
	delete from GXDBVersions where aliasname = 'AppUpdateEntitySetting'
GO

insert into GXDBVersions values(2, 'AppUpdateEntitySetting',  '00000000000000000000', 'AppUpdateEntitySetting', '00000000000000000000')
GO

