

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateEdgeMonitorConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppRefreshUserConfig							|
--	|  Procedure to get all the sync folders and user centric clients configured on a laptop.
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateEdgeMonitorConfig <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateEdgeMonitorConfig')
	drop procedure AppUpdateEdgeMonitorConfig
IF EXISTS (select * from GxQscripts where name='AppUpdateEdgeMonitorConfig')
	delete from GxQscripts where name = 'AppUpdateEdgeMonitorConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateEdgeMonitorConfig')
	delete from GXDBVersions where aliasname = 'AppUpdateEdgeMonitorConfig'
GO
print '... Creating Procedure: AppUpdateEdgeMonitorConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateEdgeMonitorConfig
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN TRY
	DECLARE @rc INT = 0
	DECLARE @errStr nvarchar(max)
	DECLARE @folder INT
	DECLARE @clientName nvarchar(100)
	DECLARE @localUser nvarchar(100)
	DECLARE @configOptions XML
	DECLARE @SyncFolderLocalUserMapping table ( folder INT,clientName nvarchar(100),localUser nvarchar(100) )
	INSERT INTO @SyncFolderLocalUserMapping
	SELECT ref.value('syncWebFolder[1]/@syncWebFolderId', 'INT'),
			ref.value('associatedClients[1]/client[1]/@clientName', 'nvarchar(100)'),
		   ref.value('associatedClients[1]/syncOptions[1]/localUser[1]/@userName','nvarchar(max)')
	FROM
	@i_xmlString.nodes ('App_UpdateEdgeMonitorConfigReq/syncInfo') R(ref)
	--select * from @SyncFolderLocalUserMapping
	-- RECURSIVELY DO THIS FOR NOW. TALK to Aaron to find how this can be modified
	-- Should not be more than 2 per client/laptop
	DECLARE syncUserCursor CURSOR FOR
	SELECT folder, clientName, localUser
	FROM @SyncFolderLocalUserMapping
  	OPEN syncUserCursor
	FETCH NEXT FROM syncUserCursor INTO @folder, @clientName, @localUser
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @configOptions = ISNULL((SELECT configOptions FROM App_SyncCloudConfig
		WHERE syncWebFolderId = @folder
		and clientId IN (SELECT id from App_client where net_hostname = @clientName)),N'')
		IF @configOptions is null OR @configOptions.exist('*') = 0
		BEGIN
			--FRAME XML
			SET @configOptions = (
									SELECT  '13' as '@_type_',
									(SELECT @localUser as '@userName' FOR XML PATH('localUser'),TYPE)
									FOR XML PATH('syncOptions')
									)
		END
		ELSE
		BEGIN
			IF @configOptions.exist('syncOptions/localUser') = 1
			BEGIN
				IF ISNULL(@configOptions.value('(syncOptions/localUser/@userName)[1]','nvarchar(255)'),N'') = N''
				BEGIN
					--INSERT attribute
					SET @configOptions.modify('insert (attribute userName {sql:variable("@localUser")})into (syncOptions/localUser)[1]')
				END
				ELSE
				BEGIN
					--REPLACE
					SET @configOptions.modify('replace value of (syncOptions/localUser/@userName)[1] with sql:variable("@localUser")')
				END
			END
			ELSE
			BEGIN
				DECLARE @userNode XML = (SELECT @localUser as '@userName' FOR XML PATH('localUser'))
				SET @configOptions.modify('insert sql:variable("@userNode") into (syncOptions)[1]')
			END
		END
	UPDATE 	App_SyncCloudConfig
		SET configOptions = @configOptions
		WHERE syncWebFolderId = @folder
		and clientId IN (SELECT id from App_client where net_hostname = @clientName)
		FETCH NEXT FROM syncUserCursor INTO @folder, @clientName, @localUser
	END
	CLOSE syncUserCursor;
	DEALLOCATE syncUserCursor;
	SET @i_xmlString = (
							SELECT @rc as '@errorCode',
								   @errStr as '@errorMessage'
							FOR XML PATH('App_GenericResp')
						)
	SELECT @i_xmlString
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @rc = ERROR_NUMBER()
    set @errStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    SET @i_xmlString = (
							SELECT @rc as '@errorCode',
								   @errStr as '@errorMessage'
							FOR XML PATH('App_GenericResp')
						)
	SELECT @i_xmlString
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateEdgeMonitorConfig')
	delete from GxQscripts where name = 'AppUpdateEdgeMonitorConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateEdgeMonitorConfig')
	delete from GXDBVersions where aliasname = 'AppUpdateEdgeMonitorConfig'
GO

insert into GXDBVersions values(2, 'AppUpdateEdgeMonitorConfig',  '00000000000000000000', 'AppUpdateEdgeMonitorConfig', '00000000000000000000')
GO

