

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateDistributedStorage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppUpdateDistributedStorage')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateDistributedStorage <<<'
	drop procedure AppUpdateDistributedStorage
END
IF EXISTS (select * from GxQscripts where name='AppUpdateDistributedStorage')
	delete from GxQscripts where name = 'AppUpdateDistributedStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDistributedStorage')
	delete from GXDBVersions where aliasname = 'AppUpdateDistributedStorage'
GO
print '... Creating Procedure: AppUpdateDistributedStorage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppUpdateDistributedStorage
  @userId INT,
  @localeId INT = 0,
  @xmlstr XML OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @nowTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())
	DECLARE @outputErrorStr NVARCHAR(MAX)
	DECLARE @HEDVIG	INT = 0x1
	DECLARE @distributedStorageId INT = 0
DECLARE @name NVARCHAR(255), @url NVARCHAR(MAX)
	DECLARE @credentialName NVARCHAR(MAX), @username NVARCHAR(MAX), @password NVARCHAR(MAX)
DECLARE @currentName NVARCHAR(255), @currentUrl NVARCHAR(MAX), @credentialId INT
	DECLARE @currentUsername NVARCHAR(MAX), @currentPassword NVARCHAR(MAX)
DECLARE @newName NVARCHAR(255), @newUrl NVARCHAR(MAX)
	------ READ DISTRIBUTED STORAGE INFO FROM REQUEST XML ------
	SET @distributedStorageId = ISNULL((SELECT ref.value('@distributedStorageId', 'INT') FROM @xmlstr.nodes('App_UpdateDistributedStorageRequest/distributedStorageInfo/distributedStorage') R(ref)), 0)
SET @name = ISNULL((SELECT ref.value('@distributedStorageName', 'NVARCHAR(255)') FROM @xmlstr.nodes('App_UpdateDistributedStorageRequest/distributedStorageInfo/distributedStorage') R(ref)), '')
	SET @url = ISNULL((SELECT ref.value('@url', 'NVARCHAR(MAX)') FROM @xmlstr.nodes('App_UpdateDistributedStorageRequest/distributedStorageInfo') R(ref)), '')
	SELECT
		@credentialName = Tbl.Col.value('(credentialRecord/@credentialName)[1]', 'nvarchar(max)'),
		@username = Tbl.Col.value('(record/@userName)[1]', 'nvarchar(max)'),
		@password = Tbl.Col.value('(record/@password)[1]', 'nvarchar(max)')
	FROM @xmlstr.nodes('/App_UpdateDistributedStorageRequest/distributedStorageInfo/credential') as Tbl(Col)
	------ CHECK IF REQUIRED FIELDS ARE VALID ------
	IF @userId <= 0
	BEGIN
SET @errorCode = (4625 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	IF @distributedStorageId = 0
	BEGIN
SET @errorCode = (4626 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	ELSE
	BEGIN
		SELECT @currentName = name, @currentUrl = url, @credentialId = credentialId FROM App_DistributedStorage WHERE id = @distributedStorageId
		IF @currentName IS NULL
		BEGIN
SET @errorCode = (4623 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO PROC_EXIT
		END
SET @credentialId = ISNULL((SELECT credentialId FROM APP_CredentialAssoc WHERE entityId = @distributedStorageId AND entityType = 195), 0)
	END
	SET @newName = @currentName
	SET @newUrl = @currentUrl
	------ SECURITY CHECK ------
	DECLARE @hasRight INT
EXEC sec_checkPermissionOnEntity @userId, 260, @hasRight OUTPUT, 195, @distributedStorageId
	IF @hasRight <> 1
	BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	------ CHECK IF DISTRIBUTED STORAGE NAME NEEDS TO BE UPDATED ------
	DECLARE @updateDistributedStorageTable INT = 0
	IF @name <> '' AND @name <> @currentName
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_DistributedStorage WHERE name = @name)
		BEGIN
			SET @newName = @name
			SET @updateDistributedStorageTable = 1
		END
		ELSE
		BEGIN
SET @errorCode = (4636 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @errorCode and localeId = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', @name)
			GOTO PROC_EXIT
		END
	END
	------ CHECK IF DISTRIBUTED STORAGE URL NEEDS TO BE UPDATED ------
	IF @url <> '' AND @url <> @currentUrl
	BEGIN
		SET @newUrl = @url
		SET @updateDistributedStorageTable = 1
	END
	------ UPDATE TABLE App_DistributedStorage IF NEEDED ------
	IF @updateDistributedStorageTable = 1
	BEGIN
		UPDATE App_DistributedStorage
		SET name = @newName, url = @newUrl
		WHERE id = @distributedStorageId
	END
	------ UPDATE CREDENTIAL RECORD ------
	IF @username IS NOT NULL OR @password IS NOT NULL
	BEGIN
		SELECT @currentUsername = username, @currentPassword = password
		FROM App_Credentials WHERE credentialId = @credentialId
		IF @password IS NOT NULL
		BEGIN
			SET @password =(CASE
					WHEN (CHARINDEX('|#',@password, 1) > 0) THEN (select dbo.base64decode(SUBSTRING(dbo.DecodeInvalidXMLChar(@password),2,LEN(dbo.DecodeInvalidXMLChar(@password)))))
					ELSE dbo.base64decode(@password) END)
		END
		IF @username <> @currentUsername OR @password <> @currentPassword
		BEGIN
			UPDATE App_Credentials
			SET username = (CASE WHEN @username IS NOT NULL THEN @username ELSE @currentUsername END),
				password = (CASE WHEN @password IS NOT NULL THEN @password ELSE @currentPassword END)
			WHERE credentialId = @credentialId
		END
	END
	-- UPDATE DISTRIBUTED STORAGE PROPERTIES
	IF object_id('tempdb.dbo.#tempDistributedStoragePropTbl') IS NOT null DROP TABLE #tempDistributedStoragePropTbl
	CREATE TABLE #tempDistributedStoragePropTbl
(distributedStorageId INT, attrName VARCHAR(255), attrVal NVARCHAR(MAX), attrType INT, PRIMARY KEY(distributedStorageId, attrName))
	INSERT INTO #tempDistributedStoragePropTbl (distributedStorageId, attrName, attrVal, attrType)
	SELECT distinct @distributedStorageId, CA.propertyTypId, CA.Value, CA.attrType
	FROM @xmlstr.nodes('App_UpdateDistributedStorageRequest/distributedStorageInfo') R ( ref )
	CROSS APPLY (
SELECT 'Cluster Nodes' AS propertyTypId,  r.ref.value('@clusterNodes','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'Targets' AS propertyTypId, r.ref.value('@targets','NVARCHAR(MAX)') AS Value, 1 AS attrType
	) CA
	WHERE CA.Value IS NOT NULL
	MERGE App_DistributedStorageProp AS T
	USING #tempDistributedStoragePropTbl AS S
	ON  T.attrName = S.attrName and t.componentNameId = S.distributedStorageId
	WHEN MATCHED AND T.attrVal <> S.attrVal THEN
	UPDATE SET attrVal = S.attrVal
	WHEN NOT MATCHED THEN
	INSERT (componentNameId, attrName, attrType, attrVal, created)
	VALUES (s.distributedStorageId, S.attrName, S.attrType, S.attrVal, @nowTime);
	------  AUDIT ADD DISTRIBUTED STORAGE OPERATION ------
DECLARE @opMsgId    INT = (700 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	DECLARE @opEvMsgId  INT = 0
	DECLARE @opId       INT = 0
DECLARE @paramMsgId INT = (1851 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Update Distributed Storage [^1%s]
	EXEC EvGuiAuditSetOperation  @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- audit record parameter values
	EXEC EvGuiAuditSetParamData @opId, @currentName, 0
	-- tie up
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
PROC_EXIT:
	IF @errorCode <> 0 AND @errorString = ''
	BEGIN
		SET @errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @errorCode and localeId = @localeId)
	END
	SET @xmlstr =
	(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ('error'), ROOT('App_UpdateDistributedStorageResponse'))
	select @xmlstr
	IF object_id('tempdb.dbo.#tempDistributedStoragePropTbl') IS NOT null DROP TABLE #tempDistributedStoragePropTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateDistributedStorage')
	delete from GxQscripts where name = 'AppUpdateDistributedStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDistributedStorage')
	delete from GXDBVersions where aliasname = 'AppUpdateDistributedStorage'
GO

insert into GXDBVersions values(2, 'AppUpdateDistributedStorage',  '00000000000000000000', 'AppUpdateDistributedStorage', '00000000000000000000')
GO

