

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateDeletedCompanyEntityNames.sp] ---------- 

--  +------------------------------------------------------------------------------------------+
--  |   Procedure : "AppUpdateDeletedCompanyEntityNames"
--  |   Description: Stored procedure to update the display name with marked for deletion
--  |    for the entities of a company which is marked for delete .
--  |   Author: sghatbale
--  +------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateDeletedCompanyEntityNames')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateDeletedCompanyEntityNames <<<'
	drop procedure AppUpdateDeletedCompanyEntityNames
END
IF EXISTS (select * from GxQscripts where name='AppUpdateDeletedCompanyEntityNames')
	delete from GxQscripts where name = 'AppUpdateDeletedCompanyEntityNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDeletedCompanyEntityNames')
	delete from GXDBVersions where aliasname = 'AppUpdateDeletedCompanyEntityNames'
GO
print '... Creating Procedure: AppUpdateDeletedCompanyEntityNames'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateDeletedCompanyEntityNames
  @companyId INTEGER
AS
  DECLARE @errorString nvarchar(1024)
  DECLARE @errorCode INT
  DECLARE @rowsUpdated INT
SET NOCOUNT ON
set @errorCode = 0
set @rowsUpdated = 0
BEGIN TRY
    DECLARE @c_flags INT = 0
    SELECT @c_flags = flags FROM UMDSProviders WHERE id = @companyId AND enabled=0
IF  @c_flags & 0x0002 = 0x0002
    BEGIN
        DECLARE @scheduledForDeletion   NVARCHAR(255) = N': scheduled for deletion at ' + CAST(GetUTCdate() AS NVARCHAR(64)) + ' UTC '
        DECLARE @dataBearingEntities Table (entityType INT primary Key not null)
        INSERT @dataBearingEntities(entityType) values
(3), (7), (6),
(5), (28),
(17), (158), (9)
        DECLARE @entityType INT = 0
        DECLARE entityTypes CURSOR FOR
        SELECT entityType FROM @dataBearingEntities
        OPEN entityTypes
        FETCH NEXT FROM entityTypes INTO @entityType
        WHILE @@FETCH_STATUS = 0
        BEGIN
            DECLARE @dynamicSQLStr NVARCHAR(MAX) = ''
            DECLARE @idColName VARCHAR(128) = ''
                ,@tableName VARCHAR(128) = ''
                ,@entityNameColName VARCHAR(128) = ''
                ,@whereClause VARCHAR(512) = ''
            SELECT @idColName = idColName, @tableName = tableName, @whereClause = whereClause,  @entityNameColName = entityNameColName
            FROM APP_Entity
            WHERE
                entityType = @entityType
            IF @whereClause = ''
                SET @whereClause = '1=1'
            IF PATINDEX('%flags%', @whereClause) <> 0 AND PATINDEX('%.flags%', @whereClause) = 0
            BEGIN
                -- Sometimes whereclause has columns such flags which may be ambiguous with the table it is joining to, so better add table table in clause.
                SET @whereClause = REPLACE(@whereClause, 'flags', @tableName + '.' + 'flags')
            END
            BEGIN TRY
                BEGIN TRAN
                SET @dynamicSQLStr =  'UPDATE ' + @tableName +
                                      ' SET ' + @entityNameColName + ' = ' + @tableName + '.' + @entityNameColName +
                                      ' + ''' + @scheduledForDeletion + '''' +
                                      ' FROM ' + @tableName +
                                      ' INNER JOIN App_CompanyEntities App
                                        ON App.entityId = '  + @tableName + '.' + @idColName +
                                      ' AND App.entityType = ' + CAST (@entityType AS VARCHAR(10)) +
                                      ' WHERE App.companyId = ' + CAST (@companyId AS VARCHAR(10))  +
' AND App.flags & ' + CAST ((SELECT CONVERT(INT, 0x2)) AS VARCHAR(16)) + ' = 0 ' +
' AND App.flags & ' + CAST ((SELECT CONVERT(INT, 0x4)) AS VARCHAR(16)) + ' = 0 ' +
                                        ' AND ' + @whereClause
                EXEC (@dynamicSQLStr)
                SET @rowsUpdated += @@ROWCOUNT
                UPDATE ce
SET flags = flags | 0x2
                FROM App_CompanyEntities ce
                WHERE entityType = @entityType AND
                      companyId = @companyId AND
flags & 0x2 = 0 AND
flags & 0x4 = 0
                -- Special case: For the subclient & backupset which are not
                -- yet mapped in App_CompanyEntites table, for them right now
                -- we've to rely on their corresponding client to get their company
IF @entityType = 7
                BEGIN
                    UPDATE Appl
                    SET subclientName = subclientName +  @scheduledForDeletion,
subclientStatus = subclientStatus | 0x200000
                    FROM App_Application Appl
                    INNER JOIN App_Client AC
                        On AC.id = Appl.clientId
                    INNER JOIN App_CompanyEntities App
On App.entityId = AC.id AND App.entityType = 3
                    LEFT JOIN App_CompanyEntities App2
On App2.entityId = Appl.id AND App2.entityType = 7
                    WHERE App2.entityId is NULL AND
                        App.companyId = @companyId AND
App.flags & 0x4 = 0 AND
Appl.subclientStatus & 0x200000 = 0
                END
ELSE IF @entityType = 6
                BEGIN
                    UPDATE Bkp
                    SET name = Bkp.name + @scheduledForDeletion,
status = Bkp.status | 0x100000
                    FROM APP_BackupSetName Bkp
                    INNER JOIN App_Application Appl
                        On Appl.backupSet = Bkp.id
                    INNER JOIN App_Client AC
                        On AC.id = Appl.clientId
                    INNER JOIN App_CompanyEntities App
On App.entityId = AC.id AND App.entityType = 3
                    LEFT JOIN App_CompanyEntities App2
On App2.entityId = Bkp.id AND App2.entityType = 6
                    WHERE App2.entityId is NULL AND
                        App.companyId = @companyId AND
App.flags & 0x4 = 0 AND
Bkp.status & 0x100000 = 0
                END
ELSE IF @entityType = 5
                BEGIN
                    UPDATE AI
                    SET name = AI.name + @scheduledForDeletion,
status = AI.status | 0x10000
                    FROM APP_InstanceName AI
                    INNER JOIN App_Application Appl
                        On Appl.instance = AI.id
                    INNER JOIN App_Client AC
                        On AC.id = Appl.clientId
                    INNER JOIN App_CompanyEntities App
On App.entityId = AC.id AND App.entityType = 3
                    LEFT JOIN App_CompanyEntities App2
On App2.entityId = AI.id AND App2.entityType = 5
                    WHERE App2.entityId is NULL AND
                        App.companyId = @companyId AND
App.flags & 0x4 = 0 AND
AI.status & 0x10000 = 0 AND
                        AI.id <> 1 AND AI.id NOT IN (SELECT componentNameId
				  FROM APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK)
ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 and attrVal = '1')   /*default VM instance*/
                END
                COMMIT TRAN
            END TRY
            BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
                ROLLBACK TRAN
                CLOSE entityTypes
                DEALLOCATE entityTypes
                ;THROW; -- Re-Throw the execption
            END CATCH
        FETCH NEXT FROM entityTypes INTO @entityType
        END
        CLOSE entityTypes
        DEALLOCATE entityTypes
    END
    ELSE
    BEGIN
        set @errorCode = 1
        set @errorString = 'Failed to update display name of entities of company since company is not marked for delete'
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Failed to update display name of entities of company ' +ERROR_MESSAGE()
END CATCH
SELECT @errorCode AS 'errorCode',
       @errorString AS 'errorString',
       @rowsUpdated AS 'rowsUpdated'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateDeletedCompanyEntityNames')
	delete from GxQscripts where name = 'AppUpdateDeletedCompanyEntityNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDeletedCompanyEntityNames')
	delete from GXDBVersions where aliasname = 'AppUpdateDeletedCompanyEntityNames'
GO

insert into GXDBVersions values(2, 'AppUpdateDeletedCompanyEntityNames',  '00000000000000000000', 'AppUpdateDeletedCompanyEntityNames', '00000000000000000000')
GO

