

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateDataRetentionForDeconfiguredClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===================================================================+
--  |                     AppUpdateDataRetentionForDeconfiguredClients          |
--  +===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateDataRetentionForDeconfiguredClients')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateDataRetentionForDeconfiguredClients <<<'
	drop procedure AppUpdateDataRetentionForDeconfiguredClients
END
IF EXISTS (select * from GxQscripts where name='AppUpdateDataRetentionForDeconfiguredClients')
	delete from GxQscripts where name = 'AppUpdateDataRetentionForDeconfiguredClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDataRetentionForDeconfiguredClients')
	delete from GXDBVersions where aliasname = 'AppUpdateDataRetentionForDeconfiguredClients'
GO
print '... Creating Procedure: AppUpdateDataRetentionForDeconfiguredClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateDataRetentionForDeconfiguredClients
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
  @entityId INT,
  @entityType INT,
  @numberOfDays INT,
  @i_selectOutput INT,
  @o_errorCode INT OUTPUT,
  @o_errorString NVARCHAR(MAX) OUTPUT
-----------------------------------------------------------
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX) = ''
SET NOCOUNT ON
BEGIN TRY
    DECLARE @localeId INT = 0;
	SET @numberOfDays = ISNULL(@numberOfDays,365);
	DECLARE @clientRcnt INT = 0;
	-- No valid inputs
	IF @entityId IS NULL AND  @entityType IS NULL
	BEGIN
SET @o_errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
        GOTO ERROR_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#clientsToUpdate') IS NOT NULL
	DROP TABLE #clientsToUpdate
	CREATE TABLE #clientsToUpdate (
		clientId           INT PRIMARY KEY,
	)
IF @entityType = 1 OR @entityType = 61
	BEGIN
		INSERT INTO #clientsToUpdate (clientId)
		SELECT C.id
		FROM APP_Client C (NOLOCK)
		INNER JOIN
		APP_ClientProp CP (NOLOCK)
ON C.id = CP.componentNameId AND C.status & 0x1000 = 0x1000 AND CP.attrName='Installation Company ID' AND CP.attrVal = @entityId AND CP.modified = 0
		LEFT JOIN
		APP_ClientProp CP1 (NOLOCK)
ON C.id = CP1.componentNameId AND CP1.attrName='Associated Plan' AND CP1.modified = 0
		WHERE  CP1.attrVal = 0 OR CP1.attrVal IS NULL
		SET @clientRcnt = @@ROWCOUNT
	END
ELSE IF @entityType = 158
	BEGIN
		INSERT INTO #clientsToUpdate (clientId)
			SELECT C.id
				FROM  APP_Client C (NOLOCK)
				INNER JOIN APP_ClientProp CP (NOLOCK)
				ON C.id = CP.componentNameId
WHERE C.status & 0x1000 = 0x1000  AND CP.attrName='Associated Plan' AND CP.attrVal = @entityId AND CP.modified = 0
		SET @clientRcnt = @@ROWCOUNT
	END
	IF (@clientRcnt > 0)
	BEGIN
		UPDATE App_ClientProp
			SET attrVal = @numberOfDays
			FROM #clientsToUpdate CU
WHERE CU.clientId = componentNameId AND attrName = 'Number of days to keep data of de-configured clients' AND attrVal <> @numberOfDays AND modified = 0
	END
ERROR_EXIT:
        SET @o_errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @o_errorCode AND [localeId] = @localeId)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errorCode = ERROR_NUMBER()
    set @o_errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
IF @i_selectOutput = 1
BEGIN
	SELECT @o_errorCode AS errorCode, @o_errorString AS errorString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateDataRetentionForDeconfiguredClients')
	delete from GxQscripts where name = 'AppUpdateDataRetentionForDeconfiguredClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDataRetentionForDeconfiguredClients')
	delete from GXDBVersions where aliasname = 'AppUpdateDataRetentionForDeconfiguredClients'
GO

insert into GXDBVersions values(2, 'AppUpdateDataRetentionForDeconfiguredClients',  '00000000000000000000', 'AppUpdateDataRetentionForDeconfiguredClients', '00000000000000000000')
GO

