

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateDCPlanSubclientAssociation.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateDCPlanSubclientAssociation.sp,v $ $Id: AppUpdateDCPlanSubclientAssociation.sp,v 1.1.2.1 2020/08/11 21:15:40 alakra Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Create date: 07/29/2020
-- Description:	 SP to update DC plan association to Subclient
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateDCPlanSubclientAssociation')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateDCPlanSubclientAssociation <<<'
	drop procedure AppUpdateDCPlanSubclientAssociation
END
IF EXISTS (select * from GxQscripts where name='AppUpdateDCPlanSubclientAssociation')
	delete from GxQscripts where name = 'AppUpdateDCPlanSubclientAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDCPlanSubclientAssociation')
	delete from GXDBVersions where aliasname = 'AppUpdateDCPlanSubclientAssociation'
GO
print '... Creating Procedure: AppUpdateDCPlanSubclientAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateDCPlanSubclientAssociation
  @i_userId INT,
  @i_localeId INT,
  @i_skipSecurityCheck INT,
  @i_skipAudit INT,
  @x_xmlData XML,
  @isFromCPP INT,   
  @o_errorCode INT OUTPUT,
  @o_errorString NVARCHAR(MAX) OUTPUT
AS
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
-- '<Api_AssociateDCPlanSubclientRequest planOperationType="1">
--   <plan planId="20">
--   </plan>
--   <entities>
--     <entity entityId="391">
--     </entity>
--     <definedIn entityId="247" entityType="3">
--     </definedIn>
--   </entities>
--   <entities>
--     <entity entityId="406">
--     </entity>
--     <definedIn entityId="249" entityType="3">
--     </definedIn>
--   </entities>
--   <entities>
--     <entity entityId="420">
--     </entity>
--     <definedIn entityId="352" entityType="6">
--     </definedIn>
--   </entities>
--   <entities>
--     <entity entityId="421">
--     </entity>
--   </entities>
-- </Api_AssociateDCPlanSubclientRequest>
SET @errorCode = 0
SET @errorString = N''
BEGIN TRY
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @indexServerId		INTEGER
	DECLARE @ciPolicyId			INTEGER
	DECLARE @xmlForSP			XML
	DECLARE @nowtime			INTEGER = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @invalidSubclients	NVARCHAR(MAX)
	DECLARE @invalidPlans		NVARCHAR(MAX)
	DECLARE @opType				INTEGER = ISNULL((SELECT  ref.value('@planOperationType', 'INT')
													FROM @x_xmlData.nodes('Api_AssociateDCPlanSubclientRequest') R ( ref )),0)
	DECLARE @planId				INTEGER = ISNULL((SELECT  ref.value('@planId', 'INT')
													FROM @x_xmlData.nodes('Api_AssociateDCPlanSubclientRequest/plan') R ( ref )),0)
	DECLARE @planName			NVARCHAR(MAX) = ISNULL((SELECT name FROM App_Plan WHERE id=@planId),'Invalid Plan Id')
	IF object_id('tempdb.dbo.#InputSubClientList')	IS NOT null				DROP TABLE #InputSubClientList
	IF object_id('tempdb.dbo.#backupsetIndex')	IS NOT null					DROP TABLE #backupsetIndex
	IF OBJECT_ID('tempdb.dbo.#PlansList')	IS NOT NULL						DROP TABLE #PlansList
	IF OBJECT_ID('tempdb.dbo.#userSubClients') IS NOT NULL					DROP TABLE #userSubClients
	IF OBJECT_ID('tempdb.dbo.#planInfo') IS NOT NULL						DROP TABLE #planInfo
	IF OBJECT_ID('tempdb.dbo.#siblingSubclientInfo') IS NOT NULL			DROP TABLE #siblingSubclientInfo
	IF OBJECT_ID('tempdb.dbo.#deleteBackupsetAssocInfo') IS NOT NULL		DROP TABLE #deleteBackupsetAssocInfo
	CREATE TABLE #InputSubClientList
	(
		_ID										INT IDENTITY(1,1) PRIMARY KEY,
		subclientId								INT,
		subClientName							NVARCHAR(MAX),
		backupSetId								INT,
		planId									INT,
		planName								NVARCHAR(MAX),
		planParentEntityType					INT,
		planParentEntityId						INT,
		currentPlanId							INT,
		ciPolicyId								INT,
		indexServerId							INT,
		currentIndexServer						INT,
		processForIndexServerDisassociation		INT DEFAULT 1,
		isSubclientIndexEnabled					INT DEFAULT 0
	)
	CREATE TABLE #deleteBackupsetAssocInfo
	(
		backupSetId								INT
	)
	CREATE TABLE #siblingSubclientInfo
	(
		subclientId								INT PRIMARY KEY,
		backupsetId								INT
	)
	CREATE TABLE #backupsetIndex
	(
		backupSetId					INT,
		isSubclientIndexEnabled		INT DEFAULT 0
	)
	CREATE TABLE #planInfo
	(
		planId					INT PRIMARY KEY,
		indexServer				INT,
		ciPolicy				INT
	)
	CREATE TABLE #userSubClients                   (t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
	CREATE TABLE #PlansList(planId INT NOT NULL)
	CREATE CLUSTERED INDEX PlansList_planId_idx ON #PlansList(planId)
	-- Start Processing
	-- 1. Fetch info from XML
	INSERT INTO #InputSubClientList (subclientId, planParentEntityType, planParentEntityId, planId, planName)
	SELECT ISNULL(subclient.N.value('(@subclientId)', 'INT'), ISNULL(subclient.N.value('(@entityId)', 'INT'), 0)),
		--ISNULL(subclient.N.value('(@subclientName)', 'NVARCHAR(MAX)'), ISNULL(subclient.N.value('(@entityName)', 'NVARCHAR(MAX)'), 0)),
		parentEntity.N.value('(@entityType)', 'INT'),
		parentEntity.N.value('(@entityId)', 'INT'),
		@planId,
		@planName
		FROM @x_xmlData.nodes('Api_AssociateDCPlanSubclientRequest/entities') R ( ref )
		CROSS APPLY R.ref.nodes('entity') as  subclient(N)
		OUTER APPLY R.ref.nodes('definedIn') as  parentEntity(N)
	-- Get Subclient Name
	-- this might be needed in case security validation fails
	UPDATE ISC
		SET ISC.subClientName = ISNULL (AAP.subclientName, 'Invalid subclient Id'),
			ISC.backupSetId	= AAP.backupSet
	FROM #InputSubClientList ISC
	LEFT OUTER JOIN APP_Application AAP
		ON AAP.id=ISC.subclientId
	-- Parameter Validation
	IF (
			(
				@opType  NOT IN(1,2,3,4)
			)
			OR
			(
				@opType IN(3,4)
				AND
				NOT EXISTS(SELECT 1 FROM APP_SubClientProp ASCP
							INNER JOIN #InputSubClientList ISC
ON ISC.subclientId=ASCP.componentNameId AND ASCP.attrName='Associated DC Plan' AND ASCP.modified=0 AND ASCP.cs_attrName=CHECKSUM(N'Associated DC Plan'))
			)
			OR
			(
				@opType IN (1,2)  AND @planName='Invalid Plan Id'
			)
			OR
			(
				-- Invalid subclient id
				EXISTS (SELECT 1 FROM #InputSubClientList WHERE subClientName='Invalid subclient Id')
			)
		)
	BEGIN
SET @errorCode = (1 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
							WHERE messageId = @errorCode AND [localeId] = @i_localeId)
		GOTO GENERATE_OUTPUT
	END
	IF (@i_skipSecurityCheck = 0)
	BEGIN
		-- Security Check
		-- All plan that user have rights to use
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#PlansList'
		-- All subclient that user have rights to manage - EV_MANAGE_APPLICATION
EXEC sec_getIdaObjectsForUser @i_userId, 7 , 2, 1, '#userSubClients'
		-- User should have "Use Plan" rights on all the provided plan
		IF EXISTS (SELECT 1 FROM #InputSubClientList IVM
				LEFT OUTER JOIN #PlansList PL
					ON PL.planId=IVM.planId
				WHERE PL.planId IS NULL)
		BEGIN
			SELECT @invalidPlans = COALESCE(@invalidPlans+', ' ,'') + IVM.planName FROM #InputSubClientList IVM
				LEFT OUTER JOIN #PlansList PL
					ON PL.planId=IVM.planId
				WHERE PL.planId IS NULL
			GROUP BY IVM.planName
SET @errorCode = (4496 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
							WHERE messageId = @errorCode AND [localeId] = @i_localeId)
			--SET @o_errString = REPLACE(@o_errString, '^1%s', CAT_PLAN_ASSOCIATIONS_ADD_REMOVE_NAME)
			SET @errorString = REPLACE(@errorString, '^1%s', 'Use Plan')
			SET @errorString = REPLACE(@errorString, '^2%s', @invalidPlans)
			GOTO GENERATE_OUTPUT
		END
		-- Subclient input present for which user don't seems to have right or missing form above list
		IF EXISTS (SELECT 1 FROM #InputSubClientList IVM
					LEFT OUTER JOIN #userSubClients UC
						ON UC.t_subclientId=IVM.subclientId
					WHERE UC.t_subclientId IS NULL)
		BEGIN
			SELECT @invalidSubclients = COALESCE(@invalidSubclients+', ' ,'') + IVM.subClientName FROM #InputSubClientList IVM
					LEFT OUTER JOIN #userSubClients UC
						ON UC.t_subclientId=IVM.subclientId
					WHERE  UC.t_subclientId IS NULL
				-- User does not have [^1%s] rights on subclient(s)-[^2%s].
SET @errorCode = (4613 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
								WHERE messageId = @errorString AND [localeId] = @i_localeId)
				--SET @o_errString = REPLACE(@o_errString, '^1%s', 'EV_MANAGE_APPLICATION')
				SET @errorString = REPLACE(@errorString, '^1%s', 'Agent Management')
				SET @errorString = REPLACE(@errorString, '^2%s', @invalidSubclients)
				GOTO GENERATE_OUTPUT
		END
	END
	-- Update subclient index support
	-- This will tell us whether index server will be associated at backupset level or subclient level
	--
	INSERT INTO #backupsetIndex
	SELECT backupSetId, dbo.isSubClientIndexEnabled(backupSetId) FROM #InputSubClientList
	GROUP BY backupSetId
	UPDATE ISC
		SET ISC.isSubclientIndexEnabled = BI.isSubclientIndexEnabled
	FROM #InputSubClientList ISC
	INNER JOIN #backupsetIndex BI
		ON BI.backupSetId=ISC.backupSetId
	-- Get Plan Info
SET @indexServerId = dbo.AppPlanGetEntityValue(@planId, 'Analytics Index Server Id', default)
SET @ciPolicyId = dbo.AppPlanGetEntityValue(@planId,'Content Indexing Policy', default)
	-- Fetch plan info in table
	-- In case of many subclients , this will help in minimal fetching of records
	INSERT INTO #planInfo
	SELECT @planId,  @indexServerId, @ciPolicyId
	UNION
--SELECT currentPlanId,  dbo.AppPlanGetEntityValue(currentPlanId, 'Analytics Index Server Id', default)   ,  dbo.AppPlanGetEntityValue(currentPlanId, 'Content Indexing Policy', default)   FROM #InputSubClientList
	SELECT currentPlanId,  dbo.AppPlanGetEntityValue(currentPlanId, 'Analytics Index Server Id', default)   ,  dbo.AppPlanGetEntityValue(currentPlanId, 'Content Indexing Policy', default)
		FROM #InputSubClientList
	WHERE currentPlanId IS NOT NULL
	GROUP BY currentPlanId
	-- update in our table
	UPDATE ISC
		SET ISC.ciPolicyId = PNew.ciPolicy,
			ISC.indexServerId	= PNew.indexServer,
			ISC.currentIndexServer = PCurrent.indexServer
	FROM #InputSubClientList ISC
	LEFT OUTER JOIN #planInfo PNew
		ON PNew.planId=ISC.planId
	LEFT OUTER JOIN #planInfo PCurrent
		ON PNew.planId=ISC.currentPlanId
	IF @opType IN(1,2) -- Overwrite , Add
	BEGIN
		-- Create 2 calls
		-- 1 for subclient level index
		-- 2nd for backupset level index (even though call was for subclient)
		IF EXISTS(SELECT 1 FROM #InputSubClientList WHERE isSubclientIndexEnabled=0)
		BEGIN
			SET @xmlForSP = (SELECT 1 AS '@opType', -- Optype Add
											@indexServerId AS '@idxServerClientId',
											0 AS '@isPrimary',
											2 AS '@engineType',			-- App::IdxDbEngineType::IdxDbEngineType_LUCENE
											0 AS '@updateIfSrvrExistsForEngine',	-- Don't Update Engine if it's association already exist
											1 AS '@skipIfPrimaryExistsForEngine',	-- need to check for this
											6 AS '@entityType',	-- BACKUPSET Entity	-- backupset entity since index is at backupset level and not subclient
											(SELECT backupSetId AS '@val'
												FROM #InputSubClientList  WHERE isSubclientIndexEnabled=0
												GROUP By backupSetId
												FOR XML PATH('entityIdList'), TYPE)
										 FOR XML PATH('Indexing_ModifyIndexServerReq'), TYPE)
			EXEC AppModifyIndexServer @xmlForSP OUTPUT
			SET @errorCode = ISNULL((SELECT  ref.value('@errorCode', 'INT')
										FROM    @xmlForSP.nodes('App_GenericResp') R ( ref )),-1)
			SET @errorString = (SELECT  ref.value('@errorMessage', 'NVARCHAR(MAX)')
										FROM    @xmlForSP.nodes('App_GenericResp') R ( ref ))
			IF ((@errorCode=-1) AND @errorString IS NULL)
			BEGIN
				SET @errorString = 'Failed to set Index Server for DC plan association.'
			END
			IF @errorCode <>0
			BEGIN
				-- We failed for some reason. Let's stop further processing
				GOTO  GENERATE_OUTPUT
			END
		END
		IF EXISTS(SELECT 1 FROM #InputSubClientList WHERE isSubclientIndexEnabled=1)
		BEGIN
			SET @xmlForSP = (SELECT 1 AS '@opType', -- Optype Add
											@indexServerId AS '@idxServerClientId',
											0 AS '@isPrimary',
											2 AS '@engineType',			-- App::IdxDbEngineType::IdxDbEngineType_LUCENE
											0 AS '@updateIfSrvrExistsForEngine',	-- Don't Update Engine if it's association already exist
											1 AS '@skipIfPrimaryExistsForEngine',	-- need to check for this
											7 AS '@entityType',	-- Subclient Entity
											(SELECT subclientId AS '@val'
												FROM #InputSubClientList  WHERE isSubclientIndexEnabled=1
												FOR XML PATH('entityIdList'), TYPE)
										 FOR XML PATH('Indexing_ModifyIndexServerReq'), TYPE)
			EXEC AppModifyIndexServer @xmlForSP OUTPUT
			SET @errorCode = ISNULL((SELECT  ref.value('@errorCode', 'INT')
										FROM    @xmlForSP.nodes('App_GenericResp') R ( ref )),-1)
			SET @errorString = (SELECT  ref.value('@errorMessage', 'NVARCHAR(MAX)')
										FROM    @xmlForSP.nodes('App_GenericResp') R ( ref ))
			IF ((@errorCode=-1) AND @errorString IS NULL)
			BEGIN
				SET @errorString = 'Failed to set Index Server for DC plan association.'
			END
			IF @errorCode <>0
				GOTO  GENERATE_OUTPUT
		END
		IF @errorCode <>0
				GOTO  GENERATE_OUTPUT
		-- Index Server association done
		-- Let's just age off current plan property(if present) and insert new one
		-- PIT is useful during debugging and checking when plan was changed
		UPDATE ASCP
			SET modified=@nowtime
		FROM APP_SubClientProp ASCP
		INNER JOIN #InputSubClientList ISCP
ON ISCP.subclientId=ASCP.componentNameId AND ASCP.modified=0 AND ASCP.attrName IN ('Associated DC Plan', 'Associated DC Plan Parent EntityType', 'Associated DC Plan Parent EntityId')
AND ASCP.cs_attrName IN (CHECKSUM(N'Associated DC Plan'), CHECKSUM(N'Associated DC Plan Parent EntityType'),CHECKSUM(N'Associated DC Plan Parent EntityId'))
		INSERT INTO APP_SubClientProp
SELECT subclientId, 'Associated DC Plan', 7, planId, @nowtime, 0, 0 FROM #InputSubClientList
		UNION
SELECT subclientId, 'Associated DC Plan Parent EntityId', 7, planParentEntityId, @nowtime, 0, 0 FROM #InputSubClientList WHERE planParentEntityId IS NOT NULL and planParentEntityType IS NOT NULL
		UNION
SELECT subclientId, 'Associated DC Plan Parent EntityType', 7, planParentEntityType, @nowtime, 0, 0 FROM #InputSubClientList WHERE planParentEntityId IS NOT NULL and planParentEntityType IS NOT NULL
	END
	ELSE IF @opType IN(3,4)	--Delete , Clear
	BEGIN
		-- This will get all subclient in that backupset which have DC plan set (toher than 1 we have in the request)
		-- We will remove index server association when last subclient in that backupset will be disassociated from plan
		-- We are getting record in temp table as we might end up with doing additional processing later
		INSERT INTO #siblingSubclientInfo
		SELECT AAP.id, AAP.backupSet FROM #InputSubClientList ISC
		INNER JOIN APP_Application AAP
			ON AAP.backupSet=ISC.backupSetId AND ISC.isSubclientIndexEnabled=0
		INNER JOIN APP_SubClientProp ASCP
ON ASCP.componentNameId=AAP.id AND ASCP.attrName='Associated DC Plan' AND ASCP.modified=0 AND ASCP.cs_attrName=CHECKSUM(N'Associated DC Plan')
		LEFT OUTER JOIN #InputSubClientList ISC_Second
			ON ISC_Second.subclientId=ASCP.componentNameId
		WHERE AAP.subclientStatus & (2 | 4 | 16 | 32) = 0 AND ISC_Second.subclientId IS NULL -- (CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN)
		-- If we have a single record for backupset
		INSERT INTO #deleteBackupsetAssocInfo
		SELECT DISTINCT BKP.backupSetId FROM #InputSubClientList bkp
		LEFT OUTER JOIN #siblingSubclientInfo SCInfo
			ON SCInfo.backupsetId=bkp.backupSetId
		WHERE BKP.isSubclientIndexEnabled=0 AND SCInfo.backupsetId IS NULL
		IF EXISTS(SELECT 1 FROM #deleteBackupsetAssocInfo)
		BEGIN
			SET @xmlForSP = (SELECT 3 AS '@opType',	-- Optype Delete
											@indexServerId AS '@idxServerClientId',
											0 AS '@isPrimary',
											2 AS '@engineType',			-- App::IdxDbEngineType::IdxDbEngineType_LUCENE
											0 AS '@updateIfSrvrExistsForEngine',	-- Don't Update Engine if it's association already exist
											1 AS '@skipIfPrimaryExistsForEngine',	-- need to check for this
											6 AS '@entityType',	-- BACKUPSET Entity
											(SELECT backupSetId AS '@val'
												FROM #deleteBackupsetAssocInfo
												FOR XML PATH('entityIdList'), TYPE)
										 FOR XML PATH('Indexing_ModifyIndexServerReq'), TYPE)
			EXEC AppModifyIndexServer @xmlForSP OUTPUT
			SET @errorCode = ISNULL((SELECT  ref.value('@errorCode', 'INT')
										FROM    @xmlForSP.nodes('App_GenericResp') R ( ref )),-1)
			SET @errorString = (SELECT  ref.value('@errorMessage', 'NVARCHAR(MAX)')
										FROM    @xmlForSP.nodes('App_GenericResp') R ( ref ))
			IF ((@errorCode=-1) AND @errorString IS NULL)
			BEGIN
				SET @errorString = 'Failed to remove Index Server association while dissociating for DC plan association.'
			END
			IF @errorCode <>0
			BEGIN
				-- We failed for some reason. Let's stop further processing
				GOTO  GENERATE_OUTPUT
			END
		END
		-- Process subclient level index remove request
		IF EXISTS(SELECT 1 FROM #InputSubClientList WHERE isSubclientIndexEnabled=1)
		BEGIN
			SET @xmlForSP = (SELECT 3 AS '@opType', -- Optype Delete
											@indexServerId AS '@idxServerClientId',
											0 AS '@isPrimary',
											2 AS '@engineType',			-- App::IdxDbEngineType::IdxDbEngineType_LUCENE
											0 AS '@updateIfSrvrExistsForEngine',	-- Don't Update Engine if it's association already exist
											1 AS '@skipIfPrimaryExistsForEngine',	-- need to check for this
											7 AS '@entityType',	-- Subclient Entity
											(SELECT subclientId AS '@val'
												FROM #InputSubClientList  WHERE isSubclientIndexEnabled=1
												FOR XML PATH('entityIdList'), TYPE)
										 FOR XML PATH('Indexing_ModifyIndexServerReq'), TYPE)
			EXEC AppModifyIndexServer @xmlForSP OUTPUT
			SET @errorCode = ISNULL((SELECT  ref.value('@errorCode', 'INT')
										FROM    @xmlForSP.nodes('App_GenericResp') R ( ref )),-1)
			SET @errorString = (SELECT  ref.value('@errorMessage', 'NVARCHAR(MAX)')
										FROM    @xmlForSP.nodes('App_GenericResp') R ( ref ))
			IF ((@errorCode=-1) AND @errorString IS NULL)
			BEGIN
				SET @errorString = 'Failed to remove Index Server association while dissociating for DC plan association.'
			END
			IF @errorCode <>0
				GOTO  GENERATE_OUTPUT
		END
		IF @errorCode <>0
				GOTO  GENERATE_OUTPUT
		-- Let's just age off current plan property
		UPDATE ASCP
			SET modified=@nowtime
		FROM APP_SubClientProp ASCP
		INNER JOIN #InputSubClientList ISCP
ON ISCP.subclientId=ASCP.componentNameId AND ASCP.modified=0 AND ASCP.attrName IN ('Associated DC Plan', 'Associated DC Plan Parent EntityType', 'Associated DC Plan Parent EntityId')
AND ASCP.cs_attrName IN (CHECKSUM(N'Associated DC Plan'), CHECKSUM(N'Associated DC Plan Parent EntityType'),CHECKSUM(N'Associated DC Plan Parent EntityId'))
	END
	IF object_id('tempdb.dbo.#InputSubClientList')	IS NOT null				DROP TABLE #InputSubClientList
	IF object_id('tempdb.dbo.#backupsetIndex')	IS NOT null					DROP TABLE #backupsetIndex
	IF OBJECT_ID('tempdb.dbo.#PlansList')	IS NOT NULL						DROP TABLE #PlansList
	IF OBJECT_ID('tempdb.dbo.#userSubClients') IS NOT NULL					DROP TABLE #userSubClients
	IF OBJECT_ID('tempdb.dbo.#planInfo') IS NOT NULL						DROP TABLE #planInfo
	IF OBJECT_ID('tempdb.dbo.#siblingSubclientInfo') IS NOT NULL			DROP TABLE #siblingSubclientInfo
	IF OBJECT_ID('tempdb.dbo.#deleteBackupsetAssocInfo') IS NOT NULL		DROP TABLE #deleteBackupsetAssocInfo
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
			SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
	SET @o_errorCode  = @errorCode
	SET @o_errorString  = @errorString
	IF (@isFromCPP = 1)
	BEGIN
		SELECT @errorCode, @errorString
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateDCPlanSubclientAssociation')
	delete from GxQscripts where name = 'AppUpdateDCPlanSubclientAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDCPlanSubclientAssociation')
	delete from GXDBVersions where aliasname = 'AppUpdateDCPlanSubclientAssociation'
GO

insert into GXDBVersions values(2, 'AppUpdateDCPlanSubclientAssociation',  '00010001000200010000', 'AppUpdateDCPlanSubclientAssociation', '00010001000200010000')
GO

