

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateCustomProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateCustomProperty.sp,v $ $Id: AppUpdateCustomProperty.sp,v 1.1.2.5 2018/03/22 01:39:40 jiechen Exp $";
--	+===================================================================+
--	|  					  AppUpdateCustomProperty							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateCustomProperty <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateCustomProperty')
	drop procedure AppUpdateCustomProperty
IF EXISTS (select * from GxQscripts where name='AppUpdateCustomProperty')
	delete from GxQscripts where name = 'AppUpdateCustomProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCustomProperty')
	delete from GXDBVersions where aliasname = 'AppUpdateCustomProperty'
GO
print '... Creating Procedure: AppUpdateCustomProperty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateCustomProperty
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	-- Read the XML
	DECLARE @propertyId			INT	= 0
	DECLARE @propertyName		NVARCHAR(MAX) = ''
	DECLARE @description		NVARCHAR(MAX) = ''
	DECLARE @defaultValue		NVARCHAR(MAX) = ''
	DECLARE @securityAssocXml	XML
	SELECT
			@propertyId = ISNULL ((ref.value('@propertyId', 'INT')), 0),
			@propertyName = ISNULL((ref.value('@propertyName', 'NVARCHAR(MAX)')), ''),
			@description = ISNULL((ref.value('@description', 'NVARCHAR(MAX)')), ''),
			@defaultValue = ISNULL((ref.value('@defaultValue', 'NVARCHAR(MAX)')), ''),
			@securityAssocXml = ref.query('./securityAssociations')
	FROM
	@inXml.nodes('App_UpdateCustomPropertyRequest/property') R(ref)
	IF NOT EXISTS (SELECT 1 FROM App_CustomProperty WITH (NOLOCK) WHERE propertyId = @propertyId)
	BEGIN
			-- TODO - Assign proper event message codes.
SET @errorCode = (3067 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
	END
	BEGIN TRAN
	-- CHECK IF USER HAS AN ABILITY / PERMISSION TO DELETE THE PROPERTY
	DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @inUserId, 209, @userHasCapability OUTPUT, 166, @propertyId
	-- CHECK IF USER IS THE PROPERTY OWNER OR HAS UPDATE CAPABILITY
    IF NOT EXISTS ( SELECT  propertyId
                    FROM    App_CustomProperty
                    WHERE       propertyId = @propertyId
                            AND ((ownerId = @inUserId) OR (@userHasCapability = 1)))
	BEGIN
SET @errorCode = (3106 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
        GOTO ERROR
    END
	-- SET SECURITY ASSOCIATIONS
	IF @securityAssocXml IS NOT NULL AND @securityAssocXml.exist('/securityAssociations') = 1
	BEGIN
		DECLARE @errorTable TABLE(
									errorCode INT,
									errorString NVARCHAR(MAX)
								)
		SET @securityAssocXml = CAST(REPLACE(CAST(@securityAssocXml as NVARCHAR(MAX)), 'securityAssociations', 'App_SecurityAssociationForEntityList') as XML)
		INSERT @errorTable
EXEC sec_setSecurityAssociationsFromEntity @securityAssocXml, @inUserId, 0, 0, 166, @propertyId, 0, 0, 0, 0, 0, 0, 0, 0
		IF EXISTS (SELECT 1 FROM @errorTable)
		BEGIN
			SELECT TOP 1 @errorCode = errorCode, @errorString = errorString FROM @errorTable
			IF @errorCode <> 0
				GOTO ERROR
		END
	END
	UPDATE App_CustomProperty
	SET propertyName = @propertyName, description = @description, defaultValue = @defaultValue
	WHERE propertyId = @propertyId
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
ERROR:
	IF @errorCode <> 0
	BEGIN
		ROLLBACK TRAN
		IF @errorString = ''
		BEGIN
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, 1, 0, 2)
		END
	END
	ELSE
		COMMIT TRAN
ERROR_EXIT:
		SET @outXml = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE)
							FOR XML PATH('App_CustomPropertyResponse'), TYPE)
	SELECT @outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateCustomProperty')
	delete from GxQscripts where name = 'AppUpdateCustomProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCustomProperty')
	delete from GXDBVersions where aliasname = 'AppUpdateCustomProperty'
GO

insert into GXDBVersions values(2, 'AppUpdateCustomProperty',  '00010001000200050000', 'AppUpdateCustomProperty', '00010001000200050000')
GO

