

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateCredentialAssocForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateCredentialAssocForEntity.sp,v $ $Id: AppUpdateCredentialAssocForEntity.sp,v 1.1.2.4 2020/12/31 00:21:27 stelagamsetti Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppUpdateCredentialAssocForEntity
--  |
--  | Description:  Creates an association between credential and caller entity
--  |
--  |       Input:  Entity Id, Entity Type, Credential Id
--  |
--  |      Output:  Credential assoc ID if a valid credential ID was passed
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.1        aselvanayagam 	Stored procedure to create / update a credential association with a credential id
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppUpdateCredentialAssocForEntity')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateCredentialAssocForEntity <<<'
	drop procedure AppUpdateCredentialAssocForEntity
END
IF EXISTS (select * from GxQscripts where name='AppUpdateCredentialAssocForEntity')
	delete from GxQscripts where name = 'AppUpdateCredentialAssocForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCredentialAssocForEntity')
	delete from GXDBVersions where aliasname = 'AppUpdateCredentialAssocForEntity'
GO
print '... Creating Procedure: AppUpdateCredentialAssocForEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppUpdateCredentialAssocForEntity
  @i_entityId integer,
  @i_entityType integer,
  @i_credentialId integer
AS
  DECLARE @o_credentialAssocId integer
SET NOCOUNT ON
IF EXISTS (SELECT 1 FROM APP_Credentials WHERE credentialId = @i_credentialId)
	BEGIN
		DECLARE @l_localCredentialAssocId integer = 0
IF @i_entityType = 186
		BEGIN
			SELECT @l_localCredentialAssocId = CredentialAssocId FROM MMDeviceController WHERE DeviceControllerId = @i_entityId
		END
		ELSE
		BEGIN
			SELECT	@l_localCredentialAssocId = ACS.assocId
			FROM	APP_CredentialAssoc ACS WITH (READUNCOMMITTED)
				INNER JOIN  APP_Credentials AC WITH (READUNCOMMITTED)
				ON	ACS.credentialId = AC.credentialId
			WHERE	ACS.entityId = @i_entityId AND ACS.entityType = @i_entityType
		END
		IF @l_localCredentialAssocId = 0
		BEGIN
			SET @o_credentialAssocId = 0
			SELECT @o_credentialAssocId = assocId FROM APP_CredentialAssoc WHERE entityId = @i_entityId and entityType = @i_entityType
			IF @o_credentialAssocId = 0
			BEGIN
				-- No association exists, create the association now
				INSERT INTO APP_CredentialAssoc (credentialId, entityType, entityId)
				VALUES(@i_credentialId, @i_entityType, @i_entityId)
				SET @o_credentialAssocId = SCOPE_IDENTITY()
			END
			-- Update the caller entity's table with the credential association Id
			-- Every time support for credential association is added to a new table / entity type
			-- the corresponding table can be updated here with the newly created association's Id
IF @i_entityType = 186
				BEGIN
					-- If we are working with a disk device, empty out username and password
					-- If we are working with a cloud device, empty out password only
					UPDATE MDC
					SET MDC.CredentialAssocId = @o_credentialAssocId,
					MDC.Userpassword = '',
					MDC.Username =	CASE
WHEN MD.DeviceTypeId >= 2 AND MD.DeviceTypeID <= 1000 THEN MDC.UserName
						ELSE ''
					END
					FROM MMDeviceController MDC
					INNER JOIN MMDevice MD ON MD.DeviceId = MDC.DeviceId
					WHERE MDC.DeviceControllerId = @i_entityId
				END
		END
		ELSE
		BEGIN
			-- Association exists, just update the association if a new credential Id was passed in
			SET @o_credentialAssocId = @l_localCredentialAssocId
			IF EXISTS (SELECT 1 FROM APP_Credentials WHERE credentialId = @i_credentialId)
			-- Update the credential association table with the new credential ID
				BEGIN
					UPDATE APP_CredentialAssoc SET credentialId = @i_credentialId
					WHERE assocId = @l_localCredentialAssocId
					AND credentialId <> @i_credentialId
				END
		END
		SELECT @o_credentialAssocId
	END
ELSE
	-- No credential with the passed in credential Id exists, return error
	SELECT -1;
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateCredentialAssocForEntity')
	delete from GxQscripts where name = 'AppUpdateCredentialAssocForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCredentialAssocForEntity')
	delete from GXDBVersions where aliasname = 'AppUpdateCredentialAssocForEntity'
GO

insert into GXDBVersions values(2, 'AppUpdateCredentialAssocForEntity',  '00010001000200040000', 'AppUpdateCredentialAssocForEntity', '00010001000200040000')
GO

