

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateContinuousReplicationTaskInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppUpdateContinuousReplicationTaskInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateContinuousReplicationTaskInfo <<<'
	drop procedure AppUpdateContinuousReplicationTaskInfo
END
IF EXISTS (select * from GxQscripts where name='AppUpdateContinuousReplicationTaskInfo')
	delete from GxQscripts where name = 'AppUpdateContinuousReplicationTaskInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateContinuousReplicationTaskInfo')
	delete from GXDBVersions where aliasname = 'AppUpdateContinuousReplicationTaskInfo'
GO
print '... Creating Procedure: AppUpdateContinuousReplicationTaskInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppUpdateContinuousReplicationTaskInfo
  @userId INT,
  @localeId INT = 0,
  @xmlstr XML 	OUTPUT
AS
SET NOCOUNT ON
BEGIN TRY
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX)
	IF object_id('tempdb.dbo.#blrPairInfoTempTable') IS NOT NULL
		DROP TABLE #blrPairInfoTempTable
	CREATE TABLE #blrPairInfoTempTable
	(
		pairId 						INT PRIMARY KEY,
		subclientId					INT,
		hypervisorClientId 			INT,
		hasPermissionOnHypervisor	INT DEFAULT 0,
		sourceVMClientId			INT,
		hasPermissionOnSourceVM		INT DEFAULT 0,
		taskInfoXMLStr				NVARCHAR(MAX),
	)
	-- READ INPUT INFO
	INSERT INTO #blrPairInfoTempTable
	(pairId, taskInfoXMLStr)
	SELECT ref.value('@pairId', 'INT') as 'pairId', REPLACE(CAST(T2.Opt.query('.') AS NVARCHAR(MAX)), 'taskInfo', 'TMMsg_TaskInfo')
	FROM @xmlstr.nodes('/TMMsg_UpdateReplicationTaskInfoReq/replicationTaskInfo') as T(ref)
	CROSS APPLY ref.nodes('taskInfo') AS T2(Opt)
	UPDATE I
	SET hypervisorClientId = A.clientId, subclientId = B.subClientId
	FROM #blrPairInfoTempTable I
	JOIN BlrPair B ON I.pairId = B.id
	JOIN APP_Application A ON B.subClientId = A.id
	UPDATE I
	SET sourceVMClientId = C.componentNameId
	FROM #blrPairInfoTempTable I
	JOIN BlrPair B ON I.pairId = B.id
	JOIN App_ClientProp C ON C.attrName = 'Virtual Machine Instance UUID' AND C.modified = 0 AND C.attrVal = B.srcGuid
	-- PERMISSION CHECK
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	CREATE TABLE #permissionIdTable (permissionId INT)
	INSERT INTO #permissionIdTable
	(permissionId)
VALUES (31), (3), (20), (22)
EXEC sec_getObjectsWithPermissionsV2 @userId, 3, 0
	UPDATE I
	SET hasPermissionOnHypervisor = 1
	FROM #blrPairInfoTempTable I
	JOIN #getObjectsTable O ON I.hypervisorClientId = O.entityId
	UPDATE I
	SET hasPermissionOnSourceVM = 1
	FROM #blrPairInfoTempTable I
	JOIN #getObjectsTable O ON I.sourceVMClientId = O.entityId
	-- REMOVE RECORD WHERE USER DOES NOT HAVE PERMISSIONS ON NEITHER HYPERVISOR CLIENT NOR SOURCE VM CLIENT
	DELETE FROM #blrPairInfoTempTable
	WHERE hasPermissionOnHypervisor = 0 AND hasPermissionOnSourceVM = 0
	-- UPDATE TASK INFO FOR EACH PAIR
	UPDATE APP_SubclientProp
	SET attrVal = taskInfoXMLStr
	FROM APP_SubclientProp S
	JOIN #blrPairInfoTempTable I
ON S.attrName = N'Virtual Server Block Level Replication Restore XML'
AND S.cs_attrName = CHECKSUM(N'Virtual Server Block Level Replication Restore XML')
		AND S.modified = 0
		AND I.subClientId = S.componentNameId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
	SET @xmlstr = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateContinuousReplicationTaskInfo')
	delete from GxQscripts where name = 'AppUpdateContinuousReplicationTaskInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateContinuousReplicationTaskInfo')
	delete from GXDBVersions where aliasname = 'AppUpdateContinuousReplicationTaskInfo'
GO

insert into GXDBVersions values(2, 'AppUpdateContinuousReplicationTaskInfo',  '00000000000000000000', 'AppUpdateContinuousReplicationTaskInfo', '00000000000000000000')
GO

