

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateCompanyPropWithRetireClientJobId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateCompanyPropWithRetireClientJobId.sp,v $ $Id: AppUpdateCompanyPropWithRetireClientJobId.sp,v 1.1.2.1 2020/09/27 09:57:30 jswaminathan Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"AppUpdateCompanyPropWithRetireClientJobId"               				|
--  |       Author	    :	sghatbale                            			|
--  | Execute the System stored procedure to update retire client job id    |
--	| in company prop table. The Job is for retiring all the clients of		|
--	| company except MA clients												|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateCompanyPropWithRetireClientJobId')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateCompanyPropWithRetireClientJobId <<<'
	drop procedure AppUpdateCompanyPropWithRetireClientJobId
END
IF EXISTS (select * from GxQscripts where name='AppUpdateCompanyPropWithRetireClientJobId')
	delete from GxQscripts where name = 'AppUpdateCompanyPropWithRetireClientJobId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCompanyPropWithRetireClientJobId')
	delete from GXDBVersions where aliasname = 'AppUpdateCompanyPropWithRetireClientJobId'
GO
print '... Creating Procedure: AppUpdateCompanyPropWithRetireClientJobId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateCompanyPropWithRetireClientJobId
  @companyId INTEGER,
  @jobId BIGINT,
  @IsMAClientJobId INTEGER = 0
AS
  DECLARE @errorCode INT
set @errorCode = 0
BEGIN TRY
	DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
	IF @IsMAClientJobId = 1
	BEGIN
IF EXISTS (SELECT 1 FROM App_CompanyProp WITH (NOLOCK) WHERE componentNameId = @companyId AND attrName = 'CompanyRetireMAClientsJobId' AND modified = 0 )
		BEGIN
			UPDATE App_CompanyProp
			SET modified = @nowTime
			WHERE componentNameId = @companyId
AND attrName = 'CompanyRetireMAClientsJobId'
				AND modified = 0
		END
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'CompanyRetireMAClientsJobId', 7, @jobId, @nowTime, 0)
	END
	ELSE
	BEGIN
IF EXISTS (SELECT 1 FROM App_CompanyProp WITH (NOLOCK) WHERE componentNameId = @companyId AND attrName = 'CompanyRetireClientsJobId' AND modified = 0 )
		BEGIN
			UPDATE App_CompanyProp
			SET modified = @nowTime
			WHERE componentNameId = @companyId
AND attrName = 'CompanyRetireClientsJobId'
				AND modified = 0
		END
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'CompanyRetireClientsJobId', 7, @jobId, @nowTime, 0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = 1
END CATCH
SELECT @errorCode AS 'errorCode'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateCompanyPropWithRetireClientJobId')
	delete from GxQscripts where name = 'AppUpdateCompanyPropWithRetireClientJobId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCompanyPropWithRetireClientJobId')
	delete from GXDBVersions where aliasname = 'AppUpdateCompanyPropWithRetireClientJobId'
GO

insert into GXDBVersions values(2, 'AppUpdateCompanyPropWithRetireClientJobId',  '00010001000200010000', 'AppUpdateCompanyPropWithRetireClientJobId', '00010001000200010000')
GO

