

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateCompanyDomainOnConflictWithProvider.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Get all the users that belongs to the organization of the userId and that are not of provider type 2(AD)
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateCompanyDomainOnConflictWithProvider')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateCompanyDomainOnConflictWithProvider <<<'
	drop procedure AppUpdateCompanyDomainOnConflictWithProvider
END
IF EXISTS (select * from GxQscripts where name='AppUpdateCompanyDomainOnConflictWithProvider')
	delete from GxQscripts where name = 'AppUpdateCompanyDomainOnConflictWithProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCompanyDomainOnConflictWithProvider')
	delete from GXDBVersions where aliasname = 'AppUpdateCompanyDomainOnConflictWithProvider'
GO
print '... Creating Procedure: AppUpdateCompanyDomainOnConflictWithProvider'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateCompanyDomainOnConflictWithProvider
  @ownerCompanyId INT,
  @providerDomainName nvarchar(512),
  @errorCode INT OUTPUT,                    
  @errorString NVARCHAR(MAX) OUTPUT
AS
SET @errorCode = 0
BEGIN TRY
	--company domain name is same as AD that is getting created. So rename the company domain nanme to add .local.
	--After chaging the alias name of the company update users login name, the smart client group rule and APP_AdvanceSettings properties of the company. This logic is same as updating the aliasName of the company in AppSetCompanyProperties.sp
IF(@ownerCompanyId > 0 AND EXISTS(SELECT 1 FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @providerDomainName and serviceType=5 and id=@ownerCompanyId))
	BEGIN
		DECLARE @newAliasName nvarchar(255) = @providerDomainName + '.local'
EXEC AppGetUniqueEntityName 61,@newAliasName,1,@newAliasName OUTPUT
		--Now update it's related entities
		UPDATE UMDSProviders SET domainName = @newAliasName where id=@ownerCompanyId
		--update login name of all the users
		UPDATE UMUsers SET LOGIN = REPLACE(cast(login as NVARCHAR(MAX)),@providerDomainName  + '\', @newAliasName + '\')
		WHERE umDSproviderId=@ownerCompanyId
		DECLARE @companyGroup int = 0
		SELECT @companyGroup = CG.id FROM APP_ClientGroup CG
		INNER JOIN App_CompanyProp C ON C.attrValInt=CG.id
WHERE C.componentNameId = @ownerCompanyId AND C.attrName ='Associated Smart Client Group' AND C.modified = 0 AND C.cs_attrName = CHECKSUM('Associated Smart Client Group') -- 'Associated Smart Client Group'
		--Update the client group rule
		IF(@companyGroup > 0)
		BEGIN
			DECLARE @xmlRule XML
			SELECT @xmlRule=ruleXML FROM App_SCGRule WHERE scgId=@companyGroup
			SET @xmlRule.modify('replace value of (/scgRule/rules/rule/rules/rule[@propID=("44")]/@secValue)[1] with sql:variable("@newAliasName")')
			SET @xmlRule.modify('replace value of (/scgRule/rules/rule/rules/rule[@propID=("55")]/@secValue)[1] with sql:variable("@newAliasName")')
			UPDATE App_SCGRule SET ruleXml=@xmlRule WHERE scgId=@companyGroup
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   SET @errorCode = ERROR_NUMBER()
   SET @errorString = 'Error updating company domain name for the provider.'
END	  CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateCompanyDomainOnConflictWithProvider')
	delete from GxQscripts where name = 'AppUpdateCompanyDomainOnConflictWithProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCompanyDomainOnConflictWithProvider')
	delete from GXDBVersions where aliasname = 'AppUpdateCompanyDomainOnConflictWithProvider'
GO

insert into GXDBVersions values(2, 'AppUpdateCompanyDomainOnConflictWithProvider',  '00000000000000000000', 'AppUpdateCompanyDomainOnConflictWithProvider', '00000000000000000000')
GO

