

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateCommcellNotificationStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateCommcellNotificationStatus.sp,v $ $Id: AppUpdateCommcellNotificationStatus.sp,v 1.1.2.3 2020/09/13 05:06:28 riyer Exp $";
-- ====================================================================
-- Author:		Rohit Iyer
-- Create date: 03/22/2018
-- Description:	Update and track commcell pending notifications status
-- ====================================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateCommcellNotificationStatus')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateCommcellNotificationStatus <<<'
	drop procedure AppUpdateCommcellNotificationStatus
END
IF EXISTS (select * from GxQscripts where name='AppUpdateCommcellNotificationStatus')
	delete from GxQscripts where name = 'AppUpdateCommcellNotificationStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCommcellNotificationStatus')
	delete from GXDBVersions where aliasname = 'AppUpdateCommcellNotificationStatus'
GO
print '... Creating Procedure: AppUpdateCommcellNotificationStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateCommcellNotificationStatus
AS
BEGIN TRY
SET NOCOUNT ON
  DECLARE @errorCode int = 0
  DECLARE @errorMessage nvarchar(1024) = ''
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
------------------------------------------------Message Status----------------------------------------------
--WAITING_ON_USER_ACK = 1
--WAITING_ON_TASK_COMPLETION = 2
--COMPLETED = 4
--ERROR = 8
----------------------------------------------Entity Types---------------------------------------------------
--CRITICAL_FIXES = 1
-------------------------------------------------------------------------------------------------------------
--This procedure deals with the status of entries in table [CommServ.CommcellPopupNotifications]
IF object_id('tempdb.dbo.#AddPatches') is not null
		DROP TABLE #AddPatches
Create Table #AddPatches
(
	AdditionalPatches     		nvarchar(max)
)
insert into #AddPatches
SELECT DISTINCT CAST(AdditionalPatches AS NVARCHAR(MAX))  FROM simInstalledPackages
WHERE AdditionalPatches IS NOT NULL
--Store notificaiton list and properties in temp table
IF object_id('tempdb.dbo.#CommcellNotifListTbl') is not null
		DROP TABLE #CommcellNotifListTbl
Create Table #CommcellNotifListTbl
(
	updateName     		nvarchar(50)
)
--Get the list of all updates installed after service pack installation/upgrade
insert into #CommcellNotifListTbl
SELECT DISTINCT Split.a.value('.', 'NVARCHAR(100)') AS String
FROM  ( SELECT CAST ('<M>' + REPLACE(cast(AdditionalPatches as nvarchar(100)), ',', '</M><M>') + '</M>' AS XML) AS String
	FROM  #AddPatches AS A ) AS B
	CROSS APPLY B.String.nodes ('/M') AS Split(a)
	--Delete all invalid entries
	delete from #CommcellNotifListTbl where updateName = 'None' or updateName like '%Pre-Release%'
--1. Msg Type : Critical fixes
begin
	-- using the implicit transaction since only 1 operation
	--Update the CommcellPopupNotifications table to update the status of critical fixes
	--if found installed on the commcell
	update  A
	set	A.flag = 4--COMPLETED
	from	CommcellPopupNotifications A inner join #CommcellNotifListTbl B on A.entityIdentifier = B.updateName
	where 	A.msgType = 1 and A.entityType = 1 and (A.flag & 4) = 0
end
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    IF @@TRANCOUNT > 0
        ROLLBACK TRANSACTION;
END CATCH
SEND_RESPONSE:
SELECT  @errorCode , @errorMessage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateCommcellNotificationStatus')
	delete from GxQscripts where name = 'AppUpdateCommcellNotificationStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCommcellNotificationStatus')
	delete from GXDBVersions where aliasname = 'AppUpdateCommcellNotificationStatus'
GO

insert into GXDBVersions values(2, 'AppUpdateCommcellNotificationStatus',  '00010001000200030000', 'AppUpdateCommcellNotificationStatus', '00010001000200030000')
GO

