

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateCloudLaptopStats.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppUpdateCloudLaptopStats')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateCloudLaptopStats <<<'
	drop procedure AppUpdateCloudLaptopStats
END
IF EXISTS (select * from GxQscripts where name='AppUpdateCloudLaptopStats')
	delete from GxQscripts where name = 'AppUpdateCloudLaptopStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCloudLaptopStats')
	delete from GXDBVersions where aliasname = 'AppUpdateCloudLaptopStats'
GO
print '... Creating Procedure: AppUpdateCloudLaptopStats'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppUpdateCloudLaptopStats
  @xmlText XML
AS
DECLARE @outXml XML
DECLARE @appId INT
DECLARE @errorCode INT = 0
DECLARE @error nvarchar(max)
DECLARE @appGuid nvarchar(64) = @xmlText.value('(/Indexing_UpdateCloudLaptopStatsReq/@appGuid)[1]', 'nvarchar(64)')
DECLARE @appSize BIGINT = ISNULL(@xmlText.value('(/Indexing_UpdateCloudLaptopStatsReq/@applicationSize)[1]', 'BIGINT'), -1)
DECLARE @backupSize BIGINT = ISNULL(@xmlText.value('(/Indexing_UpdateCloudLaptopStatsReq/@backupSize)[1]', 'BIGINT'), -1)
DECLARE @backupTime INT = ISNULL(@xmlText.value('(/Indexing_UpdateCloudLaptopStatsReq/@lastbackupTime)[1]', 'INT'), -1)
SELECT @appId = id FROM APP_Application WITH(NOLOCK) WHERE GUID = @appGuid
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp SCP WITH(NOLOCK)
				WHERE SCP.attrName = 'Cloud Mode Enabled' AND SCP.attrVal = N'1' AND SCP.modified = 0 AND SCP.componentNameId = @appId)
	BEGIN
		SET @errorCode = 1
		SET @error = 'Cloud latop mode not enabled for appguid ' + @appGuid
		GOTO EXIT_SP
	END
DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
DECLARE @updateProps table(propName nvarchar(max),  propType INT, propVal BIGINT)
IF @backupSize <> -1
	INSERT INTO @updateProps values('Last Backup Size', 15, CAST(@backupSize AS nvarchar(max)))
IF @backupTime > 0
	INSERT INTO @updateProps values('Last Data Protected Time', 7, CAST(@backupTime AS nvarchar(max)))
MERGE App_subclientprop t USING @updateProps s
ON ((t.componentNameId = @appId) AND (t.attrName = s.propName) AND (t.modified = 0))
WHEN NOT MATCHED BY TARGET THEN
	INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@appId, s.propName, s.propType, s.propVal, @currentTime, 0, 0)
WHEN MATCHED THEN
	UPDATE SET t.attrVal = s.propVal;
-- update idaprop for showing completed job status in Client listing.
IF @backupTime > 0
BEGIN
	DECLARE @jobStatus nvarchar(max) ='<lastBackupJobInfo status="1"><startTime time="' + CAST(@backupTime AS nvarchar(max)) +'"/></lastBackupJobInfo>'
	DECLARE @idaId INT
	SELECT @idaId = IDA.id FROM APP_IDAName IDA WITH(NOLOCk) INNER JOIN APP_Application APP WITH(NOLOCK)
			 ON IDA.clientId = APP.clientId  AND IDA.appTypeId = APP.appTypeId WHERE
			 APP.GUID = @appGuid
	UPDATE APP_IDAProp SET attrVal = @jobStatus WHERE componentNameId = @idaId AND attrName = 'Last Backup Job Info' and modified = 0
	IF @@ROWCOUNT = 0
		INSERT INTO APP_IDAProp values(@idaId, 'Last Backup Job Info', 15, @jobStatus, @currentTime, 0, 0)
END
IF @appSize <> -1
BEGIN
	-- update quota/appsize
	DECLARE @guid VARCHAR(36) = @appGuid
	DECLARE @bsGuid VARCHAR(36)
	DECLARE @bsId INT
	SELECT @bsGuid = BS.GUID, @bsId = BS.id FROM APP_BackupSetName BS WITH(NOLOCK) INNER JOIN
		 APP_Application APP WITH(NOLOCK) ON APP.backupSet = BS.id WHERE APP.GUID = @appGuid
	IF dbo.isSubClientIndexEnabled(@bsId) <> 1
		SET @guid = @bsGuid
	DECLARE @spaceUseXml XML = '<App_FSBackupSetUsage backupSetGuid="' + CAST(@guid AS nvarchar(max)) + '" spaceConsumed="' + CAST(@appSize AS nvarchar(max)) + '"></App_FSBackupSetUsage>'
	exec AppUpdateFileSystemUsage2 @spaceUseXml
END
EXIT_SP:
	SET @outXml = (SELECT @errorCode AS '@errorCode' , @error AS 'errorDescription'
        FOR XML PATH ('Common_Ack'),TYPE)
    SELECT @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateCloudLaptopStats')
	delete from GxQscripts where name = 'AppUpdateCloudLaptopStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCloudLaptopStats')
	delete from GXDBVersions where aliasname = 'AppUpdateCloudLaptopStats'
GO

insert into GXDBVersions values(2, 'AppUpdateCloudLaptopStats',  '00000000000000000000', 'AppUpdateCloudLaptopStats', '00000000000000000000')
GO

