

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateClientGroupCLAUsages.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2013  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateClientGroupCLAUsages.sp,v $ $Id: AppUpdateClientGroupCLAUsages.sp,v 1.1.2.4 2017/03/30 03:41:14 sbhukar Exp $";
-- =========================================================
-- Author: Sunil Telagamsetti
-- Description: Update the user mailbox usage
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateClientGroupCLAUsages <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateClientGroupCLAUsages')
	drop procedure AppUpdateClientGroupCLAUsages
IF EXISTS (select * from GxQscripts where name='AppUpdateClientGroupCLAUsages')
	delete from GxQscripts where name = 'AppUpdateClientGroupCLAUsages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateClientGroupCLAUsages')
	delete from GXDBVersions where aliasname = 'AppUpdateClientGroupCLAUsages'
GO
print '... Creating Procedure: AppUpdateClientGroupCLAUsages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateClientGroupCLAUsages
  @xmlText XML
AS
SET NOCOUNT ON;
--
BEGIN TRY
	DECLARE @inCCId int;
	SELECT @inCCId = N.value('@commCellId', 'int') FROM @xmlText.nodes ('App_ClientGroupCLAUsages') AS T(N);
	DECLARE @globalQuotaUpdateTime INT = dbo.GetUnixTime(GETUTCDATE())
	CREATE TABLE #ClientGroupQuotaUsage
	(
	        clientGroupId   INT,
	        ClientGroupName NVARCHAR(512),
	        globalUsedGB    BIGINT,
	        globalLimitGB   BIGINT,
	        updateTime      INT,
			quotaType		INT,
			expiryTime		INT
	)
	INSERT INTO #ClientGroupQuotaUsage
	SELECT DISTINCT
	0 AS clientGroupId,
	N.value('@clientGroupName', 'nvarchar(max)') AS clientGroupName,
	N.value('@quotaUsedGB', 'int') AS quotaUsedGB,
	N.value('@quotaLimitGB', 'int') AS quotaLimitGB,
	N.value('@updateTime', 'int') AS updateTime,
	N.value('@quotaType', 'int') AS quotaType,
	N.value('@expiryTime', 'int') AS expiryTime
	FROM @xmlText.nodes ('App_ClientGroupCLAUsages/usageData') AS T(N)
	EXEC RptSetClientGroupQuotaUsage 1
	IF EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'Global Client Group Quota Update Time')
		UPDATE GxGlobalParam set value = CAST(@globalQuotaUpdateTime AS NVARCHAR(MAX)) WHERE name = 'Global Client Group Quota Update Time' and modified = 0
	ELSE
		INSERT INTO GXGlobalParam VALUES('Global Client Group Quota Update Time', CAST(@globalQuotaUpdateTime AS NVARCHAR(MAX)), @globalQuotaUpdateTime, 0 )
	-- return success response
	SET @xmlText = (SELECT 0 AS '@errorCode', NULL AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
	SELECT @xmlText;
	--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
	--
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
	SELECT @xmlText;
	IF object_id('tempdb.dbo.#ClientGroupQuotaUsage') is not null DROP TABLE #ClientGroupQuotaUsage
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateClientGroupCLAUsages')
	delete from GxQscripts where name = 'AppUpdateClientGroupCLAUsages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateClientGroupCLAUsages')
	delete from GXDBVersions where aliasname = 'AppUpdateClientGroupCLAUsages'
GO

insert into GXDBVersions values(2, 'AppUpdateClientGroupCLAUsages',  '00010001000200040000', 'AppUpdateClientGroupCLAUsages', '00010001000200040000')
GO

