

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateClientFeatures.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016 CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppUpdateClientFeatures()
--  |
--  | Description:  SP for Pushing Modified Features to clients.
--  |
--  |       Input:  Modified Features
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   1.0		   rengu  	To Send Modified Feature List to client through Work Queue Token
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateClientFeatures <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateClientFeatures')
	drop procedure AppUpdateClientFeatures
IF EXISTS (select * from GxQscripts where name='AppUpdateClientFeatures')
	delete from GxQscripts where name = 'AppUpdateClientFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateClientFeatures')
	delete from GXDBVersions where aliasname = 'AppUpdateClientFeatures'
GO
print '... Creating Procedure: AppUpdateClientFeatures'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateClientFeatures
  @xmldata XML
AS
  DECLARE @oxml XML
DECLARE @errorCode INT=0
DECLARE @errorString nvarchar(MAX)=N''
DECLARE @workQueueParam nvarchar(MAX)=N''
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	CREATE TABLE #clientIds
	(
		clientId integer,
	);
	DECLARE @featuretype INT = 6
	DECLARE @archivingEnabled INT = ISNULL ((
	SELECT R.ref.value('@enable','INT') FROM @xmldata.nodes('/App_UpdateFeatureList/featureList[@featureType=sql:variable("@featuretype")]') R(ref)
	), -1)
	INSERT INTO #clientIds
	SELECT ref.value('@clientId', 'INT')
	FROM  @xmldata.nodes ('App_UpdateFeatureList/clients/client') R(ref)
	DECLARE @xmlToSend XML = @xmldata
	SET @xmlToSend.modify('
		delete /App_UpdateFeatureList/clients
	')
	SET @workQueueParam = CAST(@xmlToSend AS NVARCHAR(MAX))
	-- Pushing Work Queue Token
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT DISTINCT clientId, 28/*WORK_TOKEN_FEATURE_LIST*/, @workQueueParam, dbo.getUnixTime(GetUTCDate()), 0, 0, 0, -1
	FROM #clientIds
	DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
	IF @archivingEnabled = 1
	BEGIN
		if OBJECT_ID('tempdb.dbo.#enabledclientIds') is not null drop table dbo.#enabledclientIds
		CREATE TABLE #enabledclientIds
		(
			clientId integer,
		);
		DECLARE @enableClient INT = 1
		INSERT INTO #enabledclientIds
		SELECT ref.value('@clientId', 'INT')
		FROM  @xmldata.nodes ('App_UpdateFeatureList/clients[@enable=sql:variable("@enableClient")]/client') R(ref)
		UPDATE APP_SubClientProp SET modified= @nowTime
		FROM (
			SELECT SC.id
			FROM APP_Application SC
INNER JOIN #clientIds C ON SC.clientId = C.clientId AND SC.subclientStatus & 0x00008 = 0x00008
		) Subclient
		WHERE componentNameId = Subclient.id
		AND attrName = 'Is Archive Retention Mode Enabled'
		INSERT INTO APP_SubClientProp
		SELECT SC.id,N'Is Archive Retention Mode Enabled' , 7, 1 , @nowTime, 0, 0
				FROM APP_Application SC
INNER JOIN #clientIds C ON SC.clientId = C.clientId AND SC.subclientStatus & 0x00008 = 0x00008
		UPDATE APP_SubClientProp SET modified= @nowTime
		FROM (
			SELECT SC.id
			FROM APP_Application SC
INNER JOIN #clientIds C ON SC.clientId = C.clientId AND SC.subclientStatus & 0x00008 = 0x00008
		) Subclient
		WHERE componentNameId = Subclient.id
		AND attrName = 'User deleted stubs expiration days'
		INSERT INTO APP_SubClientProp
		SELECT SC.id,N'User deleted stubs expiration days', 7, 730 , @nowTime, 0, 0
				FROM APP_Application SC
INNER JOIN #clientIds C ON SC.clientId = C.clientId AND SC.subclientStatus & 0x00008 = 0x00008
		UPDATE APP_SubClientProp SET modified= @nowTime
		FROM (
			SELECT SC.id
			FROM APP_Application SC
INNER JOIN #clientIds C ON SC.clientId = C.clientId AND SC.subclientStatus & 0x00008 = 0x00008
		) Subclient
		WHERE componentNameId = Subclient.id
		AND attrName = 'Is Turbo Subclient'
		INSERT INTO APP_SubClientProp
		SELECT SC.id,N'Is Turbo Subclient' , 7, 1 , @nowTime, 0, 0
				FROM APP_Application SC
INNER JOIN #clientIds C ON SC.clientId = C.clientId AND SC.subclientStatus & 0x00008 = 0x00008
		INSERT INTO APP_IDAProp
		SELECT AG.id,N'Enable Archive' , 2, 1 , @nowTime, 0, 0
				FROM APP_IDAName AG
					INNER JOIN #enabledclientIds C ON AG.clientId = C.clientId
				WHERE AG.appTypeId IN (
					select appTypeId from APP_AppTypeGroupAssoc where appGroupId IN ( 57, 34) /*APPGRP_WindowsFileSystemIDA*/
				)
		INSERT INTO APP_IDAProp
		SELECT AG.id,N'Use Archiver Driver' , 2, 1 , @nowTime, 0, 0
				FROM APP_IDAName AG
					INNER JOIN #enabledclientIds C ON AG.clientId = C.clientId
				WHERE AG.appTypeId IN (
					select appTypeId from APP_AppTypeGroupAssoc where appGroupId = 34 /*APPGRP_UnixFileSystem*/
				)
		if OBJECT_ID('tempdb.dbo.#enabledclientIds') is not null drop table dbo.#enabledclientIds
	END
	ELSE IF(@archivingEnabled = 0)
	BEGIN
		UPDATE APP_SubClientProp SET modified= @nowTime
		FROM (
			SELECT SC.id
			FROM APP_Application SC
INNER JOIN #clientIds C ON SC.clientId = C.clientId AND SC.subclientStatus & 0x00008 = 0x00008
		) Subclient
		WHERE componentNameId = Subclient.id
		AND attrName = 'Is Turbo Subclient'
		DELETE FROM APP_IDAProp WHERE componentNameId IN (SELECT AN.id FROM APP_IDAName AN WHERE EXISTS (SELECT * FROM #clientIds C WHERE C.clientId = AN.clientId))
			AND attrName IN ('Enable Archive', 'Use Archiver Driver')
	END
	if OBJECT_ID('tempdb.dbo.#clientIds') is not null drop table dbo.#clientIds
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = N'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
	SET @oxml = (
					SELECT	@errorCode as '@errorCode',
							@errorString as '@errorMessage'
								FOR XML PATH ('error'),TYPE
				 )
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateClientFeatures')
	delete from GxQscripts where name = 'AppUpdateClientFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateClientFeatures')
	delete from GXDBVersions where aliasname = 'AppUpdateClientFeatures'
GO

insert into GXDBVersions values(2, 'AppUpdateClientFeatures',  '00000000000000000000', 'AppUpdateClientFeatures', '00000000000000000000')
GO

