

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateCMCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppUpdateCMCredentials					    |
--	|				Update Credential Manager Records					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateCMCredentials')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateCMCredentials <<<'
	drop procedure AppUpdateCMCredentials
END
IF EXISTS (select * from GxQscripts where name='AppUpdateCMCredentials')
	delete from GxQscripts where name = 'AppUpdateCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCMCredentials')
	delete from GXDBVersions where aliasname = 'AppUpdateCMCredentials'
GO
print '... Creating Procedure: AppUpdateCMCredentials'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateCMCredentials
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @ixml XML
-----------------------------------------------------------
AS
  DECLARE @oxml XML
SET NOCOUNT ON
BEGIN TRY
	DECLARE @userId int
	DECLARE @locale int = 0
	DECLARE @o_ErrorString   NVARCHAR(max) =''
	DECLARE @o_ErrorCode     integer=0
	DECLARE @validData       integer=1
	DECLARE @creatorUserOrGroupId   integer=0
	DECLARE @creatorType   integer=0
	DECLARE @secXml xml = ''
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(220 AS NVARCHAR(10)) + ',' + CAST(218 AS NVARCHAR(10))
	if OBJECT_ID('tempdb.dbo.#credToUpdate') is not null drop table dbo.#credToUpdate
	if OBJECT_ID('tempdb.dbo.#credIdsUserHaveRights') is not null drop table dbo.#credIdsUserHaveRights
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int')
	FROM @ixml.nodes('App_UpdateCredentialRecordReq/processinginstructioninfo/user') R ( ref )),0)
	SET @locale = ISNULL((SELECT  ref.value('@localeId', 'int')
	FROM @ixml.nodes('App_UpdateCredentialRecordReq/processinginstructioninfo/locale') R ( ref )),0)
	create table #credToUpdate
	(
		credentialId		integer PRIMARY KEY,
		ownerUserOrGroupId	integer,
		ownerIsUser			integer,
		credentialName		nvarchar(max),
		recordType			integer,
		userName		    nvarchar(max),
		password			nvarchar(max),
		credentialInfo		xml,
		description			nvarchar(max),
		enabled				integer,
		flags				xml,
		secAssoc            xml
	);
	create table #credIdsUserHaveRights
	(
		credentialId integer PRIMARY KEY
	);
	INSERT INTO #credToUpdate
	(credentialId, ownerUserOrGroupId, ownerIsUser, credentialName, recordType,userName,password,credentialInfo,description,enabled,flags,secAssoc)
	SELECT
		Tbl.Col.value('(credentialRecord/@credentialId)[1]', 'int'),
		CASE ISNULL(Tbl.Col.value('(createAs/user/user/@_type_)[1]', 'int'),0)
WHEN 13 THEN Tbl.Col.value('(createAs/user/user/@userId)[1]', 'int')
ELSE (CASE ISNULL(Tbl.Col.value('(createAs/userGroup/@_type_)[1]', 'int'),0) WHEN 15 THEN Tbl.Col.value('(createAs/userGroup/@userGroupId)[1]', 'int') ELSE NULL END)
		END,
		CASE ISNULL(Tbl.Col.value('(createAs/user/user/@_type_)[1]', 'int'),0)
WHEN 13 THEN 13
ELSE (CASE ISNULL(Tbl.Col.value('(createAs/userGroup/@_type_)[1]', 'int'),0) WHEN 15 THEN 15 ELSE NULL END)
		END,
		Tbl.Col.value('(credentialRecord/@credentialName)[1]', 'nvarchar(max)'),
		Tbl.Col.value('(@recordType)[1]', 'int'),
		Tbl.Col.value('(record/@userName)[1]', 'nvarchar(max)'),
		Tbl.Col.value('(record/@password)[1]', 'nvarchar(max)'),
		REPLACE(NULLIF(CAST(Tbl.Col.query('additionalInformation') AS NVARCHAR(MAX)), ''), 'additionalInformation', 'App_AdditionalCredInfo'),
		Tbl.Col.value('(@description)[1]', 'nvarchar(max)'),
		1,
		Tbl.Col.query('flags'),
		REPLACE(NULLIF(CAST(Tbl.Col.query('(securityAssociations)')as NVARCHAR(MAX)), ''), 'securityAssociations', 'App_SecurityAssociationForEntityList')
	 FROM @ixml.nodes('App_UpdateCredentialRecordReq/credentialRecordInfo') as Tbl(Col)
	 SET @validData = 1
	 --Data validation checks
	 IF @validData = 1
	 BEGIN
		IF EXISTS (select 1 from #credToUpdate where (credentialId is NULL) OR ((credentialName is NOT null) AND (credentialName = '')) OR ((userName is NOT NULL) AND (userName = '')) OR ((password is NOT NULL) AND (password = '')))
		BEGIN
			SET @o_ErrorCode = -1
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3449 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @validData = 0
		END
	 END
	 --Owner User/Group validation checks
	 IF @validData = 1
	 BEGIN
IF EXISTS (select 1 from #credToUpdate where (ownerUserOrGroupId IS NOT NULL AND  ownerIsUser=15 and ownerUserOrGroupId not in (select distinct id from UMGroups)) OR (ownerUserOrGroupId IS NOT NULL AND ownerIsUser=13 and ownerUserOrGroupId not in (select DISTINCT id FROM UMUsers where id>0)))
		BEGIN
			SET @o_ErrorCode = -1
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3450 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @validData = 0
		END
	 END
 	 IF @validData = 1
	 BEGIN
	 	IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') is not null drop table dbo.#getMemberUserGroupsHelperOutputTbl
		create table #getMemberUserGroupsHelperOutputTbl
		(
			isUser int,
			userOrGroupId int
		);
		EXEC sec_getMemberUserGroupsHelper @userId
		INSERT INTO #credIdsUserHaveRights
		(credentialId)
		SELECT DISTINCT entityId1 FROM UMSecurityAssociations Sec
		INNER JOIN #getMemberUserGroupsHelperOutputTbl Tbl
		ON Sec.isUser = Tbl.isUSer AND Sec.userOrGroupId = Tbl.userOrGroupId
WHERE entityType1 = 174 AND isCreator = 1
		IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') is not null drop table dbo.#getMemberUserGroupsHelperOutputTbl
		-- credential ids that user does not have ownership
		IF EXISTS (select 1 from #credToUpdate where credentialId NOT IN (SELECT distinct credentialId FROM #credIdsUserHaveRights))
		BEGIN
			SET @o_ErrorCode = -1
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3454 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @validData = 0
		END
	 END
	IF @validData = 1
	BEGIN
		 update #credToUpdate
		 SET password =(CASE
				WHEN (CHARINDEX('|#',password, 1) > 0) THEN (select dbo.base64decode(SUBSTRING(dbo.DecodeInvalidXMLChar(password),2,LEN(dbo.DecodeInvalidXMLChar(password)))))
				ELSE dbo.base64decode(password) END)
		 where password is NOT NULL
		-- update table with new records
		UPDATE apc
		SET credentialName = (case when ciu.credentialName is not null THEN ciu.credentialName ELSE apc.credentialName end),
			recordType  = (case when ciu.recordType is not null THEN ciu.recordType ELSE apc.recordType end),
			userName  = (case when ciu.userName is not null THEN ciu.userName ELSE apc.userName end),
			password  = (case when ciu.password is not null THEN ciu.password ELSE apc.password end),
			credentialInfo  = (case when ciu.credentialInfo is not null THEN ciu.credentialInfo ELSE apc.credentialInfo end),
			description  = (case when ciu.description is not null THEN ciu.description ELSE apc.description end),
			enabled = (case when ciu.enabled is not null THEN ciu.enabled ELSE apc.enabled end),
			flags = (case ciu.flags.exist('//@*') when 0 then apc.flags else
					apc.flags |
					(
(case ciu.flags.exist('flags[@isWorkflowRecord = 1]') when 1 then 1 else 0 end) |
(case ciu.flags.exist('flags[@hasAzureKeyVaultAccess = 1]') when 1 then 2 else 0 end) |
(case ciu.flags.exist('flags[@hasAzureKeyVaultStorageAccess = 1]') when 1 then 4 else 0 end) |
(case ciu.flags.exist('flags[@hidden = 1]') when 1 then 16 else 0 end) |
(case ciu.flags.exist('flags[@hasAzureRSVAccess = 1]') when 1 then 8 else 0 end)
					) & ~
					(
(case ciu.flags.exist('flags[@isWorkflowRecord = 0]') when 1 then 1 else 0 end) |
(case ciu.flags.exist('flags[@hasAzureKeyVaultAccess = 0]') when 1 then 2 else 0 end) |
(case ciu.flags.exist('flags[@hasAzureKeyVaultStorageAccess = 0]') when 1 then 4 else 0 end) |
(case ciu.flags.exist('flags[@hidden = 1]') when 1 then 16 else 0 end) |
(case ciu.flags.exist('flags[@hasAzureRSVAccess = 0]') when 1 then 8 else 0 end)
					) end)
		FROM #credToUpdate ciu INNER JOIN APP_Credentials apc ON apc.credentialId=ciu.credentialId
		DECLARE @credIdToUpdate INT = 0
		DECLARE @minLength INT = DATALENGTH('App_SecurityAssociationForEntityList')
		DECLARE updateSecCred CURSOR
		FOR SELECT credentialId FROM #credToUpdate
		OPEN updateSecCred
		FETCH updateSecCred INTO @credIdToUpdate
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @creatorUserOrGroupId = 0
			SET @creatorType = 0
			SET @secXml = ''
			SELECT @creatorUserOrGroupId=ownerUserOrGroupId, @creatorType=ownerIsUser, @secXml=secAssoc FROM #credToUpdate WHERE credentialId=@credIdToUpdate
			IF DATALENGTH(@secXml) > @minLength
			BEGIN
			EXEC[dbo].[sec_setSecurityAssociationsFromEntity]
				@xmlIn = @secXml,
				@userId = @userId,
				@isCmdLine = 0,
				@skipSecurityCheck = 1,
@entityType1 = 174,
				@entityId1 = @credIdToUpdate,
				@entityType2 = 0,
				@entityId2 = 0,
				@entityType3 = 0,
				@entityId3 = 0,
				@entityType4 = 0,
				@entityId4 = 0,
				@entityType5 = 0,
				@entityId5 = 0
			END
			IF @creatorUserOrGroupId>0
			BEGIN
IF @creatorType = 13
					EXEC sec_setCreatorForEntity @loggedInUserID = @userId,
												 @creatorRoleID = 0,
												 @creatorPermissions = @permissionsList,
												 @errorCode = @o_ErrorCode OUTPUT,
												 @errorString = @o_ErrorString OUTPUT,
@entityType1 = 174,
												 @entityId1 = @credIdToUpdate,
												 @creatorUserId = @creatorUserOrGroupId
ELSE IF @creatorType = 15
					EXEC sec_setCreatorForEntity @loggedInUserID = @userId,
												 @creatorRoleID = 0,
												 @creatorPermissions = @permissionsList,
												 @errorCode = @o_ErrorCode OUTPUT,
												 @errorString = @o_ErrorString OUTPUT,
@entityType1 = 174,
												 @entityId1 = @credIdToUpdate,
												 @creatorUserGroupId = @creatorUserOrGroupId
			END
			FETCH updateSecCred INTO @credIdToUpdate
		END
		CLOSE updateSecCred
		DEALLOCATE updateSecCred
		SET @o_ErrorCode = 0
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (29 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_ErrorCode = ERROR_NUMBER()
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2722 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
    --Close cursor
    IF ( CURSOR_STATUS('global', 'updateSecCred') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'updateSecCred') >= 0 )
    CLOSE updateSecCred
    IF ( CURSOR_STATUS('global','updateSecCred') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','updateSecCred') = -1 )
    DEALLOCATE updateSecCred
END CATCH
SET @oxml =
(
	SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorMessage'
    FOR XML PATH ('error'), ROOT('App_UpdateCredentialRecordResp')
)
if OBJECT_ID('tempdb.dbo.#credToUpdate') is not null drop table dbo.#credToUpdate
SELECT @oxml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateCMCredentials')
	delete from GxQscripts where name = 'AppUpdateCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateCMCredentials')
	delete from GXDBVersions where aliasname = 'AppUpdateCMCredentials'
GO

insert into GXDBVersions values(2, 'AppUpdateCMCredentials',  '00000000000000000000', 'AppUpdateCMCredentials', '00000000000000000000')
GO

