

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateBackupset.sp] ---------- 

-----------------------------------------------------------------------------------------------
--   AppUpdateBackupset - Add/Update properties that are stored in the app_backupsetName Table
-----------------------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 2009  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateBackupset.sp,v $ $Id: AppUpdateBackupset.sp,v 1.2.208.1 2019/12/12 22:39:19 vdevassy Exp $";
--#define IS_CCP_SUBCLIENT  1
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateBackupset')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateBackupset <<<'
	drop procedure AppUpdateBackupset
END
IF EXISTS (select * from GxQscripts where name='AppUpdateBackupset')
	delete from GxQscripts where name = 'AppUpdateBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateBackupset')
	delete from GXDBVersions where aliasname = 'AppUpdateBackupset'
GO
print '... Creating Procedure: AppUpdateBackupset'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateBackupset
---------------------------------------
--   PARAMETERS   &   OUTPUTS 		---
---------------------------------------
  @i_id integer,
  @i_mode integer,
  @i_name nvarchar(256),
  @i_status integer,
  @i_refTime integer
AS
-------------------------------------------------------------------------------------------
--   AppUpdateComponent - Replaces "simple" update statement in C++ code for application table
--						  with logic to ensure that changes to CCP objects get propogated to
-- 						  all related objects and that no changes are allowed to objects
--						  that are currently part of a CCP!
-------------------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/SPBodies/AppUpdateComponent.spb,v $ $Id: AppUpdateComponent.spb,v 1.4.60.4 2018/12/28 21:29:38 vikashkumar Exp $";
-------------------------------------------------------
---  LOCAL VARIABLES 								---
-------------------------------------------------------
DECLARE @componentNameId	AS integer = 0
DECLARE @errCode			AS integer = 0				-- Returned as column to caller, 0 == SUCCESS
DECLARE @errString			AS varchar(2048) = ''
DECLARE	@cv_STATUS_CCP		AS integer		= 0x10000		--'CV_STATUS_CCP'
----------------------------------------------------------------------------------------------------------
DECLARE @oldStatus			integer
DECLARE @oldName			nvarchar(128)
DECLARE @ccpId				integer
DECLARE @isCCP				AS integer = 0
BEGIN TRY
SELECT @ccpId = ccpId, @oldStatus = status, @oldName = name
FROM app_backupsetName
	  WHERE id = @i_id
	-------------------------------------------
	-- FETCH CURRENT VALUES FOR Component	---
	-------------------------------------------
	IF @oldStatus is null
	BEGIN
SET @errCode = 0x060001
		SET @errString = 'Error. No object with id[' + convert(varchar(10), @i_id) +'] exists.'
		GOTO ALL_WORK_DONE
	END
	-------------------------------------------
	-- DETERMINE IF THIS IS A CCP or NOT	---
	-------------------------------------------
	IF (@oldStatus & @cv_STATUS_CCP) <> 0
		SET @isCCP = 1
	-----------------------------------------------------------------------
	-- CHECK FOR ATTEMPT TO MODIFY A COMPONENT ASSOCIATED WITH A CCP	---
	-----------------------------------------------------------------------
	IF @ccpId <> 0 AND @isCCP = 0
	BEGIN
		SET @errCode = 0x090004						-- CV_ASSOC_CCP_ATTEMPT
		SET @errString = 'Error. object with id[' + convert(varchar(10), @i_id) +'] is a member of a CCP and cannot be modified directly.'
		GOTO ALL_WORK_DONE
	END
IF @i_mode = (1)						--'APP_SUBJECT_UPDATE_NAME'
UPDATE app_backupsetName
SET name = @i_name, modified = @i_refTime
			WHERE id=@i_id
			   --OR (ccpId = @i_id AND (STATUS_COLUMN & @cv_STATUS_CCP) = 0)
ELSE IF @i_mode = (1 + 2)			-- 'APP_OBJECT_UPDATE_NAME | APP_OBJECT_UPDATE_STATUS'
	BEGIN
UPDATE app_backupsetName
SET name = @i_name, modified = @i_refTime, status = @i_status
			WHERE id=@i_id
		--UPDATE APP_COMPONENT_TABLE
		--SET NAME_COLUMN = @i_name, modified = @i_refTime, STATUS_COLUMN = (@i_status  & ~@cv_STATUS_CCP)
		--	WHERE (ccpId = @i_id AND (STATUS_COLUMN & @cv_STATUS_CCP) = 0)
	END
	ELSE
	BEGIN
		SET @errCode = 0x0A0007						-- 'CV_BAD_ARGS'
		SET @errString = 'Error. object with id[' + convert(varchar(10), @i_id) +'] unknown update mode [' + convert(varchar(4), @i_mode) + '] specified'
		GOTO ALL_WORK_DONE
	END
END	  TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
ALL_WORK_DONE:
SELECT @errCode, @errString


IF EXISTS (select * from GxQscripts where name = 'AppUpdateBackupset')
	delete from GxQscripts where name = 'AppUpdateBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateBackupset')
	delete from GXDBVersions where aliasname = 'AppUpdateBackupset'
GO

insert into GXDBVersions values(2, 'AppUpdateBackupset',  '00010002020800010000', 'AppUpdateBackupset', '00010002020800010000')
GO

