

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateAutomationResults.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppUpdateAutomationResults						|
--	|		 Procedure to get replication information					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateAutomationResults')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateAutomationResults <<<'
	drop procedure AppUpdateAutomationResults
END
IF EXISTS (select * from GxQscripts where name='AppUpdateAutomationResults')
	delete from GxQscripts where name = 'AppUpdateAutomationResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateAutomationResults')
	delete from GXDBVersions where aliasname = 'AppUpdateAutomationResults'
GO
print '... Creating Procedure: AppUpdateAutomationResults'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateAutomationResults
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(256) = ''
DECLARE @o_xmlString XML
BEGIN TRY
	DECLARE @jobId INT = ISNULL((SELECT n.value('@jobId[1]', 'INT') FROM @i_xmlString.nodes('App_UpdateAutomationResults') r(n)), 0)
	IF @jobId > 0
	BEGIN
		DECLARE @startTime INT = ISNULL((SELECT n.value('@startTime[1]', 'INT') FROM @i_xmlString.nodes('App_UpdateAutomationResults') r(n)), 0)
		DECLARE @endTime INT = ISNULL((SELECT n.value('@endTime[1]', 'INT') FROM @i_xmlString.nodes('App_UpdateAutomationResults') r(n)), 0)
		DECLARE @servicePack INT = ISNULL((SELECT n.value('@servicePack[1]', 'INT') FROM @i_xmlString.nodes('App_UpdateAutomationResults') r(n)), 0)
		IF object_id('tempdb.dbo.#testcase_InfoTable') is not null
			DROP TABLE #testcase_InfoTable
		CREATE TABLE #testcase_InfoTable(TestcaseId INT, tcStatus INT, Summary nvarchar(max), featureId INT, OSID INT, AppVerId INT,
		AddPropId INT, TestSetId INT, TstcInsId INT, jobId INT, startTime INT, endTime INT, servicePack INT)
		INSERT INTO #testcase_InfoTable (TestcaseId, tcStatus, Summary, featureId, OSID, AppVerId, AddPropId)
		SELECT i.value('@testcaseId[1]', 'INT') AS TestcaseId, i.value('@status[1]', 'INT') AS tcStatus, i.value('@summary[1]', 'nvarchar(max)') AS Summary,
		f.FeatureID as featureId, os.OSID AS OSID,
		app.AppVersionID as AppVerId, addProp.AddPropID as AddPropId
		FROM @i_xmlString.nodes('App_UpdateAutomationResults/testset') r(n)
		OUTER APPLY n.nodes('./testcase') s(i)
		INNER JOIN HistoryDB.dbo.AUTO_Feature f ON f.DisplayName = n.value('@featureName[1]', 'nvarchar(256)')
		INNER JOIN HistoryDB.dbo.AUTO_TestsetOS os ON os.OSName = n.value('@osName[1]', 'nvarchar(256)')
		LEFT JOIN HistoryDB.dbo.AUTO_AppVersion app ON COALESCE(app.AppVersionName, '') = COALESCE(n.value('@appVersionName[1]', 'nvarchar(256)'), '')
		LEFT JOIN HistoryDB.dbo.AUTO_AddProp addProp ON COALESCE(addProp.AddPropName, '') = COALESCE(n.value('@addPropName[1]', 'nvarchar(256)'), '')
		UPDATE tcInfo
		SET tcInfo.TestSetId = ts.TestsetID, tcInfo.TstcInsId = map.TcTsInstanceID
		FROM #testcase_InfoTable tcInfo
		INNER JOIN HistoryDB.dbo.AUTO_TcTsMap map ON map.TestcaseID = ISNULL(tcInfo.TestcaseId, 0)
		INNER JOIN HistoryDB.dbo.AUTO_Testset ts ON ts.FeatureID = tcInfo.featureId AND tcInfo.OSID = ts.OSID
		WHERE ts.TestsetID = map.TestsetID AND COALESCE(ts.AddPropID, '') = COALESCE(tcInfo.AddPropId, 0) AND COALESCE(ts.AppVersionID, '') = COALESCE(tcInfo.AppVerId, 0)
		UPDATE tcInfo
		SET tcInfo.jobId = @jobId, tcInfo.startTime = @startTime, tcInfo.endTime = @endTime, tcInfo.servicePack = @servicePack
		FROM #testcase_InfoTable tcInfo
		INSERT INTO HistoryDB.dbo.AUTO_JobStatus (JobID, Status, StartDate, EndDate, TcTsInstanceID, ServicePack, Summary)
		SELECT tcInfo.jobId AS JobID, tcInfo.tcStatus AS Status, tcInfo.startTime AS StartDate, tcInfo.endTime AS EndDate, tcInfo.TstcInsId AS TcTsInstanceID,
		tcInfo.servicePack AS ServicePack, tcInfo.Summary AS Summary
		FROM #testcase_InfoTable tcInfo
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid job id.'
	END
END TRY
BEGIN CATCH
	SET @errorCode = @@ERROR
	SET @errorString = 'Failed to update testcase results.'
END CATCH
SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
					FOR XML PATH('App_GenericResp'), TYPE)
SELECT @o_xmlString AS o_xmlString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateAutomationResults')
	delete from GxQscripts where name = 'AppUpdateAutomationResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateAutomationResults')
	delete from GXDBVersions where aliasname = 'AppUpdateAutomationResults'
GO

insert into GXDBVersions values(2, 'AppUpdateAutomationResults',  '00000000000000000000', 'AppUpdateAutomationResults', '00000000000000000000')
GO

