

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateAsyncXMLRequestStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateAsyncXMLRequestStatus.sp,v $ $Id: AppUpdateAsyncXMLRequestStatus.sp,v 1.1.2.5 2018/09/02 03:34:20 logeshg Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateAsyncXMLRequestStatus <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateAsyncXMLRequestStatus')
	drop procedure AppUpdateAsyncXMLRequestStatus
IF EXISTS (select * from GxQscripts where name='AppUpdateAsyncXMLRequestStatus')
	delete from GxQscripts where name = 'AppUpdateAsyncXMLRequestStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateAsyncXMLRequestStatus')
	delete from GXDBVersions where aliasname = 'AppUpdateAsyncXMLRequestStatus'
GO
print '... Creating Procedure: AppUpdateAsyncXMLRequestStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppUpdateAsyncXMLRequestStatus
  @i_requestId INTEGER,
  @i_requestGUID VARCHAR(1024),
  @i_Status INTEGER
AS
  DECLARE @o_ErrorCode INTEGER = 0
DECLARE @nowTime INTEGER = dbo.GetUnixTime(GetUTCDate())
BEGIN TRY
	BEGIN TRANSACTION
	UPDATE APP_XMLRequestInfo
	SET status = (CASE WHEN @i_Status = 8 THEN 0 ELSE @i_Status END),
		retryCount = (CASE WHEN @i_Status = 8 THEN retryCount + 1 ELSE retryCount END),
					lastUpdateTime = @nowTime
	WHERE requestId = @i_requestId AND GUID = @i_requestGUID
	DECLARE @wqId BIGINT= ISNULL((SELECT workQueueId FROM APP_XMLRequestInfo WHERE requestId = @i_requestId AND GUID = @i_requestGUID),0)
	IF @wqId <> 0 AND @i_Status IN (4,8,16,64)
	BEGIN
		DECLARE @inputXML XML
		SET @inputXML =	(SELECT @wqId as '@nWorkQueueID',
							(CASE WHEN @i_Status = 4 OR @i_Status = 16 OR @i_Status = 64 THEN 8 ELSE 0 END) as '@nFlag'
								FOR XML PATH('lRequestList'),ROOT('App_WorkQueueRequestStatusList'))
		exec AppWorkQueueUpdateRequest @inputXML
	END
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_ErrorCode = 1
	ROLLBACK TRANSACTION
END CATCH
SELECT @o_ErrorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateAsyncXMLRequestStatus')
	delete from GxQscripts where name = 'AppUpdateAsyncXMLRequestStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateAsyncXMLRequestStatus')
	delete from GXDBVersions where aliasname = 'AppUpdateAsyncXMLRequestStatus'
GO

insert into GXDBVersions values(2, 'AppUpdateAsyncXMLRequestStatus',  '00010001000200050000', 'AppUpdateAsyncXMLRequestStatus', '00010001000200050000')
GO

