

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateAssocBsetSP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateAssocBsetSP.sp,v $ $Id: AppUpdateAssocBsetSP.sp,v 1.1.2.4 2020/08/21 22:59:05 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUpdateAssocBsetSP')
BEGIN
	print '>>> Drop Stored Procedure: AppUpdateAssocBsetSP <<<'
	drop procedure AppUpdateAssocBsetSP
END
IF EXISTS (select * from GxQscripts where name='AppUpdateAssocBsetSP')
	delete from GxQscripts where name = 'AppUpdateAssocBsetSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateAssocBsetSP')
	delete from GXDBVersions where aliasname = 'AppUpdateAssocBsetSP'
GO
print '... Creating Procedure: AppUpdateAssocBsetSP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateAssocBsetSP
--  User Input arguments
  @inBSId INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @errCode INT;
  DECLARE @xmlReport XML;
BEGIN
	SET NOCOUNT ON
	--=============================================================================================================================
	--= This SP performs 3 order operations:
	--= 1. It first identifies all the information to process in temp tables for the inputted BackupSetId.
	--= 2. Next it processes the information identifying all the various table rows that need to be updated, inserted, or deleted
	--=    so that the tables can be updated in an ordered fashion to avoid deadlocks with other sessions (hopefully) and with
	--=    other sessions performing simultaneous SubClient Policy Updates (this SP).
	--= 3. Last it performs the ordered table update operations.
	--=============================================================================================================================
	-- Controls Options for matching the original CUR File Operations for comparison
	-- and verification of operations or flow controls
	DECLARE @noDataChangeCtrl	TINYINT = 1		--	Check and avoid Table Row No Data Change Operations
	DECLARE @UpdateOp			TINYINT = 1
	SET @errCode = 0
	-- Temp Tables
	IF OBJECT_ID('tempdb.dbo.#ESPAgents') IS NOT NULL
		DROP TABLE #ESPAgents
	DECLARE @ESPRowCnt INT = 0
	CREATE TABLE #ESPAgents (
		agentId INT PRIMARY KEY
	)
	IF OBJECT_ID('tempdb.dbo.#bsEntities') IS NOT NULL
		DROP TABLE #bsEntities
	DECLARE @bsRowCnt INT = 0
	CREATE TABLE #bsEntities (
		bsId		INT PRIMARY KEY,
		status		INT,
		clientId	INT,
		appTypeId	INT,
		instanceId	INT,
		scStatus	INT,
		bsPolicyId	INT		-- added to allow simple join op
	)
	IF OBJECT_ID('tempdb.dbo.#scpEntities') IS NOT NULL
		DROP TABLE #scpEntities
	DECLARE @scpRowCnt INT = 0
	DECLARE @scpNewRowCnt INT = 0
	CREATE TABLE #scpEntities (
		scpId				INT PRIMARY KEY,
		chSCPId				NVARCHAR(12),
		clientId			INT,
		appTypeId			INT,
		instance			INT,
		backupSet			INT,
		appNumber			INT,
		dataArchGrpID		INT,
		logArchGrpID		INT,
		refTime				INT,
		modified			INT,
		subclientName		NVARCHAR(128),
		subclientStatus		INT,
		noSCAssocs			TINYINT DEFAULT 0,
		defaultSC			TINYINT,
		preCreatedSC		TINYINT,
		systemState			TINYINT,
		newAppRow			TINYINT DEFAULT 0,		-- This is set to 1 if we find no SubClient Entities to update and noSCAssocs = 1
		swCompress			INT DEFAULT NULL,
		nwAgents			INT DEFAULT NULL,
		nwWriteSpeed		INT DEFAULT NULL
	)
	IF OBJECT_ID('tempdb.dbo.#scEntities') IS NOT NULL
		DROP TABLE #scEntities
	DECLARE @scRowCnt INT = 0
	CREATE TABLE #scEntities (
		scId				INT PRIMARY KEY,
		scStatus			INT,
		scDataAGId			INT,
		scpId				INT,
		scpBSId				INT,
		scpBSUninstalled	TINYINT,
		scpDeleted			TINYINT,
		scpNewStatus		INT,
		spExists			TINYINT,				-- Storage Policy / Archive Group exists
		dagIdChgd			TINYINT DEFAULT 0,		-- data archive group id changed
		isEdgeDrive			TINYINT,
		scpDefaultSC		TINYINT,
		scClientId			INT
	)
	IF OBJECT_ID('tempdb.dbo.#scNoAssocEntities') IS NOT NULL
		DROP TABLE #scNoAssocEntities
	-- Operation Types for #scNoAssocEntities
	DECLARE @scDefType		TINYINT = 1,
			@scIBMIType		TINYINT = 2,
			@scSysStateType	TINYINT = 3,
			@scNewType		TINYINT = 4
	DECLARE @scNoAssocRowCnt INT = 0
	CREATE TABLE #scNoAssocEntities (
		opType				TINYINT,
		scId				INT,
		scpId				INT,
		scpStatus			INT,
		scpDataArchGrpID	INT,
		scpLogArchGrpID		INT,
		scpSubclientName	NVARCHAR(128),
		newlyLinked			TINYINT,
		dagIdChgd			TINYINT DEFAULT 0,		-- data archive group id changed
		bsId				INT,
		scClientId			INT,
		PRIMARY KEY (opType, scpId, bsId, scClientId)	--NEW
	)
	IF OBJECT_ID('tempdb.dbo.#SCPropRowsToUpdate') IS NOT NULL
		DROP TABLE #SCPropRowsToUpdate
	CREATE TABLE #SCPropRowsToUpdate (
		scpId			INT,
		opType			TINYINT,		-- 1 Update, 2 Delete (currently none)
		attrName		NVARCHAR(128) DEFAULT '',
		newAttrVal		NVARCHAR(128) DEFAULT NULL,
		markModified	TINYINT DEFAULT 0,
		upCreated		TINYINT DEFAULT 0,
		PRIMARY KEY (scpId, opType, attrName)
	)
	IF OBJECT_ID('tempdb.dbo.#SCPropRowsToInsert') IS NOT NULL
		DROP TABLE #SCPropRowsToInsert
	CREATE TABLE #SCPropRowsToInsert (
		scId			INT,
		attrName		NVARCHAR(128),
		attrVal			NVARCHAR(128),
		attrType		INT,
		PRIMARY KEY (scId, attrName)
	)
	IF OBJECT_ID('tempdb.dbo.#AppRowsToUpdate') IS NOT NULL
		DROP TABLE #AppRowsToUpdate
	CREATE TABLE #AppRowsToUpdate (
		appId			INT PRIMARY KEY,
		dataArchGrpID	INT,
		logArchGrpID	INT,
		subclientName	NVARCHAR(128),
		subclientStatus	INT
	)
	-- Table to capture new SCP associations
	IF OBJECT_ID('TempDb..#NewAppIds') IS NOT NULL
		DROP TABLE #NewAppIds
	CREATE TABLE #NewAppIds (
		scId		INT PRIMARY KEY,
		cId			INT,
		bsId		INT
	)
	DECLARE @timeStamp INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @edgeDriveSCFlag INT = CAST(0x20000 AS INT)		-- CV_STATUS_EDGEDRIVE_SUB
	DECLARE @preCreatedSCFlag INT = CAST(0x400000 AS INT)	-- CV_STATUS_PRE_CREATED_SUB
	DECLARE @systemRecoveryFlag INT = CAST(0x0100 AS INT)	-- CV_STATUS_SYSTEM_RECOVERY
	BEGIN TRY
		--=============================================================================================================================
		--= 1. Identify what needs to be processed
		--=============================================================================================================================
		DECLARE @ESPEnabled INT = 0
		SELECT TOP 1
			@ESPEnabled = 1
		FROM APP_Application subclient WITH(NOLOCK)
			INNER JOIN APP_SubClientProp prop WITH(NOLOCK) ON
				subclient.id = prop.componentNameId
				AND prop.attrName = N'Subclient Policy Has Retention'
				AND prop.cs_attrName = CHECKSUM(N'Subclient Policy Has Retention' )
				AND prop.attrVal = '1'
				AND prop.modified = 0
			INNER JOIN APP_SubClientProp ESP WITH(NOLOCK) ON
				subclient.id = ESP.componentNameId
				AND ESP.attrName = N'Is Turbo Subclient'
				AND ESP.cs_attrName = CHECKSUM(N'Is Turbo Subclient')
				AND ESP.attrVal = N'1'
				AND ESP.modified = 0
		WHERE
			subclient.backupSet = @inBSId
		 --MR: 163985: Now bring back the code, it is enabled on key bEnablePopUpMessageDuringStoragePolicyChange
		DECLARE @EnablePopUpMessageDuringStoragePolicyChange INT = 0
		SELECT
			@EnablePopUpMessageDuringStoragePolicyChange = 1
		FROM APP_AdvanceSettings s WITH(NOLOCK)
		WHERE
			s.keyName = 'bEnablePopUpMessageDuringStoragePolicyChange'
			AND s.relativePath = 'CommServDB.Console'
			AND s.type = 'BOOLEAN'
			AND CAST(s.[value] AS NVARCHAR(32)) = N'true'
			AND s.enabled = 1
			AND s.deleted = 0
			AND s.entityType = 3	-- Client Entity
			AND s.entityId = 2	-- csId
		IF @ESPEnabled = 1
		BEGIN
			--Identify all backupsets(of V2 client) associated to subclient policy. Identify all FS agent of associated backupset. Set Enable Archive on all FS agents of associated backupset.
			INSERT #ESPAgents (agentId)
				SELECT DISTINCT
					agent.id
				FROM APP_BackupSetProp BP WITH(NOLOCK)
					INNER JOIN APP_Application subclient WITH(NOLOCK) ON
						BP.componentNameId = subclient.backupSet
						AND BP.attrName = N'Associated subclient Policy'
						AND BP.modified = 0
					INNER JOIN APP_IDAName agent WITH(NOLOCK) ON
						agent.clientId = subclient.clientId
						AND agent.appTypeId = subclient.appTypeId
					INNER JOIN APP_AppTypeGroupAssoc appType WITH(NOLOCK) ON
						appType.appTypeId = subclient.appTypeId
						AND appType.appGroupId IN (22,34)	 --22:WinFS and 34:UnixFS
						AND appType.typeOfGroup = 0
					INNER JOIN APP_ClientProp client WITH(NOLOCK) ON
						client.componentNameId = subclient.clientId
						AND client.attrName = N'IndexingV2'
						AND client.attrVal = N'1'
						AND client.modified = 0
				WHERE
					BP.attrVal = CAST (@inBSId AS NVARCHAR(12))
			SET @ESPRowCnt = @@ROWCOUNT
		END
		-- Get all the BackupSet Entities associated to the SubClient Policy BackupSetNameId
		INSERT INTO #bsEntities (bsId, status, clientId, appTypeId, instanceId, scStatus, bsPolicyId)
			SELECT DISTINCT
				BP.componentNameId,
				BS.status ,
				a.clientId,
				a.appTypeId,
				a.instance
				,0 --,(SELECT TOP 1 subclientStatus FROM APP_Application a1 WITH(NOLOCK) WHERE a1.backupSet = BP.componentNameId)		-- support original implementation ... BUG?
				,@inBSId
			FROM APP_BackupSetProp BP WITH(NOLOCK)
				INNER JOIN APP_BackupSetName BS WITH(NOLOCK) ON
					BS.id = BP.componentNameId
					AND BP.attrName = N'Associated subclient Policy'
					AND BP.modified = 0
				INNER JOIN APP_Application a WITH(NOLOCK) ON
					a.backupSet = BP.componentNameId
			WHERE
				BP.attrVal = CAST(@inBSId AS NVARCHAR(12))
		SET @bsRowCnt = @@ROWCOUNT
		--SELECT @bsRowCnt bsRowCnt
		IF (@bsRowCnt > 0)
		BEGIN
			--SELECT * FROM #bsEntities
			-- Get all the 1030 AppType SubClient Entities mapped to SubClient Policy BackupSetNameId
			INSERT INTO #scpEntities (
				scpId,
				chSCPId,
				clientId,
				appTypeId,
				instance,
				backupSet,
				appNumber,
				dataArchGrpID,
				logArchGrpID,
				refTime,
				modified,
				subclientName,
				subclientStatus,
				defaultSC,
				preCreatedSC,
				systemState,
				swCompress,
				nwAgents,
				nwWriteSpeed
			)
				SELECT
					a.id,
					CAST(a.id AS NVARCHAR(12)),
					a.clientId,
					a.appTypeId,
					a.instance,
					a.backupSet,
					a.appNumber,
					a.dataArchGrpID,
					a.logArchGrpID,
					a.refTime,
					a.modified,
					a.subclientName,
					a.subclientStatus,
					IIF(((a.subclientStatus & 8) = 8), 1, 0) defaultSC,			-- Default SubClient Flag - CV_STATUS_DEFAULT
					IIF(((a.subclientStatus & @preCreatedSCFlag) = @preCreatedSCFlag), 1, 0) preCreatedSC,
					IIF((scp.id IS NOT NULL), 1, 0) systemState,
					apc.compressWhere,
					apc.numNWAgents,
					apc.NWWriteSpeed
				  FROM APP_Application a WITH(NOLOCK)
					LEFT OUTER JOIN APP_SubClientProp scp ON
						scp.componentNameId = a.id
						AND scp.attrName = N'System State Subclient'
						AND scp.cs_attrName = CHECKSUM(N'System State Subclient')
						AND scp.modified = 0
					LEFT OUTER JOIN archPipeConfig apc WITH(NOLOCK) ON		--Insert the sw comp and NW agent in archpipeconfig table
						apc.appNumber = a.id
				  WHERE
					a.backupset = @inBSId
			SET @scpRowCnt = @@ROWCOUNT
			-- Determine if SubClient Policy has no subclients property associated to it
			DECLARE @scpNoAssocRowCnt INT = 0
			UPDATE e
				SET noSCAssocs = 1
			FROM #scpEntities e
				LEFT OUTER JOIN APP_SubClientProp scp WITH(NOLOCK) ON
					scp.attrName = N'Associated subclient Policy'
					AND scp.cs_attrName = CHECKSUM(N'Associated subclient Policy')
					AND scp.modified = 0
					AND scp.attrVal = e.chSCPId
			WHERE
				scp.id IS NULL
			SET @scpNoAssocRowCnt = @@ROWCOUNT
			--NEW
			IF OBJECT_ID('TempDb..#NewClientSCs') IS NOT NULL
				DROP TABLE #NewClientSCs
			CREATE TABLE #NewClientSCs (
				clientId		INT,
				bsId			INT,
				--PRIMARY KEY (clientId, bsId)
			)
			INSERT INTO #NewClientSCs (clientId, bsId)
				SELECT DISTINCT
					a1.clientId,
					a1.backupSet
				FROM #scpEntities e
					INNER JOIN APP_SubClientProp scp WITH(NOLOCK) ON
						scp.attrName = N'Associated subclient Policy'
						AND scp.cs_attrName = CHECKSUM(N'Associated subclient Policy')
						AND scp.modified = 0
						AND scp.attrVal = CAST(e.chSCPId AS NVARCHAR(12))
					INNER JOIN APP_Application a1 WITH(NOLOCK) ON
						a1.id = scp.componentNameId
				WHERE
					e.noSCAssocs = 0
				UNION
				SELECT		-- No Associations for new Policy, create associations
					bs.clientId,
					bs.bsId
				FROM #scpEntities e
					INNER JOIN #bsEntities bs ON
						bs.bsPolicyId = e.backupSet
				WHERE
					e.noSCAssocs = 1
			--select * from #NewClientSCs
			--SELECT @scpRowCnt scpRowCnt
			IF (@scpRowCnt > 0)
			BEGIN
				--SELECT * FROM #scpEntities
				-- Get all existing Client SubClient Entities assocaited to the SubClient Policy
				INSERT INTO #scEntities (
					scId,
					scStatus,
					scDataAGId,
					scpId,
					scpBSId,
					scpBSUninstalled,
					scpDeleted,
					scpNewStatus,
					spExists,
					dagIdChgd,
					isEdgeDrive,
					scpDefaultSC,
					scClientId
				)
					SELECT
						scp.componentNameId,
						a.subclientStatus,
						a.dataArchGrpId,
						e.scpId,
						bs.bsId,
						IIF(((bs.status & 2) = 2), 1, 0) scpBSUninstalled,		-- CV_STATUS_UNINSTALLED
						IIF(((e.subclientStatus & 4) = 4), 1, 0) scpDeleted,	-- CV_STATUS_DELETED
						--====================================================================================
						-- Gokul indicated a bug in the original CUR for computing @newSCStatus
						-- should be for the actual SubClient, not on the SubClient backupSetId
						-- which could have multiple rows in the APP_Application table and basically
						-- randomly pick one as a value to use as SubClient Status.
						IIF(((bs.status & 2) = 2), (e.subclientStatus | 2), e.subclientStatus) scpNewStatus,
						--====================================================================================
						IIF((sp.id IS NULL), 0, 1) spExists,		-- If storage policy is changed , no update will take place.
						IIF((a.dataArchGrpId <> e.dataArchGrpID), 1, 0) dagIdChgd,
						IIF(((e.subclientStatus & @edgeDriveSCFlag) = @edgeDriveSCFlag), 1, 0) isEdgeDrive,
						e.defaultSC scpDefaultSC,
						a.clientId
					FROM #bsEntities bs
						INNER JOIN APP_Application a WITH(NOLOCK) ON
							a.backupset = bs.bsId
						INNER JOIN APP_SubClientProp scp WITH(NOLOCK) ON
							scp.componentNameId = a.id
							AND scp.attrName = N'Associated subclient Policy'
							AND scp.cs_attrName = CHECKSUM(N'Associated subclient Policy')
							AND scp.modified = 0
						INNER JOIN #scpEntities e ON
							scp.attrVal = e.chSCPId
						LEFT OUTER JOIN APP_SubClientProp sp WITH(NOLOCK) ON	-- does Storage Policy / Archive Group Exists
							sp.componentNameId = a.id
							AND scp.attrName = N'last data SP'
							AND scp.cs_attrName = CHECKSUM(N'last data SP')
							AND scp.modified = 0
				SET @scRowCnt = @@ROWCOUNT
				--SELECT * FROM #scEntities
			END
			--SELECT @scpNoAssocRowCnt scpNoAssocRowCnt
			IF (@scpNoAssocRowCnt > 0)
			BEGIN
				 --if it is default subclient, update will take place.
				 --if it is iBMi Subclient then update update precreated subclients
				 --else new subclient association
				 INSERT INTO #scNoAssocEntities (
					opType,
					scId,
					scpId,
					scpStatus,
					scpDataArchGrpID,
					scpLogArchGrpID,
					scpSubclientName,
					newlyLinked,
					dagIdChgd,
					bsId,
					scClientId
				)
					SELECT
						CASE
							WHEN e.defaultSC = 1 AND (e.subclientStatus & 8) = 8 THEN @scDefType
							WHEN e.preCreatedSC = 1 AND (e.subclientStatus & @preCreatedSCFlag) = @preCreatedSCFlag THEN @scIBMIType
							ELSE @scNewType
						END,
						CASE
							WHEN e.defaultSC = 1 AND (e.subclientStatus & 8) = 8 THEN (
									SELECT
										aa.id
									FROM APP_Application aa WITH(NOLOCK)
									WHERE
										aa.backupset = nsc.bsId
										AND ((aa.subclientStatus & 8) = 8)
								)
							WHEN e.preCreatedSC = 1 AND (e.subclientStatus & @preCreatedSCFlag) = @preCreatedSCFlag THEN (
									SELECT id
									FROM APP_Application aa WITH(NOLOCK)
									WHERE
										aa.backupset = nsc.bsId
										AND ((aa.subclientStatus & @preCreatedSCFlag) = @preCreatedSCFlag)
										AND aa.subclientName = e.subClientName
								)
							ELSE -1
						END,
						e.scpId,
						e.subclientStatus,
						e.dataArchGrpId,
						e.logArchGrpId,
						e.subClientName,
						1 newlyLinked,
						e.dataArchGrpID dagIdChgd,
						nsc.bsId,
						nsc.clientId
					FROM #scpEntities e
						CROSS JOIN #NewClientSCs nsc
					WHERE
						e.noSCAssocs = 1
						AND e.systemState <> 1
				SET @scNoAssocRowCnt += @@ROWCOUNT
				--SELECT 'Default', @scNoAssocRowCnt scNoAssocRowCnt
				INSERT INTO #scNoAssocEntities (
					opType,
					scId,
					scpId,
					scpStatus,
					scpDataArchGrpID,
					scpLogArchGrpID,
					scpSubclientName,
					newlyLinked,
					dagIdChgd,
					bsId,
					scClientId
				)
					SELECT	--NEW
						@scSysStateType,
						a.id,
						e.scpId,
						e.subclientStatus,
						e.dataArchGrpId,
						e.logArchGrpId,
						e.subClientName,
						1 newlyLinked,
						e.dataArchGrpID dagIdChgd,
						nsc.bsId,
						nsc.clientId
					FROM #bsEntities bs
						INNER JOIN #NewClientSCs nsc ON
							nsc.bsId = bs.bsId
						INNER JOIN APP_Application a WITH(NOLOCK) ON
							a.backupset = bs.bsId
						LEFT OUTER JOIN APP_SubClientProp scp WITH(NOLOCK) ON
							scp.componentNameId = a.id
							AND scp.modified = 0
							AND scp.attrName = N'System State Subclient'
							AND scp.cs_attrName = CHECKSUM(N'System State Subclient')
						CROSS JOIN #scpEntities e		-- not sure this is correct needs to be tested
					WHERE
						e.noSCAssocs = 1
						AND e.systemState = 1
						AND scp.id IS NOT NULL
				SET @scNoAssocRowCnt += @@ROWCOUNT
				--SELECT 'SysState', @scNoAssocRowCnt scNoAssocRowCnt
				--SELECT * FROM #scNoAssocEntities
				-- Do we have any new SubClient Polices with no associations
				UPDATE e
					SET newAppRow = 1
				FROM #scpEntities e
					INNER JOIN #scNoAssocEntities na ON
						na.scpId = e.scpId
				WHERE
					e.noSCAssocs = 1
					AND na.scId = -1
					AND na.opType = 4
				SET @scpNewRowCnt = @@ROWCOUNT
				--select '#scpEntities', * from #scpEntities
				--select '#scNoAssocEntities', * from #scNoAssocEntities
				--select '#bsEntities', * from #bsEntities
				-- Need to create APP_Application rows now so that I can map SCProps to these AppIds for insertion below
				DECLARE @scpNewInsRowCnt INT = 0
				IF (@scpNewRowCnt > 0)
				BEGIN
					-- Need AppIds to map subclient prop rows so have to do inserts here and now
					INSERT INTO APP_Application (
						clientId,
						appTypeId,
						instance,
						backupSet,
						appNumber,
						dataArchGrpID,
						logArchGrpID,
						refTime,
						modified,
						subclientName,
						subclientStatus,
						origCCID,
						GUID
					)
						OUTPUT INSERTED.id, INSERTED.clientId, INSERTED.backupSet
							INTO #NewAppIds (scId, cId, bsId)
						SELECT
							bs.clientId,
							bs.appTypeId,
							bs.instanceId,
							bs.bsId,
							scp.appNumber,
							scp.dataArchGrpID,
							scp.logArchGrpID,
							scp.refTime,
							scp.modified,
							scp.subclientName,
							scp.subclientStatus,
							2,
							NEWID()
						FROM #scpEntities scp
							INNER JOIN #scNoAssocEntities na ON
								na.scpId = scp.scpId
							INNER JOIN #bsEntities bs ON
								bs.bsId = na.bsId
						WHERE
							scp.newAppRow = 1
					SET @scpNewInsRowCnt = @@ROWCOUNT
					--select @scpNewInsRowCnt scpNewInsRowCnt
					-- Update for new AppIds created
					UPDATE na
						SET scId = a.scId
					FROM #scNoAssocEntities na
						INNER JOIN #NewAppIds a ON
							a.cId = na.scClientId
							AND na.bsId = a.bsId
					--select '#scNoAssocEntities', * from #scNoAssocEntities
				END
			END
		END
		IF OBJECT_ID('tempdb.dbo.#dagChanged') IS NOT NULL
			DROP TABLE #dagChanged
		CREATE TABLE #dagChanged (
			scId		INT PRIMARY KEY,
			tblType		TINYINT,	-- 1: #scEntities, 2: #scNoAssocEntities
			newlyLinked	TINYINT
		)
		DECLARE @dagRowCnt INT = 0
		INSERT INTO #dagChanged (scId, tblType, newlyLinked)
			SELECT
				sc.scId,
				1,
				0
			FROM #scEntities sc
			WHERE
				sc.dagIdChgd = 1
			UNION	-- need to eliminate any duplicate rows in each query
			SELECT
				na.scId,
				2,
				na.newlyLinked
			FROM #scNoAssocEntities na
			WHERE
				na.dagIdChgd <> 0
		SET @dagRowCnt = @@ROWCOUNT
		--SELECT @dagRowCnt dagRowCnt
		--SELECT * FROM #dagChanged
		--=============================================================================================================================
		--= 2. Identify what needs to be updated
		--=============================================================================================================================
		-- Diagnostic Row Counts
		DECLARE @dagUpRowCnt1 INT = 0
		DECLARE @dagUpRowCnt2 INT = 0
		DECLARE @dagUpRowCnt3 INT = 0
		DECLARE @dagUpRowCnt4 INT = 0
		DECLARE @scPropAgedRowCnt INT = 0
		DECLARE @scPropNAInsRowCnt INT = 0
		DECLARE @scPropNAExpRowCnt INT = 0
		DECLARE @scPropNARetRowCnt INT = 0
		DECLARE @scPropNAAExpRowCnt INT = 0
		DECLARE @sffRowCnt INT = 0
		-- APP_SubClientProp and APP_Application have many Update and Insert Operations against it so try to consolidate into 1 Operation each.
		IF (@EnablePopUpMessageDuringStoragePolicyChange = 1)
		BEGIN
			IF (@dagRowCnt > 0)
			BEGIN
				--MR 146895: Do not change last backuptime
				--If there is change in the dataarchiveID or logarchiveId, then we need to change the last backup time and set the reason for clearinig the backup time
				--MR: 163985: Now bring back the code, it is enabled on key bEnablePopUpMessageDuringStoragePolicyChange
				INSERT INTO #SCPropRowsToUpdate (scpId, opType, attrName, newAttrVal)
					SELECT
						scp.id,
						1,
						scp.attrName,
						N'0'
					FROM APP_SubClientProp scp WITH(NOLOCK)
						INNER JOIN #dagChanged dc ON
							dc.scId = scp.componentNameId
							AND scp.attrName IN (N'sys:last full', N'sys:last incr')
							AND scp.cs_attrName IN (CHECKSUM(N'sys:last full'), CHECKSUM(N'sys:last incr'))
							AND scp.modified = 0
							AND scp.attrVal <> N'0'
				SET @dagUpRowCnt1 = @@ROWCOUNT
				INSERT INTO #SCPropRowsToUpdate (scpId, opType, attrName, newAttrVal)	--fixed typo
					SELECT
						scp.id,
						1,
						scp.attrName,
						N'9'
					FROM APP_SubClientProp scp WITH(NOLOCK)
						INNER JOIN #dagChanged dc ON
							dc.scId = scp.componentNameId
							AND scp.attrName = N'Reason last backup time cleared'
							AND scp.cs_attrName  = CHECKSUM(N'Reason last backup time cleared')
							AND scp.modified = 0
							AND scp.attrVal <> N'9'
				SET @dagUpRowCnt2 = @@ROWCOUNT
				INSERT INTO #SCPropRowsToInsert (scId, attrName, attrType, attrVal)
					SELECT
						dc.scId,
						N'Reason last backup time cleared',
						7,
						N'9'
					FROM #dagChanged dc
						LEFT OUTER JOIN APP_SubClientProp scp  WITH(NOLOCK) ON
							dc.scId = scp.componentNameId
							AND scp.attrName = N'Reason last backup time cleared'
							AND scp.cs_attrName  = CHECKSUM(N'Reason last backup time cleared')
							AND scp.modified = 0
					WHERE
						scp.id IS NULL
				SET @dagUpRowCnt2 += @@ROWCOUNT
				-- Update Data Archive Group information - Running only on SubClient entities associations found
				-- With Storage Policy check
				INSERT INTO #AppRowsToUpdate (appId, dataArchGrpID, logArchGrpID, subclientName, subclientStatus)
					SELECT
						a.id,
						dc.dataArchGrpID,
						dc.logArchGrpID,
						IIF((dc.isEdgeDrive = 1), a.subClientName, dc.subclientName),			-- Do not update name if Edge Drive
						(a.subclientStatus | (a.subclientStatus & @systemRecoveryFlag) | dc.scpStatus)
					FROM APP_Application a WITH(NOLOCK)
						INNER JOIN (
							SELECT
								sc.scid,
								scp.dataArchGrpID,
								scp.logArchGrpID,
								scp.subclientName,
								sc.scpNewStatus scpStatus,
								sc.isEdgeDrive
							FROM #scEntities sc
								INNER JOIN #dagChanged dc ON
									dc.scId = sc.scId
									AND sc.spExists = 0
								INNER JOIN #scpEntities scp ON
									scp.scpId = sc.scpId
							) dc ON
								dc.scId = a.id
				SET @dagUpRowCnt3 = @@ROWCOUNT
				--select '#AppRowsToUpdate1', * from #AppRowsToUpdate
			END
		END
		ELSE
		BEGIN
			--update the APP_Application with the new info
			INSERT INTO #AppRowsToUpdate (appId, dataArchGrpID, logArchGrpID, subclientName, subclientStatus)
				SELECT
					a.id,
					a.dataArchGrpID,		-- set existing
					a.logArchGrpID,			-- set existing
					IIF((dc.isEdgeDrive = 1), a.subClientName, dc.subclientName),			-- Do not update name if Edge Drive
					(a.subclientStatus |
						(CASE
							WHEN dc.defaultSC = 1 OR dc.preCreatedSC = 1 OR dc.systemState = 1		-- Update SC Status if any of these conditions
								THEN ((a.subclientStatus & @systemRecoveryFlag) | dc.scpStatus)
							ELSE 0
						END)
					)
				FROM APP_Application a
					INNER JOIN (
						SELECT
							sc.scid,
							scp.subclientName,
							sc.scpNewStatus scpStatus,
							sc.isEdgeDrive,
							scp.defaultSC,
							scp.preCreatedSC,
							scp.systemState
						FROM #scEntities sc
							INNER JOIN #scpEntities scp ON
								scp.scpId = sc.scpId
						) dc ON
							dc.scId = a.id
			SET @dagUpRowCnt3 = @@ROWCOUNT
			--select '#AppRowsToUpdate2', * from #AppRowsToUpdate
		END
		IF (@dagRowCnt > 0)
		BEGIN
			-- Update Data Archive Group information - For no assocaited SubClient entities found
			INSERT INTO #AppRowsToUpdate (appId, dataArchGrpID, logArchGrpID, subclientName, subclientStatus)
				SELECT
					a.id,
					dc.dataArchGrpID,
					dc.logArchGrpID,
					dc.subclientName,
					(a.subclientStatus |
						(CASE
							WHEN dc.defaultSC = 1 OR dc.preCreatedSC = 1 OR dc.systemState = 1		-- Update SC Status if any of these conditions
								THEN ((a.subclientStatus & @systemRecoveryFlag) | dc.scpStatus)
							ELSE 0
						END)
					)
				FROM APP_Application a WITH(NOLOCK)
					INNER JOIN (
						SELECT
							sc.scid,
							scp.dataArchGrpID,
							scp.logArchGrpID,
							scp.subclientName,
							sc.scpStatus,
							scp.defaultSC,
							scp.preCreatedSC,
							scp.systemState
						FROM #scNoAssocEntities sc
							INNER JOIN #dagChanged dc ON
								dc.scId = sc.scId
							INNER JOIN #scpEntities scp ON
								scp.scpId = sc.scpId
					) dc ON
						dc.scId = a.id
					LEFT OUTER JOIN #AppRowsToUpdate u ON
						u.appId = a.id
				WHERE
					u.appId IS NULL
			SET @dagUpRowCnt4 = @@ROWCOUNT
			--select '#AppRowsToUpdate3', * from #AppRowsToUpdate
		END
		IF (@scpNoAssocRowCnt > 0)
		BEGIN
			-- Configure Associations
			-- Newly Linked
			INSERT INTO #SCPropRowsToUpdate (scpId, opType, markModified)
				SELECT		--AGE OFF THE ALREADY DEFINED OVERLAPPED PROPERTIES
					oscp.id,
					1,
					1
				FROM #scNoAssocEntities na
					INNER JOIN APP_SubClientProp oscp WITH(NOLOCK)  ON
						na.scId = oscp.componentNameId
						AND oscp.modified = 0
					INNER JOIN APP_SubClientProp nscp WITH(NOLOCK)  ON
						na.scpId = nscp.componentNameId
						AND nscp.modified = 0
				WHERE
					nscp.attrName = oscp.attrName
					AND nscp.cs_attrName = oscp.cs_attrName
					AND na.newlyLinked = 1
				UNION		-- need to eliminate duplicate rows to avoid key constraint failure
				SELECT		--AGE OFF "DEFAULT" PROPERTIES OF SCP THAT MAY NOT HAVE BEEN SET YET
					scp.id,
					1,
					1
				FROM #scNoAssocEntities na
					INNER JOIN APP_SubClientProp scp  WITH(NOLOCK) ON
						scp.componentNameId = na.scId
						AND scp.modified = 0
					INNER JOIN APP_CCP_Prop ccp  WITH(NOLOCK) ON
						scp.attrName = ccp.attrName
						AND scp.cs_attrName = ccp.cs_attrName
				WHERE
					na.newlyLinked = 1
			SET @scPropAgedRowCnt += @@ROWCOUNT
			--Insert the association information
			INSERT INTO #SCPropRowsToInsert (scId, attrName, attrType, attrVal)
				SELECT
					na.scId,
					N'Associated subclient Policy',
					10,
					CAST(na.scpId AS NVARCHAR(12))
				FROM #scNoAssocEntities na
				UNION ALL
				SELECT
					na.scId,
					N'Keep items past their expiration',
					2,
					N'1'
				FROM #scNoAssocEntities na
					LEFT OUTER JOIN APP_SubClientProp scp WITH(NOLOCK)  ON
						scp.componentNameId = na.scId
						AND scp.attrName = N'Keep items past their expiration'
						AND scp.cs_attrName = CHECKSUM(N'Keep items past their expiration')
						AND scp.modified = 0
				WHERE
					scp.id IS NULL
				UNION ALL
				SELECT
					na.scId,
					N'Days to keep items past their expiration',
					7,
					IIF((c.id IS NOT NULL), N'730',  N'0')
				FROM #scNoAssocEntities na
					INNER JOIN #bsEntities bs ON
						bs.bsid = na.bsId
					LEFT OUTER JOIN APP_Client c  WITH(NOLOCK) ON
						c.id = bs.clientId
						AND (c.status & 4096) = 4096				-- Laptop Configuration
					LEFT OUTER JOIN APP_SubClientProp scp WITH(NOLOCK)  ON
						scp.componentNameId = na.scId
						AND scp.attrName = N'Days to keep items past their expiration'
						AND scp.cs_attrName = CHECKSUM(N'Days to keep items past their expiration')
						AND scp.modified = 0
				WHERE
					scp.id IS NULL
				UNION ALL
				SELECT
					na.scId,
					N'Archived expiration days',
					7,
					N'-1'
				FROM #scNoAssocEntities na
					LEFT OUTER JOIN APP_SubClientProp scp WITH(NOLOCK)  ON
						scp.componentNameId = na.scId
						AND scp.attrName = N'Archived expiration days'
						AND scp.cs_attrName = CHECKSUM(N'Archived expiration days')
						AND scp.modified = 0
				WHERE
					scp.id IS NULL
			SET @scPropNAInsRowCnt = @@ROWCOUNT
			IF OBJECT_ID('TempDb..#DelModified') IS NOT NULL
				DROP TABLE #DelModified
			CREATE TABLE #DelModified (
				scpId	INT
			)
			INSERT INTO #SCPropRowsToUpdate (scpId, opType, attrName, newAttrVal, upCreated)
				OUTPUT INSERTED.scpId INTO  #DelModified (scpId)
				SELECT
					scp.id,
					1,
					scp.attrName,
					N'1',
					1
				FROM #scNoAssocEntities na
					INNER JOIN APP_SubClientProp scp  WITH(NOLOCK) ON
						scp.componentNameId = na.scId
						AND scp.attrName = N'Keep items past their expiration'
						AND scp.cs_attrName = CHECKSUM(N'Keep items past their expiration')
						AND scp.modified = 0
						--AND scp.attrVal <> N'1'		-- Commented out so that created time will be updated like previous implementation
				SET @scPropNAExpRowCnt = @@ROWCOUNT
				-- Determine retention to set
				INSERT INTO #SCPropRowsToUpdate (scpId, opType, attrName, newAttrVal, upCreated)
					OUTPUT INSERTED.scpId INTO  #DelModified (scpId)
					SELECT
						scp.id,
						1,
						scp.attrName,
						IIF((c.id IS NOT NULL), N'730',  N'0'),
						1
					FROM #scNoAssocEntities na
						INNER JOIN #bsEntities bs ON
							bs.bsid = na.bsId
						LEFT OUTER JOIN APP_Client c  WITH(NOLOCK) ON
							c.id = bs.clientId
							AND (c.status & 4096) = 4096			-- Laptop Configuration
						INNER JOIN APP_SubClientProp scp  WITH(NOLOCK) ON
							scp.componentNameId = na.scId
							AND scp.attrName = N'Days to keep items past their expiration'
							AND scp.cs_attrName = CHECKSUM(N'Days to keep items past their expiration')
							AND scp.modified = 0
				SET @scPropNARetRowCnt = @@ROWCOUNT
				INSERT INTO #SCPropRowsToUpdate (scpId, opType, attrName, newAttrVal, upCreated)
					OUTPUT INSERTED.scpId INTO  #DelModified (scpId)
					SELECT
						scp.id,
						1,
						scp.attrName,
						N'-1',
						1
					FROM #scNoAssocEntities na
						INNER JOIN APP_SubClientProp scp  WITH(NOLOCK) ON
							scp.componentNameId = na.scId
							AND scp.attrName = N'Archived expiration days'
							AND scp.cs_attrName = CHECKSUM(N'Archived expiration days')
							AND scp.modified = 0
							--AND scp.attrVal <> N'-1'		-- Commented out so that created time will be updated like previous implementation
				SET @scPropNAAExpRowCnt = @@ROWCOUNT
				-- Remove previous insert rows to mark modified since we want to update rows in place with updated created time
				DELETE p
				FROM #SCPropRowsToUpdate p
					INNER JOIN #DelModified d ON
						p.scpId = d.scpId
						AND p.opType = 1
						AND p.markModified = 1		-- remove matching id marked to have modified set
		END
		--=============================================================================================================================
		--= 3. Last step Update Tables in an orderly fashion
		--=============================================================================================================================
		--=== APP_IDAProp Operations
		IF @ESPEnabled = 1
		BEGIN
			DECLARE @espUpRowCnt INT = 0
			DECLARE @espInsRowCnt INT = 0
			UPDATE T
				SET T.modified = @timeStamp
			FROM APP_IDAProp T
				INNER JOIN #ESPAgents AS Src ON
					T.componentNameId = Src.agentId
			WHERE
				T.attrName = N'Enable Archive'
				AND T.attrVal = N'0'
				AND T.modified = 0
			SET @espUpRowCnt = @@ROWCOUNT
			INSERT INTO APP_IDAProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				SELECT
					Src.agentId,
					N'Enable Archive',
					2,
					N'1',
					@timeStamp,
					0,
					0
				FROM #ESPAgents Src
					LEFT OUTER JOIN APP_IDAProp Dest ON
						Dest.componentNameId = Src.agentId
						AND Dest.attrName = N'Enable Archive'
						AND Dest.attrVal = N'1'
						AND Dest.modified = 0
				WHERE
					Dest.id IS NULL
			SET @espInsRowCnt = @@ROWCOUNT
		END
		--=== APP_Application Operations
		IF (@noDataChangeCtrl <> 1)
		BEGIN
			UPDATE a
				SET dataArchGrpID = aru.dataArchGrpID,
					logArchGrpID = aru.logArchGrpID,
					subclientName = aru.subclientName,
					subclientStatus = aru.subclientStatus
			FROM APP_Application a
				INNER JOIN #AppRowsToUpdate aru ON
					aru.appId = a.id
		END
		ELSE
		BEGIN
			-- Avoid No Data Change Operations
			UPDATE a
				SET dataArchGrpID = aru.dataArchGrpID,
					logArchGrpID = aru.logArchGrpID,
					subclientName = aru.subclientName,
					subclientStatus = aru.subclientStatus
			FROM APP_Application a
				INNER JOIN #AppRowsToUpdate aru ON
					aru.appid = a.id
			WHERE
				(
					a.dataArchGrpID <> aru.dataArchGrpID
					OR a.logArchGrpID <> aru.logArchGrpID
					OR a.subclientName <> aru.subclientName
					OR a.subclientStatus <> aru.subclientStatus
				)
		END
		--=== APP_ScFilterFile Operations
		IF (@scpNoAssocRowCnt > 0)
		BEGIN
			-- Configure Associations
			-- Newly Linked
			--AGE OFF THE ALREADY DEFINED CONTENT AND FILTER OF THE SC
			UPDATE sff
				SET modified = @timeStamp
			FROM APP_ScFilterFile sff
				INNER JOIN #scNoAssocEntities na ON
					na.scId = sff.componentNameId
					AND sff.modified = 0
			WHERE
				na.newlyLinked = 1
			SET @sffRowCnt = @@ROWCOUNT
		END
		--=== APP_SubClientProp Operations
		-- Note No Data Change checked when inserted into temp tables
		UPDATE scp
			SET attrVal = IIF((u.newAttrVal IS NOT NULL), u.newAttrVal, scp.attrVal),
				created = IIF((u.upCreated = 1), @timeStamp, created),
				modified = IIF((u.markModified = 1), @timeStamp, modified)
		FROM APP_SubClientProp scp
			INNER JOIN #SCPropRowsToUpdate u ON
				u.scpId = scp.id
		WHERE
			u.opType = 1
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT
				i.scId,
				i.attrName,
				i.attrType,
				i.attrVal,
				@timeStamp,
				0
			FROM #SCPropRowsToInsert i
		--=== archPipeConfig Operations
		--Insert the sw comp and NW agent in archpipeconfig table
		DECLARE @apcUpRowCnt INT = 0
		DECLARE @apcInsRowCnt INT = 0
		DECLARE @apcDelRowCnt INT = 0
		IF (@noDataChangeCtrl <> 1)
		BEGIN
			UPDATE apc
				SET compressWhere = scp.swCompress,
					numNWAgents = scp.nwAgents,
					NWWriteSpeed = scp.nwWriteSpeed
			FROM
				(
					SELECT
						sc.scId,
						sc.scpId
					FROM #scEntities sc
					UNION
					SELECT
						na.scId,
						na.scpId
					FROM #scNoAssocEntities na
				) sc
				INNER JOIN #scpEntities scp ON
					sc.scpId = scp.scpId
				INNER JOIN archPipeConfig apc ON
					apc.appNumber = sc.scId		-- archPipeCOnfig row exists for SubClient
			WHERE
				scp.swCompress IS NOT NULL		-- archPipeConfig row exists for SubClient Policy
			SET @apcUpRowCnt = @@ROWCOUNT
		END
		ELSE
		BEGIN
			-- Avoid No Data Change Operations
			UPDATE apc
				SET compressWhere = scp.swCompress,
					numNWAgents = scp.nwAgents,
					NWWriteSpeed = scp.nwWriteSpeed
			FROM
				(
					SELECT
						sc.scId,
						sc.scpId
					FROM #scEntities sc
					UNION
					SELECT
						na.scId,
						na.scpId
					FROM #scNoAssocEntities na
				) sc
				INNER JOIN #scpEntities scp ON
					sc.scpId = scp.scpId
				INNER JOIN archPipeConfig apc ON
					apc.appNumber = sc.scId		-- archPipeCOnfig row exists for SubClient
			WHERE
				scp.swCompress IS NOT NULL		-- archPipeConfig row exists for SubClient Policy
				AND ( -- make sure there is a data change
					scp.swCompress <> apc.compressWhere
					OR scp.nwAgents <> apc.numNWAgents
					OR scp.nwWriteSpeed <> apc.NWWriteSpeed
				)
			SET @apcUpRowCnt = @@ROWCOUNT
		END
		INSERT INTO archPipeConfig (appNumber, compressWhere, numNWAgents, NWWriteSpeed)
			SELECT
				sc.scId,
				scp.swCompress,
				scp.nwAgents,
				scp.nwWriteSpeed
			FROM #scEntities sc
				INNER JOIN #scpEntities scp ON
					sc.scpId = scp.scpId
				LEFT OUTER JOIN archPipeConfig apc ON
					apc.appNumber = sc.scId
			WHERE
				scp.swCompress IS NOT NULL		-- archPipeConfig row exists for SubClient Policy
				AND apc.appNumber IS NULL		-- archPipeCOnfig row does not exists for SubClient
			UNION
			SELECT
				a.scId,
				scp.swCompress,
				scp.nwAgents,
				scp.nwWriteSpeed
			FROM #NewAppIds a
				INNER JOIN #scNoAssocEntities na ON
					na.bsId = a.bsId
				INNER JOIN #scpEntities scp ON
					na.scpId = scp.scpId
				LEFT OUTER JOIN archPipeConfig apc ON
					apc.appNumber = a.scId
			WHERE
				scp.newAppRow = 1
				AND apc.appNumber IS NULL		-- archPipeCOnfig row does not exists for SubClient
		SET @apcInsRowCnt = @@ROWCOUNT
		DELETE apc
		FROM #scEntities sc
			INNER JOIN #scpEntities scp ON
				sc.scpId = scp.scpId
			INNER JOIN archPipeConfig apc ON
				apc.appNumber = sc.scId		-- archPipeCOnfig row exists for SubClient
		WHERE
				scp.swCompress IS NULL		-- archPipeConfig row does not exists for SubClient Policy
		SET @apcDelRowCnt = @@ROWCOUNT
		--SELECT @apcUpRowCnt apcUpRowCnt, @apcInsRowCnt apcInsRowCnt, @apcDelRowCnt apcDelRowCnt
		--=== APP_WorkQueueRequest Operations
		-- Configure WorkQueue request
		DECLARE @wqRowCnt INT = 0
		INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
			SELECT DISTINCT		-- Clients found for NonAssociated SubClients
				bs.clientId,
				4,		-- WORK_TOKEN_OSC
				N'',
				@timeStamp,
				0,
				0,
				0,
				-1
			FROM #scNoAssocEntities na
				INNER JOIN #bsEntities bs ON
					bs.bsid = na.bsId
			UNION ALL
			SELECT DISTINCT			-- Clients for Assocaited SubClients that need to be updated due to subclient status change
				bs.clientId,
				4,		-- WORK_TOKEN_OSC
				N'',
				@timeStamp,
				0,
				0,
				0,
				-1
			FROM #scEntities sc
				INNER JOIN #bsEntities bs ON
					bs.bsId = sc.scpBSId
			WHERE
				sc.scpDeleted = 1
				AND sc.scStatus <> sc.scpNewStatus
		SET @wqRowCnt = @@ROWCOUNT
		--SELECT @wqRowCnt wqRowCnt
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errCode = 1
	END CATCH
END_OF_PROC:
	-- Report
	SET @xmlReport = (
		SELECT
			@errCode '@errorCode',
			@inBSId '@scpBackupSetId',
			@bsRowCnt '@backupSetRowCount',
			@scpRowCnt '@subClientPolicyRowCount',
			@scpNoAssocRowCnt '@scpWithNonAssocRowCount',
			@scpNewRowCnt '@newSCPRowCount',
			@EnablePopUpMessageDuringStoragePolicyChange '@enablePopUpMessageDuringStoragePolicyChange',
			@ESPEnabled 'ESP/@espEnabled',
			@ESPRowCnt 'ESP/@espRowCount',
			@espUpRowCnt 'ESP/@espUpRowCount',
			@espInsRowCnt 'ESP/@espInsRowCount',
			@scNoAssocRowCnt 'SubClient/@scForNonAssocRowCount',
			@scpNewInsRowCnt 'SubClient/@newSCPInsRowCount',
			@dagUpRowCnt3 'SubClient/@scAppUpRowCount',
			@dagRowCnt 'SubClient/DataArchiveChanged/@dagRowCount',
			@dagUpRowCnt1 'SubClient/DataArchiveChanged/@scPropFullIncrRowCount',
			@dagUpRowCnt2 'SubClient/DataArchiveChanged/@scPropReasonCodeRowCount',
			@dagUpRowCnt4 'SubClient/DataArchiveChanged/@scNonAssocAppRowCount',
			@sffRowCnt 'SubClient/NonAssocSCs/@filterFileAgedRowCount',
			@scPropAgedRowCnt 'SubClient/NonAssocSCs/@scPropAgedRowCount',
			@scPropNAInsRowCnt 'SubClient/NonAssocSCs/@newSCPropInsRowCount',
			@scPropNAExpRowCnt 'SubClient/NonAssocSCs/@scPropPastExpRowCount',
			@scPropNARetRowCnt 'SubClient/NonAssocSCs/@scPropRetDaysRowCount',
			@scPropNAAExpRowCnt 'SubClient/NonAssocSCs/@scPropArchExpRowCount',
			@apcUpRowCnt 'ArchPipeConfig/@updatedRowCount',
			@apcInsRowCnt 'ArchPipeConfig/@insertedRowCount',
			@apcDelRowCnt 'ArchPipeConfig/@deletedRowCount',
			@wqRowCnt 'WorkQueueRequest/@rowCount'
		FOR XML PATH ('SCPBackupSetReport'), TYPE
	)
	SELECT @errCode errorCode, @xmlReport xmlReport
	RETURN
END

IF EXISTS (select * from GxQscripts where name = 'AppUpdateAssocBsetSP')
	delete from GxQscripts where name = 'AppUpdateAssocBsetSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateAssocBsetSP')
	delete from GXDBVersions where aliasname = 'AppUpdateAssocBsetSP'
GO

insert into GXDBVersions values(2, 'AppUpdateAssocBsetSP',  '00010001000200040000', 'AppUpdateAssocBsetSP', '00010001000200040000')
GO

