

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUpdateAddSettingsRelativePathForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUpdateAddSettingsRelativePathForClient.sp,v $ $Id: AppUpdateAddSettingsRelativePathForClient.sp,v 1.1.2.2 2018/03/27 08:51:12 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Proc: "AppUpdateAddSettingsRelativePathForClient"						|
--	|																		|
--	|	Proc to update relative path on client upgrade
--	|																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateAddSettingsRelativePathForClient <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateAddSettingsRelativePathForClient')
	drop procedure AppUpdateAddSettingsRelativePathForClient
IF EXISTS (select * from GxQscripts where name='AppUpdateAddSettingsRelativePathForClient')
	delete from GxQscripts where name = 'AppUpdateAddSettingsRelativePathForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateAddSettingsRelativePathForClient')
	delete from GXDBVersions where aliasname = 'AppUpdateAddSettingsRelativePathForClient'
GO
print '... Creating Procedure: AppUpdateAddSettingsRelativePathForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateAddSettingsRelativePathForClient
  @clientID INTEGER,
  @oldRelativePath NVARCHAR(MAX),
  @newRelativePath NVARCHAR(MAX)
AS
	IF EXISTS (SELECT 1 FROM APP_AdvanceSettings
					WHERE entityId = @clientID AND entityType = 3 AND RTRIM(LTRIM(relativePath)) =  @oldRelativePath  AND deleted = 0
							AND sourceId = 0)
	BEGIN
		INSERT INTO APP_AdvanceSettings
		SELECT entityId,keyName,type,@newRelativePath,value,enabled,deleted,entityType,sourceId,0 FROM APP_AdvanceSettings
						WHERE entityId = @clientID AND entityType = 3 AND RTRIM(LTRIM(relativePath)) =  @oldRelativePath  AND deleted = 0
								AND sourceId = 0
		UPDATE APP_AdvanceSettings
		SET deleted = 1
		WHERE entityId = @clientID AND entityType = 3 AND RTRIM(LTRIM(relativePath)) =  @oldRelativePath  AND deleted = 0
								AND sourceId = 0
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateAddSettingsRelativePathForClient')
	delete from GxQscripts where name = 'AppUpdateAddSettingsRelativePathForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateAddSettingsRelativePathForClient')
	delete from GXDBVersions where aliasname = 'AppUpdateAddSettingsRelativePathForClient'
GO

insert into GXDBVersions values(2, 'AppUpdateAddSettingsRelativePathForClient',  '00010001000200020000', 'AppUpdateAddSettingsRelativePathForClient', '00010001000200020000')
GO

