

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppUndelAllEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppUndelAllEntities.sp,v $ $Id: AppUndelAllEntities.sp,v 1.1.2.5 2020/03/20 19:23:59 scheppuri Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppUndelAllEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppUndelAllEntities <<<'
	drop procedure AppUndelAllEntities
END
IF EXISTS (select * from GxQscripts where name='AppUndelAllEntities')
	delete from GxQscripts where name = 'AppUndelAllEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUndelAllEntities')
	delete from GXDBVersions where aliasname = 'AppUndelAllEntities'
GO
print '... Creating Procedure: AppUndelAllEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUndelAllEntities
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @EntityID integer,
  @ClientID integer,
  @EntityType integer 
AS
  DECLARE @errorCode integer 
  DECLARE @errorString nvarchar(max)
BEGIN
SET NOCOUNT ON
-- We dont two variables to denote the levels.
-- hierarchy - lowest to highest
-- subclient, backupset, instance,agent,client
-- Use case - we are trying to reset the status based on the entity level provided
--client- level 1 - execute all cursors
--agent level 2 - execute all except client
--instance level 3 - execute all except 1 and 2 3
--backupset level 4
--subclient level 5 5
DECLARE @BackupSetIdListTable table(backupsetid int)
BEGIN TRY
IF @EntityType =5
BEGIN
    update APP_Application set subclientStatus = subclientStatus & ~2
where APP_Application.id = @EntityID AND (subclientStatus & 0x00002) > 0
END
ELSE IF  @EntityType= 4
BEGIN
    update APP_Application set subclientStatus = subclientStatus & ~2
where APP_Application.backupset = @EntityID  AND (subclientStatus & 0x00002) > 0
    update APP_BackupSetName set status = status & ~2 OUTPUT inserted.id INTO @BackupSetIdListTable
where APP_BackupSetName.id = @EntityID AND (status & 0x00002) > 0
END
ELSE IF @EntityType =3  --Instance
BEGIN
    update APP_Application set subclientStatus = subclientStatus & ~2
where APP_Application.instance = @EntityID	AND (subclientStatus & 0x00002) > 0
    update APP_BackupSetName set status = status & ~2 OUTPUT inserted.id INTO @BackupSetIdListTable
							where APP_BackupSetName.id IN
(select backupset from APP_Application where 	instance = @EntityID) AND (status & 0x00002) > 0
    update APP_InstanceName set status = status & ~2
where APP_InstanceName.id = @EntityID and  APP_InstanceName.id <> 1 AND (status & 0x00002) > 0
END
ELSE IF @EntityType =2 -- Apptypes
BEGIN
    update APP_Application set subclientStatus = subclientStatus & ~2
where APP_Application.appTypeId = @EntityID AND APP_Application.clientId = @clientId AND (subclientStatus & 0x00002) > 0
     update APP_InstanceName set status = status & ~2
			where APP_InstanceName.id IN (select instance from APP_Application where
				appTypeId = @EntityID AND clientId = @clientId
AND instance != 1)  AND (status & 0x00002) > 0
   update APP_BackupSetName set status = status & ~2 OUTPUT inserted.id INTO @BackupSetIdListTable
							where APP_BackupSetName.id IN
(select backupset from APP_Application where appTypeId = @EntityID AND clientId = @clientId) AND (status & 0x00002) > 0
    update APP_IDAName set status = status & ~2
where APP_IDAName.appTypeid = @EntityID AND APP_IDAName.clientId = @clientId AND (status & 0x00002) > 0
END
ELSE IF @EntityType =1 -- Clients
BEGIN
	update APP_ClientProp
	set attrVal = '0'
	where attrName LIKE 'sys:apptype: deleted%' AND attrVal = '1' AND modified = 0 AND 	componentNameId =@EntityID
	update APP_ClientProp
	set attrVal = '0'
	where attrName LIKE 'PlatformDeleted 4' AND attrVal = '1' AND modified = 0 AND 	componentNameId =@EntityID
	update APP_ClientProp
	set attrVal = '0'
	where attrName = 'deleted' AND attrVal = '1' AND modified = 0 AND 	componentNameId =@EntityID
    update APP_InstanceName set status = status & ~2
			where APP_InstanceName.id IN (select instance from APP_Application where
				clientid = @EntityID and
instance != 1) AND (status & 0x00002) > 0
    update APP_BackupSetName set status = status & ~2 OUTPUT inserted.id INTO @BackupSetIdListTable
				where APP_BackupSetName.id IN
(select backupset from APP_Application where clientid = @EntityID) AND (status & 0x00002) > 0
    update APP_Application set subclientStatus = subclientStatus & ~2
where APP_Application.clientId =  @EntityID AND (subclientStatus & 0x00002) > 0
END
--Configure associated VM backupsets for VSA backupsets
IF OBJECT_ID('tempdb.dbo.#tmpVSASubClientInfo') IS NOT NULL
	DROP TABLE #tmpVSASubClientInfo
IF OBJECT_ID('tempdb.dbo.#ConfigureOrDeConfigureVMBackupsets_vmClientIdList') IS NOT NULL
	DROP TABLE #ConfigureOrDeConfigureVMBackupsets_vmClientIdList
CREATE TABLE #tmpVSASubClientInfo (
	subClientId INT PRIMARY KEY,
	backupsetid INT
)
CREATE TABLE #ConfigureOrDeConfigureVMBackupsets_vmClientIdList (
    vmClientId INT,
	vmBackupSetId INT,
	PRIMARY KEY (vmClientId, vmBackupSetId)
)
INSERT INTO #tmpVSASubClientInfo
    SELECT distinct subCl.id, backupsetid FROM @BackupSetIdListTable
INNER JOIN APP_Application subCl ON subCl.backupSet = backupsetid AND appTypeId=106
--Configure VM clients which are actively getting backedup
INSERT INTO #ConfigureOrDeConfigureVMBackupsets_vmClientIdList
	SELECT distinct VMClientId,ChildBackupSetId FROM APP_VMBackupSet vmb
	INNER JOIN #tmpVSASubClientInfo ON vmb.ParentBackupSetId=backupsetid
	INNER JOIN app_clientprop ON componentNameId = vmb.VMClientId AND attrName = N'VSA Discover Subclient ID'/*VSA_DISCOVER_CLIENT_PROP_SQL*/ AND modified = 0 AND CAST(attrVal as INT) = subClientId
--Configure VM clients which are marked for deconfigure but not actually deconfigured
INSERT INTO #ConfigureOrDeConfigureVMBackupsets_vmClientIdList
	SELECT distinct VMClientId,ChildBackupSetId FROM APP_VMBackupSet vmb
	INNER JOIN #tmpVSASubClientInfo ON vmb.ParentBackupSetId=backupsetid
INNER JOIN APP_BackupSetProp bsProp ON componentNameId = vmb.ChildBackupSetId AND attrName='Marked For Deconfigure' AND modified = 0 and isnull(bsProp.attrVal,0) !=0 and cast(bsProp.attrval as int) != 0
IF EXISTS (SELECT 1 from #ConfigureOrDeConfigureVMBackupsets_vmClientIdList)
BEGIN
	EXEC ConfigureOrDeConfigureVMBackupsets 1
END
IF OBJECT_ID('tempdb.dbo.#tmpVSASubClientInfo') IS NOT NULL
	DROP TABLE #tmpVSASubClientInfo
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode   = 1
        SET @errorString = 'Problems Executing AppUndelAllEntities Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
     SELECT @errorCode,@errorString
END
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppUndelAllEntities')
	delete from GxQscripts where name = 'AppUndelAllEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUndelAllEntities')
	delete from GXDBVersions where aliasname = 'AppUndelAllEntities'
GO

insert into GXDBVersions values(2, 'AppUndelAllEntities',  '00010001000200050000', 'AppUndelAllEntities', '00010001000200050000')
GO

