

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppTriggerToWorkQueue.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppTriggerToWorkQueue.sp,v $ $Id: AppTriggerToWorkQueue.sp,v 1.1.2.4 2018/03/22 01:35:39 jiechen Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppTriggerToWorkQueue <<<'

IF EXISTS (select * from sysobjects where name='AppTriggerToWorkQueue')
	drop procedure AppTriggerToWorkQueue
IF EXISTS (select * from GxQscripts where name='AppTriggerToWorkQueue')
	delete from GxQscripts where name = 'AppTriggerToWorkQueue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppTriggerToWorkQueue')
	delete from GXDBVersions where aliasname = 'AppTriggerToWorkQueue'
GO
print '... Creating Procedure: AppTriggerToWorkQueue'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppTriggerToWorkQueue
-- Input arguments
  @startTime INT = 0
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_errorCode int = 0
  DECLARE @o_errorCodeStr nvarchar(1024) = ''
	SET NOCOUNT ON
	DECLARE @rowCnt INT = 0
	DECLARE @WorkToken INT = 35	--WORK_TOKEN_UPDATE_CLIENT_CACHE
	DECLARE @AllClients INT = -1
	IF (@startTime = 0)
	BEGIN
		-- set to current time
		SET @startTime = dbo.GetUnixTime(GetUTCDate())
	END
	SELECT @rowCnt = COUNT(*) FROM APP_CLTTriggerRows WITH (NOLOCK) WHERE modified <= @startTime
	IF (@rowCnt = 0)
	BEGIN
		-- NOTHING TO DO!
		GOTO END_OF_PROC
	END
	-- Table to hold clientIds for all active Clients
	IF OBJECT_ID('tempdb.dbo.#activeClients') IS NOT NULL
		 DROP TABLE #activeClients
	CREATE TABLE #activeClients (clientId INT PRIMARY KEY)
	INSERT #activeClients (clientId)
		SELECT
			DISTINCT c.id
		FROM
			APP_Client c WITH (NOLOCK)
			JOIN APP_CLTTriggerRows lt (NOLOCK) ON lt.clientId = c.id
			JOIN APP_ClientProp cp WITH (NOLOCK) ON
				cp.componentNameId = lt.clientId
				AND (c.status & 2) <> 2		-- installed
				AND cp.modified = 0
				AND cp.attrName = 'PlatformDeleted 4'
				AND cp.attrVal = '0'
	-- Process CommServ "Associated Subclient Policies" row changes that need to be mapped for delivery to all CCS Enabled Clients
	IF OBJECT_ID('tempdb.dbo.#ASCPApps') IS NOT NULL
		DROP TABLE #ASCPApps
	CREATE TABLE #ASCPApps (
		appId		INT,
		bsId		NVARCHAR(10),
		PRIMARY KEY(appId, bsId)
	)
	-- GET ALL ASSOCIATED SUBCLIENT POLICY IDS
	INSERT INTO #ASCPApps (appId, bsId)
		SELECT
			a.id,
			CAST(a.backupSet AS NVARCHAR(10))
		FROM APP_Application a WITH(NOLOCK)
		JOIN APP_CLTTriggerRows lt (NOLOCK)
		ON
		a.clientId = 2		-- CommCell
		AND lt.rowId1 = a.clientId
AND a.appTypeId = 1030
	IF (@@ROWCOUNT <> 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#withSCPolicy') IS NOT NULL
			DROP TABLE #withSCPolicy
		CREATE TABLE #withSCPolicy (
			scpId		INT,
			scId		INT,
			clientId	INT,
			PRIMARY KEY(scId, scpId)
		)
		--GET SUBCLIENTS WHICH HAVE SUBCLIENT POLICY ASSOCIATION
		INSERT INTO #withSCPolicy(scpId, scId, clientId)
		SELECT
			SP.bsId,
			P.componentNameId,
			A.clientId
		FROM #ASCPApps SP
		JOIN APP_SubClientProp P (NOLOCK) ON P.cs_attrName = checksum(N'Associated subclient Policy') AND P.attrName = 'Associated subclient Policy' AND SP.bsId = P.attrVal AND P.modified = 0
		JOIN APP_Application A (NOLOCK) ON A.id = P.componentNameId
		JOIN #activeClients AC ON AC.clientId = A.clientId
		-- Process all CCS Enabled Clients and map trapped trigger rows to clients
		INSERT INTO APP_CLTTriggerRows(clientId, tableType, opCode, modified, rowId1)
			SELECT		-- CS APP_Application rows to forward to associated clients for Associated SubClient Polices
				c.clientId,
				ctr.tableType,
				ctr.opCode,
				ctr.modified,
				c.scId
			FROM
				APP_CLTTriggerRows ctr WITH(NOLOCK)
				INNER JOIN APP_Application ap ON
					ctr.clientId = 2			-- CommCell
					AND ctr.tableType = 4		--APP_Application Table Type. ClientConfigTableType.Application
					AND ctr.modified <= @startTime
					AND ap.id = ctr.rowId1
				INNER JOIN #ASCPApps a ON
					ap.id = a.appId
				INNER JOIN #withSCPolicy c ON
					c.scpId = a.bsId
			WHERE
				ctr.tableType IS NOT NULL
				AND c.clientId <> 2	--Don't re-insert CommCell client
			UNION
			SELECT		-- CS APP_BackupSetName rows to forward to associated clients for Associated SubClient Polices
				c.clientId,
				ctr.tableType,
				ctr.opCode,
				ctr.modified,
				c.scId
			FROM
				APP_CLTTriggerRows ctr WITH(NOLOCK)
				INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
					ctr.clientId = 2			-- CommCell
					AND ctr.tableType = 11		--APP_BackupSetName Table Type. ClientConfigTableType.BackupSetName
					AND ctr.modified <= @startTime
				INNER JOIN #ASCPApps a ON
					bs.id = a.bsId
				INNER JOIN #withSCPolicy c ON
					c.scpId = a.bsId
			WHERE
				ctr.tableType IS NOT NULL
				AND c.clientId <> 2	--Don't re-insert CommCell client
			UNION
			SELECT		-- CS APP_BackupSetProp rows to forward to associated clients for Associated SubClient Polices
				c.clientId,
				ctr.tableType,
				ctr.opCode,
				ctr.modified,
				c.scId
			FROM
				APP_CLTTriggerRows ctr WITH(NOLOCK)
				INNER JOIN APP_BackupSetProp bsp WITH(NOLOCK) ON
					ctr.clientId = 2			-- CommCell
					AND ctr.tableType = 12		--APP_BackupSetProp Table Type. ClientConfigTableType.BackupSetProp
					AND ctr.modified <= @startTime
				INNER JOIN #ASCPApps a ON
					bsp.componentNameId = a.bsId
				INNER JOIN #withSCPolicy c ON
					c.scpId = a.bsId
			WHERE
				ctr.tableType IS NOT NULL
				AND c.clientId <> 2	--Don't re-insert CommCell client
			UNION
			SELECT		-- CS APP_SubClientProp rows to forward to associated clients for Associated SubClient Polices
				c.clientId,
				ctr.tableType,
				ctr.opCode,
				ctr.modified,
				c.scId
			FROM
				APP_CLTTriggerRows ctr WITH(NOLOCK)
				INNER JOIN APP_SubClientProp sc WITH(NOLOCK) ON
					ctr.clientId = 2			-- CommCell
					AND ctr.tableType = 5		--APP_SubClientProp Table Type. ClientConfigTableType.SubClientProp
					AND ctr.modified <= @startTime
					--AND sc.id = ctr.rowId1
				INNER JOIN #ASCPApps a ON
					sc.componentNameId = a.appId
				INNER JOIN #withSCPolicy c ON
					c.scpId = a.bsId
			WHERE
				ctr.tableType IS NOT NULL
				AND c.clientId <> 2	--Don't re-insert CommCell client
	END
	--  Delete Enabled Clients for clients that currently DO NOT have network connectivity to the CS
	DELETE FROM #activeClients
	WHERE clientId IN
		(SELECT clientId FROM #activeClients
		EXCEPT
		(SELECT
			c.clientId AS clientId
		FROM #activeClients AS c
			INNER JOIN CCRClientToClient AS ctc WITH (NOLOCK) ON
				ctc.FromClientId = 2
				AND ctc.ToClientId = c.clientId
				AND ctc.lastOnlineTime > ctc.lastOfflineTime))
	-- Delete Clients for clients that are currently having WorkQueue retry issues
	DELETE FROM #activeClients
	WHERE clientId IN
		(SELECT
			wq.clientId
		FROM
			APP_WorkQueueRequest wq WITH(NOLOCK)
		WHERE
			wq.workToken = @WorkToken
			AND wq.retryCount > 0
		GROUP BY
			wq.clientId
		HAVING
			COUNT(wq.clientId) > 6)		-- total rows for client in WQ Table in retry mode
	-- Consolidate Table Row Updates to only what is needed to update the clients
	IF OBJECT_ID('tempdb.dbo.#TableUpdates') IS NOT NULL
		 DROP TABLE #TableUpdates
	CREATE TABLE #TableUpdates (
		clientId		INT,
		entityType		INT,
		rowNumber		INT,
		opCode			INT,
		modified		INT,
		rowId1			INT,
rowId1Name		NVARCHAR(2048)
	)
	CREATE UNIQUE INDEX TableUpdates_idx1 on #TableUpdates (clientId, entityType, rowNumber)
	INSERT INTO #TableUpdates(clientId, entityType, rowNumber, opCode, modified, rowId1, rowId1Name)
		SELECT
			cr.clientId,
			cr.tableType,
			ROW_NUMBER() OVER (PARTITION BY cr.clientId, cr.tableType ORDER BY cr.opCode ASC, cr.modified ASC) AS rowNumber,
			cr.opCode,
			cr.modified,
			CASE
				WHEN cr.rowId1 = 0 THEN cr.clientId
				ELSE cr.rowId1
				END rowId1,
			cr.rowId1Name
		FROM
			-- only need the latest inserted(0), updated(1), deleted(2) row to send all row data to the client, eliminate all other rows
			(SELECT
				r.clientId,
				r.tableType,
				r.opCode,
				r.modified,
				r.rowId1,
				r.rowId1Name
			FROM
				(SELECT
					RANK() OVER (PARTITION BY d.clientId, d.tableType, d.opCode ORDER BY d.opCode DESC, d.modified DESC) AS rk,
					d.clientId,
					d.tableType,
					d.opCode,
					d.modified,
					d.rowId1,
					d.rowId1Name
				FROM
					(SELECT DISTINCT		-- eliminate duplicate rows with same modified timestamp
						cr.clientId,
						CASE cr.tableType
						WHEN 1 THEN 3	--CLIENT_ENTITY
						WHEN 2 THEN 3	--CLIENT_ENTITY
						WHEN 10 THEN 4	--APPTYPE_ENTITY
						WHEN 13 THEN 5	--INSTANCE_ENTITY
						WHEN 14 THEN 5	--INSTANCE_ENTITY
						WHEN 11 THEN 6	--BACKUPSET_ENTITY
						WHEN 12 THEN 6	--BACKUPSET_ENTITY
						WHEN 4 THEN 7	--SUBCLIENT_ENTITY
						WHEN 5 THEN 7	--SUBCLIENT_ENTITY
						ELSE cr.tableType
						END tableType,
						cr.opCode,
						cr.modified,
						cr.rowId1,
						cr.rowId1Name
					FROM
						APP_CLTTriggerRows cr WITH (NOLOCK)
						INNER JOIN #activeClients c ON
							cr.clientId = c.clientId
							AND cr.opCode IN (0,1,2)	--ClientConfigTableOpCode.RowInserted, ClientConfigTableOpCode.RowUpdated, ClientConfigTableOpCode.RowDeleted
							AND cr.modified <= @startTime) AS d) AS r
			WHERE
				r.rk = 1	-- take the top ranked row only
			) AS cr
	SELECT @rowCnt = COUNT(*) FROM #TableUpdates
	IF (@rowCnt = 0)
	BEGIN
		-- rows no longer valid for processing
		-- Delete all rows before start time and for processed clients
		DELETE FROM	APP_CLTTriggerRows
		WHERE
			clientId IN (SELECT clientId FROM #activeClients)
			AND modified <= @startTime
		GOTO END_OF_PROC
	END
	-- Remove duplicate entries that are already in the Work Queue Pipeline
	IF OBJECT_ID('tempdb.dbo.#WorkRows') IS NOT NULL
		 DROP TABLE #WorkRows
	CREATE TABLE #WorkRows (
		clientId		INT,
		flag			INT,
		entityType		INT,
		tableOpCode		INT,
		tableRowID		INT
	)
	CREATE INDEX WorkRows_idx1 on #WorkRows (clientId, entityType, tableOpCode)
	-- Retreive all 19 type workTokens and parse workTokenParams into usable data fields
	INSERT INTO #WorkRows (clientId, flag, entityType, tableOpCode, tableRowID)
		SELECT
			d.clientId,
			d.flag,
			attr.value('(./@entityType)[1]', 'INT') AS tableType,
			CASE
				WHEN attr.value('(./@deleted)[1]', 'INT') = 1 AND attr.value('(./@include)[1]', 'INT') = 1 THEN 1	--IT'S UPDATE	ClientConfigTableOpCode.RowUpdated
				WHEN attr.value('(./@deleted)[1]', 'INT') = 0 AND attr.value('(./@include)[1]', 'INT') = 1 THEN 0	--IT IS INSERT	ClientConfigTableOpCode.RowInserted
				WHEN attr.value('(./@deleted)[1]', 'INT') = 1 AND attr.value('(./@include)[1]', 'INT') = 0 THEN 2	--IT IS DELETE	ClientConfigTableOpCode.RowDeleted
				END tableOpCode,
			attr.value('(./@entityId)[1]', 'INT') AS tableRowID
		FROM
			(SELECT
				wq.clientId,
				CAST(wq.workTokenParams AS XML) token,
				wq.flag--,
			FROM
				APP_WorkQueueRequest wq	-- need good data so NOLOCK not used
				INNER JOIN #activeClients c ON
					wq.clientId = c.clientId
					AND wq.workToken = @WorkToken) AS d
			CROSS APPLY d.token.nodes('/App_PurgeEntityInfo/entities') t(attr)
	-- now delete new entries that are already in the Work Queue pipe that are not already started
	DELETE tu
	FROM #TableUpdates tu, #WorkRows wr, APP_CCSXMLMapping xm WITH (NOLOCK)
	WHERE
		tu.clientId = wr.clientId
		AND tu.entityType = wr.entityType
		AND xm.id = wr.entityType
		AND wr.flag = 0				-- not being processed
		-- only delete where opCode is an insert or update operation, let delete operations go thru
		AND tu.opCode IN (0,1)		--ClientConfigTableOpCode.RowInserted, ClientConfigTableOpCode.RowUpdated
	-- Create Work Queue Client Config Store Update work token strings
	IF OBJECT_ID('tempdb.dbo.#WorkTokens') IS NOT NULL
		 DROP TABLE #WorkTokens
	CREATE TABLE #WorkTokens (
		clientId		INT,
		token			XML
	)
	CREATE INDEX WorkTokens_idx1 on #WorkTokens (clientId) INCLUDE (token)
	-- Insert actual client rows
	INSERT INTO #WorkTokens (clientId, token)
		SELECT
			mcr.clientId,
			(SELECT
				(SELECT
					cr.entityType AS '@entityType',
					cr.rowId1 AS '@entityId',
					cr.rowId1Name AS '@entityName',
					(SELECT		--BOTH INCLUDE AND DELETE MEANS UPDATE
						CASE
						WHEN cr.opCode IN (0, 1)
						THEN 1
						END '@include',
						CASE
						WHEN cr.opCode IN (1, 2)
						THEN 1
						END '@deleted'
						FOR XML PATH('flags'), TYPE
					)
				FROM #TableUpdates cr WITH (NOLOCK)
				WHERE
					cr.clientId = mcr.clientId
				FOR XML PATH('entities'), TYPE)
			FOR XML PATH('App_PurgeEntityInfo'))
		FROM
			(SELECT DISTINCT
				tr.clientId
			FROM
				APP_CLTTriggerRows tr WITH (NOLOCK)
				INNER JOIN #activeClients c ON
					tr.clientId = c.clientId
					AND tr.modified <= @startTime) AS mcr
	--=========================================================================
	-- From here on actual database updates take place to APP_WorkQueueRequest
	--=========================================================================
	BEGIN TRY
		BEGIN TRANSACTION Update_WorkQueueRequest
		-- Delete WorkQueueRequest that are not enabled for Operations any longer
		DELETE wq
		FROM APP_WorkQueueRequest wq		-- delete workqueue rows for any of these clients that are not installed
			INNER JOIN (SELECT	-- get uninstalled clients
							c.id clientId
						FROM APP_Client c WITH(NOLOCK)
						INNER JOIN APP_ClientProp cp  WITH(NOLOCK) ON
							cp.componentNameId = c.id
							AND cp.attrName = 'PlatformDeleted 4'
							AND cp.attrVal = '1'
							AND cp.modified = 0
							AND (c.status & 2) = 2		-- uninstalled
					) c ON
				c.clientId = wq.clientId
				AND wq.workToken = @WorkToken
		-- Insert APP_WorkQueueRequest rows
		INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
			SELECT
				wt.clientId,
				@WorkToken,
				CAST(wt.token AS NVARCHAR(MAX)),
				@startTime, 0, 0, 0, -1
			FROM
				APP_Client c
				INNER JOIN #WorkTokens wt ON
					c.id = wt.clientId					-- make sure client still exist and was not deleted
					AND (c.status & 2) <> 2				-- has not been uninstalled
					AND CAST(wt.token AS NVARCHAR(MAX)) <> '<TMMsg_CCSTableUpdates/>'
				INNER JOIN APP_ClientProp cp  WITH(NOLOCK) ON
					cp.componentNameId = c.id
					AND cp.attrName = 'PlatformDeleted 4'
					AND cp.attrVal = '0'
					AND cp.modified = 0
				LEFT OUTER JOIN APP_WorkQueueRequest wqr ON
					wt.clientId = wqr.clientId
					AND wqr.workToken = @WorkToken
					AND wqr.flag = 0            -- work item has not started
					AND CAST(wt.token AS NVARCHAR(MAX)) = wqr.workTokenParams
			WHERE
				wqr.workQueueId IS NULL     -- only insert rows that do not already exist or failed all attempts
		-- Delete all rows before start time and for processed clients
		DELETE FROM	APP_CLTTriggerRows
		WHERE
			clientId IN (SELECT clientId FROM #activeClients)
			AND modified <= @startTime
		COMMIT TRANSACTION Update_WorkQueueRequest
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorCode = 1
		SET @o_errorCodeStr = 'APP_WorkQueueRequest Trigger Row update failed'
		ROLLBACK TRANSACTION Update_WorkQueueRequest
	END CATCH
END_OF_PROC:
	IF OBJECT_ID('tempdb.dbo.#WorkRows') IS NOT NULL
		 DROP TABLE #WorkRows
	IF OBJECT_ID('tempdb.dbo.#WorkTokens') IS NOT NULL
		 DROP TABLE #WorkTokens
	IF OBJECT_ID('tempdb.dbo.#TableUpdates') IS NOT NULL
		 DROP TABLE #TableUpdates
	IF OBJECT_ID('tempdb.dbo.#activeClients') IS NOT NULL
		 DROP TABLE #activeClients
	IF OBJECT_ID('tempdb.dbo.#withSCPolicy') IS NOT NULL
		DROP TABLE #withSCPolicy
	SELECT @o_errorCode, @o_errorCodeStr
GO

IF EXISTS (select * from GxQscripts where name = 'AppTriggerToWorkQueue')
	delete from GxQscripts where name = 'AppTriggerToWorkQueue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppTriggerToWorkQueue')
	delete from GXDBVersions where aliasname = 'AppTriggerToWorkQueue'
GO

insert into GXDBVersions values(2, 'AppTriggerToWorkQueue',  '00010001000200040000', 'AppTriggerToWorkQueue', '00010001000200040000')
GO

