

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppTimeZoneToRegionMapping.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppTimeZoneToRegionMapping.sp,v $ $Id: AppTimeZoneToRegionMapping.sp,v 1.1.2.2 2018/03/22 01:15:59 jiechen Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppTimeZoneToRegionMapping <<<'

IF EXISTS (select * from sysobjects where name='AppTimeZoneToRegionMapping')
	drop procedure AppTimeZoneToRegionMapping
IF EXISTS (select * from GxQscripts where name='AppTimeZoneToRegionMapping')
	delete from GxQscripts where name = 'AppTimeZoneToRegionMapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppTimeZoneToRegionMapping')
	delete from GXDBVersions where aliasname = 'AppTimeZoneToRegionMapping'
GO
print '... Creating Procedure: AppTimeZoneToRegionMapping'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppTimeZoneToRegionMapping
-- Input arguments
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_errorCode INT
  DECLARE @o_errorMsg VARCHAR(255)
SET NOCOUNT ON
SET @o_errorCode = 0
SET @o_errorMsg = 'Success'
BEGIN TRY
	MERGE SchedTimeZoneToRegion tztr
	USING SchedTimeZone tz ON
		tz.TimeZoneStdName = tztr.tzStdName
	WHEN NOT MATCHED THEN
		INSERT (tzStdName, regionId, timeZoneID)
			VALUES(tz.TimeZoneStdName, 0, tz.TimeZoneID)
	WHEN MATCHED AND tz.TimeZoneID <> tztr.timeZoneID THEN
		UPDATE
			SET tztr.timeZoneID = tz.TimeZoneID
	--OUTPUT $action, Inserted.*
	;
	DECLARE @tzUnmappedList NVARCHAR(MAX) = N''
	SELECT
		@tzUnmappedList +=  N'Windows TimeZone Standard Name: ''' + t.tzStdName + N'''  TimeZoneID: ' + CAST(t.timeZoneID AS NVARCHAR(10)) + NCHAR(10)
	FROM SchedTimeZoneToRegion t
	WHERE
		t.regionId = 0
		AND t.timeZoneID <> 0
	IF (@tzUnmappedList <> N'')
	BEGIN
		-- log message
		PRINT N'WARNING: Local supported TimeZones not mapped to a TimeZone Region contact product representative:' + NCHAR(10) + @tzUnmappedList
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = 1
	SET @o_errorMsg = 'Catch Block Error'
END CATCH
SELECT @o_errorCode o_errorCode, @o_errorMsg o_errorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'AppTimeZoneToRegionMapping')
	delete from GxQscripts where name = 'AppTimeZoneToRegionMapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppTimeZoneToRegionMapping')
	delete from GXDBVersions where aliasname = 'AppTimeZoneToRegionMapping'
GO

insert into GXDBVersions values(2, 'AppTimeZoneToRegionMapping',  '00010001000200020000', 'AppTimeZoneToRegionMapping', '00010001000200020000')
GO

