

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncUpdateConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSyncUpdateConfig							|
--	|       Procedure for modifying  an existing Sync Web Folder		|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncUpdateConfig <<<'

IF EXISTS (select * from sysobjects where name='AppSyncUpdateConfig')
	drop procedure AppSyncUpdateConfig
IF EXISTS (select * from GxQscripts where name='AppSyncUpdateConfig')
	delete from GxQscripts where name = 'AppSyncUpdateConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncUpdateConfig')
	delete from GXDBVersions where aliasname = 'AppSyncUpdateConfig'
GO
print '... Creating Procedure: AppSyncUpdateConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncUpdateConfig
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @ownerId			INT	= 0
	DECLARE @assocCount			INT = 0
	DECLARE @i					INT = 1
	DECLARE @assocXML			XML
	DECLARE @syncType			INT
	DECLARE @syncPath			NVARCHAR(MAX)
	DECLARE @syncPathOld		NVARCHAR(MAX)
	DECLARE @subclientId		INT
	DECLARE @clientId			INT
	DECLARE @syncClientFlag		INT
	DECLARE @oldSyncClientFlag	INT
	DECLARE @configOptions		XML
	DECLARE @oldConfigOptions	XML
	DECLARE @scFilterFileID		INT = 0
	DECLARE @contentTbl			TABLE
	(subclientId INT, isContentchanged INT, isNewConfigClient INT)
	DECLARE @workQueueParam		NVARCHAR(MAX)
	DECLARE @workQueueXML		XML
	DECLARE @contentChanged		INT = 0
	DECLARE @workQOutPutTbl		TABLE (errCode INT, errString NVARCHAR(MAX))
	DECLARE @contentOutPutTbl	TABLE (scFilterFileId INT, isContentChanged INT)
	DECLARE @oscClientTbl		TABLE (clientId INT, subclientId INT)
	DECLARE @wasSource			INT = 0
	DECLARE @wasSourceNowBoth	INT = 0
	DECLARE @wasBothNowOnlySource	INT = 0
	DECLARE @clientName			NVARCHAR(MAX) = ''
	DECLARE @oldSyncFolderName	NVARCHAR(MAX) = ''
    DECLARE @opEvMsgId          INT = 0
    DECLARE @dataIsEvent        INT = 0
    DECLARE @opMsgId            INT = 0
	DECLARE @opId				INT = 0
	DECLARE @paramMsgId			INT = 0
	DECLARE @oldSyncType		INT
	DECLARE @oldTypeParam		INT
	DECLARE @oldTypeParamVal	NVARCHAR(MAX) = ''
	DECLARE @newTypeParam		INT
	DECLARE @newTypeParamVal	NVARCHAR(MAX) = ''
	DECLARE @localeParamVal		NVARCHAR(MAX) = ''
DECLARE @excludeStatusMask int = (cast(0x00002 as int) | cast(0x00004 as int) | cast(0x00010 as int) | cast(0x00020 as int))
	-- Read the XML
	DECLARE @syncWebFolderId		INT				= ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
														FROM @i_xmlString.nodes ('App_UpdateSyncWebFolderReq/syncInfos/syncWebFolder') R(ref)), '')
	DECLARE @syncWebFolderName		NVARCHAR(MAX)	= ISNULL (( SELECT ref.value('@syncWebFolderName', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_UpdateSyncWebFolderReq/syncInfos/syncWebFolder') R(ref)), '')
	DECLARE @description			NVARCHAR(MAX)	= ISNULL (( SELECT ref.value('@description', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_UpdateSyncWebFolderReq/syncInfos') R(ref)), '')
	DECLARE @syncWebFolderFlag		INT				= ISNULL (( SELECT ref.value('@flag', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_UpdateSyncWebFolderReq/syncInfos') R(ref)), 0)
	DECLARE @enabled				INT				= ISNULL (( SELECT ref.value('@enabled', 'INT')
														FROM @i_xmlString.nodes ('App_UpdateSyncWebFolderReq/syncInfos') R(ref)), 0)
	DECLARE @isNewConfigClient		INT = 0
	DECLARE @isSelectiveSyncChanged INT = 0
	DECLARE @isSelectiveSync INT = 0
	DECLARE @oldIsSelectiveSync INT = 0
	DECLARE @isDecoupledSelectiveSync INT = 0
	DECLARE @subclientPolicyAppId INT = 0
	IF OBJECT_ID('tempdb.dbo.#policyEdgeSelectiveSyncContent') IS NOT NULL DROP TABLE #policyEdgeSelectiveSyncContent
	CREATE TABLE #policyEdgeSelectiveSyncContent(itemPath NVARCHAR(MAX))
	IF OBJECT_ID('tempdb.dbo.#inEdgeSelectiveSyncContent') IS NOT NULL DROP TABLE #inEdgeSelectiveSyncContent
	CREATE TABLE #inEdgeSelectiveSyncContent(itemPath NVARCHAR(MAX))
	IF OBJECT_ID('tempdb.dbo.#oldEdgeSelectiveSyncContent') IS NOT NULL DROP TABLE #oldEdgeSelectiveSyncContent
	CREATE TABLE #oldEdgeSelectiveSyncContent(itemPath NVARCHAR(MAX))
	IF @syncWebFolderId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid Web Folder info in update request.'
		GOTO ERROR_EXIT
	END
	SET @ownerId = ISNULL( (SELECT ownerId FROM App_SyncCloudFolder WITH(READUNCOMMITTED) WHERE syncWebFolderId = @syncWebFolderId), 0)
	If @ownerId = 0
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Error : Web Folder does not exist.'
		GOTO ERROR_EXIT
	END
	--MR#156620
	--IF EXISTS (SELECT 1 FROM App_SyncCloudFolder WHERE syncWebFolderName = @syncWebFolderName AND syncWebFolderId <> @syncWebFolderId AND ownerId = @ownerId)
	IF EXISTS (SELECT 1 FROM App_SyncCloudFolder SF WITH(NOLOCK) JOIN App_SyncCloudFolders SFV ON SF.syncWebFolderId = SFV.SyncWebFolderId
				WHERE SF.syncWebFolderId <> @syncWebFolderId AND syncWebFolderName = @syncWebFolderName AND ownerId = @ownerId	AND SFV.FLAG = 0)
	BEGIN
		SET @errorCode = 3
		SET @errorString = 'Error : Another Web Folder with same name already exists for user.'
		GOTO ERROR_EXIT
	END
	SET @oldSyncFolderName = ISNULL((SELECT syncWebFolderName FROM App_SyncCloudFolder WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND ownerId = @ownerId), '')
DECLARE @isEdgeDrive INT = ISNULL((SELECT 1 FROM App_SyncCloudFolder WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND flag & 0x10 > 0), 0)
	DECLARE @edgeClientId INT = 0
	IF @isEdgeDrive = 1
	BEGIN
		SET @edgeClientId = (SELECT TOP 1 clientId FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND syncType = 1)
	END
	-- @@TODO
	-- Any other validation
	BEGIN TRAN
	-- Update the web folder
	UPDATE App_SyncCloudFolder
	SET syncWebFolderName = @syncWebFolderName,
	description = @description,
	flag = @syncWebFolderFlag,
	ownerId = @ownerId,
	modified = @nowTime
	WHERE syncWebFolderId = @syncWebFolderId
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
	-- Add or Update client to existing web folder if supplied
	-- Delete will be a separate unlink request
-- Add the sync clients for this folder
	SET @assocCount = @i_xmlString.value('count(//.[@syncType])','INT')
	IF @isEdgeDrive = 0 -- No audit in SP for edge drive
	BEGIN
		--ONLY ADD OPERATION IF SOMETHING CHANGED
		IF (@assocCount > 0 OR  LTRIM(RTRIM(@syncWebFolderName)) <>  LTRIM(RTRIM(@oldSyncFolderName)))
		BEGIN
			-- SET GUI AUDIT OPERATION
SET @opMsgId = (382 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @oldSyncFolderName, @dataIsEvent
SET @paramMsgId = (1038 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		IF ( LTRIM(RTRIM(@syncWebFolderName)) <>  LTRIM(RTRIM(@oldSyncFolderName)))
		BEGIN
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @oldSyncFolderName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @syncWebFolderName, @dataIsEvent
SET @paramMsgId = (1050 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
	END
	WHILE (@i <= @assocCount)
	BEGIN
		SET @scFilterFileID = 0
		SET @contentChanged = 0
		SET @isNewConfigClient = 0
		SET @workQueueXML = ''
		SET @syncPathOld = ''
		DELETE FROM @workQOutPutTbl
		DELETE FROM @contentOutPutTbl
		SET @assocXML = @i_xmlString.query('(//.[@syncType])[sql:variable("@i")]')
		SET @syncType = ISNULL (( SELECT ref.value('@syncType', 'INT')
									FROM @assocXML.nodes ('associatedClients') R(ref)), 0)
		SET @syncPath = ISNULL (( SELECT ref.value('@syncPath', 'NVARCHAR(MAX)')
									FROM @assocXML.nodes ('associatedClients') R(ref)), '')
		SET @subclientId = ISNULL (( SELECT ref.value('@subclientId', 'INT')
									FROM @assocXML.nodes ('associatedClients/client') R(ref)), 0)
		SET @clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
									FROM @assocXML.nodes ('associatedClients/client') R(ref)), 0)
		SET @syncClientFlag = ISNULL (( SELECT ref.value('@flag', 'INT')
									FROM @assocXML.nodes ('associatedClients') R(ref)), 0)
		SET @configOptions = ISNULL (@assocXML.query('associatedClients/syncOptions') , '')
		SELECT @clientName = name FROM App_Client WITH (NOLOCK)
		WHERE id = @clientId
		SELECT @oldSyncType = syncType FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId
		-- Perform all client validation.
		-- This is same as in AppSyncGetWebFolders.sp
		IF NOT EXISTS (SELECT 1
					   FROM   UMOwnerCredentials um WITH(NOLOCK)
					   WHERE userId = @i_userId
					   AND clientId = @clientId)
		BEGIN
SET @errorCode = 10001
			SET @errorString = 'Error : User has no ownership over client [' + @clientName + '].'
			GOTO ERROR
		END
		IF NOT EXISTS ( SELECT 1
						FROM APP_Client WITH(NOLOCK)
						WHERE id = @clientId
AND status & 0x1000 <> 0)
		BEGIN
SET @errorCode = 10002
			SET @errorString = 'Error : Client [' + @clientName + '] is not configured as a laptop.'
			GOTO ERROR
		END
		IF NOT EXISTS ( SELECT 1
						FROM App_Client CL WITH(NOLOCK)
						INNER JOIN APP_IDAName IDA WITH(NOLOCK) ON IDA.clientId = CL.id and  ( IDA.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) and IDA.appTypeId <> 13)
						INNER JOIN APP_Application APP ON APP.clientId = CL.id and subclientStatus&@excludeStatusMask = 0 and (subClientStatus & 0x00008 = 0x00008)
						WHERE releaseId > 14 AND CL.status & @excludeStatusMask = 0 -- Consider only laptop clients
						AND CL.id = @clientId)
		BEGIN
SET @errorCode = 10003
			SET @errorString = 'Error : Client [' + @clientName + '] does not have a valid FS apptype installed.'
			GOTO ERROR
		END
		-- Compute selective sync flags for edge drive
		IF @isEdgeDrive = 1
		BEGIN
			SET @isSelectiveSync = 0
			SET @OldIsSelectiveSync = 0
			SET @isDecoupledSelectiveSync = 0
			SET @subclientPolicyAppId = 0
			-- Old selective sync options
			SELECT @oldConfigOptions = SC.configOptions, @oldSyncClientFlag = SC.flag
			FROM App_SyncCloudConfig SC
			WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId
			IF @syncType <> 4
			BEGIN
				SELECT @isSelectiveSync = ref.value('@selectiveSync', 'INT')
				FROM
				@configOptions.nodes('/syncOptions/destinationOptions') doc(ref)
				TRUNCATE TABLE #oldEdgeSelectiveSyncContent
				TRUNCATE TABLE #inEdgeSelectiveSyncContent
				TRUNCATE TABLE #policyEdgeSelectiveSyncContent
				INSERT INTO #inEdgeSelectiveSyncContent
				SELECT ref.value('@itemPath', 'NVARCHAR(MAX)')
				FROM
				@configOptions.nodes('/syncOptions/destinationOptions/selectiveItemsToSync') doc(ref)
				IF @oldSyncClientFlag IS NOT NULL
				BEGIN
					-- This means existing client. See if selective sync is changed
IF @oldSyncClientFlag & 0x100 = 0x100
						SET @OldIsSelectiveSync = 1
					IF @OldIsSelectiveSync <> @isSelectiveSync
						SET @isSelectiveSyncChanged = 1
					ELSE IF @OldIsSelectiveSync = 1
					BEGIN
						INSERT INTO #oldEdgeSelectiveSyncContent
						SELECT ref.value('@itemPath', 'NVARCHAR(MAX)')
						FROM
						@oldConfigOptions.nodes('/syncOptions/destinationOptions/selectiveItemsToSync') doc(ref)
						SET @isSelectiveSyncChanged = (SELECT TOP 1 1
														 FROM
														 (
															SELECT DISTINCT itemPath
															FROM #inEdgeSelectiveSyncContent
															UNION ALL
															SELECT DISTINCT itemPath
															FROM #oldEdgeSelectiveSyncContent
														 ) tmp
														 GROUP BY itemPath
														 HAVING COUNT(*) = 1)
					END
					If @isSelectiveSyncChanged = 1
					BEGIN
						INSERT INTO @oscClientTbl
						VALUES(@clientId,@subclientId)
						-- Also save this in history for new content lookup.
						INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, stringVal, longVal, longlongVal, created, modified)
VALUES(19, --CV_COMPONENT_SYNC_CONFIG_HISTORY
						@subclientId,
						@clientId,
						1, --PROPERTY_STRING
						CAST(@configOptions AS NVARCHAR(MAX)), 0, 0, @nowTime, 0)
					END
				END
				IF @isSelectiveSync = 1
				BEGIN
					-- Set selective sync flag.
SET @syncClientFlag = @syncClientFlag  | 0x100
					INSERT INTO #policyEdgeSelectiveSyncContent
					SELECT SFF.fileName
					FROM APP_Application APP
					INNER JOIN APP_SubClientProp SP ON SP.attrName = 'Associated subclient Policy' AND SP.cs_attrName = CHECKSUM(N'Associated subclient Policy') AND SP.modified = 0
					INNER JOIN APP_ScFilterFile SFF ON SFF.componentNameId = APP.id
					WHERE SP.componentNameId = @subclientId
					AND CAST(APP.id AS NVARCHAR(MAX)) = SP.attrVal
					AND SFF.type = 24 -- CV_EDGE_SELECTIVE_SYNC_FILTERS
					AND SFF.modified = 0
					-- If policy level and input content do not match, then it is decoupled.
					SET @isDecoupledSelectiveSync = (SELECT TOP 1 1
													 FROM
													 (
														SELECT DISTINCT itemPath
														FROM #inEdgeSelectiveSyncContent
														UNION ALL
														SELECT DISTINCT itemPath
														FROM #policyEdgeSelectiveSyncContent
													 ) tmp
													 GROUP BY itemPath
													 HAVING COUNT(*) = 1)
					-- Set decoupled selective sync flag.
					IF @isDecoupledSelectiveSync = 1
SET @syncClientFlag = @syncClientFlag  | 0x200
				END
			END
		END
		--  when edgedrive is unlinked or paused
IF @syncType = 4 OR (@syncClientFlag & 0x1 = 0x1)
		BEGIN
			-- Mark syncWebFolder as paused for the client
IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId AND flag & 0x1 <> 0x1)
			BEGIN
				-- Mark the client as paused
				UPDATE App_SyncCloudConfig
SET flag = flag | 0x1
				WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId
				SELECT @errorCode = @@ERROR
				IF @errorCode <> 0 GOTO ERROR
			END
			IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId AND syncType & 1 = 1)
			BEGIN
				INSERT INTO @oscClientTbl
				VALUES(@clientId,@subclientId)
			END
			IF @syncType = 4
			BEGIN
				IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId)
				BEGIN
					-- Mark the client as unlinked
					UPDATE App_SyncCloudConfig
					SET synctype = @syncType
					WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId
					-- Cleanup selective sync
IF @isEdgeDrive = 1 AND @oldSyncClientFlag & 0x100 = 0x100
					BEGIN
						SET @oldConfigOptions.modify('replace value of (/syncOptions/destinationOptions/@selectiveSync)[1] with "0"')
						SET @oldConfigOptions.modify('delete /syncOptions/destinationOptions/selectiveSync')
						SET @oldConfigOptions.modify('delete /syncOptions/destinationOptions/selectiveItemsToSync')
						UPDATE App_SyncCloudConfig
SET flag = flag &~ (CAST(0x100 AS INT) | CAST(0x200 AS INT)),
							configOptions = @oldConfigOptions
						WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId
					END
				END
			END
			IF @isEdgeDrive = 0 -- No audit in SP for edge drive
			BEGIN
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
SET @localeParamVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (149 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0, 2)
				EXEC EvGuiAuditSetParamData @opId, @localeParamVal, @dataIsEvent
SET @localeParamVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1251 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0, 2)
				EXEC EvGuiAuditSetParamData @opId, @localeParamVal, @dataIsEvent
SET @paramMsgId = (1052 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
		END
		ELSE
		BEGIN
			-- Other parameters validation
			IF @syncType NOT IN (1,2,3)
			   OR @syncPath = ''
			BEGIN
				SET @errorCode = 2
				SET @errorString = 'Error : Invalid values found in update request.'
				GOTO ERROR
			END
			IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId)
			BEGIN
				SET @syncPathOld = ISNULL((SELECT syncPath FROM App_SyncCloudConfig WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId ),'')
				SET @wasSource = 0
				SET @wasSourceNowBoth = 0
				SET @wasBothNowOnlySource = 0
				IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId AND syncType & 1 = 1) AND @syncType & 1 <> 1
					SET @wasSource = 1
				-- This means it is a source and so check if we need to add backup content.
				IF @syncType & 1 = 1
				BEGIN
					IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId AND syncType = 1)
						AND @syncType = 3
					BEGIN
						SET @wasSourceNowBoth = 1
					END
					IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId AND syncType = 3)
						AND @syncType = 1
					BEGIN
						SET @wasBothNowOnlySource = 1
					END
					-- Do this only if it not all Content.
IF @syncClientFlag & 0x2 = 0
AND @syncWebFolderFlag & 0x10 = 0
					BEGIN
						--INSERT INTO @contentOutPutTbl
						EXEC AppCheckAndInsertSubclientContent @subclientId, @syncPath, @i_userId, @i_localeId, @scFilterFileID OUTPUT, @contentChanged OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
						IF @errorCode <> 0 GOTO ERROR
						--SELECT @scFilterFileID = scFilterFileId, @contentChanged = isContentChanged, @oldContent = oldContent, @newContent = newContent FROM @contentOutPutTbl
					END
IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId AND flag & 0x1 <> 0)
					BEGIN
						INSERT INTO @oscClientTbl
						VALUES(@clientId,@subclientId)
					END
				END
				IF @wasSource = 1
				BEGIN
					-- Delete the stats entry
					DELETE App_SyncCloudStats
					WHERE syncWebFolderId = @syncWebFolderId AND sourceSubclientId = @subclientId
--
					-- Send token to start backup so that sync content can get modified
					INSERT INTO @oscClientTbl
					VALUES(@clientId,@subclientId)
				END
--
				IF @wasBothNowOnlySource = 1
				BEGIN
					-- Delete the stats entry
					DELETE App_SyncCloudStats
					WHERE syncWebFolderId = @syncWebFolderId AND destClientId = @clientId
				END
--
--If the path has changed, then have to restart sync
				IF @isEdgeDrive = 0 -- No audit in SP for edge drive
				BEGIN
					IF LTRIM(RTRIM(@syncPathOld)) <> LTRIM(RTRIM(@syncPath))
					BEGIN
						UPDATE App_SyncCloudStats
						SET syncStatus = 0, retryCount = 0, lastSuccessSyncJobId = 0
						WHERE syncWebFolderId = @syncWebFolderId AND destClientId = @clientId
							AND NOT EXISTS (SELECT * FROM App_SyncCloudConfig WHERE syncWebFolderId = @syncWebFolderId AND subclientId = sourceSubclientId AND flag & 1 = 1)
						-- SET GUI AUDIT PARAMETER
						EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
						EXEC EvGuiAuditSetParamData @opId, @syncPathOld, @dataIsEvent
						EXEC EvGuiAuditSetParamData @opId, @syncPath, @dataIsEvent
SET @paramMsgId = (1051 | (CAST(POWER(2, 24) AS BIGINT) * 85))
						EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
					END
				END
--
				UPDATE App_SyncCloudConfig
				SET syncPath = @syncPath,
				subclientId = @subclientId,
				syncType = @syncType,
				scFilterFileId = @scFilterFileID,
				flag = @syncClientFlag,
				configOptions = @configOptions
				WHERE syncWebFolderId = @syncWebFolderId AND clientId = @clientId
--
				SELECT @errorCode = @@ERROR
				IF @errorCode <> 0 GOTO ERROR
				IF @isEdgeDrive = 0 -- No audit in SP for edge drive
				BEGIN
					-- SET GUI AUDIT PARAMETER
					EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
SET @localeParamVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1251 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0, 2)
					EXEC EvGuiAuditSetParamData @opId, @localeParamVal, @dataIsEvent
SET @localeParamVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (149 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0, 2)
					EXEC EvGuiAuditSetParamData @opId, @localeParamVal, @dataIsEvent
SET @paramMsgId = (1052 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
				END
			END
			ELSE
			BEGIN
				IF @syncType & 1 = 1
				BEGIN
					-- Do this only if it not all Content.
IF @syncClientFlag & 0x2 = 0
AND @syncWebFolderFlag & 0x10 = 0
					BEGIN
						--INSERT INTO @contentOutPutTbl
						EXEC AppCheckAndInsertSubclientContent @subclientId, @syncPath, @i_userId, @i_localeId, @scFilterFileID OUTPUT, @contentChanged OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
						IF @errorCode <> 0 GOTO ERROR
						--SELECT @scFilterFileID = scFilterFileId, @contentChanged = isContentChanged FROM @contentOutPutTbl
					END
					-- Send token to start backup so that sync content can get modified
					--IF NOT EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK) WHERE clientId = @clientId AND syncType & 1 = 1)
					BEGIN
						INSERT INTO @oscClientTbl
						VALUES(@clientId,@subclientId)
					END
				END
				-- Insert the sync client in web folder
				INSERT INTO App_SyncCloudConfig(syncWebFolderId, syncPath, clientId, subclientId, syncType, scFilterFileId,  created, flag, configOptions)
				VALUES(@syncWebFolderId, @syncPath, @clientId, @subclientId, @syncType, @scFilterFileID, @nowTime, @syncClientFlag, @configOptions)
				SELECT @errorCode = @@ERROR
				IF @errorCode <> 0 GOTO ERROR
				SET @isNewConfigClient = 1
			END
--
			IF (@wasSource = 0 and @wasBothNowOnlySource = 0) OR @wasSourceNowBoth = 1
			BEGIN
				INSERT INTO @contentTbl
				VALUES(@subclientId, @contentChanged, @isNewConfigClient)
			END
			IF @isEdgeDrive = 0 -- No audit in SP for edge drive
			BEGIN
				IF @oldSyncType <> @syncType
				BEGIN
					SET @oldTypeParam =
(SELECT CASE WHEN @oldSyncType = 1 THEN (1040 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @oldSyncType = 2 THEN (1041 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @oldSyncType = 3 THEN (1039 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @oldSyncType = 4 THEN (1042 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					END)
					SET @oldTypeParamVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @oldTypeParam, 0, 2)
					SET @newTypeParam =
(SELECT CASE WHEN @syncType = 1 THEN (1040 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @syncType = 2 THEN (1041 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @syncType = 3 THEN (1039 | (CAST(POWER(2, 24) AS BIGINT) * 85))
WHEN @syncType = 4 THEN (1042 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					END)
					SET @newTypeParamVal = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @newTypeParam, 0, 2)
					-- SET GUI AUDIT PARAMETER
					EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
					EXEC EvGuiAuditSetParamData @opId, @oldTypeParamVal, @dataIsEvent
					EXEC EvGuiAuditSetParamData @opId, @newTypeParamVal, @dataIsEvent
SET @paramMsgId = (1052 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
				END
			END
		END
		SET @i  = @i +1
	END
	-- Populate the sync stats table
	INSERT INTO App_SyncCloudStats (syncWebFolderId, destClientId, sourceSubclientId, lastBackupSyncJobId, lastSuccessSyncJobId, currentRestoreJobId, syncStatus)
	SELECT DISTINCT WF.syncWebFolderId, D.clientId, S.subclientId, 0, 0, 0,
	CASE CON.isContentchanged
	WHEN 0 THEN 0 -- If content not changed, then it is already backed up. So syncStatus = 0 ==> NEEDS_RESTORE_AFTER_BACKUP
	WHEN 1 THEN 2 --If content changed, then it is not already backed up. It will be backed up by workflow. So syncStatus = 2 ==> SYNC_SUCCESSFUL
	END
	FROM App_SyncCloudFolder WF
	INNER JOIN App_SyncCloudConfig S ON WF.syncWebFolderId = S.syncWebFolderId AND S.syncType & 1 = 1
	INNER JOIN App_SyncCloudConfig D ON WF.syncWebFolderId = D.syncWebFolderId AND D.syncType & 2 = 2 AND S.syncConfigId <> D.syncConfigId
	INNER JOIN @contentTbl CON ON S.subclientId = CON.subClientId
	LEFT OUTER JOIN App_SyncCloudStats STAT ON S.subclientId = STAT.sourceSubclientId AND D.clientId = STAT.destClientId AND WF.syncWebFolderId = STAT.syncWebFolderId
	WHERE WF.syncWebFolderId = @syncWebFolderId
	AND (STAT.sourceSubclientId IS NULL)
--
--
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
--
--
	-- Push OSC for the required clients
	DECLARE @oscClientId INT = 0
	DECLARE @oscSubclientId INT = 0
	DECLARE GetOSCClients CURSOR
	FOR SELECT DISTINCT clientId,subclientId FROM @oscClientTbl
	OPEN GetOSCClients
	FETCH GetOSCClients INTO @oscClientId, @oscSubclientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @isEdgeDrive = 0
		BEGIN
			-- Submit Workqueue for subclient content change WORK_TOKEN_SUBCLIENT_CONTENT = 7
			SET @workQueueXML = (SELECT @oscSubclientId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE)
			SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
			DELETE @workQOutPutTbl
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 7, 0, 0, @oscClientId, 0, @workQueueParam
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
			IF @errorCode <> 0
			BEGIN
				CLOSE GetOSCClients
				DEALLOCATE GetOSCClients
				GOTO ERROR
			END
		END
		DELETE @workQOutPutTbl
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 4, 0, 0, @oscClientId, 0, ''
		SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		IF @errorCode <> 0
		BEGIN
			CLOSE GetOSCClients
			DEALLOCATE GetOSCClients
			GOTO ERROR
		END
		IF @isSelectiveSyncChanged = 1
		BEGIN
			-- Send selective sync changed workqueue
			SET @workQueueXML = (	SELECT (
											SELECT @edgeClientId AS '@clientId',
												   @oscSubclientId AS '@subclientId'
											FOR XML PATH('subclient'), TYPE
											),
											(
											SELECT @syncWebFolderId AS '@syncWebFolderId'
											FOR XML PATH('syncFolder'), TYPE
											)
									FOR XML PATH('TMMsg_SyncRestoreWorkQueueReq'), TYPE
								)
			SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
			DELETE @workQOutPutTbl
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 44, 0, 0, @oscClientId, 0, @workQueueParam -- WORK_TOKEN_SELECTIVE_SYNC_CONTENT_CHANGED
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
			IF @errorCode <> 0
			BEGIN
				CLOSE GetOSCClients
				DEALLOCATE GetOSCClients
				GOTO ERROR
			END
		END
		FETCH GetOSCClients INTO @oscClientId, @oscSubclientId
	END
	CLOSE GetOSCClients
	DEALLOCATE GetOSCClients
	ERROR:
		IF @errorCode <> 0
			ROLLBACK TRAN
		ELSE
			COMMIT TRAN
	ERROR_EXIT:
		SET @o_xmlString = (SELECT (
									SELECT @errorCode AS '@errorCode', @errorString AS '@errorString'
									FOR XML PATH('response'), TYPE)
							FOR XML PATH('App_UpdateSyncWebFolderResp'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncUpdateConfig')
	delete from GxQscripts where name = 'AppSyncUpdateConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncUpdateConfig')
	delete from GXDBVersions where aliasname = 'AppSyncUpdateConfig'
GO

insert into GXDBVersions values(2, 'AppSyncUpdateConfig',  '00000000000000000000', 'AppSyncUpdateConfig', '00000000000000000000')
GO

