

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncSetClientUserProfile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSyncSetClientUserProfile.sp,v $ $Id: AppSyncSetClientUserProfile.sp,v 1.4.86.4 2018/03/27 08:19:47 jiechen Exp $";
--	+===================================================================+
--	|  					  AppSyncSetClientUserProfile							|
--	|          Procedure for mapping client user profile to galaxy user				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncSetClientUserProfile <<<'

IF EXISTS (select * from sysobjects where name='AppSyncSetClientUserProfile')
	drop procedure AppSyncSetClientUserProfile
IF EXISTS (select * from GxQscripts where name='AppSyncSetClientUserProfile')
	delete from GxQscripts where name = 'AppSyncSetClientUserProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncSetClientUserProfile')
	delete from GXDBVersions where aliasname = 'AppSyncSetClientUserProfile'
GO
print '... Creating Procedure: AppSyncSetClientUserProfile'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncSetClientUserProfile
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
    DECLARE @opEvMsgId          INT = 0
    DECLARE @dataIsEvent        INT = 0
    DECLARE @opMsgId            INT = 0
	DECLARE @opId				INT = 0
	DECLARE @paramMsgId			INT = 0
	DECLARE @oldUserProfName	NVARCHAR(MAX) = ''
	DECLARE @clientName			NVARCHAR(MAX) = ''
	DECLARE @clientId			INT = ISNULL (( SELECT ref.value('@clientId', 'INT')
														FROM @i_xmlString.nodes ('App_SetClientUserProfileReq/client') R(ref)), '0')
	-- Read the XML
	DECLARE @localUserProfile	NVARCHAR(MAX)	= ISNULL (( SELECT ref.value('@localUserProfile', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_SetClientUserProfileReq/userProfileMap') R(ref)), '')
	DECLARE @registeredUserId	INT				= ISNULL (( SELECT ref.value('@userId', 'INT')
														FROM @i_xmlString.nodes ('App_SetClientUserProfileReq/userProfileMap/registeredUser') R(ref)), 0)
	IF (@clientId = 0 OR @registeredUserId = 0 OR LEN(@localUserProfile) = 0)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid Input'
		GOTO ERROR_EXIT
	END
	-- Reset the previous mapping for the client
	--UPDATE UMClientUserMap
	--SET umUserId = 0
	--WHERE clientId = @clientId
	SET @oldUserProfName = ISNULL((SELECT TOP 1 localUserLogin FROM UMClientUserMap WHERE clientId = @clientId AND umUserId = @registeredUserId), '')
	IF EXISTS(SELECT 1 FROM UMClientUserMap WHERE clientId = @clientId AND umUserId = @registeredUserId)
	BEGIN
		UPDATE UMClientUserMap
		SET umUserId = 0, modified = @nowTime
		WHERE clientId = @clientId AND umUserId = @registeredUserId
	END
	IF EXISTS(SELECT 1 FROM UMClientUserMap WHERE clientId = @clientId AND localUserLogin = @localUserProfile AND umUserId = 0)
	BEGIN
		UPDATE UMClientUserMap
		SET umUserId = @registeredUserId, modified = @nowTime
		WHERE clientId = @clientId AND localUserLogin = @localUserProfile AND umUserId = 0
	END
	ELSE
	BEGIN
		INSERT INTO UMClientUserMap(umUserId,clientId,localUserLogin,modified)
		VALUES(@registeredUserId,@clientId,@localUserProfile,@nowTime)
	END
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR_EXIT
	-- This is to delete all redundant user profiles
	DELETE FROM UMClientUserMap WHERE localUserLogin IN (
	SELECT localUserLogin FROM UMClientUserMap WHERE clientId = @clientId GROUP BY localUserLogin HAVING COUNT(*) > 1) AND umUserId = 0 AND clientId = @clientId
	SET @clientName = ISNULL((SELECT name FROM App_Client WITH (NOLOCK) WHERE id = @clientId), '')
	IF @oldUserProfName = ''
	BEGIN	--DO AUDIT TRAIL FOR ADD
		-- SET GUI AUDIT OPERATION
SET @opMsgId = (383 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
        -- SET GUI AUDIT PARAMETER
        EXEC EvGuiAuditSetParamData @opId, @localUserProfile, @dataIsEvent
        EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
SET @paramMsgId = (1053 | (CAST(POWER(2, 24) AS BIGINT) * 85))
        EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
	END
	ELSE
	BEGIN	--DO AUDIT TRAIL FOR UPDATE
		-- SET GUI AUDIT OPERATION
SET @opMsgId = (383 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
        -- SET GUI AUDIT PARAMETER
        EXEC EvGuiAuditSetParamData @opId, @oldUserProfName, @dataIsEvent
        EXEC EvGuiAuditSetParamData @opId, @localUserProfile, @dataIsEvent
        EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
SET @paramMsgId = (1054 | (CAST(POWER(2, 24) AS BIGINT) * 85))
        EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
	END
ERROR_EXIT:
		SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString'
								FOR XML PATH('App_GenericResp'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncSetClientUserProfile')
	delete from GxQscripts where name = 'AppSyncSetClientUserProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncSetClientUserProfile')
	delete from GXDBVersions where aliasname = 'AppSyncSetClientUserProfile'
GO

insert into GXDBVersions values(2, 'AppSyncSetClientUserProfile',  '00010004008600040000', 'AppSyncSetClientUserProfile', '00010004008600040000')
GO

