

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncResume.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+=======================================================================+
--	|  							AppSyncResume								|
--	|  Procedure to resume the sync configuration at client or folder level	|
--	+=======================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncResume <<<'

IF EXISTS (select * from sysobjects where name='AppSyncResume')
	drop procedure AppSyncResume
IF EXISTS (select * from GxQscripts where name='AppSyncResume')
	delete from GxQscripts where name = 'AppSyncResume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncResume')
	delete from GXDBVersions where aliasname = 'AppSyncResume'
GO
print '... Creating Procedure: AppSyncResume'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncResume
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	  SET @o_xmlString = ''
      DECLARE @errorCode                  INT = 0
      DECLARE @errorString          NVARCHAR(MAX) = ''
      DECLARE @nowTime              INT = dbo.GetUnixTime (GetUTCdate())
      DECLARE @templateTbl          TABLE
      (syncWebFolderId INT, templateXML XML)
      DECLARE @oscClientTbl         TABLE (clientId INT, subclientId INT)
      -- Read the XML
      DECLARE @inClientId                       INT                     = ISNULL (( SELECT ref.value('@clientId', 'INT')
                                                                                    FROM @i_xmlString.nodes ('App_ResumeSyncReq/client') R(ref)), 0)
      DECLARE @inSyncWebFolderId          INT               = ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
                                                                                    FROM @i_xmlString.nodes ('App_ResumeSyncReq/syncWebFolder') R(ref)), 0)
	  DECLARE @isEdgeDrive		  INT = 0
      IF @inSyncWebFolderId > 0 AND NOT EXISTS(SELECT 1 FROM App_SyncCloudFolder WITH (NOLOCK) WHERE syncWebFolderId = @inSyncWebFolderId)
      BEGIN
            SET @errorCode = 1
            SET @errorString = 'Error : Invalid Web Folder Info in Resume Request.'
            GOTO ERROR_EXIT
      END
      ELSE IF @inSyncWebFolderId < 0
      BEGIN
            INSERT INTO @templateTbl
            SELECT 0, value FROM GXGlobalParam
            WHERE name = 'Sync Folder Template'
            AND modified=0
            UPDATE @templateTbl
            SET syncWebFolderId = templateXML.value('data(/syncInfos/syncWebFolder/@syncWebFolderId)[1]', 'INT')
            IF NOT EXISTS (SELECT 1 FROM @templateTbl WHERE syncWebFolderId = @inSyncWebFolderId)
            BEGIN
                  SET @errorCode = 2
                  SET @errorString = 'Error : Invalid Web Folder Info in Resume Request.'
                  GOTO ERROR_EXIT
            END
      END
      -- Template Sync folder is being resumed, create the real folder.
      IF @inSyncWebFolderId < 0
      BEGIN
            DECLARE @templateXML                      XML
            DECLARE @templateSyncWebFolderName  NVARCHAR(MAX)
            DECLARE @templateDescription        NVARCHAR(MAX)
            DECLARE @templateSyncType                 INT
            DECLARE @templateSyncPath                 NVARCHAR(MAX)
            DECLARE @tmpSyncPath                      NVARCHAR(MAX)
            DECLARE @templateClientFlag               INT
            DECLARE @templateFlag                     INT
            DECLARE @configOptions                    XML
            DECLARE @tempClientId                     INT
            DECLARE @tempSubclientId                  INT
            DECLARE @scFilterFileID                   INT
            DECLARE @clientList TABLE(clientId INT, subclientId INT)
            DECLARE @contentTbl               TABLE
            (subclientId INT, isContentchanged INT)
            DECLARE @workQueueXML         XML
            DECLARE @workQueueParam       NVARCHAR(MAX)
            DECLARE @contentChanged       INT = 0
            DECLARE @workQOutPutTbl       TABLE (errCode INT, errString NVARCHAR(MAX))
            DECLARE @contentOutPutTbl     TABLE (scFilterFileId INT, isContentChanged INT)
           	DECLARE @excludeStatusMask int = (cast(0x00002 as int) | cast(0x00004 as int) | cast(0x00010 as int) | cast(0x00020 as int))
            INSERT @clientList
            SELECT um.clientId, APP.id
            FROM   UMOwnerCredentials um
            INNER JOIN App_Client CL WITH(NOLOCK) ON CL.id = um.clientId AND releaseId > 14 AND CL.status & 4096 = 4096 AND CL.status & @excludeStatusMask = 0 -- Consider only laptop clients
            INNER JOIN APP_IDAName IDA  WITH(NOLOCK)ON IDA.clientId = um.clientId and  ( IDA.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) and IDA.appTypeId <> 13)
            INNER JOIN App_Application APP  WITH(NOLOCK)ON IDA.clientId = APP.clientId AND APP.appTypeId = IDA.appTypeId AND APP.subclientStatus & 8 <> 0
            INNER JOIN App_BackupSetName BSET  WITH(NOLOCK)ON APP.backupSet = BSET.id AND BSET.status & 8 <> 0
            WHERE um.userId = @i_userId
            -- Form the web folders detail from the GxGlobalParam table for this user.
            SET @templateXML = (SELECT templateXML FROM @templateTbl WHERE syncWebFolderId = @inSyncWebFolderId)
            -- Get All details from template
            SET @templateSyncWebFolderName            = ISNULL((SELECT ref.value('@syncWebFolderName', 'NVARCHAR(MAX)')
                                                                        FROM  @templateXML.nodes ('syncInfos/syncWebFolder') R(ref)), '')
            SET @templateDescription                  = ISNULL((SELECT ref.value('@description', 'NVARCHAR(MAX)')
                                                                        FROM  @templateXML.nodes ('syncInfos') R(ref)), '')
            SET @templateFlag                         = ISNULL((SELECT ref.value('@flag', 'INT')
                                                                        FROM  @templateXML.nodes ('syncInfos') R(ref)), 3)
            SET @templateSyncType                     = ISNULL((SELECT ref.value('@syncType', 'INT')
                                                                        FROM  @templateXML.nodes ('syncInfos/associatedClients') R(ref)), 0)
            SET @templateSyncPath                     = ISNULL((SELECT ref.value('@syncPath', 'NVARCHAR(MAX)')
                                                                        FROM  @templateXML.nodes ('syncInfos/associatedClients') R(ref)), '')
            SET @templateClientFlag                         = ISNULL((SELECT ref.value('@flag', 'INT')
                                                                        FROM  @templateXML.nodes ('syncInfos/associatedClients') R(ref)), 0)
            BEGIN TRAN
			GENERATE_RETRY:
				SET @inSyncWebFolderId = ABS(CHECKSUM(NEWID())) % 1000000 + 1;
				IF EXISTS (SELECT 1 FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @inSyncWebFolderId)
					GOTO GENERATE_RETRY
            INSERT INTO App_SyncCloudFolder (syncWebFolderName, description, created, modified, flag, ownerId, syncWebFolderId)
            VALUES(@templateSyncWebFolderName, @templateDescription, @nowTime, 0, @templateFlag^1, @i_userId, @inSyncWebFolderId)
            SELECT @errorCode = @@ERROR, @inSyncWebFolderId = @@IDENTITY
            IF @errorCode <> 0 GOTO ERROR
            DECLARE GetUserClients CURSOR
            FOR
                  SELECT clientId, subclientId FROM @clientList
            OPEN  GetUserClients
            FETCH GetUserClients INTO @tempClientId, @tempSubclientId
            WHILE @@FETCH_STATUS = 0
            BEGIN
                  SET @scFilterFileID = 0
                  SET @contentChanged = 0
                  SET @workQueueXML = ''
                  DELETE FROM @workQOutPutTbl
                  DELETE FROM @contentOutPutTbl
--
                  IF dbo.scgGetClientOSType(@tempClientId) = 2  --UNIX
                        SET @tmpSyncPath = REPLACE(@templateSyncPath, '\', '/')
                  ELSE
                        SET @tmpSyncPath = @templateSyncPath
--
                  -- This means it is a source and so check if we need to add backup content.
                  IF @templateSyncType & 1 = 1
                  BEGIN
                        IF NOT EXISTS (SELECT 1 FROM @oscClientTbl WHERE clientId = @tempClientId) -- Not already exists
                        BEGIN
                              INSERT INTO @oscClientTbl
                              VALUES(@tempClientId, @tempSubclientId)
                        END
                        -- Do this only if it not all Content.
                        IF @templateClientFlag & 0x2 = 0
                        BEGIN
                              --INSERT INTO @contentOutPutTbl
                              EXEC AppCheckAndInsertSubclientContent @tempSubclientId, @tmpSyncPath, @i_userId, @i_localeId, @scFilterFileID OUTPUT, @contentChanged OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
					          IF @errorCode <> 0 GOTO ERROR
                              --SELECT @scFilterFileID = scFilterFileId, @contentChanged = isContentChanged, @oldContent = oldContent, @newContent = newContent FROM @contentOutPutTbl
                              --If @contentChanged = 1
                              --BEGIN
                              --    -- Submit Workqueue for subclient content change WORK_TOKEN_SUBCLIENT_CONTENT = 7
                              --    SET @workQueueXML = (SELECT @tempSubclientId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE)
                              --    SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
                              --    INSERT INTO @workQOutPutTbl
                              --    EXEC AppWorkQueueSubmitRequest 7/*WORK_TOKEN_SUBCLIENT_CONTENT*/, 0, 0, @tempClientId, 0, @workQueueParam
                              --    SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
                              --    IF @errorCode <> 0 GOTO ERROR
                              --END
                              INSERT INTO @contentTbl
                              VALUES(@tempSubclientId, @contentChanged)
                        END
                  END
                  INSERT INTO App_SyncCloudConfig(syncWebFolderId, syncPath, clientId, subclientId, syncType, scFilterFileId, created, flag, configOptions)
                  SELECT @inSyncWebFolderId, @tmpSyncPath, @tempClientId, @tempSubclientId, @templateSyncType, @scFilterFileID,  @nowTime, @templateClientFlag, @configOptions
                  SELECT @errorCode = @@ERROR
                  IF @errorCode <> 0 GOTO ERROR
                  FETCH GetUserClients INTO @tempClientId, @tempSubclientId
            END
            CLOSE GetUserClients
            DEALLOCATE GetUserClients
            --
			-- Populate the sync stats table
            INSERT INTO App_SyncCloudStats (syncWebFolderId, destClientId, sourceSubclientId, lastBackupSyncJobId, lastSuccessSyncJobId, currentRestoreJobId, syncStatus)
            SELECT DISTINCT WF.syncWebFolderId, D.clientId, S.subclientId, 0, 0, 0,
            CASE CON.isContentchanged
            WHEN 0 THEN 0 -- If content not changed, then it is already backed up. So syncStatus = 0 ==> NEEDS_RESTORE_AFTER_BACKUP
            WHEN 1 THEN 2 --If content changed, then it is not already backed up. It will be backed up by workflow. So syncStatus = 2 ==> SYNC_SUCCESSFUL
            END
            FROM App_SyncCloudFolder WF
            INNER JOIN App_SyncCloudConfig S ON WF.syncWebFolderId = S.syncWebFolderId AND S.syncType & 1 = 1
            INNER JOIN App_SyncCloudConfig D ON WF.syncWebFolderId = D.syncWebFolderId AND D.syncType & 2 = 2 AND S.syncConfigId <> D.syncConfigId
            INNER JOIN @contentTbl CON ON S.subclientId = CON.subClientId
            LEFT OUTER JOIN App_SyncCloudStats STAT ON S.subclientId = STAT.sourceSubclientId AND D.clientId = STAT.destClientId AND WF.syncWebFolderId = STAT.syncWebFolderId
            WHERE WF.syncWebFolderId = @inSyncWebFolderId
            AND (STAT.sourceSubclientId IS NULL)
--
--
	-- Now insert into componentprop to know that we have to run full restores
	--DELETE FROM @contentTbl WHERE isContentchanged > 0
	--INSERT INTO [CommServ].[dbo].[APP_ComponentProp]
 --          ([componentType]
 --          ,[componentId]
 --          ,[propertyTypeId]
 --          ,[dataType]
 --          ,[longVal]
 --          ,[longlongVal]
 --          ,[stringVal]
 --          ,[created]
 --          ,[modified])
	--SELECT 15 --CV_COMPONENT_TYPE_SYNC_WEB_FOLDER
 --          ,CS.sourceSubclientId
 --          , 2001 --CV_COMPONENT_SYNC_PAIR
 --          ,10 --PROPERTY_ULONG
 --          ,CS.destClientId
 --          ,0
 --          ,''
 --          ,(SELECT DBO.GETUNIXTIME(GETUTCDATE()))
 --          ,0
	--FROM App_SyncCloudStats CS  INNER JOIN
	--	@contentTbl CON ON CON.subclientId = CS.sourceSubclientId AND CS.syncWebFolderId = @inSyncWebFolderId
--
--
            --
			-- Now check if the user already has profile mapped for each client
            UPDATE UMClientUserMap
            SET umUserId = UM.id
            FROM UMClientUserMap UC INNER JOIN UMUsers UM ON UC.localUserLogin = UM.login AND UM.id = @i_userId
            WHERE UC.clientId IN (SELECT clientId FROM App_SyncCloudConfig WHERE syncWebFolderId = @inSyncWebFolderId)
                  AND NOT EXISTS(SELECT * FROM UMClientUserMap WHERE clientId = UC.clientId AND umUserId = @i_userId)
            --
			-- Pause the clients who dont have their user profile set
            UPDATE App_SyncCloudConfig
            SET flag = flag | 0x1
            FROM App_SyncCloudConfig CFG
            WHERE NOT EXISTS
                  (SELECT clientId FROM UMClientUserMap UC WHERE UC.clientId = CFG.clientId AND
                  CFG.syncWebFolderId = @inSyncWebFolderId AND UC.umUserId = @i_userId)
                  AND CFG.syncWebFolderId = @inSyncWebFolderId
            SELECT @errorCode = @@ERROR
            IF @errorCode <> 0 GOTO ERROR
			--
            -- Now send the clients back which dont have a user profile set
            SET @o_xmlString = (SELECT
                                                (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString',
                                                      (SELECT A.clientId AS '@clientId', A.clientName AS '@clientName'
                                                      FOR XML PATH('entity'), TYPE)
                                                FROM (SELECT DISTINCT CFG.clientId clientId,c.name clientName
                                                            FROM App_SyncCloudConfig CFG
                                                            INNER JOIN APP_Client C WITH (READUNCOMMITTED) ON CFG.clientId = C.id
                                                            WHERE CFG.syncWebFolderId = @inSyncWebFolderId
                                                            AND NOT EXISTS ( SELECT 1 FROM UMClientUserMap UC WHERE UC.clientId = CFG.clientId AND umUserId = @i_userId)) A
                                                FOR XML PATH('response'), TYPE),
                                                (SELECT @inSyncWebFolderId AS '@syncWebFolderId'
                                                FOR XML PATH('syncWebFolder'),TYPE)
                                          FOR XML PATH('App_ResumeSyncResp'), TYPE)
ERROR:
      IF @errorCode <> 0
            ROLLBACK TRAN
      ELSE
      BEGIN
            COMMIT TRAN
            --GOTO PROC_EXIT
      END
      END
      -- Real Sync Folder is being resumed
      ELSE
      BEGIN
SET @isEdgeDrive = ISNULL((SELECT 1 FROM App_SyncCloudFolder WITH (NOLOCK) WHERE syncWebFolderId = @inSyncWebFolderId AND flag & 0x10 = 0x10), 0)
            -- Client level Resume request
            IF @inClientId > 0
            BEGIN
                  IF NOT EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK)
                                       WHERE syncWebFolderId = @inSyncWebFolderId AND clientId = @inClientId)
                  BEGIN
                        SET @errorCode = 2
                        SET @errorString = 'Error : Invalid Client Info Client level Resume Request.'
                        GOTO ERROR_EXIT
                  END
                  DECLARE @tempSubID INT = 0
                  SELECT @tempSubID = subclientId FROM App_SyncCloudConfig WITH (NOLOCK)
                  WHERE syncWebFolderId = @inSyncWebFolderId AND clientId = @inClientId
                  -- Mark the client as not-paused
                  UPDATE App_SyncCloudConfig
                  SET flag = flag ^ 0x1
                  WHERE syncWebFolderId = @inSyncWebFolderId AND clientId = @inClientId
                  AND flag & 0x1 <> 0
                  SELECT @errorCode = @@ERROR
                  IF @errorCode <> 0 GOTO ERROR_EXIT
                  -- Mark the sync status as 0 If any restore is needed
                  -- Do not touch the sync Status as backup needs to be kicked off
                  --UPDATE App_SyncCloudStats
                  --SET syncStatus = 0
                  --WHERE syncWebFolderId = @inSyncWebFolderId
                  --AND (destClientId = @inClientId OR sourceSubClientId = @tempSubID)
                  --AND lastSuccessSyncJobId < (SELECT MAX(jobId) FROM JMBkpStats WITH (NOLOCK)
                  --                                        WHERE appId = sourceSubClientId AND status IN (1,3,14))
                  --SELECT @errorCode = @@ERROR
                  --IF @errorCode <> 0 GOTO ERROR_EXIT
                  -- Send workqueue tokens for these clients to kick off backup else sync content will not get modified
                  IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WHERE syncWebFolderId = @inSyncWebFolderId AND clientId = @inClientId AND syncType & 1 = 1) -- Client is a source
                          AND NOT EXISTS (SELECT 1 FROM @oscClientTbl WHERE clientId = @inClientId) -- Not already exists
                  BEGIN
                        INSERT INTO @oscClientTbl
                        VALUES(@inClientId, ISNULL((SELECT subclientId FROM App_SyncCloudConfig WHERE syncWebFolderId = @inSyncWebFolderId AND clientId = @inClientId AND syncType & 1 = 1 ),0))
                  END
            END
            -- Sync Folder level Pause request
            ELSE
            BEGIN
                  -- Mark the sync folder as not-paused
                  UPDATE App_SyncCloudFolder
                  SET flag = flag ^ 0x1
                  WHERE syncWebFolderId = @inSyncWebFolderId
                  AND flag & 0x1 <> 0
                  AND EXISTS -- ADD USER CHECK FOR SMART CONTENT FOLDERS
                  (SELECT 1 FROM UMClientUserMap UC
                  JOIN App_SyncCloudConfig CFG ON CFG.clientId = UC.clientId
                        WHERE UC.clientId = CFG.clientId AND
                        syncWebFolderId = @inSyncWebFolderId AND UC.umUserId = ownerId
                  )
                  SELECT @errorCode = @@ERROR
                  IF @errorCode <> 0 GOTO ERROR_EXIT
                  -- Mark the sync status as 0 If any restore is needed
                  -- Do not touch the sync Status as backup needs to be kicked off
                  --UPDATE App_SyncCloudStats
                  --SET syncStatus = 0
                  --WHERE syncWebFolderId = @inSyncWebFolderId
                  --AND lastSuccessSyncJobId < (SELECT MAX(jobId) FROM JMBkpStats WITH (NOLOCK)
                  --                                        WHERE appId = sourceSubClientId AND status IN (1,3,14))
                  --AND EXISTS -- ADD USER CHECK FOR SMART CONTENT FOLDERS
                  --(SELECT 1 FROM UMClientUserMap UC
                  --JOIN App_SyncCloudConfig CFG ON CFG.clientId = UC.clientId
                  --JOIN App_SyncCloudFolder CF ON CF.syncWebFolderId = CFG.syncWebFolderId
                  --    WHERE UC.clientId = CFG.clientId AND
                  --    CF.syncWebFolderId = @inSyncWebFolderId AND UC.umUserId = CF.ownerId
                  --)
                  --SELECT @errorCode = @@ERROR
                  --IF @errorCode <> 0 GOTO ERROR_EXIT
                  -- Un-pause all the clients under this folder
                  UPDATE App_SyncCloudConfig
				  SET flag = flag ^ 0x1
				  WHERE syncWebFolderId = @inSyncWebFolderId
                  -- Send subclient changed worktoken for all source clients so that backup can start
                  INSERT INTO @oscClientTbl
                  SELECT clientId,subclientId
                  FROM App_SyncCloudConfig
                  WHERE syncWebFolderId = @inSyncWebFolderId
                        AND syncType & 1 = 1
                  --SEND CLIENTS WITH NO USER MAP WHEN RESUMING
                  SET @o_xmlString = (SELECT
                                                (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString',
                                                      (SELECT A.clientId AS '@clientId', A.clientName AS '@clientName'
                                                      FOR XML PATH('entity'), TYPE)
                                                FROM (SELECT DISTINCT CFG.clientId clientId,c.name clientName
                                                            FROM App_SyncCloudConfig CFG
                                                            INNER JOIN APP_Client C WITH (READUNCOMMITTED) ON CFG.clientId = C.id
                                                            WHERE CFG.syncWebFolderId = @inSyncWebFolderId
                                                            AND NOT EXISTS ( SELECT 1 FROM UMClientUserMap UC WHERE UC.clientId = CFG.clientId AND umUserId = @i_userId)) A
                                                FOR XML PATH('response'), TYPE),
                                                (SELECT @inSyncWebFolderId AS '@syncWebFolderId'
                                                FOR XML PATH('syncWebFolder'),TYPE)
                                          FOR XML PATH('App_ResumeSyncResp'), TYPE)
                  --CONTENT HAS NOT CHANGED, NO NEED TO PUSH OSC TO CLIENT
                  -- GOTO PROC_EXIT
            END
      END
-- Push OSC for the required clients
DECLARE @oscClientId INT = 0
DECLARE @oscSubClientId INT = 0
DECLARE GetOSCClients CURSOR
FOR SELECT clientId, subclientId FROM @oscClientTbl
OPEN GetOSCClients
FETCH GetOSCClients INTO @oscClientId, @oscSubClientId
WHILE @@FETCH_STATUS = 0
BEGIN
      DELETE FROM @workQOutPutTbl
--
	  IF @isEdgeDrive = 0
	  BEGIN
		  -- Submit Workqueue for subclient content change WORK_TOKEN_SUBCLIENT_CONTENT = 7
		  SET @workQueueXML = (SELECT @oscSubClientId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE)
		  SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
--
		  INSERT INTO @workQOutPutTbl
		  EXEC AppWorkQueueSubmitRequest 7/*WORK_TOKEN_SUBCLIENT_CONTENT*/, 0, 0, @oscClientId, 0, @workQueueParam
		  SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
--
		  IF @errorCode <> 0
		  BEGIN
				CLOSE GetOSCClients
				DEALLOCATE GetOSCClients
				GOTO ERROR_EXIT
		  END
		  DELETE FROM @workQOutPutTbl
	--
		  INSERT INTO @workQOutPutTbl
		  EXEC AppWorkQueueSubmitRequest 4/*WORK_TOKEN_OSC,*/, 0, 0, @oscClientId, 0, ''
	--
		  SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
	--
		  IF @errorCode <> 0
			BEGIN
				CLOSE GetOSCClients
				DEALLOCATE GetOSCClients
				GOTO ERROR
			END
	--
	  END
	  ELSE
	  BEGIN
        DELETE FROM @workQOutPutTbl
        SET @workQueueXML = (   SELECT 2 AS '@status',	--SYNC_PENDING
                                        (
                                        SELECT @oscClientId AS '@clientId',
                                        @oscSubClientId AS '@subclientId'
                                        FOR XML PATH('subclient'), TYPE
                                        ),
                                        (
                                        SELECT @inSyncWebFolderId AS '@syncWebFolderId'
                                        FOR XML PATH('syncFolder'), TYPE
                                        )
                                FOR XML PATH('TMMsg_SyncConfigWorkQueueReq'), TYPE
                            )
		  SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
		  INSERT INTO @workQOutPutTbl
		  EXEC AppWorkQueueSubmitRequest 17/*WORK_TOKEN_SYNC_RESTORE_CONFIG*/, 0, 0, @oscClientId, 0, @workQueueParam
		  SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
--
		  IF @errorCode <> 0
		  BEGIN
				CLOSE GetOSCClients
				DEALLOCATE GetOSCClients
				GOTO ERROR_EXIT
		  END
	  END
      FETCH GetOSCClients INTO @oscClientId, @oscSubClientId
END
CLOSE GetOSCClients
DEALLOCATE GetOSCClients
ERROR_EXIT:
      IF LEN(ISNULL((CAST(@o_xmlString AS NVARCHAR(MAX))),'')) = 0
      BEGIN
      SET @o_xmlString = (SELECT
                                                    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString'
                                                      FOR XML PATH('response'), TYPE),
                                                      (SELECT @inSyncWebFolderId AS '@syncWebFolderId'
                                                      FOR XML PATH('syncWebFolder'),TYPE)
                                          FOR XML PATH('App_ResumeSyncResp'), TYPE)
	  END
PROC_EXIT:
      SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncResume')
	delete from GxQscripts where name = 'AppSyncResume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncResume')
	delete from GXDBVersions where aliasname = 'AppSyncResume'
GO

insert into GXDBVersions values(2, 'AppSyncResume',  '00000000000000000000', 'AppSyncResume', '00000000000000000000')
GO

