

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncReplicationGroup.sp] ---------- 

--  +=============================================================================================+
--  |                       Name: AppSyncReplicationGroup()
--  | Description: Syncs replicationGroup table with taskinfo(periodic replication) or blrpair(continuous replication)
--  |
--  |       Input: taskId, blrPairId, operation
--  |      Output: errorCode
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSyncReplicationGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppSyncReplicationGroup <<<'
	drop procedure AppSyncReplicationGroup
END
IF EXISTS (select * from GxQscripts where name='AppSyncReplicationGroup')
	delete from GxQscripts where name = 'AppSyncReplicationGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncReplicationGroup')
	delete from GXDBVersions where aliasname = 'AppSyncReplicationGroup'
GO
print '... Creating Procedure: AppSyncReplicationGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncReplicationGroup
  @repGroupId INT,
  @taskId INT,
  @blrPairsXML XML,
  @replicationGroupName NVARCHAR(MAX),
  @planId INT,
  @operation INT,
  @repGroupXML XML OUTPUT
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @replicationGroupId INT = @repGroupId
	DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	--Modify replication group name with operation 2(modify)
	IF(@replicationGroupId <> 0 AND @replicationGroupName <> '' AND @operation = 2)
	BEGIN
		IF EXISTS(SELECT 1 FROM App_ReplicationGroup WHERE name = @replicationGroupName)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Duplicate Replication group name not allowed'
			GOTO PROC_EXIT
		END
		UPDATE App_ReplicationGroup SET name = @replicationGroupName WHERE id = @repGroupId
		GOTO PROC_EXIT
	END
	-- Syncing for periodic replication
	IF(@taskId <> 0)
	BEGIN
		IF(@operation = 1) -- CREATE TASK REQ
		BEGIN
			-- type -> '1' implies its periodic replication
			INSERT INTO App_ReplicationGroup(name,type,status)
				SELECT @replicationGroupName, 1, CONVERT(INT,TM.disabled) FROM TM_Task TM WITH(NOLOCK) WHERE taskId = @taskId
			SET @replicationGroupId = SCOPE_IDENTITY()
			INSERT INTO App_ReplicationGroupAssociation(componentNameId,taskId,blrPairId)
				VALUES (@replicationGroupId, @taskId, NULL)
			-- Inserting associated planId for periodic groups as well.
			INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)
VALUES (@replicationGroupId, 'Associated Plan', 7, @planId, '',@currentTime, 0 )
		END
		ELSE
		BEGIN
			SET @errorCode = 2;
			SET @errorString = 'Incorrect operation type provided. Please check input';
		END
	END
	-- Syncing for continuous replication
	ELSE
	BEGIN
		IF(@operation = 1) -- CREATE BLR PAIR
		BEGIN
			-- Type = 2 indicates DRReplicationType - Continuous
			INSERT INTO App_ReplicationGroup(name,type,status)
				VALUES(@replicationGroupName, 2, 0)
			SET @replicationGroupId = SCOPE_IDENTITY()
			INSERT INTO App_ReplicationGroupAssociation(componentNameId,taskId,blrPairId)
				SELECT @replicationGroupId, NULL, id FROM BlrPair WITH(NOLOCK) WHERE srcName IN
					(SELECT ref.value('@name', 'NVARCHAR(255)') FROM @blrPairsXML.nodes('TMMsg_DiskLevelVMRestoreOption/advancedRestoreOptions') R(ref) )
			INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT subClientId, 'Associated Plan', 7, @planId, @currentTime, 0
					FROM BlrPair WITH(NOLOCK) WHERE srcName IN
					(SELECT ref.value('@name', 'NVARCHAR(255)') FROM @blrPairsXML.nodes('TMMsg_DiskLevelVMRestoreOption/advancedRestoreOptions') R(ref) )
			-- Store the pair taskinfo for the first time the replicationgroup is created. This is used as template when vms are added or removed from this replication group
IF NOT EXISTS(SELECT 1 FROM App_ReplicationGroupProp WITH(NOLOCK) WHERE componentNameId = @replicationGroupId AND attrName = 'Virtual Server Block Level Replication Restore XML')
			BEGIN
				DECLARE @taskInfo nvarchar(max)
				DECLARE @taskInfoXML XML
				DECLARE @blrRecovertyOpts XML
				SELECT TOP 1 @taskInfo = attrVal FROM App_SubclientProp SUB WITH(NOLOCK) JOIN BlrPair BLR WITH(NOLOCK) ON SUB.componentNameId = BLR.subClientId
					JOIN @blrPairsXML.nodes('TMMsg_DiskLevelVMRestoreOption/advancedRestoreOptions') R(ref) ON ref.value('@name','NVARCHAR(255)') = BLR.srcName
WHERE SUB.attrName = 'Virtual Server Block Level Replication Restore XML' AND SUB.cs_attrName = CheckSum(N'Virtual Server Block Level Replication Restore XML') AND SUB.modified = 0
				DECLARE @startTag INT = CHARINDEX( '<',@taskInfo,1)
				DECLARE @startEncodeTag INT = CHARINDEX( '?xml',@taskInfo,1)
				IF (@startEncodeTag = (@startTag)+1)
				BEGIN
					SET @taskInfoXML  =(SELECT CONVERT(XML,SUBSTRING(@taskInfo,CHARINDEX('?>',@taskInfo,1)+2,LEN(@taskInfo)),2))
				END
				ELSE
				BEGIN
					SET @taskInfoXML  = (SELECT CONVERT(XML,@taskInfo))
				END
				SET @blrRecovertyOpts = (SELECT @taskInfoXML.query('/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/defaultRestoreSettings/blrRecoveryOpts'))
				--Update replication group properties table.
				INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)
VALUES(@replicationGroupId, 'Virtual Server Block Level Replication Restore XML', 1 , '', @taskInfoXML, @currentTime, 0),
(@replicationGroupId, 'Associated Plan', 7, @planId, '',@currentTime, 0 ),
(@replicationGroupId, 'BLR recovery options', 1, '', @blrRecovertyOpts, @currentTime, 0)
			END
		END
		ELSE IF(@operation = 2 AND @replicationGroupId <> 0) -- MODIFY REP GROUP BY ADDING/REMOVING BLR PAIR
		BEGIN
			INSERT INTO App_ReplicationGroupAssociation(componentNameId,taskId,blrPairId)
				SELECT @replicationGroupId, NULL, id FROM BlrPair WITH(NOLOCK) WHERE srcName IN
					(SELECT ref.value('@name', 'NVARCHAR(255)') FROM @blrPairsXML.nodes('TMMsg_DiskLevelVMRestoreOption/advancedRestoreOptions') R(ref) )
			INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT subClientId, 'Associated Plan', 7, @planId, @currentTime, 0
					FROM BlrPair WITH(NOLOCK) WHERE srcName IN
					(SELECT ref.value('@name', 'NVARCHAR(255)') FROM @blrPairsXML.nodes('TMMsg_DiskLevelVMRestoreOption/advancedRestoreOptions') R(ref) )
		END
		ELSE
		BEGIN
			SET @errorCode = 2;
			SET @errorString = 'Incorrect operation type provided. Please check input';
			GOTO PROC_EXIT
		END
	END
	-- HIDE THE STORAGE POLICY AUTOMATICALLY CREATED FOR THIS REPLICATION GROUP
	UPDATE archGroup
SET flags = flags | 64
WHERE id = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @planId AND attrName = 'Storage policy')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
END CATCH
PROC_EXIT:
	IF(@errorCode = 0)
	BEGIN
		SET @repGroupXML = (SELECT @replicationGroupId AS N'@replicationGroupId'
						FOR XML PATH(N'CvEntities_ReplicationGroupEntity'), TYPE);
	END
	ELSE
	BEGIN
		SET @repGroupXML = (SELECT @errorCode AS N'@errorCode', @errorString AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
	END
    SELECT @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncReplicationGroup')
	delete from GxQscripts where name = 'AppSyncReplicationGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncReplicationGroup')
	delete from GXDBVersions where aliasname = 'AppSyncReplicationGroup'
GO

insert into GXDBVersions values(2, 'AppSyncReplicationGroup',  '00000000000000000000', 'AppSyncReplicationGroup', '00000000000000000000')
GO

