

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncProcessSyncJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSyncProcessSyncJob.sp,v $ $Id: AppSyncProcessSyncJob.sp,v 1.14 2014/01/27 22:36:53 gpattabiraman Exp $";
---- =============================================
---- Author:		Sergio Bonilla
---- Create date:	03/10/2012
---- Description:	Get the information to start a Sync job.
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncProcessSyncJob <<<'

IF EXISTS (select * from sysobjects where name='AppSyncProcessSyncJob')
	drop procedure AppSyncProcessSyncJob
IF EXISTS (select * from GxQscripts where name='AppSyncProcessSyncJob')
	delete from GxQscripts where name = 'AppSyncProcessSyncJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncProcessSyncJob')
	delete from GXDBVersions where aliasname = 'AppSyncProcessSyncJob'
GO
print '... Creating Procedure: AppSyncProcessSyncJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncProcessSyncJob
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_sourceSubclientId integer,
  @i_destClientId integer,
  @i_syncWebFolders nvarchar(max),
  @i_jobId BIGINT,
  @i_restoreToTime INT,
  @i_syncStatus INT
AS
  DECLARE @o_syncStatus INT
SET NOCOUNT ON
BEGIN
DECLARE @syncFolders TABLE
(syncFolderId INT)
SET @o_syncStatus = 0
IF @i_sourceSubclientId= 0 AND @i_destClientId = 0 AND @i_syncWebFolders = '' AND @i_jobId = 0 AND @i_restoreToTime = 0 AND @i_syncStatus = -1
BEGIN
	DECLARE @now	 INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @maxRetryCount INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='maximunNumberToRetryFailedSyncJobs'), 5)
	DECLARE @completedSyncTbl TABLE (syncStatId int, jobId int, jobStatus int, destClientId int, syncWebFolderId int, restoreJobId int)
--
	INSERT INTO @completedSyncTbl
	SELECT STAT.syncStatId, JM.jobId, JM.status, STAT.destClientId, STAT.syncWebFolderId, STAT.currentRestoreJobId
	FROM App_SyncCloudStats STAT
		INNER JOIN JMRestoreStats JM WITH (NOLOCK) ON STAT.currentRestoreJobId = JM.jobId AND STAT.currentRestoreJobId <> 0 AND JM.commCellId = 2
	-- Restore jobs that failed with "Nothing to restore" errors should be considered as success
	UPDATE @completedSyncTbl
	SET jobStatus = 1 --SUCCESS
	FROM @completedSyncTbl COMP
	INNER JOIN JMRestoreStats RST WITH (NOLOCK) ON COMP.jobId = RST.jobId AND RST.commCellId = 2
		AND RST.status = 2 -- Failed jobs
		AND failureReason <> '' -- Jobs with failure reason
	INNER JOIN JMFailureReasonMsg MSG WITH (NOLOCK) ON MSG.id = CAST(SUBSTRING(RST.failureReason, 0, CHARINDEX(',', failureReason, 0)) AS INT)
		AND MSG.messageId IN(402653247, 402653248) -- There was nothing to restore - item(s) not found or not backed up.
--
	UPDATE App_SyncCloudConfig
      SET lastRestoreSyncJobId = COMP.restoreJobId
      FROM @completedSyncTbl COMP, App_SyncCloudConfig CF, App_SyncCloudStats STAT
      WHERE COMP.jobStatus IN (1 /*JMSUCCESS*/) --, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
      AND CF.clientId = COMP.destClientId AND COMP.syncWebFolderId = CF.syncWebFolderId
      AND STAT.syncWebFolderId = CF.syncWebFolderId
      AND STAT.syncStatId = COMP.syncStatId
--
-- Now delete the entry so that we dont fire full restores again
	--DELETE APP_ComponentProp
	--FROM App_SyncCloudStats STAT
	--	INNER JOIN @completedSyncTbl COMP ON STAT.syncStatId = COMP.syncStatId
	--WHERE componentType = 15 --CV_COMPONENT_TYPE_SYNC_WEB_FOLDER
	--AND componentId = STAT.sourceSubclientId
	--AND propertyTypeId = 2001 --CV_COMPONENT_SYNC_PAIR
	--AND longVal = STAT.destClientId
	--AND COMP.jobStatus IN (1 /*JMSUCCESS*/) --, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
--
	UPDATE App_SyncCloudStats
	SET lastSuccessSyncJobId = lastBackupSyncJobId, lastBackupSyncJobId = 0, currentRestoreJobId = 0, retryCount = 0
	FROM App_SyncCloudStats STAT INNER JOIN @completedSyncTbl COMP ON STAT.syncStatId = COMP.syncStatId AND COMP.jobStatus IN (1 /*JMSUCCESS*/)--, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
--
	UPDATE App_SyncCloudStats
	SET syncStatus = 2 --SYNC_SUCCESSFUL
	FROM App_SyncCloudStats STAT INNER JOIN @completedSyncTbl COMP ON STAT.syncStatId = COMP.syncStatId AND COMP.jobStatus IN (1 /*JMSUCCESS*/)--, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
	AND STAT.syncStatus = 1 --SYNC_INPROGRESS
--
	UPDATE App_SyncCloudStats
	SET lastBackupSyncJobId = 0, currentRestoreJobId = 0, syncStatus = 0 /*NEEDS_SYNC*/
	FROM App_SyncCloudStats STAT INNER JOIN @completedSyncTbl COMP ON STAT.syncStatId = COMP.syncStatId AND COMP.jobStatus NOT IN (1 /*JMSUCCESS*/) --, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
	UPDATE App_SyncCloudStats
	SET syncStatus = 2 /*SYNC_SUCCESSFUL*/
	FROM App_SyncCloudStats STAT INNER JOIN @completedSyncTbl COMP ON STAT.syncStatId = COMP.syncStatId AND COMP.jobStatus NOT IN (1 /*JMSUCCESS*/) --, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
	AND STAT.retryCount > @maxRetryCount
--
	UPDATE App_SyncCloudStats
	SET syncStatus = 2 --SYNC_SUCCESSFUL
	FROM App_SyncCloudStats STAT
	LEFT OUTER JOIN JMBkpStats BKP WITH (NOLOCK) ON STAT.sourceSubclientId = BKP.appId AND BKP.status IN (1 /*JMSUCCESS*/) --, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
	WHERE STAT.syncStatus = 0 /*NEEDS_SYNC*/ AND BKP.jobId IS NULL
--
	UPDATE App_SyncCloudStats
	SET syncStatus = 0, retryCount = 0 --RESET RETRY COUNT AFTER 24 HOURS
	FROM App_SyncCloudStats STAT
	INNER JOIN App_SyncCloudConfig CF WITH (NOLOCK) ON STAT.syncWebFolderId = CF.syncWebFolderId
	LEFT OUTER JOIN JMRestoreStats JR WITH (NOLOCK) ON JR.jobId = CF.lastRestoreSyncJobId
	WHERE STAT.syncStatus = 2 /*SYNC_SUCCESSFUL*/
	AND (@now > ISNULL((JR.servEndTime),0) + 24*60*60) AND STAT.retryCount = @maxRetryCount
END
ELSE IF @i_syncStatus > -1
BEGIN
	-- Get list of sync folders first
	INSERT INTO @syncFolders
	SELECT _ID FROM dbo.SplitIDs(@i_syncWebFolders)
	-- First set the sync status to 2 for all the pairs for this combination and sync folders
	UPDATE App_SyncCloudStats
	SET syncStatus = 2 /*SYNC_COMPLETE*/
	FROM App_SyncCloudStats STAT
	WHERE sourceSubclientId = @i_sourceSubClientId
	AND destClientId =  @i_destClientId
	AND syncStatus = 0 /*NEEDS_SYNC*/
	AND syncWebFolderId IN (SELECT syncFolderId FROM @syncFolders)
	UPDATE App_SyncCloudStats
	SET syncStatus = @i_syncStatus
	FROM App_SyncCloudStats STAT
	WHERE sourceSubclientId = @i_sourceSubClientId
	AND destClientId =  @i_destClientId
	AND syncWebFolderId IN (SELECT syncFolderId FROM @syncFolders)
	AND syncStatus = 2 /*SYNC_COMPLETE*/
	AND EXISTS(SELECT 1 FROM App_SyncCloudFolder CF WHERE flag & 1 = 0 AND CF.syncWebFolderId = STAT.syncWebFolderId) -- Unpaused folders
	--AND EXISTS(SELECT 1 FROM App_SyncCloudConfig S WHERE flag & 1 = 0 AND S.subclientId = STAT.sourceSubClientId AND S.syncWebFolderId = STAT.syncWebFolderId) --Unpaused source clients
	AND EXISTS(SELECT 1 FROM App_SyncCloudConfig D WHERE flag & 1 = 0 AND D.clientId = STAT.destClientId AND D.syncWebFolderId = STAT.syncWebFolderId) -- Unpaused dest clients
END
ELSE
BEGIN
		DECLARE @lastBackupJobId BIGINT = ISNULL((SELECT MAX(jobId)
										   FROM JMBkpStats
										   WHERE appId = @i_sourceSubclientId
										   and servEndDate <= @i_restoreToTime and status IN (1 /*JMSUCCESS*/) --, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
										   AND totalNumOfFiles > 0), 0)
		-- Get list of sync folders first
		INSERT INTO @syncFolders
		SELECT _ID FROM dbo.SplitIDs(@i_syncWebFolders)
		UPDATE App_SyncCloudStats
		SET lastBackupSyncJobId = @lastBackupJobId,
			currentRestoreJobId = @i_jobId,
			retryCount = retryCount + 1
		FROM App_SyncCloudStats STAT
		WHERE sourceSubClientId = @i_sourceSubClientId
		AND destClientId = @i_destClientId
		AND syncWebFolderId IN (SELECT syncFolderId FROM @syncFolders)
		AND syncStatus = 1 --SYNC_INPROGRESS
		AND EXISTS(SELECT 1 FROM App_SyncCloudFolder CF WHERE flag & 1 = 0 AND CF.syncWebFolderId = STAT.syncWebFolderId) -- Unpaused folders
		--AND EXISTS(SELECT 1 FROM App_SyncCloudConfig S WHERE flag & 1 = 0 AND S.subclientId = STAT.sourceSubClientId AND S.syncWebFolderId = STAT.syncWebFolderId) --Unpaused source clients
		AND EXISTS(SELECT 1 FROM App_SyncCloudConfig D WHERE flag & 1 = 0 AND D.clientId = STAT.destClientId AND D.syncWebFolderId = STAT.syncWebFolderId) -- Unpaused dest clients
END
SELECT @o_syncStatus AS o_syncStatus
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncProcessSyncJob')
	delete from GxQscripts where name = 'AppSyncProcessSyncJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncProcessSyncJob')
	delete from GXDBVersions where aliasname = 'AppSyncProcessSyncJob'
GO

insert into GXDBVersions values(2, 'AppSyncProcessSyncJob',  '00010014000000000000', 'AppSyncProcessSyncJob', '00010014000000000000')
GO

