

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncPause.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+=======================================================================+
--	|  							AppSyncPause								|
--	|  Procedure to pause the sync configuration at client or folder level	|
--	+=======================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncPause <<<'

IF EXISTS (select * from sysobjects where name='AppSyncPause')
	drop procedure AppSyncPause
IF EXISTS (select * from GxQscripts where name='AppSyncPause')
	delete from GxQscripts where name = 'AppSyncPause'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncPause')
	delete from GXDBVersions where aliasname = 'AppSyncPause'
GO
print '... Creating Procedure: AppSyncPause'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncPause
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @clientList TABLE(clientId INT, clientName NVARCHAR(MAX))
	DECLARE @oscClientTbl         TABLE (clientId INT, subclientId INT)
	DECLARE @workQOutPutTbl       TABLE (errCode INT, errString NVARCHAR(MAX))
    DECLARE @workQueueXML         XML
    DECLARE @workQueueParam       NVARCHAR(MAX)
	DECLARE @isEdgeDrive		  INT = 0
	-- Read the XML
	DECLARE @inClientId				INT				= ISNULL (( SELECT ref.value('@clientId', 'INT')
														FROM @i_xmlString.nodes ('App_PauseSyncReq/client') R(ref)), 0)
	DECLARE @inSyncWebFolderId		INT			= ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
														FROM @i_xmlString.nodes ('App_PauseSyncReq/syncWebFolder') R(ref)), 0)
	IF @inSyncWebFolderId < 1 OR NOT EXISTS(SELECT 1 FROM App_SyncCloudFolder WITH (NOLOCK) WHERE syncWebFolderId = @inSyncWebFolderId)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid Web Folder Info in Pause Request.'
		GOTO ERROR_EXIT
	END
SET @isEdgeDrive = ISNULL((SELECT 1 FROM App_SyncCloudFolder WITH (NOLOCK) WHERE syncWebFolderId = @inSyncWebFolderId AND flag & 0x10 = 0x10), 0)
	-- Client level Pause request
	IF @inClientId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK)
						WHERE syncWebFolderId = @inSyncWebFolderId AND clientId = @inClientId)
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error : Invalid Client Info Client level Pause Request.'
			GOTO ERROR_EXIT
		END
		-- Mark the client as paused
		UPDATE App_SyncCloudConfig
		SET flag = flag | 0x1
		WHERE syncWebFolderId = @inSyncWebFolderId AND clientId = @inClientId
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR_EXIT
	END
	-- Sync Folder level Pause request
	ELSE
	BEGIN
		-- Mark the sync folder as paused
		UPDATE App_SyncCloudFolder
		SET flag = flag | 0x1
		WHERE syncWebFolderId = @inSyncWebFolderId
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR_EXIT
		UPDATE App_SyncCloudConfig
		SET flag = flag | 0x1
		WHERE syncWebFolderId = @inSyncWebFolderId
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR_EXIT
	END
-- Push OSC for the required clients
DECLARE @oscClientId INT = 0
DECLARE @oscSubClientId INT = 0
--
DECLARE GetOSCClients CURSOR
FOR SELECT clientId, subclientId FROM App_SyncCloudConfig
WHERE ((syncWebFolderId=@inSyncWebFolderId AND @inClientId = 0) OR (clientId=@inClientId AND syncWebFolderId=@inSyncWebFolderId)) AND syncType & 1 = 1 -- SOURCE CLIENTS ONLY
OPEN GetOSCClients
FETCH GetOSCClients INTO @oscClientId, @oscSubClientId
--
WHILE @@FETCH_STATUS = 0
BEGIN
	IF @isEdgeDrive = 0
	BEGIN
		-- Submit Workqueue for subclient content change WORK_TOKEN_SUBCLIENT_CONTENT = 7
		SET @workQueueXML = (SELECT @oscSubClientId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE)
		SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
		--
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 7/*WORK_TOKEN_SUBCLIENT_CONTENT*/, 0, 0, @oscClientId, 0, @workQueueParam
		SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		IF @errorCode <> 0
		BEGIN
			CLOSE GetOSCClients
			DEALLOCATE GetOSCClients
			GOTO ERROR_EXIT
		END
		DELETE FROM @workQOutPutTbl
		-- Send OSC when we dont have any other unpaused sync folder
		IF NOT EXISTS (	SELECT 1
						FROM App_SyncCloudFolder WF
						JOIN App_SyncCloudConfig CF ON CF.syncWebFolderId = WF.syncWebFolderId AND CF.clientId = @oscClientId AND CF.subclientId = @oscSubClientId AND CF.syncType & 1 = 1 -- SyncType_SOURCE
						LEFT JOIN (SELECT SFV.syncWebFolderId FROM App_SyncCloudFolders SFV  -- VIEW FOR SHARE
								   WHERE SFV.FLAG <> 0) SH ON SH.syncWebFolderId = WF.syncWebFolderId
						WHERE
(WF.flag & CAST(0x1 AS INT) = 0)
AND (CF.flag & CAST(0x1 AS INT) = 0)
							AND SH.syncWebFolderId IS NULL) -- Not a share
		BEGIN
		  INSERT INTO @workQOutPutTbl
		  EXEC AppWorkQueueSubmitRequest 4/*WORK_TOKEN_OSC,*/, 0, 0, @oscClientId, 0, ''
	--
		  SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		  IF @errorCode <> 0
		  BEGIN
			CLOSE GetOSCClients
			DEALLOCATE GetOSCClients
			GOTO ERROR_EXIT
		  END
	--
		END
	END
	ELSE
	BEGIN
	   DELETE FROM @workQOutPutTbl
		SET @workQueueXML = (   SELECT 4 AS '@status',	--SYNC_PAUSED
										(
										SELECT @oscClientId AS '@clientId',
										@oscSubClientId AS '@subclientId'
										FOR XML PATH('subclient'), TYPE
										),
										(
										SELECT @inSyncWebFolderId AS '@syncWebFolderId'
										FOR XML PATH('syncFolder'), TYPE
										)
								FOR XML PATH('TMMsg_SyncConfigWorkQueueReq'), TYPE
							)
		  SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
		  INSERT INTO @workQOutPutTbl
		  EXEC AppWorkQueueSubmitRequest 17/*WORK_TOKEN_SYNC_RESTORE_CONFIG*/, 0, 0, @oscClientId, 0, @workQueueParam
		  SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
--
		  IF @errorCode <> 0
		  BEGIN
				CLOSE GetOSCClients
				DEALLOCATE GetOSCClients
				GOTO ERROR_EXIT
		  END
	END
    FETCH GetOSCClients INTO @oscClientId, @oscSubClientId
END
CLOSE GetOSCClients
DEALLOCATE GetOSCClients
ERROR_EXIT:
	SET @o_xmlString = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString'
									 FOR XML PATH('response'), TYPE)
							FOR XML PATH('App_PauseSyncResp'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncPause')
	delete from GxQscripts where name = 'AppSyncPause'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncPause')
	delete from GXDBVersions where aliasname = 'AppSyncPause'
GO

insert into GXDBVersions values(2, 'AppSyncPause',  '00000000000000000000', 'AppSyncPause', '00000000000000000000')
GO

