

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncMaintenance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSyncMaintenance						|
--	|			Procedure to clean up sync entries	|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSyncMaintenance')
BEGIN
	print '>>> Drop Stored Procedure: AppSyncMaintenance <<<'
	drop procedure AppSyncMaintenance
END
IF EXISTS (select * from GxQscripts where name='AppSyncMaintenance')
	delete from GxQscripts where name = 'AppSyncMaintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncMaintenance')
	delete from GXDBVersions where aliasname = 'AppSyncMaintenance'
GO
print '... Creating Procedure: AppSyncMaintenance'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSyncMaintenance
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(MAX) OUTPUT,
  @xmlText XML OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @posIdx				INT = 0
	DECLARE @opEvMsgId			INT = 0
	DECLARE @dataIsEvent		INT = 0
	DECLARE @opMsgId			INT = 0
	DECLARE @opId				INT = 0
	DECLARE @paramMsgId			INT = 0
	DECLARE @shareId			INT = 0
	DECLARE @userId				INT = ISNULL((SELECT TOP 1 id FROM UMUsers (NOLOCK) WHERE flags&0x40=0x40), 1)
	DECLARE @shareName			NVARCHAR(MAX) = ''
	DECLARE @i_localeId			INT = ISNULL((SELECT top 1 CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='Commcell Locale' and modified = 0), 0)
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @numOfDays			INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='NumberOfDaysToKeepExpiredShares'), 7)
	DECLARE @daysToKeep			INT = @numOfDays*24*60*60
	DECLARE @privateShareFlag	INT = CAST(0x4 AS INT)
	DECLARE @excludeStatusMask	INT = (cast(0x00002 as int) | cast(0x00004 as int) | cast(0x00010 as int) | cast(0x00020 as int))
	-- Email subject string for expired share deletion
	DECLARE @delSubjectMail		NVARCHAR(MAX) = 'Your share link [^1%s] is expired and has been deleted.'
	-- Email subject string for expired share renew email
	DECLARE @subjectMail		NVARCHAR(MAX) = 'Your share link [^1%s] has expired and it will be deleted in [^2%s] days.'
	DECLARE @mailBody			NVARCHAR(MAX) = ''
	DECLARE @webConsoleURL		NVARCHAR(MAX) = ''
	DECLARE @hostName			NVARCHAR(MAX) = ''
	DECLARE @driveBrowseURL		NVARCHAR(200) = 'webconsole/browse/MyDrive.do?clientId={@ID}&path={@PATH}'
	DECLARE @driveShareBrowseURL	NVARCHAR(200) = 'webconsole/browse/MyDrive.do?shareFolderId={@SHAREID}&path={@PATH}',
			@fsBrowseURL		NVARCHAR(200) = 'webconsole/browse/fsBrowse.do?clientId={@ID}&path={@PATH}',
			@fsShareBrowseURL	NVARCHAR(200) = 'webconsole/browse/fsBrowse.do?shareFolderId={@SHAREID}'
	DECLARE @privateSharesUrl	NVARCHAR(MAX) = ''
	DECLARE @publicSharesUrl	NVARCHAR(MAX) = ''
	-- Message string for expired share renew email
	DECLARE @expireMessage		NVARCHAR(MAX) = 'The link [^1%s] which you have shared has expired and it will be deleted in [^2%s] days. Click ^3%s here ^4%s to renew it if you want to continue sharing it.^5%sOpen^4%s the file or folder.'
	-- Message string for expired share deletion
	DECLARE @deletMessage		NVARCHAR(MAX) = 'The link [^1%s] which you have shared is expired and has been deleted.^2%sOpen^3%s the file or folder.'
	DECLARE @strShareBody		NVARCHAR(MAX) = '<!doctype html><html><head/><body><div style="width: 600px;padding: 0;margin: 0 auto;text-align: center;text-align:-moz-center; text-align:-webkit-center;border:0;"><table border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff" width="600" style="color: #666;background: #ffffff;width: 600px;border:0;"><tbody><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-family: Helvetica, Arial, sans-serif;font-size: 1.5em;line-height: 1.25em;text-align: left;padding: 0;margin:0;"><p style="font-family: Helvetica, Arial, sans-serif;font-size: 1.5em; margin: 0;padding:0;text-transform: uppercase;font-weight: bold;">commvault</p><hr width="100%" noshade="noshade" size="1" color="#666666" style="height: 1px;" /></td></tr><tr><td>&nbsp;</td></tr><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-family: Helvetica, Arial, sans-serif;font-size: 1.85em;line-height: 1.25em;text-align: left;padding: 0;margin:0;"><p style="margin: 0;padding:0;">$MESSAGE_TITLE</p></td></tr><tr><td>&nbsp;</td></tr><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-size: 1em;line-height: 1.2em;text-align: left;font-family: Helvetica, Arial, sans-serif;"><p>$MESSAGE_CONTENT<hr width="100%" noshade="noshade" size="1" color="#666666" style="height: 1px;" /><span style="font-size:75%;"><br >$PROBLEM</span></p></td></tr></tbody></table></div></body></html>'
	SET @strShareBody			= ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam(NOLOCK) WHERE name = 'WebserverEmailMessageTemplate' AND modified = 0), @strShareBody)
	DECLARE @strDriveLinkMsg	NVARCHAR(300) = '<br><br><a style="font-weight: bold; color: #00a3d4; padding-top: 5px; padding-bottom: 5px; text-decoration: none; font-family:Verdana, Helvetica, sans-serif; min-width:200px; line-hight:1.25;" href="{@DRIVELINK}">'
DECLARE @isShareFolder		INT	= (CAST(0x4 AS INT)|CAST(0x8 AS INT)|CAST(0x80 AS INT)),
			@emailFooter		NVARCHAR(4000)
--
	IF object_id('tempdb.dbo.#shareList') IS NOT null DROP TABLE #shareList
	CREATE TABLE #shareList	(shareId INT, shareName NVARCHAR(MAX), expireTime BIGINT, ownerId INT, dontCopyOwner INT, browseUrl NVARCHAR(MAX), flag INT, syncPath NVARCHAR(MAX), clientId INT, parentShareId INT, isEdgeClient INT)
	CREATE UNIQUE CLUSTERED INDEX shareList_IDX ON #shareList (shareId);
--
	IF object_id('tempdb.dbo.#expireList') IS NOT null DROP TABLE #expireList
	CREATE TABLE #expireList (action  NVARCHAR(MAX), shareId INT, shareName NVARCHAR(MAX), expireTime BIGINT, ownerId INT, dontCopyOwner INT )
	CREATE CLUSTERED INDEX expireList_IDX ON #expireList (shareId);
--
	SET @strShareBody = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam(NOLOCK) WHERE name = 'EMailShareExpirationMessage' AND modified = 0), @strShareBody)
	SET @deletMessage = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam(NOLOCK) WHERE name = 'EMailShareDeleteMessage' AND modified = 0), @deletMessage)
	SET @subjectMail = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam(NOLOCK) WHERE name = 'EMailShareExpirationSubject' AND modified = 0), @subjectMail)
	SET @delSubjectMail = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam(NOLOCK) WHERE name = 'EMailShareDeleteSubject' AND modified = 0), @delSubjectMail)
SET @paramMsgId = (3573 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	SET @deletMessage = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageID=@paramMsgId and LocaleID=@i_localeId)
SET @paramMsgId = (2508 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	SET @delSubjectMail = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageID=@paramMsgId and LocaleID=@i_localeId)
SET @paramMsgId = (3574 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	SET @expireMessage = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageID=@paramMsgId and LocaleID=@i_localeId)
SET @paramMsgId = (2505 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	SET @subjectMail = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageID=@paramMsgId and LocaleID=@i_localeId)
--
	SET @deletMessage = REPLACE(@deletMessage, '^1%s', '{@SHARENAME}')
	SET @deletMessage = REPLACE(@deletMessage,  '^2%s', @strDriveLinkMsg)
	SET @deletMessage = REPLACE(@deletMessage,  '^3%s', '</a>')
	SET @delSubjectMail = REPLACE(@delSubjectMail, '^1%s', '{@SHARENAME}')
	SET @subjectMail = REPLACE(@subjectMail, '^1%s', '{@SHARENAME}')
	SET @subjectMail = REPLACE(@subjectMail, '^2%s', CAST(@numOfDays AS NVARCHAR(10)))
	SET @subjectMail = REPLACE(@subjectMail, '^3%s', '{@LINK}')
	SET @expireMessage = REPLACE(@expireMessage, '^1%s', '<a style="font-weight: bold; color: #00a3d4; padding-top: 5px; padding-bottom: 5px; text-decoration: none; font-family:Verdana, Helvetica, sans-serif; min-width:200px; line-hight:1.25;" href="{@LINK}">{@SHARENAME}</a>')
	SET @expireMessage = REPLACE(@expireMessage, '^2%s', CAST(@numOfDays AS NVARCHAR(10)))
	SET @expireMessage = REPLACE(@expireMessage, '^3%s', '<a style="font-weight: bold; color: #00a3d4; padding-top: 5px; padding-bottom: 5px; text-decoration: none; font-family:Verdana, Helvetica, sans-serif; min-width:200px; line-hight:1.25;" href="{@SHARESLINK}">')
	SET @expireMessage = REPLACE(@expireMessage,  '^4%s', '</a>')
	SET @expireMessage = REPLACE(@expireMessage,  '^5%s', @strDriveLinkMsg)
	--
	--BUILD BROWSE URL TO RETURN TO GUI
	SELECT @webConsoleURL = value FROM GXGlobalParam (NOLOCK)
	WHERE name = 'WebConsoleURL' AND modified = 0
	SET @posIdx = PATINDEX('%/webconsole/%', @webConsoleURL)
	IF @posIdx = 0
	BEGIN
		SET @posIdx = PATINDEX('%/webconsole%', @webConsoleURL)
		IF @posIdx = 0
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error : Invalid webserver information.'
		END
		SET @webConsoleURL =  REVERSE(RIGHT(REVERSE (@webConsoleURL), len(@webConsoleURL) -
			NULLIF(charindex('elosnocbew/', REVERSE(@webConsoleURL)) - 2,0))) + '/'
	END
	ELSE
	BEGIN
		SET @webConsoleURL = LEFT(@webConsoleURL, @posIdx+LEN('/webconsole/')-1)
	END
	SET @privateSharesUrl = @webConsoleURL + 'summary/index.do?page=sharedByMeLi'
	SET @publicSharesUrl = @webConsoleURL + 'summary/index.do?page=publicShareLi'
	SET @hostName = ISNULL(LEFT(@webConsoleURL, @posIdx), '')
	IF @hostName = ''
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Error : Could not find hostname from the webserver information.'
		GOTO EDGE_ERROR
	END
	-- Fill share email template -- ---------------------------------------------------------------------------------------------------------------------------------------------------------
		-- Template has three placeholders ($MESSAGE_TITLE, $MESSAGE_CONTENT and $PROBLEM)
			-- $MESSAGE_TITLE and $MESSAGE_CONTENT will be replaced while creating the output of the proc. i.e. at the end.
	DECLARE @adminEmail NVARCHAR(200) = ISNULL((SELECT email FROM UMUsers WHERE flags&0x040=0x040), '')
SET @paramMsgId = (2773 | (CAST(POWER(2, 24) AS BIGINT) * 35));--(2773 | (CAST(POWER(2, 24) AS BIGINT) * 35));
    SET @emailFooter = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@i_localeId)
    SET @emailFooter =  REPLACE(@emailFooter, '^2%s', '</a>')
    SET @emailFooter =  REPLACE(@emailFooter, '^3%s', ' ')--'<br/>')
    SET @emailFooter =  REPLACE(@emailFooter, '^1%s', '<a href="mailto:{@MAILTO}" style="color: #3366ff;">')
    SET @emailFooter =  REPLACE(@emailFooter, '{@MAILTO}', @adminEmail)
	SET @strShareBody = REPLACE(@strShareBody, '$PROBLEM', @emailFooter)
	--  -- ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--
	-- Pause all deconfigured clients
	UPDATE CO
	SET CO.flag = CO.flag | 1
	FROM App_SyncCloudConfig CO
	INNER JOIN APP_Client CL ON CO.clientId = CL.id
	INNER JOIN App_SyncCloudFolder CF ON CF.syncWebFolderId = CO.syncWebFolderId
	INNER JOIN App_SyncCloudFolders SFV ON CF.syncWebFolderId = SFV.SyncWebFolderId
	WHERE CL.status & @excludeStatusMask > 0
AND CF.flag & (CAST(0x4 AS INT)|CAST(0x8 AS INT)|CAST(0x10 AS INT)) = 0  --DO NOT PAUSE SHARE FOLDERS OR EDGE DRIVE.
	-- For edge drive there is no way to unpause it. Instead filter out deconfigured client/subclients when sending sync restore workqueue
	AND SFV.FLAG = 0	--DO NOT PAUSE SHARE FOLDERS
	--
	-- Pause sync folders for all disabled users
	UPDATE App_SyncCloudFolder
	SET flag = flag | 1
	FROM App_SyncCloudFolder CF INNER JOIN UMUsers US (NOLOCK) ON CF.ownerId = US.id
	WHERE US.enabled = 0
	--
	--GET LIST OF SHARES THAT HAVE EXPIRATION TIME
	INSERT INTO #shareList
	SELECT
		   SC.syncWebFolderId,
		   CF.syncWebFolderName,
		   op.value('@time','BIGINT') expireTime,
		   SU.sharedBy,
		   ISNULL(co.value('@dontCopyOwner', 'INT'), 0) dontCopyOwner,
		   co.value('@browseUrl', 'NVARCHAR(MAX)') browseUrl,
		   SFV.flag, SC.syncPath, SC.clientId, SC.parentShareId,
		   IIF(SC.configOptions.exist('/browseInfo[@edgeClient=1]') = 1, 1, 0)
	FROM App_SharingUserInfo SU WITH(NOLOCK)
	INNER JOIN App_SyncCloudConfig SC WITH(NOLOCK) ON SC.syncWebFolderId = SU.shareId AND SU.isOwner=1
AND SC.flag & CAST(0x1 AS INT) = 0  --IT'S NOT PAUSED
	INNER JOIN App_SyncCloudFolder CF  WITH(NOLOCK) ON CF.syncWebFolderId = SC.syncWebFolderId
	INNER JOIN App_SyncCloudFolders SFV  WITH(NOLOCK) ON SFV.Flag <> 0 --IT'S A SHARE FOLDER
			AND CF.syncWebFolderId = SFV.SyncWebFolderId
	CROSS APPLY SC.configOptions.nodes('//browseInfo/expirationTime') AS O(op)
	CROSS APPLY SC.configOptions.nodes('//browseInfo/emailInfo') AS E(co)
	WHERE ISNULL(op.value('@time','BIGINT'), 0) > 0
--
	-- Mark expired shares
	MERGE App_SyncCloudFolder AS SC
	USING
	(
		SELECT shareId, expireTime, ownerId, shareName, dontCopyOwner
		FROM #shareList
	) AS T ON T.shareId = syncWebFolderId
WHEN MATCHED AND expireTime < @nowTime AND flag & CAST(0x40 AS INT) = 0 THEN
UPDATE SET flag = flag | 0x40
	WHEN MATCHED AND expireTime+@daysToKeep < @nowTime THEN
		DELETE
	OUTPUT $action, T.shareId, T.shareName, T.expireTime, T.ownerId, T.dontCopyOwner
	INTO #expireList;
	-- DELETE SHARES FOR WHICH SEND EXPIRATION EMAIL IS NOT SET
	DELETE FROM #expireList Where dontCopyOwner = 1
	-- Delete sync folders for all deleted users
	DELETE App_SyncCloudFolder
	FROM App_SyncCloudFolder CF
	LEFT OUTER JOIN UMUsers US (NOLOCK) ON CF.ownerId = US.id
WHERE US.flags & 1 = 0 /*Deleted*/ AND (CF.flag&(CAST(0x10 AS INT) | CAST(0x4 AS INT) | CAST(0x80 AS INT) | CAST(0x8 AS INT)) = 0) /*not Edge drive folder*/
	OR US.id IS NULL -- Hard deletion that some how happened.
	--
	-- Remove all records for deleted subclient
    DELETE R
	FROM App_RMRecord R
    LEFT OUTER JOIN APP_SubClientProp SP WITH(NOLOCK) ON SP.attrName = N'Edge Drive User Id' AND SP.cs_attrName = CHECKSUM(N'Edge Drive User Id') AND SP.modified = 0 AND SP.attrVal = CAST(R.ownerId AS NVARCHAR(MAX))
    LEFT OUTER JOIN APP_Application APP WITH(NOLOCK) ON SP.componentNameId = APP.id
	WHERE APP.id IS NULL -- Subclient is deleted
	-- DELETE SHARE CONFIGS FOR DELETED Clients/SUBCLIENTS. REMOVAL OF SHARES HAPPENS IN NEXT STEP
	DELETE SC
	FROM App_SyncCloudConfig SC
	LEFT OUTER JOIN APP_Client C WITH(NOLOCK) ON C.id = SC.clientId
	LEFT OUTER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = SC.subclientId
		WHERE C.id IS NULL OR APP.id IS NULL
--
	DELETE SCS
	FROM App_SyncCloudStats SCS
	LEFT OUTER JOIN APP_Client C WITH (NOLOCK) ON  C.id = SCS.destClientId
	LEFT OUTER JOIN APP_Application S WITH (NOLOCK) ON  S.id = SCS.sourceSubclientId
	WHERE C.id IS NULL OR S.id IS NULL
--
	-- Delete edge sync folders for all deleted backupset/subclients
	DELETE App_SyncCloudFolder
	WHERE ownerId NOT IN (SELECT attrVal FROM APP_BackupSetProp WITH(NOLOCK) WHERE attrName = 'Edge Drive User Id' AND modified = 0)
AND flag & 0x10 <> 0
--
	-- Delete shared folders for all deleted clients/subclients
	DELETE CF
	FROM App_SyncCloudFolder CF
	WHERE (CF.Flag & @isShareFolder) <> 0  AND NOT EXISTS ( SELECT TOP 1 1 FROM App_SyncCloudConfig WITH (NOLOCK) WHERE syncWebFolderId = CF.syncWebFolderId)
--
-- Push Sync restore work Queue for Edge Drive
	DECLARE @workQOutPutTbl		TABLE (errCode INT, errString NVARCHAR(MAX))
	DECLARE @edgeDriveLaptopInfo TABLE
	(
		syncStatId INT,
		clientId INT,
		edgeClientId INT,
		edgeBackupsetId INT,
		edgeSublientId INT,
		syncFolderId INT
	)
DECLARE @pausedBlackListedFlag INT = (CAST(0x1 AS INT) | CAST(0x20 AS INT))
	INSERT INTO @edgeDriveLaptopInfo
	SELECT ST.syncStatId, ST.destClientId, APP.clientId, APP.backupset, ST.sourceSubclientId, ST.syncWebFolderId
	FROM App_SyncCloudStats ST WITH(NOLOCK)
	INNER JOIN App_SyncCloudConfig SC WITH(NOLOCK) ON SC.syncWebFolderId = ST.syncWebFolderId AND SC.clientId = ST.destClientId
	INNER JOIN App_SyncCloudFolder SF WITH(NOLOCK) ON ST.syncWebFolderId = SF.syncWebFolderId
	INNER JOIN APP_Application APP WITH(NOLOCK) ON ST.sourceSubclientId = APP.id
	INNER JOIN APP_Client C2 WITH(NOLOCK) ON C2.id = ST.destClientId AND C2.status & 6 = 0 -- (CV_STATUS_UNINSTALLED | CV_STATUS_DELETED)
	INNER JOIN APP_Application APP2 WITH(NOLOCK) ON
		 APP2.appTypeId IN (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) AND APP2.appTypeId <> 13 -- File system
		 AND C2.id= APP2.clientId AND APP2.subclientStatus & 8 = 8 --CV_STATUS_DEFAULT
		 AND APP2.subclientStatus & 6 = 0 -- (CV_STATUS_UNINSTALLED | CV_STATUS_DELETED)
	INNER JOIN APP_BackupSetName BS2 WITH(NOLOCK) ON APP2.backupSet = BS2.id AND BS2.status & 8 = 8 --CV_STATUS_DEFAULT
WHERE SF.flag & 0x10 <> 0
	AND ST.syncStatus = 0
	AND SC.flag & @pausedBlackListedFlag = 0 -- Not paused or blacklisted.
	AND NOT EXISTS(SELECT 1 FROM JMBkpJobInfo JBI WITH(NOLOCK)
                   INNER JOIN JMJobInfo JI WITH(NOLOCK) ON JI.jobId = JBI.jobId AND JI.commcellId = JBI.commcellId
                   WHERE JBI.applicationId = ST.sourceSubclientId AND JBI.targetClientId = ST.destClientId AND JBI.bkpAttributesEx & 0x200 = 0x200
                   AND JI.state <> 20) -- No edge backup running on it
	--Prepare WQ Data
	DECLARE @wqData TABLE(clientId INT,data xml)
	INSERT INTO @wqData
	SELECT
	clientId,
	(SELECT
			(
				SELECT	edgeClientId AS '@clientId',
						edgeBackupsetId AS '@backupsetId',
						edgeSublientId AS '@subclientId'
				FOR XML PATH('subclient'), TYPE
			),
			(	SELECT syncFolderId AS '@syncWebFolderId'
				FOR XML PATH('syncFolder'), TYPE
			)
		FOR XML PATH('TMMsg_SyncRestoreWorkQueueReq'), TYPE)
	FROM @edgeDriveLaptopInfo
	--To avoid cursors using dynamic query to execute multiple workqueue
	DECLARE @sql NVARCHAR(MAX) = N'DECLARE @errCode INT = 0' + NCHAR(13) + N'DECLARE @errString NVARCHAR(1024) = N''''' +  NCHAR(13)
			SELECT @sql += N' EXEC AppAddToWorkQueue 16 /*WORK_TOKEN_SYNC_RESTORE*/, 0, 0, ' + CAST(clientId AS NVARCHAR(12)) + N', 0, N''' + CAST(data as NVARCHAR(256)) + N''', @errCode OUTPUT, @errString OUTPUT' + NCHAR(13)
			+ N' IF (@errCode > 0) BEGIN ' + NCHAR(13)
			+ N' GOTO END_CMD ' + NCHAR(13)
			+ N' END'  + NCHAR(13)
	FROM @wqData
	SET @sql += N'END_CMD:' + NCHAR(13) + N'SELECT @errCode, @errString' + NCHAR(13)
	INSERT INTO @workQOutPutTbl
	EXEC(@sql)
	SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
	IF @errorCode <> 0
	BEGIN
		GOTO EDGE_ERROR
	END
	UPDATE App_SyncCloudStats
	SET syncStatus = 2
	WHERE syncStatId IN (SELECT syncStatId FROM @edgeDriveLaptopInfo)
	SET @xmlText =
		(
			(SELECT
				(SELECT
					Q.email '@email',
					Q.name '@sharedTo',
					CASE WHEN action='UPDATE'
					THEN REPLACE(REPLACE(@subjectMail, '{@SHARENAME}', Q.shareName), '{@LINK}', @hostName + Q.browseUrl)
					ELSE REPLACE(@delSubjectMail, '{@SHARENAME}', Q.shareName)
					END '@mailSubject',
					CASE WHEN action='UPDATE'
					THEN REPLACE(
								REPLACE(
										REPLACE(
												REPLACE(
														REPLACE(REPLACE(@strShareBody, '$MESSAGE_TITLE', @subjectMail) ,
														'$MESSAGE_CONTENT', @expireMessage
													   ),
												'{@SHARENAME}', Q.shareName
											   )
												,'{@SHARESLINK}', (CASE WHEN Q.flag & @privateShareFlag > 0 THEN @privateSharesUrl ELSE @publicSharesUrl END)
												)
									,'{@LINK}', @hostName + Q.browseUrl
									), '{@DRIVELINK}', @hostname + REPLACE(REPLACE(
																					(CASE
																						WHEN q.parentShareId =0 THEN IIF(Q.isEdgeClient = 1, @driveBrowseURL, @fsBrowseURL)
																						ELSE REPLACE(IIF(Q.isEdgeClient = 1, @driveShareBrowseURL, @fsShareBrowseURL),'{@SHAREID}',Q.parentShareId)
																					END),
																					'{@ID}',Q.clientId
																				  ),
																			 '{@PATH}', dbo.URLEncode(Q.syncPath)
																			 )
								)
					ELSE REPLACE(REPLACE(REPLACE(REPLACE(@strShareBody, '$MESSAGE_TITLE', @delSubjectMail), '$MESSAGE_CONTENT', @deletMessage), '{@SHARENAME}', Q.shareName),
						'{@DRIVELINK}', @hostname + REPLACE(REPLACE(
																	(CASE
																		WHEN q.parentShareId =0 THEN IIF(Q.isEdgeClient = 1, @driveBrowseURL, @fsBrowseURL)
																		ELSE REPLACE(IIF(Q.isEdgeClient = 1, @driveShareBrowseURL, @fsShareBrowseURL),'{@SHAREID}',Q.parentShareId)
																	END),
																	'{@ID}',Q.clientId), '{@PATH}', dbo.URLEncode(Q.syncPath)))
					END '@mailBody',
					(SELECT Q.shareName '@emailMessage'	--USE THIS FOR SHARE NAME TO DISPLAY IN CASE OF ERROR
						FOR XML PATH('emailInfo'), TYPE
					)
					FOR XML PATH('shareUsers'), TYPE
				)
				FROM
				(
					SELECT EL.ownerId, SC.shareId, SC.browseUrl, SC.shareName, EL.expireTime, EL.action action, US.email, US.name, SC.flag, SC.syncPath, SC.clientId, SC.parentShareId, SC.isEdgeClient
					FROM #expireList EL
					JOIN #shareList SC ON SC.shareId = EL.shareId
					JOIN UMUsers US WITH (NOLOCK) ON US.id = EL.ownerId
				) Q
				FOR XML PATH(''), ROOT('App_ShareFolderEmailResp')
			)
		)
	IF EXISTS(SELECT shareId FROM #expireList WHERE action = 'DELETED')
	BEGIN
		-- SET GUI AUDIT OPERATION
SET @opMsgId = (398 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
		--DO SHARE EXPIRATION AUDIT
		DECLARE shareExpiredCur CURSOR
		FOR
		SELECT shareId, shareName FROM #expireList WHERE action = 'DELETED'
		OPEN shareExpiredCur
		FETCH FROM shareExpiredCur INTO @shareId, @shareName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @shareName, @dataIsEvent
			-- SET GUI AUDIT OPERATION
SET @paramMsgId = (1203 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			FETCH FROM shareExpiredCur INTO @shareId, @shareName
		END
		CLOSE shareExpiredCur
		DEALLOCATE shareExpiredCur
	END
	-- Toggle Sync1 property
	UPDATE APP_ClientProp
	SET attrVal = '1'
	WHERE attrname = 'Sync1 Feature Enabled'
	AND attrVal = '0'
	AND modified = 0
	AND componentNameId IN (SELECT CF.clientId
							FROM App_SyncCloudFolder WF
							JOIN App_SyncCloudConfig CF ON CF.syncWebFolderId = WF.syncWebFolderId AND CF.syncType & 1 = 1 -- SyncType_SOURCE
							LEFT JOIN (SELECT SFV.syncWebFolderId FROM App_SyncCloudFolders SFV  -- VIEW FOR SHARE
										WHERE SFV.FLAG <> 0) SH ON SH.syncWebFolderId = WF.syncWebFolderId
WHERE (WF.flag & CAST(0x1 AS INT) = 0)
AND (CF.flag & CAST(0x1 AS INT)) = 0
AND (WF.flag & 0x10 = 0)
								AND SH.syncWebFolderId IS NULL
							)
	UPDATE APP_ClientProp
	SET attrVal = '0'
	WHERE attrname = 'Sync1 Feature Enabled'
	AND attrVal = '1'
	AND modified = 0
	AND NOT EXISTS (SELECT CF.clientId
							FROM App_SyncCloudFolder WF
							JOIN App_SyncCloudConfig CF ON CF.syncWebFolderId = WF.syncWebFolderId AND CF.clientId = componentNameId AND CF.syncType & 1 = 1 -- SyncType_SOURCE
							LEFT JOIN (SELECT SFV.syncWebFolderId FROM App_SyncCloudFolders SFV  -- VIEW FOR SHARE
										WHERE SFV.FLAG <> 0) SH ON SH.syncWebFolderId = WF.syncWebFolderId
WHERE (WF.flag & CAST(0x1 AS INT) = 0)
AND (CF.flag & CAST(0x1 AS INT)) = 0
AND (WF.flag & 0x10 = 0)
								AND SH.syncWebFolderId IS NULL
							)
	EDGE_ERROR:
	IF object_id('tempdb.dbo.#shareList') IS NOT null DROP TABLE #shareList
	IF object_id('tempdb.dbo.#expireList') IS NOT null DROP TABLE #expireList
	SELECT @errorCode, @errorString, @xmlText
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncMaintenance')
	delete from GxQscripts where name = 'AppSyncMaintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncMaintenance')
	delete from GXDBVersions where aliasname = 'AppSyncMaintenance'
GO

insert into GXDBVersions values(2, 'AppSyncMaintenance',  '00000000000000000000', 'AppSyncMaintenance', '00000000000000000000')
GO

