

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncGetWebFolders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSyncGetWebFolders							|
--	|  Procedure to get a list of Sync Web folders for a given client	|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetWebFolders <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetWebFolders')
	drop procedure AppSyncGetWebFolders
IF EXISTS (select * from GxQscripts where name='AppSyncGetWebFolders')
	delete from GxQscripts where name = 'AppSyncGetWebFolders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetWebFolders')
	delete from GXDBVersions where aliasname = 'AppSyncGetWebFolders'
GO
print '... Creating Procedure: AppSyncGetWebFolders'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetWebFolders
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT = 0,
  @i_localeId INT = 0
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @templateXML		XML
	DECLARE @templateSyncType	INT
	DECLARE @templateSyncPath	NVARCHAR(MAX)
	DECLARE @templateFlag		INT
	DECLARE @assocXML			XML
	DECLARE @templateTbl		TABLE(syncWebFolderId INT, syncWebFolderName NVARCHAR(MAX), syncFolderFlag INT, templateXML XML)
	DECLARE @clientList			TABLE(clientId INT, clientName NVARCHAR(MAX))
DECLARE @excludeStatusMask int = (cast(0x00002 as int) | cast(0x00004 as int) | cast(0x00010 as int) | cast(0x00020 as int))
	DECLARE @userName			NVARCHAR(MAX) = ''
	-- Read the XML
	DECLARE @inClientId				INT				= ISNULL (( SELECT ref.value('@clientId', 'INT')
														FROM @i_xmlString.nodes ('App_GetSyncWebFolderReq/client') R(ref)), 0)
	DECLARE @inSyncWebFolderId		INT				= ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
														FROM @i_xmlString.nodes ('App_GetSyncWebFolderReq/syncWebFolder') R(ref)), '')
	DECLARE @inSyncWebFolderName	NVARCHAR(MAX)	= ISNULL (( SELECT ref.value('@syncWebFolderName', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_GetSyncWebFolderReq/syncWebFolder') R(ref)), '')
	DECLARE @inPropertyLevel		INT				= ISNULL (( SELECT ref.value('@propertyLevel', 'INT')
														FROM @i_xmlString.nodes ('App_GetSyncWebFolderReq') R(ref)), 10) -- ListPropertyLevels_AllProperties
	DECLARE @inScope		INT				= ISNULL (( SELECT ref.value('@scope', 'INT')
														FROM @i_xmlString.nodes ('App_GetSyncWebFolderReq') R(ref)), 0) -- SyncScope_WebConsole
	DECLARE @excludeUnlinked	INT					= ISNULL (( SELECT ref.value('@excludeUnlinkedSyncType', 'INT')
														FROM @i_xmlString.nodes ('App_GetSyncWebFolderReq') R(ref)), 0)
	IF @i_userId = 0
	BEGIN
		SET @userName	= ISNULL (( SELECT ref.value('@userName', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_GetSyncWebFolderReq/user') R(ref)), '')
		SET @i_userId = ISNULL((SELECT TOP 1 id from UMUsers WITH (NOLOCK) WHERE login = @username or email = @username ORDER by id ASC),0)
	END
	-- Extended properties is for a sync folder. So ID is needed.
	IF @inPropertyLevel = 30 AND @inSyncWebFolderId = 0
	BEGIN
		SET @inSyncWebFolderId = ISNULL((SELECT syncWebFolderId
										FROM App_SyncCloudFolder WITH (NOLOCK)
										WHERE syncWebFolderName = @inSyncWebFolderName AND ownerId = @i_userId), 0)
		IF @inSyncWebFolderId = 0
			GOTO ERROR_EXIT
	END
	-- Backup Monitor scope. Get and return the edge drive for this uer
	IF @inScope = 1
	BEGIN
		SET @inPropertyLevel = 30 --ListPropertyLevels_AllProperties
		SET @inSyncWebFolderId = ISNULL((SELECT syncWebFolderId
										FROM App_SyncCloudFolder WITH (NOLOCK)
WHERE ownerId = @i_userId AND flag & 0x10 <> 0), 0)
		IF @inSyncWebFolderId = 0
			GOTO ERROR_EXIT
	END
    INSERT @clientList
    SELECT DISTINCT um.clientId, CL.displayName
    FROM   UMOwnerCredentials um
	INNER JOIN App_Client CL WITH(NOLOCK) ON CL.id = um.clientId AND releaseId > 14 AND CL.status & 4096 = 4096 AND CL.status & @excludeStatusMask = 0 -- Consider only laptop clients
    INNER JOIN APP_IDAName IDA WITH(NOLOCK) ON IDA.clientId = um.clientId and  ( IDA.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) and IDA.appTypeId <> 13)
	INNER JOIN APP_Application APP ON APP.clientId = um.clientId and subclientStatus&@excludeStatusMask = 0 and (subClientStatus & 0x00008 = 0x00008)
    WHERE [userId] = @i_userId
	-- Form the XML response
	-- This is inside a particular sync folder
	IF @inPropertyLevel = 30 -- ListPropertyLevels_AllProperties
	BEGIN
		IF @inSyncWebFolderId > 0
		BEGIN
			SET @o_xmlString =	(
									(SELECT
										SYNC.description AS '@description',
										--SYNC.enabled AS '@enabled',
										--SYNC.deleted AS '@deleted',
										SYNC.flag AS '@flag',
										--SYNC.lasSyncTime AS '@lastSyncTime',
										(SELECT
											DISTINCT SYNC.syncWebFolderId  AS '@syncWebFolderId',
											SYNC.syncWebFolderName AS '@syncWebFolderName'
											FOR XML PATH('syncWebFolder'), TYPE
										),
										(SELECT
											SYNC.ownerId AS '@userId'
											FOR XML PATH('syncOwner'), TYPE
										),
										(SELECT
											CO.syncPath AS '@syncPath',
											ISNULL(CO.syncType, 4) AS '@syncType',
											CO.flag AS '@flag',
										(CASE
										  WHEN EXISTS (SELECT 1 FROM App_SyncCloudStats STAT7 WITH (NOLOCK)
													  WHERE STAT7.syncWebFolderId = SYNC.syncWebFolderId
													  AND STAT7.destClientId = CL.clientId
													  AND STAT7.lastSuccessSyncJobId = 0)
											   THEN 0
										  ELSE ISNULL((SELECT MAX(RST.servEndTime) FROM JMRestoreStats RST WITH (NOLOCK)
														WHERE RST.destClientId = CO.clientId),
														0)
										  --ELSE ISNULL( (SELECT TOP(1) servEndTime
												--FROM JMRestoreStats RST WITH (NOLOCK)
												--WHERE rstattributes & 0x100 <> 0 AND
												--RST.destClientId = CL.clientId
												--AND (status IN (1, 3, 14) OR
												--	( status = 2 -- Failed jobs
												--		AND failureReason <> '' -- Jobs with failure reason
												--		AND EXISTS (SELECT 1 FROM JMFailureReasonMsg MSG WITH (NOLOCK) WHERE MSG.id = CAST(SUBSTRING(failureReason, 0, CHARINDEX(',', failureReason, 0)) AS INT)
												--		AND MSG.messageId IN(402653247, 402653248)) -- There was nothing to restore - item(s) not found or not backed up.
												--	)
												--) ORDER BY servEndTime DESC), 0)
										  END) AS '@lastSyncTime', --FIX FOR DISAPEARING FOLDERS WHEN SYNC JOB RUNNING
												CASE WHEN EXISTS (SELECT 1 FROM App_SyncCloudStats CSTAT
																WHERE CSTAT.destClientId = CL.clientId AND CSTAT.syncWebFolderId = SYNC.syncWebFolderId AND CSTAT.syncStatus = 2 AND CSTAT.lastSuccessSyncJobId > 0) --CSTAT.syncStatus
													 THEN 1 -- Complete
													WHEN EXISTS (SELECT 1 FROM App_SyncCloudStats CSTAT
																WHERE CSTAT.destClientId = CL.clientId AND CSTAT.syncWebFolderId = SYNC.syncWebFolderId AND CSTAT.syncStatus = 1)
													 THEN
														CASE WHEN EXISTS (SELECT 1 FROM JMRstJobInfo RST
																			INNER JOIN JMJobInfo INF ON RST.jobId = INF.jobId AND RST.commcellId = INF.commcellId
																			WHERE rstattributes & 0x100 <> 0 AND
																			RST.destClientId = CL.clientId
																			AND INF.state IN (1))
															THEN 3 -- Running
														ELSE 2 -- Pending
														END
													ELSE 0
													END
												  as '@syncClientStatus',
											(SELECT
												CL.clientId AS '@clientId',
												CL.clientName AS '@clientName',
												CO.subclientId AS '@subclientId'
												FOR XML PATH('client'), TYPE
											),
											(SELECT CO.configOptions AS syncOptions)
											FROM @clientList CL
											LEFT OUTER JOIN App_SyncCloudConfig CO WITH (NOLOCK) ON CO.syncWebFolderId=SYNC.syncWebFolderId
												AND CO.clientId=CL.clientId	--FIX FOR DISAPEARING FOLDERS
											WHERE (@excludeUnlinked = 0 OR  CO.syncType <> 4 /**SyncType UNLINKED**/ )
											--WHERE (@inScope = 0 OR (@inScope = 1 AND CL.clientId = @inClientId))
											--WHERE CO.clientId = CL.clientId
											/*
												(SELECT CO.*, BKP.servEndDate FROM App_SyncCloudConfig CO WITH (NOLOCK)
												  LEFT OUTER JOIN App_SyncCloudStats STAT WITH (NOLOCK) ON CO.syncWebFolderId = STAT.syncWebFolderId AND CO.clientId = STAT.destClientId
												  LEFT OUTER JOIN JMBkpStats BKP WITH (NOLOCK) ON STAT.lastSuccessSyncJobId = BKP.jobId AND BKP.commcellId = 2
												  WHERE CO.syncWebFolderId = SYNC.syncWebFolderId) CONFIG
											*/
											FOR XML PATH('associatedClients'), TYPE
										),
										(SELECT TOP 1
											CL2.id  AS '@clientId',
											CL2.name AS '@clientName'
											FROM App_SyncCloudConfig EDC WITH (NOLOCK)
INNER JOIN APP_Client CL2 WITH (NOLOCK) ON EDC.clientId = CL2.id AND EDC.syncWebFolderId = SYNC.syncWebFolderId AND CL2.status & 0x10000000 <> 0
											FOR XML PATH('edgeDriveClient'), TYPE
										)
										FROM App_SyncCloudFolder SYNC WITH (NOLOCK)
										WHERE  SYNC.syncWebFolderId = @inSyncWebFolderId
										AND SYNC.ownerId = @i_userId
										FOR XML PATH('syncInfos'), ROOT('App_GetSyncWebFolderResp')
									)
								)
		END
		ELSE
		BEGIN
			INSERT INTO @templateTbl
			SELECT 0, '', 0, value FROM GXGlobalParam
			WHERE name = 'Sync Folder Template'
			AND modified=0
			UPDATE @templateTbl
			SET syncWebFolderId = templateXML.value('data(/syncInfos/syncWebFolder/@syncWebFolderId)[1]', 'INT'),
			syncWebFolderName = templateXML.value('data(/syncInfos/syncWebFolder/@syncWebFolderName)[1]', 'NVARCHAR(MAX)'),
			syncFolderFlag = templateXML.value('data(/syncInfos/@flag)[1]', 'NVARCHAR(MAX)')
			IF NOT EXISTS (SELECT 1 FROM @templateTbl WHERE syncWebFolderId = @inSyncWebFolderId)
			BEGIN
				GOTO ERROR_EXIT
			END
			IF @o_xmlString IS NULL
				SET @o_xmlString = '<App_GetSyncWebFolderResp/>'
			-- Form the web folders detail from the GxGlobalParam table for this user.
			SET @templateXML = (SELECT templateXML FROM @templateTbl WHERE syncWebFolderId = @inSyncWebFolderId)
			-- Get All defaults for Associations
			SET @templateSyncType		= ISNULL((SELECT ref.value('@syncType', 'INT')
													FROM  @templateXML.nodes ('syncInfos/associatedClients') R(ref)), 3)
			SET @templateSyncPath		= ISNULL((SELECT ref.value('@syncPath', 'NVARCHAR(MAX)')
													FROM  @templateXML.nodes ('syncInfos/associatedClients') R(ref)), '')
			SET @templateFlag			= ISNULL((SELECT ref.value('@flag', 'INT')
													FROM  @templateXML.nodes ('syncInfos/associatedClients') R(ref)), 3)
			SET @assocXML = (	SELECT	@templateSyncType AS '@syncType',
										@templateSyncPath AS '@syncPath',
										@templateFlag AS '@flag',
										(SELECT
											CL.clientId AS '@clientId',
											CL.clientName AS '@clientName'
										FOR XML PATH('client'), TYPE
										)
								FROM @clientList CL
								FOR XML PATH('associatedClients'), TYPE
							)
			-- Delete the dummy association
			SET @templateXML.modify('delete /syncInfos/associatedClients')
			-- Add the new association
			SET @templateXML.modify('insert sql:variable("@assocXML") as last into (/syncInfos)[1]')
			-- Set owner
			SET @templateXML.modify('replace value of (/syncInfos/syncOwner/@userId)[1] with sql:variable("@i_userId")')
			-- Insert it at the end in response
			SET @o_xmlString.modify('insert sql:variable("@templateXML") as last into (/App_GetSyncWebFolderResp)[1]')
		END
	END
	-- This is for summary page
	ELSE IF @inPropertyLevel = 10 -- ListPropertyLevels_BasicProperties
	BEGIN
		SET @o_xmlString =	(
								(SELECT
									SYNC.description AS '@description',
									--SYNC.enabled AS '@enabled',
									--SYNC.deleted AS '@deleted',
									SYNC.flag AS '@flag',
									(CASE
										  WHEN EXISTS(SELECT 1 FROM App_SyncCloudStats STAT7 WITH (NOLOCK)
													  WHERE STAT7.syncWebFolderId = SYNC.syncWebFolderId
													  AND lastSuccessSyncJobId = 0)
													THEN 0
											ELSE ISNULL((SELECT TOP (1) servEndTime
														FROM JMRestoreStats RST WITH (NOLOCK)
														JOIN App_SyncCloudConfig CONFIG WITH (NOLOCK) ON CONFIG.lastRestoreSyncJobId = RST.jobId AND CONFIG.syncWebFolderId = SYNC.syncWebFolderId
														), 0)
											--ELSE ISNULL((SELECT TOP(1) servEndTime
												--	FROM JMRestoreStats RST WITH (NOLOCK)
												--	INNER JOIN App_SyncCloudStats STAT2 WITH (NOLOCK) ON RST.destClientId = STAT2.destClientId
												--	WHERE rstattributes & 0x100 <> 0 AND
												--	STAT2.syncWebFolderId = SYNC.syncWebFolderId
												--	AND (status IN (1, 3, 14) OR
												--		( status = 2 -- Failed jobs
												--			AND failureReason <> '' -- Jobs with failure reason
												--			AND EXISTS (SELECT 1 FROM JMFailureReasonMsg MSG WITH (NOLOCK) WHERE MSG.id = CAST(SUBSTRING(failureReason, 0, CHARINDEX(',', failureReason, 0)) AS INT)
												--			AND MSG.messageId IN(402653247, 402653248)) -- There was nothing to restore - item(s) not found or not backed up.
												--		)
												--	)
												--	ORDER BY servEndTime DESC), 0)
									END) AS '@lastSyncTime',
									(CASE
WHEN SYNC.flag & 0x1 <> 0
											THEN 4 --Paused
										WHEN EXISTS(SELECT 1 FROM JMBkpJobInfo BKP
													WHERE BKP.applicationId IN (SELECT sourceSubclientId FROM App_SyncCloudStats STAT3 WITH (NOLOCK)
																			    WHERE STAT3.syncWebFolderId = SYNC.syncWebFolderId)
													AND BKP.commcellId =2)
											THEN 3 -- Backup Running
										WHEN NOT EXISTS(SELECT 1 FROM App_SyncCloudStats STAT4 WITH (NOLOCK)
														WHERE STAT4.syncWebFolderId = SYNC.syncWebFolderId
														AND (STAT4.syncStatus <> 2 OR lastSuccessSyncJobId = 0))
											THEN 1 -- All jobs Complete
										WHEN EXISTS(SELECT 1 FROM App_SyncCloudStats STAT5 WITH (NOLOCK)
													WHERE STAT5.syncWebFolderId = SYNC.syncWebFolderId
													AND STAT5.currentRestoreJobId <> 0)
											THEN
												CASE WHEN EXISTS (SELECT 1 FROM JMRstJobInfo RST
																  INNER JOIN JMJobInfo INF ON RST.jobId = INF.jobId AND RST.commcellId = INF.commcellId
																  WHERE RST.rstattributes & 0x100 <> 0 AND
																  RST.destClientId IN (SELECT destClientId FROM App_SyncCloudStats STAT6 WITH (NOLOCK)
																					   WHERE STAT6.syncWebFolderId = SYNC.syncWebFolderId)
																  AND RST.commcellId =2
																  AND INF.state IN (1))
													THEN 3 -- Restore running
												ELSE 2 -- Restore job pending\waiting or stuck
												END
										ELSE 2 -- Pending.
									END) AS '@syncStatus',
									(SELECT
										DISTINCT SYNC.syncWebFolderId  AS '@syncWebFolderId',
										SYNC.syncWebFolderName AS '@syncWebFolderName'
										FOR XML PATH('syncWebFolder'), TYPE
									),
									(SELECT
										SYNC.ownerId AS '@userId'
										FOR XML PATH('syncOwner'), TYPE
									),
									(SELECT
										(SELECT
											CL.id AS '@clientId',
											CL.displayName AS '@clientName'
											FOR XML PATH('client'), TYPE
										)
										FROM App_SyncCloudConfig CONFIG WITH (NOLOCK)
INNER JOIN App_Client CL WITH (NOLOCK) ON CONFIG.clientId = CL.id AND CONFIG.flag & 0x1 = 0
										WHERE CONFIG.syncWebFolderId = SYNC.syncWebFolderId
										FOR XML PATH('associatedClients'), TYPE
									)
									FROM App_SyncCloudFolder SYNC WITH (NOLOCK)
									WHERE SYNC.ownerId = @i_userId
AND (SYNC.flag & (CAST(0x4 AS INT)|CAST(0x8 AS INT)
|CAST(0x10 AS INT)|CAST(0x80 AS INT)) = 0)
ORDER BY (SYNC.flag & 0x2), SYNC.syncWebFolderName ASC
									FOR XML PATH('syncInfos'), ROOT('App_GetSyncWebFolderResp')
								)
							)
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<App_GetSyncWebFolderResp/>'
			INSERT INTO @templateTbl
			SELECT 0, '', 0, value FROM GXGlobalParam
			WHERE name = 'Sync Folder Template'
			AND modified=0
			UPDATE @templateTbl
			SET syncWebFolderId = templateXML.value('data(/syncInfos/syncWebFolder/@syncWebFolderId)[1]', 'INT'),
			syncWebFolderName = templateXML.value('data(/syncInfos/syncWebFolder/@syncWebFolderName)[1]', 'NVARCHAR(MAX)'),
			syncFolderFlag = templateXML.value('data(/syncInfos/@flag)[1]', 'NVARCHAR(MAX)')
			-- Remove the templates that are already active
			DELETE FROM @templateTbl
			FROM @templateTbl TMP
			INNER JOIN App_SyncCloudFolder SYNC ON TMP.syncWebFolderName = SYNC.syncWebFolderName
			INNER JOIN App_SyncCloudFolders SFV ON SYNC.syncWebFolderId = SFV.SyncWebFolderId --MR 156620
			WHERE SYNC.ownerId = @i_userId AND SFV.FLAG = 0
			-- Get All defaults for Associations
			SET @assocXML = (	SELECT
										(SELECT
											CL.clientId AS '@clientId',
											CL.clientName AS '@clientName'
										FOR XML PATH('client'), TYPE
										)
								FROM @clientList CL
								FOR XML PATH('associatedClients'), TYPE
							)
			-- Add the template web folders from the GxGlobalParam table for this user with default associations
			DECLARE GetFolderTemplates CURSOR
			FOR
				SELECT templateXML FROM @templateTbl
WHERE syncFolderFlag & 0x10 = 0 -- Exclude edge drive
				ORDER BY syncWebFolderName DESC
			OPEN GetFolderTemplates
			FETCH GetFolderTemplates INTO @templateXML
			WHILE @@FETCH_STATUS = 0
			BEGIN
				-- Delete the dummy association
				SET @templateXML.modify('delete /syncInfos/associatedClients')
				-- Add the new association
				SET @templateXML.modify('insert sql:variable("@assocXML") as last into (/syncInfos)[1]')
				-- Set owner
				SET @templateXML.modify('replace value of (/syncInfos/syncOwner/@userId)[1] with sql:variable("@i_userId")')
				-- Insert it at the start in response
				SET @o_xmlString.modify('insert sql:variable("@templateXML") as first into (/App_GetSyncWebFolderResp)[1]')
				FETCH GetFolderTemplates INTO @templateXML
			END
			CLOSE GetFolderTemplates
			DEALLOCATE GetFolderTemplates
	END
ERROR_EXIT:
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<App_GetSyncWebFolderResp/>'
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetWebFolders')
	delete from GxQscripts where name = 'AppSyncGetWebFolders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetWebFolders')
	delete from GXDBVersions where aliasname = 'AppSyncGetWebFolders'
GO

insert into GXDBVersions values(2, 'AppSyncGetWebFolders',  '00000000000000000000', 'AppSyncGetWebFolders', '00000000000000000000')
GO

