

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncGetUserMap.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppSyncGetUserMap()
--  | Description:  Get user information given local username
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSyncGetUserMap.sp,v $ $Id: AppSyncGetUserMap.sp,v 1.4.44.2 2018/03/27 08:15:20 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetUserMap <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetUserMap')
	drop procedure AppSyncGetUserMap
IF EXISTS (select * from GxQscripts where name='AppSyncGetUserMap')
	delete from GxQscripts where name = 'AppSyncGetUserMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetUserMap')
	delete from GXDBVersions where aliasname = 'AppSyncGetUserMap'
GO
print '... Creating Procedure: AppSyncGetUserMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetUserMap
  @i_xmlText XML
AS
  DECLARE @o_ErrorCode integer=0
  DECLARE @o_ErrorString NVARCHAR(1024)
  DECLARE @o_xmlText XML	
BEGIN
	DECLARE @i_userName		NVARCHAR(1024)
	DECLARE @i_clientId		INT
	SET @o_ErrorCode = 0
	SET @o_xmlText = '<App_GetSyncUserMapResp />'
	SET @i_userName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('App_GetSyncUserMapReq/user') R ( ref ) ), '')
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
						FROM @i_xmlText.nodes('App_GetSyncUserMapReq/client') R ( ref ) ), 0)
	IF LEN(@i_userName) = 0
	BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorString = 'User Name is empty'
			GOTO EXIT_PROC
	END
	IF @i_clientId = 0
	BEGIN
			SET @o_ErrorCode = 2
			SET @o_ErrorString = 'Client Id Not Found'
			GOTO EXIT_PROC
	END
	DECLARE @userId INT = ISNULL((SELECT TOP 1 umUserId FROM UMClientUserMap WHERE localUserLogin = @i_userName AND clientId = @i_clientId AND umUserId <> 0),0)
	IF @userId =0
	BEGIN
		SET @o_ErrorCode = 3
		SET @o_ErrorString = 'UserId not found for username ' + @i_userName
		GOTO EXIT_PROC
	END
	DECLARE @userName		NVARCHAR(1024) = (SELECT login FROM UMUsers WHERE id = @userId)
	DECLARE @capabilities BIGINT = 0
	EXEC sec_updateUserCredentials @userId, 1
	IF object_id('tempdb.dbo.#AppSyncGetUserMap_userObjects') is not null 		DROP TABLE #AppSyncGetUserMap_userObjects
create table  #AppSyncGetUserMap_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId,0,0,'#AppSyncGetUserMap_userObjects'
	SELECT @capabilities =@capabilities|capabilities
	FROM #AppSyncGetUserMap_userObjects
	IF object_id('tempdb.dbo.#AppSyncGetUserMap_userObjects') is not null 		DROP TABLE #AppSyncGetUserMap_userObjects
	SET @o_xmlText =
	(
		SELECT @capabilities '@capabilities',
				(
					SELECT @userId '@userId',
						   @userName '@userName'
					FOR XML PATH ('user'), TYPE
				)
		FOR XML PATH ('App_GetSyncUserMapResp'), TYPE
	)
EXIT_PROC:
	IF @o_ErrorCode > 0
	BEGIN
		SET @o_xmlText =
		(
			SELECT @o_ErrorCode '@errorCode',
					@o_ErrorString '@errorMessage'
			FOR XML PATH ('error'), ROOT('App_GetSyncUserMapResp')
		)
	END
	SELECT @o_xmlText
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetUserMap')
	delete from GxQscripts where name = 'AppSyncGetUserMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetUserMap')
	delete from GXDBVersions where aliasname = 'AppSyncGetUserMap'
GO

insert into GXDBVersions values(2, 'AppSyncGetUserMap',  '00010004004400020000', 'AppSyncGetUserMap', '00010004004400020000')
GO

