

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncGetSyncList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSyncGetSyncList						|
--	|			Procedure for getting list of eligible restore jobs	|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetSyncList <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetSyncList')
	drop procedure AppSyncGetSyncList
IF EXISTS (select * from GxQscripts where name='AppSyncGetSyncList')
	delete from GxQscripts where name = 'AppSyncGetSyncList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetSyncList')
	delete from GXDBVersions where aliasname = 'AppSyncGetSyncList'
GO
print '... Creating Procedure: AppSyncGetSyncList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetSyncList
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
AS
  DECLARE @sourceSubclientId INT
  DECLARE @destClientId INT
  DECLARE @syncWebfolders NVARCHAR(MAX)
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @syncWaitTime INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='secondsToWaitToStartSyncJobAfterBackup'), 0)
	DECLARE @maxRetryCount INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='maximunNumberToRetryFailedSyncJobs'), 5)
	DECLARE @now INT = (SELECT dbo.GetUnixTime(GETUTCDATE()))
	DECLARE @outPutTbl TABLE
	(sourceSubclientId int, destClientId INT, destPhysicalClientId INT, syncWebFolderId INT)
	IF OBJECT_ID('tempdb.dbo.#cloudStatsPhysicalClientTbl') IS NOT NULL
		DROP TABLE #cloudStatsPhysicalClientTbl
	CREATE TABLE #cloudStatsPhysicalClientTbl (
		destClientId			INT,
		destPhysicalClientId	INT
	)
	--
		INSERT INTO #cloudStatsPhysicalClientTbl
		SELECT DISTINCT CS.destClientId, ISNULL(UCPC.PhysicalClientId, CS.destClientId) as 'destPhysicalClientId'
		FROM App_SyncCloudStats CS (NOLOCK)
		LEFT OUTER JOIN
		(
			SELECT DISTINCT UC.componentNameId as 'UserCentricClientId',pc.attrVal as 'PhysicalClientId'
			FROM APP_ClientProp UC (NOLOCK)
			INNER JOIN APP_ClientProp PC (NOLOCK) ON UC.componentNameId = PC.componentNameId AND PC.modified = 0 AND PC.attrName = 'Physical Client Id'
			WHERE UC.attrName = 'User Centric Client'
		) UCPC
		ON CS.destClientId = UCPC.UserCentricClientId
	INSERT INTO @outPutTbl
	SELECT DISTINCT CS.sourceSubclientId, CS.destClientId, CSPC.destPhysicalClientId, CS.syncWebFolderId FROM App_SyncCloudStats CS
	JOIN JMBkpStats JS WITH (NOLOCK) ON JS.appId = CS.sourceSubclientId AND JS.status IN (1 /*JMSUCCESS*/) --, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
	JOIN App_SyncCloudConfig CF WITH (NOLOCK) ON CS.syncWebFolderId = CF.syncWebFolderId
	JOIN App_SyncCloudFolder SYNC WITH (NOLOCK) ON CS.syncWebFolderId = SYNC.syncWebFolderId
	JOIN #cloudStatsPhysicalClientTbl CSPC ON CS.destClientId = CSPC.destClientId
	JOIN CCRClientToClient CCR WITH (NOLOCK) ON CCR.FromClientId = 2 AND CCR.ToClientId = CS.destClientId
	LEFT OUTER JOIN JMRestoreStats JR WITH (NOLOCK) ON JR.jobId = CF.lastRestoreSyncJobId
	WHERE CS.syncStatus = 0 /*NEEDS_SYNC*/ AND CS.currentRestoreJobId = 0 AND @now > (JS.servEndDate + @syncWaitTime)
	AND (@now > ISNULL((JR.servEndTime),0) + 5*POWER(3, CS.retryCount)*60) AND CS.retryCount <= @maxRetryCount
	AND CCR.Flag = 1 -- Client has to be online.
AND SYNC.flag & 0x10 = 0
	SELECT  OP1.sourceSubclientId, OP1.destClientId, OP1.destPhysicalClientId, syncWebfolders = STUFF((SELECT ', ' + CAST(syncWebFolderId AS NVARCHAR(MAX))
																		  FROM @outPutTbl OP2
																		  WHERE OP1.sourceSubclientId = OP2.sourceSubclientId
																		  AND OP1.destClientId = OP2.destClientId
																		  FOR XML PATH('')), 1, 2, '')
	FROM @outPutTbl OP1
	GROUP BY OP1.sourceSubclientId, OP1.destClientId, OP1.destPhysicalClientId
	IF OBJECT_ID('tempdb.dbo.#cloudStatsPhysicalClientTbl') IS NOT NULL
		DROP TABLE #cloudStatsPhysicalClientTbl
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetSyncList')
	delete from GxQscripts where name = 'AppSyncGetSyncList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetSyncList')
	delete from GXDBVersions where aliasname = 'AppSyncGetSyncList'
GO

insert into GXDBVersions values(2, 'AppSyncGetSyncList',  '00000000000000000000', 'AppSyncGetSyncList', '00000000000000000000')
GO

