

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncGetJobReqInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSyncGetJobReqInfo.sp,v $ $Id: AppSyncGetJobReqInfo.sp,v 1.20.80.2 2017/02/10 21:04:46 sjohnson Exp $";
---- =============================================
---- Author:		Sergio Bonilla
---- Create date:	03/10/2012
---- Description:	Get the information to start a Sync job.
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetJobReqInfo <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetJobReqInfo')
	drop procedure AppSyncGetJobReqInfo
IF EXISTS (select * from GxQscripts where name='AppSyncGetJobReqInfo')
	delete from GxQscripts where name = 'AppSyncGetJobReqInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetJobReqInfo')
	delete from GXDBVersions where aliasname = 'AppSyncGetJobReqInfo'
GO
print '... Creating Procedure: AppSyncGetJobReqInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetJobReqInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_sourceSubClientId integer,
  @i_destClientID integer
AS
  DECLARE @srcClientId INT
  DECLARE @srcApplicationId INT
  DECLARE @srcInstanceId INT
  DECLARE @srcBackupSetId INT
  DECLARE @srcSubClientId INT
  DECLARE @srcItems NVARCHAR(MAX)
  DECLARE @useMapFile INT
  DECLARE @ownerId INT
  DECLARE @toTime INT
  DECLARE @fromTime INT
  DECLARE @destClientId INT
  DECLARE @destPath NVARCHAR(MAX)
  DECLARE @syncJobFlags INT
  DECLARE @syncWebfolders NVARCHAR(MAX)
  DECLARE @sourceConfigOptions NVARCHAR(MAX)
  DECLARE @destConfigOptions NVARCHAR(MAX)
BEGIN
	DECLARE @lastSuccessSyncJobId	BIGINT
	DECLARE @userMarker				NVARCHAR(MAX) = '!#22!' --USERPROFILEMARKER defined in ClientSyncConfig.h
	DECLARE @pathPairs TABLE
	(
		syncWebFolderId INT,
		sourceClient INT,
		sourceSubclient INT,
		sourcePath nvarchar(MAX),
		expandedSourcePath nvarchar(MAX),
		destClient INT,
		destPath nvarchar(MAX),
		umUserId INT,
		sourceConfigOptions XML,
		destConfigOptions XML
	)
	DECLARE @outPutTbl TABLE
	(srcClientId		INT,
	 srcApplicationId	INT,
	 srcInstanceId		INT,
	 srcBackupSetId		INT,
	 srcSubClientId		INT,
	 srcItems			NVARCHAR(MAX),
	 useMapFile			INT,
	 ownerId			INT,
	 toTime				INT,
	 fromTime			INT,
	 destClientId		INT,
	 destPath			NVARCHAR(MAX),
	 syncJobFlags		INT,
	 syncWebfolders		NVARCHAR(MAX),
	 sourceConfigOptions XML,
	 destConfigOptions XML
	)
	-- Note : Do not join with App_SyncCloudFolder as it may be across web folders.
	SELECT	@srcClientId=APP.clientId,
			@srcApplicationId=APP.appTypeId,
			@srcInstanceId=APP.instance,
			@srcBackupSetId=APP.backupSet,
			@srcSubClientId=APP.id,
			@destClientId=@i_destClientID,
			@syncJobFlags = 0
			--@syncJobFlags =	(CASE SCPROP.attrVal
				--			 WHEN '1' THEN ISNULL(@syncJobFlags, 0) | SYNC_JOB_ONE_PASS_SUBCLIENT
					--		 ELSE ISNULL(@syncJobFlags, 0)
						--	 END)
	FROM APP_Application APP WITH (NOLOCK)
	--LEFT OUTER JOIN APP_SubClientProp SCPROP WITH (NOLOCK)
		--ON APP.id = SCPROP.componentNameId AND SCPROP.modified = 0 AND SCPROP.attrName = 'Is Turbo Subclient' --CV_IS_SUBCLIENT_TURBO
	WHERE APP.id = @i_sourceSubClientId
	SET @ownerId = ISNULL((SELECT TOP 1 id
							FROM UMUsers
							WHERE flags & 1 = 1 AND enabled = 1 AND id IN (SELECT ownerId FROM App_SyncCloudFolder CF INNER JOIN App_SyncCloudStats STAT
									ON CF.syncWebFolderId = STAT.syncWebFolderId
									AND STAT.sourceSubclientId = @i_sourceSubclientId AND STAT.destClientId = @i_destClientID)),0)
	-- Oldest job is success job
	SET @lastSuccessSyncJobId = ISNULL((SELECT TOP 1 0
										FROM App_SyncCloudStats
										WHERE sourceSubclientId = @i_sourceSubClientId
												AND destClientId = @i_destClientID
												AND lastSuccessSyncJobId = 0),
										(SELECT TOP 1(BKP.jobId)
	FROM App_SyncCloudStats STAT WITH (NOLOCK)
	INNER JOIN JMBkpStats BKP WITH (NOLOCK) ON STAT.lastSuccessSyncJobId = BKP.jobId AND BKP.commCellId=2
	WHERE STAT.sourceSubClientId = @i_sourceSubClientId
	AND STAT.destClientId = @i_destClientID
										ORDER BY BKP.servEndDate ASC))
	--
	INSERT INTO @pathPairs
	SELECT DISTINCT STAT.syncWebFolderId, S.clientId, S.subclientId,  S.syncPath, S.syncPath, D.clientId, D.syncPath, WF.ownerId, CAST(S.configOptions as NVARCHAR(MAX)), CAST(D.configOptions as NVARCHAR(MAX))
	FROM App_SyncCloudStats STAT
	INNER JOIN App_SyncCloudConfig S ON STAT.sourceSubclientId = S.subclientId
		AND STAT.syncWebFolderId = S.syncWebFolderId
		AND S.syncType & 1 = 1 -- Sync Source
		--AND S.flag & SYNC_PAUSED = 0 -- Not paused
AND S.flag & 0x2 = 0 -- Not All Content
AND S.flag & 0x4 = 0 -- Not Wild Card
	INNER JOIN App_SyncCloudConfig D ON STAT.destClientId = D.clientId
		AND STAT.syncWebFolderId = D.syncWebFolderId
		AND S.syncConfigId <> D.syncConfigId
		AND D.syncType & 2 = 2 -- Sync Destination
AND D.flag & 0x1 = 0 -- Not paused
INNER JOIN App_SyncCloudFolder WF ON S.syncWebFolderId = WF.syncWebFolderId AND WF.flag & 0x1 = 0
	AND S.syncWebFolderId = D.syncWebFolderId
	WHERE STAT.sourceSubClientId = @i_sourceSubClientId
	AND STAT.destClientId = @i_destClientID
	AND STAT.syncStatus <> 2 AND STAT.currentRestoreJobId = 0
	-- This is needed for monickers expansion in source path.
	-- Make the username uppercase for windows so that we can do case insensitive search in indexing
	-- For unix, strip the machinename/ad domain name
	UPDATE @pathPairs
	SET expandedSourcePath =  '{20d03aa2-7726-42d8-8381-fdda7a8a1c47}' + IDA.dirDelim + 'SmartContent' + IDA.dirDelim +
		(CASE dbo.scgGetClientOSType(CU.clientId)
		 WHEN 1 THEN LOWER(CU.localUserLogin)
		 ELSE LOWER(SUBSTRING(CU.localUserLogin,CHARINDEX('\',CU.localUserLogin)+1,LEN(CU.localUserLogin)))
		 END)
		 + sourcePath  -- defineBROWSE_VIEW_DIRECTORY_NAME in irestore.h
	FROM @pathPairs PP
	INNER JOIN UMClientUserMap CU ON CU.clientId = PP.sourceClient AND CU.umUserId = PP.umUserId
	INNER JOIN App_Application APP WITH (NOLOCK) ON APP.id = PP.sourceSubclient
	INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON APP.appTypeId = IDA.type
	WHERE sourcePath LIKE '[\/]#%%#%' ESCAPE '#'
	-- Moniker Expansion Support in map file
--
	UPDATE @pathPairs
	SET sourcePath = @userMarker +
		(CASE dbo.scgGetClientOSType(CU.clientId)
		 WHEN 1 THEN LOWER(CU.localUserLogin)
		 ELSE LOWER(SUBSTRING(CU.localUserLogin,CHARINDEX('\',CU.localUserLogin)+1,LEN(CU.localUserLogin)))
		 END)
		 + '|' + sourcePath
	FROM @pathPairs PP
	INNER JOIN UMClientUserMap CU ON CU.clientId = PP.sourceClient AND CU.umUserId = PP.umUserId
	WHERE sourcePath LIKE '[\/]#%%#%' ESCAPE '#'
	--
	UPDATE @pathPairs
	SET destPath = @userMarker +
		(CASE dbo.scgGetClientOSType(CU.clientId)
		 WHEN 1 THEN LOWER(CU.localUserLogin)
		 ELSE LOWER(SUBSTRING(CU.localUserLogin,CHARINDEX('\',CU.localUserLogin)+1,LEN(CU.localUserLogin)))
		 END)
		 + '|' + destPath
	FROM @pathPairs PP
	INNER JOIN UMClientUserMap CU ON CU.clientId = PP.destClient AND CU.umUserId = PP.umUserId
	WHERE destPath LIKE '[\/]#%%#%' ESCAPE '#'
	-- Calculate the from and to times common for all jobs
	SET @toTime = ISNULL((	SELECT TOP 1 servEndDate FROM JMBkpStats WITH (NOLOCK) WHERE appId = @srcSubClientId
							AND commCellId = 2 /*DEFAULT_COMM_CELL_ID*/ AND status IN (1 /*JMSUCCESS*/) --, 3 /*PARTIALSUCCESS*/, 14 /*JMSUCCESSWITHWARNINGS*/)
							AND totalNumOfFiles > 0
							ORDER BY servEndDate DESC ), 0)
	SET @fromTime = ISNULL((SELECT servEndDate FROM JMBkpStats WITH (NOLOCK) WHERE jobId= @lastSuccessSyncJobId), 0)
--
--
	IF @fromTime = @toTime AND @fromTime > 0 AND @toTime > 0
	BEGIN
		SET @fromTime = ISNULL((SELECT servStartDate FROM JMBkpStats WITH (NOLOCK) WHERE jobId= @lastSuccessSyncJobId), 0)
	END
	-- For now - Blindly set it to null until we have some valid source options in place
	UPDATE @pathPairs
	SET sourceConfigOptions = null
	-- For now only filterCriteria is used, so if it is not present make it null
	UPDATE @pathPairs
	SET destConfigOptions = null
	WHERE destConfigOptions.exist('/syncOptions/destinationOptions/filterCriteria') = 0
	IF NOT EXISTS(SELECT 1 FROM @pathPairs)
	BEGIN
		GOTO PROC_END
	END
	/* Use Map File always
	IF ((SELECT COUNT(*) FROM @pathPairs) = 1)
	BEGIN
		SELECT @destPath = destPath FROM @pathPairs
		SET @useMapFile = 0
	END
	*/
	ELSE
	BEGIN
		-- Initialize variables
		SET @srcItems = ''
		SET @syncWebfolders = ''
		SET @useMapFile = 1
		-- First lets merge all sync folders without any config options into a single job if exists
		IF EXISTS(SELECT 1 FROM @pathPairs WHERE sourceConfigOptions is null AND destConfigOptions is null)
		BEGIN
			SELECT @destPath = ( SELECT(
										SELECT sourcePath AS '@sourcePath',
										destPath AS '@destinationPath'
										FROM @pathPairs
										WHERE sourceConfigOptions is null AND destConfigOptions is null
										FOR XML PATH('paths'), TYPE
										)
								 FOR XML PATH('syncOption')
								)
			SELECT @srcItems = expandedSourcePath + ',' + @srcItems,
				   @syncWebfolders = CAST(syncWebFolderId AS NVARCHAR(MAX)) + ',' + @syncWebfolders
			FROM @pathPairs
			WHERE sourceConfigOptions is null AND destConfigOptions is null
			INSERT INTO @outPutTbl
				SELECT	@srcClientId, @srcApplicationId, @srcInstanceId, @srcBackupSetId, @srcSubClientId,
						CASE
						WHEN @srcItems IS null THEN @srcItems
						WHEN @srcItems ='' THEN @srcItems
						ELSE SUBSTRING(@srcItems, 1, LEN(@srcItems)-1)
						END,
						@useMapFile, @ownerId, @toTime, @fromTime,	@destClientId, @destPath, @syncJobFlags, SUBSTRING(@syncWebfolders, 1, LEN(@syncWebfolders)-1), ISNULL(@sourceConfigOptions, ''), ISNULL(@destConfigOptions, '')
		END
		-- Now iterate over the path pairs for folders with config options and calculate its paths
		DECLARE @currentSyncFolderId INT = 0
		DECLARE GetSyncFolderWithOptions CURSOR
		FOR SELECT syncWebfolderId FROM @pathPairs WHERE sourceConfigOptions is not null OR destConfigOptions is not null
		OPEN GetSyncFolderWithOptions
		FETCH GetSyncFolderWithOptions INTO @currentSyncFolderId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @srcItems = ''
			SET @syncWebfolders = ''
			SELECT @destPath = ( SELECT(
									SELECT sourcePath AS '@sourcePath',
									destPath AS '@destinationPath'
									FROM @pathPairs
									WHERE syncWebFolderId =  @currentSyncFolderId
									FOR XML PATH('paths'), TYPE
									)
							 FOR XML PATH('syncOption')
							)
			FROM @pathPairs
			WHERE syncWebFolderId =  @currentSyncFolderId
			SELECT @syncWebfolders = CAST(syncWebFolderId AS NVARCHAR(MAX)) + ',' + @syncWebfolders,
				   @srcItems = expandedSourcePath + ',' + @srcItems,
				   @sourceConfigOptions = CAST(sourceConfigOptions AS NVARCHAR(MAX)),
				   @destConfigOptions = CAST(destConfigOptions AS NVARCHAR(MAX))
			FROM @pathPairs
			WHERE syncWebFolderId =  @currentSyncFolderId
			INSERT INTO @outPutTbl
			SELECT	@srcClientId, @srcApplicationId, @srcInstanceId, @srcBackupSetId, @srcSubClientId,
					CASE
					WHEN @srcItems IS null THEN @srcItems
					WHEN @srcItems ='' THEN @srcItems
					ELSE SUBSTRING(@srcItems, 1, LEN(@srcItems)-1)
					END,
					@useMapFile, @ownerId, @toTime, @fromTime,	@destClientId, @destPath, @syncJobFlags, SUBSTRING(@syncWebfolders, 1, LEN(@syncWebfolders)-1), ISNULL(@sourceConfigOptions, ''), ISNULL(@destConfigOptions, '')
			FETCH GetSyncFolderWithOptions INTO @currentSyncFolderId
		END
		CLOSE GetSyncFolderWithOptions
		DEALLOCATE GetSyncFolderWithOptions
	END
	/*
	-- All content support
	IF EXISTS (SELECT 1
			   FROM App_SyncCloudStats STAT WITH (NOLOCK)
			   INNER JOIN App_SyncCloudConfig S WITH (NOLOCK) ON STAT.sourceSubclientId = S.subclientId
					AND S.syncType & 1 = 1 -- Sync Source
AND S.flag & 0x1 = 0 -- Not paused
AND S.flag & 0x2 <> 0 -- All Content
			   WHERE STAT.sourceSubClientId = @i_sourceSubClientId
			   AND STAT.destClientId = @i_destClientID AND STAT.currentRestoreJobId = 0 )
	BEGIN
		-- Restore all the content to destination in place.
		SET @srcItems = '\\'
		SET @destPath = '@@SYNC_IN_PLACE@@'
		SET @useMapFile = 0
		INSERT INTO @outPutTbl
		SELECT	@srcClientId, @srcApplicationId, @srcInstanceId, @srcBackupSetId, @srcSubClientId,
				CASE
				WHEN @srcItems IS null THEN @srcItems
				WHEN @srcItems ='' THEN @srcItems
				ELSE SUBSTRING(@srcItems, 1, LEN(@srcItems)-1)
				END,
				@useMapFile, @ownerId, @toTime, @fromTime,	@destClientId, @destPath
	END
	*/
PROC_END:
	 SELECT	srcClientId, srcApplicationId, srcInstanceId, srcBackupSetId, srcSubClientId,
			srcItems, useMapFile,	ownerId, toTime, fromTime, destClientId, destPath, syncJobFlags, syncWebfolders, sourceConfigOptions, destConfigOptions
	 FROM @outPutTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetJobReqInfo')
	delete from GxQscripts where name = 'AppSyncGetJobReqInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetJobReqInfo')
	delete from GXDBVersions where aliasname = 'AppSyncGetJobReqInfo'
GO

insert into GXDBVersions values(2, 'AppSyncGetJobReqInfo',  '00010020008000020000', 'AppSyncGetJobReqInfo', '00010020008000020000')
GO

