

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncGetClientsUserProfiles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSyncGetClientsUserProfiles							|
--	|  Procedure to get a list of client user profiles as well as the mapped user profile	|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetClientsUserProfiles <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetClientsUserProfiles')
	drop procedure AppSyncGetClientsUserProfiles
IF EXISTS (select * from GxQscripts where name='AppSyncGetClientsUserProfiles')
	delete from GxQscripts where name = 'AppSyncGetClientsUserProfiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetClientsUserProfiles')
	delete from GXDBVersions where aliasname = 'AppSyncGetClientsUserProfiles'
GO
print '... Creating Procedure: AppSyncGetClientsUserProfiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetClientsUserProfiles
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	--DECLARE @clientId			INT = ISNULL (( SELECT ref.value('@clientId', 'INT')
	--													FROM @i_xmlString.nodes ('App_GetClientsUserProfilesReq/client') R(ref)), '0')
	DECLARE @clientTbl			TABLE(clientId INT)
	INSERT INTO @clientTbl(clientId)
		(SELECT ref.value('@clientId', 'INT')
			FROM @i_xmlString.nodes ('App_GetClientsUserProfilesReq/clients') R(ref))
	-- Form the XML response
	SET @o_xmlString =	(SELECT
							(CASE
								WHEN EXISTS (SELECT 1 FROM simInstalledPackages P WITH (NOLOCK)
									WHERE P.ClientId = CL.id AND (CL.releaseId > 16 OR (CL.releaseId = 16 AND P.HighestSP >= 7))) THEN 1
								ELSE 0
							 END) AS '@supportsACLUploads',
							(SELECT
									CL.id AS '@clientId',
									CL.name AS '@clientName'
									FOR XML PATH('client'), TYPE
							),
							(SELECT
									ULP.localUserLogin AS '@localUserProfile',
									UM.id AS 'registeredUser/@userId',
									UM.login AS 'registeredUser/@userName'
								FROM UMClientUserMap ULP
								INNER JOIN UMUsers UM ON ULP.umUserId = UM.id --AND UM.id = @i_userId
								WHERE ULP.clientId = CL.id
								FOR XML PATH('userProfilesMap'), TYPE
							)
							FROM App_Client CL WITH (READUNCOMMITTED)
							INNER JOIN @clientTbl CL1  ON CL.id = CL1.clientId
							FOR XML PATH('clientUserProfiles'), ROOT('App_GetClientsUserProfilesResp')
						)
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<App_GetClientsUserProfilesResp />'
ERROR_EXIT:
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<App_GetClientsUserProfilesResp />'
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetClientsUserProfiles')
	delete from GxQscripts where name = 'AppSyncGetClientsUserProfiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetClientsUserProfiles')
	delete from GXDBVersions where aliasname = 'AppSyncGetClientsUserProfiles'
GO

insert into GXDBVersions values(2, 'AppSyncGetClientsUserProfiles',  '00000000000000000000', 'AppSyncGetClientsUserProfiles', '00000000000000000000')
GO

