

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncGetClientUserProfile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSyncGetClientUserProfile							|
--	|  Procedure to get a list of client user profiles as well as the mapped user profile	|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetClientUserProfile <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetClientUserProfile')
	drop procedure AppSyncGetClientUserProfile
IF EXISTS (select * from GxQscripts where name='AppSyncGetClientUserProfile')
	delete from GxQscripts where name = 'AppSyncGetClientUserProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetClientUserProfile')
	delete from GXDBVersions where aliasname = 'AppSyncGetClientUserProfile'
GO
print '... Creating Procedure: AppSyncGetClientUserProfile'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetClientUserProfile
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @clientId			INT = ISNULL (( SELECT ref.value('@clientId', 'INT')
														FROM @i_xmlString.nodes ('App_GetClientUserProfileReq/client') R(ref)), '0')
	DECLARE @clientTbl			TABLE(clientId INT)
	-- If client id is 0, get all clients.
	IF (@clientId = 0)
	BEGIN
		INSERT @clientTbl
		SELECT um.clientId
		FROM   UMOwnerCredentials um
		INNER JOIN App_Client CL WITH(NOLOCK) ON CL.id = um.clientId AND CL.status&4096=4096 AND CL.status & 2 = 0
		INNER JOIN APP_IDAName IDA WITH(NOLOCK) ON IDA.clientId = um.clientId and  ( IDA.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) and IDA.appTypeId <> 13)
		WHERE um.userId = @i_userId
	END
	ELSE
	BEGIN
		IF NOT EXISTS (SELECT 1
		FROM   UMOwnerCredentials um
		INNER JOIN App_Client CL ON CL.id = um.clientId
		WHERE um.userId = @i_userId)
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error : User is not an owner of the client'
			GOTO ERROR_EXIT
		END
		INSERT INTO @clientTbl
		VALUES(@clientId)
	END
	-- Form the XML response
	SET @o_xmlString =	(
								(SELECT
									(SELECT
											CL.id AS '@clientId',
											CL.name AS '@clientName'
											FOR XML PATH('client'), TYPE
									),
									(SELECT
											ULP.localUserLogin AS '@localUserProfile',
											UM.id AS 'registeredUser/@userId',
											UM.login AS 'registeredUser/@userName'
										FROM UMClientUserMap ULP
										INNER JOIN UMUsers UM ON ULP.umUserId = UM.id AND UM.id = @i_userId
										WHERE ULP.clientId = CL.id
										FOR XML PATH('userProfileMap'), TYPE
									),
									(SELECT
										DISTINCT USR.localUserLogin AS '@val'
										FROM UMClientUserMap USR WITH (READUNCOMMITTED) WHERE USR.clientId = CL.id
										FOR XML PATH('availableUserProfiles'), TYPE
									)
									FROM App_Client CL WITH (READUNCOMMITTED)
									INNER JOIN @clientTbl CL2  ON CL.id = CL2.clientId
									FOR XML PATH('clientUserProfiles'), ROOT('App_GetClientUserProfileResp')
								)
							)
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<App_GetClientUserProfileResp />'
ERROR_EXIT:
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<App_GetClientUserProfileResp />'
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetClientUserProfile')
	delete from GxQscripts where name = 'AppSyncGetClientUserProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetClientUserProfile')
	delete from GXDBVersions where aliasname = 'AppSyncGetClientUserProfile'
GO

insert into GXDBVersions values(2, 'AppSyncGetClientUserProfile',  '00000000000000000000', 'AppSyncGetClientUserProfile', '00000000000000000000')
GO

