

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncGetClientContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+=======================================================================+
--	|  							AppSyncGetClientContent								|
--	|  Procedure to resume the sync configuration at client or folder level	|
--	+=======================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetClientContent <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetClientContent')
	drop procedure AppSyncGetClientContent
IF EXISTS (select * from GxQscripts where name='AppSyncGetClientContent')
	delete from GxQscripts where name = 'AppSyncGetClientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetClientContent')
	delete from GXDBVersions where aliasname = 'AppSyncGetClientContent'
GO
print '... Creating Procedure: AppSyncGetClientContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetClientContent
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	SET @o_xmlString = ''
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	-- Read the XML
	DECLARE @inClientId			INT	= ISNULL (( SELECT ref.value('@clientId', 'INT')
														FROM @i_xmlString.nodes ('App_GetSyncClientContentReq/client') R(ref)), 0)
	DECLARE @subclientId		INT = ISNULL (( SELECT ref.value('@subclientId', 'INT')
														FROM @i_xmlString.nodes ('App_GetSyncClientContentReq/client') R(ref)), 0)
	DECLARE @assocSCId			INT = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified = 0 AND  attrName = N'Associated subclient Policy'),'0')
	DECLARE @content table
	(
		fileName nvarchar(1024),
		type int
	)
	INSERT INTO @content
	SELECT fileName,  MAX(type) FROM
	(
		SELECT componentNameId, fileName, 0 type
		FROM APP_ScFilterFile
		WHERE componentNameId = @subclientId AND modified = 0 AND type = 1 --CV_CONTENT
		UNION
		SELECT componentNameId, fileName, 0 type
		FROM APP_ScFilterFile
		WHERE componentNameId = @assocSCId AND modified = 0 AND type = 1 --CV_CONTENT
		UNION
		SELECT SC.subclientId, SC.syncPath, 1 type
		FROM App_SyncCloudConfig SC
		JOIN App_SyncCloudFolder SF ON SF.syncWebFolderId = SC.syncWebFolderId
		WHERE SF.ownerId = @i_userId
		AND subclientId = @subclientId --AND flag&1=0
		AND syncType in (1, 3)
	) A GROUP BY A.fileName
	SET @o_xmlString = (SELECT
						(SELECT type as '@fromWebFolder',
							(SELECT fileName AS '@value'
								FOR XML PATH('content'),TYPE)
								FROM @content
							FOR XML PATH('contentList'),TYPE)
						FOR XML PATH('App_GetSyncClientContentResp'), TYPE)
ERROR_EXIT:
      IF LEN(ISNULL((CAST(@o_xmlString AS NVARCHAR(MAX))),'')) = 0
      BEGIN
      SET @o_xmlString = (SELECT
                                                    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString'
                                                      FOR XML PATH('response'), TYPE)
                                          FOR XML PATH('App_GetSyncClientContentResp'), TYPE)
	  END
PROC_EXIT:
      SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetClientContent')
	delete from GxQscripts where name = 'AppSyncGetClientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetClientContent')
	delete from GXDBVersions where aliasname = 'AppSyncGetClientContent'
GO

insert into GXDBVersions values(2, 'AppSyncGetClientContent',  '00000000000000000000', 'AppSyncGetClientContent', '00000000000000000000')
GO

