

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncForceSync.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+=======================================================================+
--	|  							AppSyncForceSync							|
--	|  Procedure to force the sync configuration at client or folder level	|
--	+=======================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncForceSync <<<'

IF EXISTS (select * from sysobjects where name='AppSyncForceSync')
	drop procedure AppSyncForceSync
IF EXISTS (select * from GxQscripts where name='AppSyncForceSync')
	delete from GxQscripts where name = 'AppSyncForceSync'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncForceSync')
	delete from GXDBVersions where aliasname = 'AppSyncForceSync'
GO
print '... Creating Procedure: AppSyncForceSync'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncForceSync
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	  SET @o_xmlString = ''
      DECLARE @errorCode                  INT = 0
      DECLARE @errorString          NVARCHAR(MAX) = ''
      DECLARE @nowTime              INT = dbo.GetUnixTime (GetUTCdate())
      DECLARE @templateTbl          TABLE
      (syncWebFolderId INT, templateXML XML)
      DECLARE @oscClientTbl         TABLE (clientId INT, subclientId INT)
      -- Read the XML
      DECLARE @inClientId                       INT                     = ISNULL (( SELECT ref.value('@clientId', 'INT')
                                                                                    FROM @i_xmlString.nodes ('App_ForceSyncReq/client') R(ref)), 0)
      DECLARE @inSyncWebFolderId          INT               = ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
                                                                                    FROM @i_xmlString.nodes ('App_ForceSyncReq/syncWebFolder') R(ref)), 0)
      IF NOT EXISTS(SELECT 1 FROM App_SyncCloudFolder WITH (NOLOCK) WHERE syncWebFolderId = @inSyncWebFolderId)
      BEGIN
            SET @errorCode = 1
            SET @errorString = 'Error : Invalid Web Folder Info in Force Sync Request.'
            GOTO ERROR_EXIT
      END
      BEGIN
            -- Client level Resume request
            IF @inClientId > 0
            BEGIN
                  IF NOT EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK)
                                       WHERE syncWebFolderId = @inSyncWebFolderId AND clientId = @inClientId)
                  BEGIN
                        SET @errorCode = 2
                        SET @errorString = 'Error : Invalid Client Info Client level in Force Sync Request.'
                        GOTO ERROR_EXIT
                  END
				  -- pause check
                  IF EXISTS (SELECT 1 FROM App_SyncCloudConfig WITH (NOLOCK)
                                       WHERE syncWebFolderId = @inSyncWebFolderId AND clientId = @inClientId AND flag&1=1)
                  BEGIN
                        SET @errorCode = 3
                        SET @errorString = 'Error : Client is paused in Force Sync Request.'
                        GOTO ERROR_EXIT
                  END
                  -- Mark the sync status as 0 If any restore is needed
                  UPDATE App_SyncCloudStats
                  SET syncStatus = 0, lastSuccessSyncJobId = 0, retryCount = 0
                  WHERE syncWebFolderId = @inSyncWebFolderId
                  AND (destClientId = @inClientId)
                  SELECT @errorCode = @@ERROR
                  IF @errorCode <> 0 GOTO ERROR_EXIT
            END
            -- Sync Folder level request
            ELSE
            BEGIN
                  -- pause check
				  IF EXISTS (SELECT 1 FROM App_SyncCloudFolder WITH (NOLOCK)
										WHERE syncWebFolderId = @inSyncWebFolderId AND flag&1=1)
                  BEGIN
                        SET @errorCode = 4
                        SET @errorString = 'Error : Sync Folder is paused in Force Sync Request.'
                        GOTO ERROR_EXIT
                  END
                  -- Mark the sync status as 0 If any restore is needed
                  UPDATE App_SyncCloudStats
                  SET syncStatus = 0, lastSuccessSyncJobId = 0, retryCount = 0
                  WHERE syncWebFolderId = @inSyncWebFolderId
                  SELECT @errorCode = @@ERROR
                  IF @errorCode <> 0 GOTO ERROR_EXIT
            END
      END
ERROR_EXIT:
      IF LEN(ISNULL((CAST(@o_xmlString AS NVARCHAR(MAX))),'')) = 0
      BEGIN
      SET @o_xmlString = (SELECT
                                                    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString'
                                                      FOR XML PATH('response'), TYPE),
                                                      (SELECT @inSyncWebFolderId AS '@syncWebFolderId'
                                                      FOR XML PATH('syncWebFolder'),TYPE)
                                          FOR XML PATH('App_ForceSyncResp'), TYPE)
	  END
PROC_EXIT:
      SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncForceSync')
	delete from GxQscripts where name = 'AppSyncForceSync'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncForceSync')
	delete from GXDBVersions where aliasname = 'AppSyncForceSync'
GO

insert into GXDBVersions values(2, 'AppSyncForceSync',  '00000000000000000000', 'AppSyncForceSync', '00000000000000000000')
GO

