

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncEncryptionSettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSyncEncryptionSettings.sp,v $ $Id: AppSyncEncryptionSettings.sp,v 1.1.2.4 2020/10/04 00:52:50 abilbrey Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSyncEncryptionSettings')
BEGIN
	print '>>> Drop Stored Procedure: AppSyncEncryptionSettings <<<'
	drop procedure AppSyncEncryptionSettings
END
IF EXISTS (select * from GxQscripts where name='AppSyncEncryptionSettings')
	delete from GxQscripts where name = 'AppSyncEncryptionSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncEncryptionSettings')
	delete from GXDBVersions where aliasname = 'AppSyncEncryptionSettings'
GO
print '... Creating Procedure: AppSyncEncryptionSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncEncryptionSettings
  @i_xml xml
AS
  DECLARE @o_xml xml;
DECLARE @l_errorCode INT = 0
DECLARE @l_errorMsg  nvarchar(1024) = ''
/*
	Prasad Nara, Mar 8, 2018
	Encryption settings can be defined at client, plan and company levels,
	client inherits settings from plan and company levels, below is the order for inheritance.
	1. Company - When encryption is set on company and client is not overriding settings.
	2. Plan   - When no company level encryption, encryption is set on any plan and client is not overriding settings.
	3. Client - all other cases (No company or No plan or Overriding on client).
	We set a property (entityId and type) on client from which settings are getting inherited
	This proc syncs the inheriting entity to clients when there are any changes
	1. Enabling encryption on company - clients in that company will inherit settings from company.
	2. Disabling encryption on company - clients will inherit settings from top 1 plan if there is any.
	3. Enabling encryption on plan - clients which are not inheriting from any other plan will points to this plan.
	4. Disabling encryption on plan - clients which are inheriting from this plan will repoint to other top 1 plan.
	5. Associating plan  - same as Enabling encryption on plan.
	6. Disassociating plan - same as Disabling encryption on plan.
	7. New client - compute inheritance based on inheritance rules.
*/
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRAN
BEGIN TRY
DECLARE  @l_entityId	int = 0
DECLARE  @l_entityType	int = 0
DECLARE  @l_operation	int = 0
SELECT 	@l_entityId = col.value('@entityId', 'int'),
		@l_entityType = col.value('@entityType', 'int'),
		@l_operation = col.value('@operationType', 'int')
FROM @i_xml.nodes('Api_SyncEncryptionSettingsReq') as node(col)
IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL DROP TABLE #lt_Clients
CREATE TABLE #lt_Clients (clientId int, entityId int default 0, entityType int default 0, primary key(clientId))
DECLARE @now int = dbo.getunixtime(getutcdate())
DECLARE @l_numClients int = 0
DECLARE @l_cs_assocScg int = checksum('Associated Smart Client Group')
DECLARE @l_cs_encSet int = checksum('Encryption Settings')
DECLARE @l_entityIdStr nvarchar(20) = CAST(@l_entityId AS nvarchar)
DECLARE @l_entityTypeStr nvarchar(20) = CAST(@l_entityType AS nvarchar)
IF 61 = @l_entityType
BEGIN
	--
	--Get all clients of the company
	--
	INSERT 	INTO #lt_Clients (clientId)
	SELECT	CN2CG.clientId
	FROM	App_ClientGroupAssoc CN2CG WITH(READUNCOMMITTED)
			INNER JOIN App_CompanyProp CP WITH(READUNCOMMITTED)
				ON CP.cs_attrName = @l_cs_assocScg
				AND CP.componentNameId = @l_entityId
AND CP.attrName = 'Associated Smart Client Group'
				AND CP.modified = 0
				AND CP.attrValInt = CN2CG.clientGroupId
END
ELSE IF 158 = @l_entityType
BEGIN
	--
	--Get all clients associated with the plan
	--
IF EXISTS(SELECT 1 FROM App_Plan WITH(READUNCOMMITTED) WHERE id = @l_entityId AND subType = 33554439)
	BEGIN
		INSERT INTO #lt_Clients (clientId)
		SELECT 	componentNameId
		FROM 	App_clientProp WITH(READUNCOMMITTED)
		WHERE 	modified = 0
AND attrName = 'Associated Plan'
				AND attrVal = @l_entityIdStr
	END
	ELSE
	BEGIN
		INSERT INTO #lt_Clients (clientId)
		SELECT 	DISTINCT SC.clientId
		FROM 	App_SubclientProp SCP WITH(READUNCOMMITTED)
				INNER JOIN App_Application SC WITH(READUNCOMMITTED) ON SCP.componentNameId = SC.id
		WHERE 	SCP.modified = 0
AND SCP.attrName = 'Associated Plan'
				AND SCP.attrVal = @l_entityIdStr
	END
END
ELSE IF 3 = @l_entityType
BEGIN
	INSERT INTO #lt_Clients (clientId)
	VALUES (@l_entityId)
END
ELSE
	GOTO SCRIPT_EXIT
SET @l_numClients = @@ROWCOUNT
IF @l_numClients = 0
	GOTO SCRIPT_EXIT
--
--If encryption is enabled at company level then point all clients to company
--
IF @l_operation = 1
AND @l_entityType = 61
BEGIN
	IF @l_entityId > 0
	IF EXISTS
	(
		SELECT 	1
		FROM	App_CompanyProp WITH (READUNCOMMITTED)
		WHERE	cs_attrName = @l_cs_encSet
				AND componentNameId = @l_entityId
				AND modified = 0
AND attrName = 'Encryption Settings'
				AND attrVal <> N'3' --NOT_SET
	)
	BEGIN
		--
		--if KMS is set at company then save the companyId on client with another property
		--This is to avoid any client to company association changes (ideally there won't be any) but just to avoid any misconfigurations
		--This property will be set once and used at every backup to encrypt keys using KMS
		--
		DECLARE @l_isKmsSet INT = 0
		IF EXISTS(SELECT 1 FROM ArchCompanyEncProperties WITH (READUNCOMMITTED) WHERE companyId = @l_entityId)
		BEGIN
			MERGE App_ClientProp AS target
			USING (SELECT clientId FROM #lt_Clients) AS source (clientId)
				ON target.componentNameId = source.clientId
AND target.attrName = 'KMS Company ID'
				AND target.modified = 0
			WHEN MATCHED AND target.attrVal = N'0' THEN
				UPDATE
				SET target.attrVal = @l_entityIdStr, target.created = @now
			WHEN NOT MATCHED THEN
				INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (source.clientId, 'KMS Company ID', 7 /*PROPERTY_INTEGER*/, @l_entityIdStr, @now, 0);
			SET @l_isKmsSet = @@ROWCOUNT
		END
		--
		-- Skip clients which has company entity set already
		-- Client should always point to kms enabled company if there is any
		-- so don't skip if kms is set at company, we should set the current company for all clients in it
		--
		IF @l_isKmsSet = 0
		BEGIN
			DELETE 	#lt_Clients
			WHERE 	EXISTS
					(
						SELECT 1 FROM App_ClientProp CP WITH (READUNCOMMITTED)
						WHERE 	CP.componentNameId = #lt_Clients.clientId
AND CP.attrName = 'Override Encryption Settings From EntityType'
								AND CP.modified = 0
AND CP.attrVal = N'61'
					)
			SET @l_numClients = @l_numClients - @@ROWCOUNT
			IF @l_numClients = 0
				GOTO SCRIPT_EXIT
		END
		--
		-- Set the company entity on clients
		--
		MERGE App_ClientProp AS target
		USING (SELECT clientId FROM #lt_Clients) AS source (clientId)
			ON target.componentNameId = source.clientId
AND target.attrName = 'Override Encryption Settings From EntityId'
			AND target.modified = 0
		WHEN MATCHED AND target.attrVal <> @l_entityIdStr THEN
			UPDATE
			SET target.attrVal = @l_entityIdStr, target.created = @now
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (source.clientId, 'Override Encryption Settings From EntityId', 7 /*PROPERTY_INTEGER*/, @l_entityIdStr, @now, 0);
		MERGE App_ClientProp AS target
		USING (SELECT clientId FROM #lt_Clients) AS source (clientId)
			ON target.componentNameId = source.clientId
AND target.attrName = 'Override Encryption Settings From EntityType'
			AND target.modified = 0
		WHEN MATCHED AND target.attrVal <> @l_entityTypeStr THEN
			UPDATE
			SET target.attrVal = @l_entityTypeStr, target.created = @now
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (source.clientId, 'Override Encryption Settings From EntityType', 7 /*PROPERTY_INTEGER*/, @l_entityTypeStr, @now, 0);
	END
	GOTO SCRIPT_EXIT
END
IF @l_operation = 2
BEGIN
	--
	-- Check if encryption settings are really disabled
	--
IF @l_entityType = 61
		AND EXISTS
		(
			SELECT 	1
			FROM	App_CompanyProp WITH (READUNCOMMITTED)
			WHERE	cs_attrName = @l_cs_encSet
					AND componentNameId = @l_entityId
					AND modified = 0
AND attrName = 'Encryption Settings'
					AND attrVal <> N'3' --NOT_SET
		)
	BEGIN
		GOTO SCRIPT_EXIT   --Not disabled skip it
	END
ELSE IF @l_entityType = 158
		AND EXISTS
		(
			SELECT 	1
			FROM	App_PlanProp WITH (READUNCOMMITTED)
			WHERE	componentNameId = @l_entityId
					AND modified = 0
AND attrName = 'Encryption Settings'
					AND attrVal <> N'3' --NOT_SET
		)
	BEGIN
		GOTO SCRIPT_EXIT   --Not disabled skip it
	END
	--
	-- Reset company/plan from client, we will pick top 1 plan later in below code
	--
	UPDATE 	CP
	SET		attrVal = N'0'
	FROM	App_ClientProp CP
			INNER JOIN #lt_Clients CN ON CP.componentNameId = CN.clientId
WHERE	CP.attrName IN ('Override Encryption Settings From EntityId', 'Override Encryption Settings From EntityType')
			AND CP.modified = 0
			AND CP.attrVal = @l_entityIdStr
END
ELSE IF @l_operation <> 3
BEGIN
	--
	-- Skip clients which has entity set already
	--
	DELETE 	#lt_Clients
	WHERE 	EXISTS
			(
				SELECT 1 FROM App_ClientProp CP WITH (READUNCOMMITTED)
				WHERE 	CP.componentNameId = #lt_Clients.clientId
AND CP.attrName = 'Override Encryption Settings From EntityId'
						AND CP.modified = 0
						AND CP.attrVal <> N'0'
			)
	SET @l_numClients = @l_numClients - @@ROWCOUNT
	IF @l_numClients = 0
		GOTO SCRIPT_EXIT
END
--
--Now pick company or plan which has encryption set for given clients
--
--
--First check for company level settings for new client
--
IF @l_operation = 3
AND @l_entityType = 3
BEGIN
	DECLARE @l_companyId INT = 0
	SELECT	TOP 1 @l_companyId = CP.componentNameId
	FROM 	APP_ClientGroupAssoc CN2CG WITH(READUNCOMMITTED)
			INNER JOIN App_CompanyProp CP WITH(READUNCOMMITTED)
				ON CP.cs_attrName = @l_cs_assocScg
AND CP.attrName = 'Associated Smart Client Group'
				AND CP.attrValInt = CN2CG.clientGroupId
				AND CP.modified = 0
			INNER JOIN App_CompanyProp COP WITH (READUNCOMMITTED)
				ON COP.cs_attrName = @l_cs_encSet
				AND COP.componentNameId = CP.componentNameId
AND COP.attrName = 'Encryption Settings'
				AND COP.modified = 0
				AND COP.attrVal <> N'3' --NOT_SET
	WHERE	CN2CG.clientId = @l_entityId
	IF @l_companyId > 0
	BEGIN
		--
		--Set the company entity on new client
		--
		UPDATE 	App_ClientProp
		SET		attrVal = CAST(@l_companyId AS nvarchar), created = @now
		WHERE	componentNameId = @l_entityId
AND attrName = 'Override Encryption Settings From EntityId'
				AND modified = 0
		IF @@ROWCOUNT > 0
		BEGIN
			UPDATE 	App_ClientProp
SET		attrVal = N'61', created = @now
			WHERE	componentNameId = @l_entityId
AND attrName = 'Override Encryption Settings From EntityType'
					AND modified = 0
		END
		ELSE
		BEGIN
			INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT @l_entityId, 'Override Encryption Settings From EntityId', 7 /*PROPERTY_INTEGER*/, CAST(@l_companyId AS nvarchar), @now, 0
			UNION ALL
SELECT @l_entityId, 'Override Encryption Settings From EntityType', 7 /*PROPERTY_INTEGER*/, N'61', @now, 0
		END
		--
		--if KMS is set at company then save the companyId on client with another property
		--This is to avoid any client to company association changes (ideally there won't be any) but just to avoid any misconfigurations
		--This property will be set once and used at every backup to encrypt keys using KMS
		--
		IF EXISTS(SELECT 1 FROM ArchCompanyEncProperties WITH (READUNCOMMITTED) WHERE companyId = @l_companyId)
		BEGIN
			MERGE App_ClientProp AS target
			USING (SELECT @l_entityId) AS source (clientId)
				ON target.componentNameId = source.clientId
AND target.attrName = 'KMS Company ID'
				AND target.modified = 0
			WHEN MATCHED AND target.attrVal = N'0' THEN
				UPDATE
				SET target.attrVal = CAST(@l_companyId AS nvarchar), target.created = @now
			WHEN NOT MATCHED THEN
				INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (source.clientId, 'KMS Company ID', 7 /*PROPERTY_INTEGER*/, CAST(@l_companyId AS nvarchar), @now, 0);
		END
		GOTO SCRIPT_EXIT
	END
END
--
--Check for plan if there are any clients not using company
--Look for top 1 plan which has encryption set for each client
--
;WITH Client2Plan AS
(
	SELECT C2P.clientId, ISNULL(MIN(PP.componentNameId), 0) planId
	FROM
	(
		SELECT 	CN.clientId, CP.attrVal planId
		FROM 	App_clientProp CP WITH(READUNCOMMITTED)
				INNER JOIN #lt_Clients CN ON CP.componentNameId = CN.clientId
				INNER JOIN App_Plan P WITH(READUNCOMMITTED) ON CP.attrVal = CAST(P.id AS nvarchar)
		WHERE 	CP.modified = 0
AND CP.attrName = 'Associated Plan'
AND P.subType = 33554439
		UNION
		SELECT 	CN.clientId, SCP.attrVal planId
		FROM 	App_SubclientProp SCP WITH(READUNCOMMITTED)
				INNER JOIN App_Application SC WITH(READUNCOMMITTED) ON SCP.componentNameId = SC.id
				INNER JOIN #lt_Clients CN ON SC.clientId = CN.clientId
				INNER JOIN App_Plan P WITH(READUNCOMMITTED) ON SCP.attrVal = CAST(P.id AS nvarchar)
		WHERE 	SCP.modified = 0
AND SCP.attrName = 'Associated Plan'
AND P.subType <> 33554439
	) AS C2P
	LEFT OUTER JOIN App_PlanProp PP WITH (READUNCOMMITTED)
		ON CAST(PP.componentNameId AS nvarchar) = C2P.planId
AND PP.attrName = 'Encryption Settings'
		AND PP.modified = 0
		AND PP.attrVal <> N'3' --NOT_SET
	GROUP BY C2P.clientId
)
UPDATE 	C
SET		entityId = P.planId,
entityType = (case when P.planId > 0 then 158 else 0 end)
FROM 	#lt_Clients C
		INNER JOIN Client2Plan P ON C.ClientId = P.ClientId
--
--Finally set the entity on client
--Entity may be 0 if there are no settings neither on company nor on plan
--
MERGE App_ClientProp AS target
USING (SELECT clientId, CAST(entityId AS nvarchar) entityIdStr FROM #lt_Clients) AS source (clientId, entityIdStr)
	ON target.componentNameId = source.clientId
AND target.attrName = 'Override Encryption Settings From EntityId'
	AND target.modified = 0
WHEN MATCHED AND target.attrVal <> source.entityIdStr THEN
	UPDATE
	SET target.attrVal = source.entityIdStr, target.created = @now
WHEN NOT MATCHED THEN
	INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (source.clientId, 'Override Encryption Settings From EntityId', 7 /*PROPERTY_INTEGER*/, source.entityIdStr, @now, 0);
MERGE App_ClientProp AS target
USING (SELECT clientId, CAST(entityType AS nvarchar) entityTypeStr FROM #lt_Clients) AS source (clientId, entityTypeStr)
	ON target.componentNameId = source.clientId
AND target.attrName = 'Override Encryption Settings From EntityType'
	AND target.modified = 0
WHEN MATCHED AND target.attrVal <> source.entityTypeStr THEN
	UPDATE
	SET target.attrVal = source.entityTypeStr, target.created = @now
WHEN NOT MATCHED THEN
	INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (source.clientId, 'Override Encryption Settings From EntityType', 7 /*PROPERTY_INTEGER*/, source.entityTypeStr, @now, 0);
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SELECT @l_errorCode = -1, @l_errorMsg = ISNULL(ERROR_MESSAGE(), 'Unknown')
    GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL DROP TABLE #lt_Clients
	IF @l_errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
	IF OBJECT_ID('tempdb..#lt_SyncSettingsOutput') IS NOT NULL
		INSERT INTO #lt_SyncSettingsOutput (o_xml)
		VALUES((SELECT 	@l_errorCode AS '@errorCode',
			@l_errorMsg AS '@errorMessage'
		FOR XML PATH('Api_GenericResp'),TYPE))
	ELSE
		SELECT 	@l_errorCode AS '@errorCode',
				@l_errorMsg AS '@errorMessage'
		FOR XML PATH('Api_GenericResp'),TYPE
	RETURN @l_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncEncryptionSettings')
	delete from GxQscripts where name = 'AppSyncEncryptionSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncEncryptionSettings')
	delete from GXDBVersions where aliasname = 'AppSyncEncryptionSettings'
GO

insert into GXDBVersions values(2, 'AppSyncEncryptionSettings',  '00010001000200040000', 'AppSyncEncryptionSettings', '00010001000200040000')
GO

