

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncEdgeGetIndexServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSyncEdgeGetIndexServers.sp,v $ $Id: AppSyncEdgeGetIndexServers.sp,v 1.5.12.14 2020/09/26 02:43:29 sagarmd Exp $";
--	+===================================================================+
--	|  					  AppSyncEdgeGetIndexServers							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSyncEdgeGetIndexServers')
BEGIN
	print '>>> Drop Stored Procedure: AppSyncEdgeGetIndexServers <<<'
	drop procedure AppSyncEdgeGetIndexServers
END
IF EXISTS (select * from GxQscripts where name='AppSyncEdgeGetIndexServers')
	delete from GxQscripts where name = 'AppSyncEdgeGetIndexServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncEdgeGetIndexServers')
	delete from GXDBVersions where aliasname = 'AppSyncEdgeGetIndexServers'
GO
print '... Creating Procedure: AppSyncEdgeGetIndexServers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncEdgeGetIndexServers
  @xmlTxt XML
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @driveType INT
	DECLARE @includeCloudType BIT
	DECLARE @isNFSCacheConfigured bit
	DECLARE @getNFSSupportedOS bit
	DECLARE @getSMBSupportedOS bit
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
	SET @driveType = ISNULL((SELECT  ref.value('@driveType', 'int') AS Agent
				FROM    @xmlTxt.nodes('App_EdgeDriveIndexServerDiscoverReq') R ( ref )),0)
	SET @includeCloudType = ISNULL((SELECT  ref.value('@includeCloudType', 'bit') AS Agent
				FROM    @xmlTxt.nodes('App_EdgeDriveIndexServerDiscoverReq') R ( ref )),0)
	SET @isNFSCacheConfigured = ISNULL((SELECT ref.value('@isNFSCacheConfigured','bit') AS Agent
									FROM @xmlTxt.nodes('App_EdgeDriveIndexServerDiscoverReq') R ( ref )) ,0)
	SET @getNFSSupportedOS = ISNULL((SELECT ref.value('@getNFSSupportedOS','bit') AS Agent
									FROM @xmlTxt.nodes('App_EdgeDriveIndexServerDiscoverReq') R ( ref )) ,0)
	SET @getSMBSupportedOS = ISNULL((SELECT ref.value('@getSMBSupportedOS','bit') AS Agent
									FROM @xmlTxt.nodes('App_EdgeDriveIndexServerDiscoverReq') R ( ref )) ,0)
	IF @driveType = 4 /*NFS_OBJECT_STORE*/ AND  @isNFSCacheConfigured = 1 /*get media agents with NFSCache configured*/
	BEGIN
		IF @getNFSSupportedOS = 0 AND  @getSMBSupportedOS = 0 /* if both set to zero then return all MA for which data cache path is set. */
		BEGIN
			SET @getNFSSupportedOS = 1
			SET @getSMBSupportedOS = 1
		END
		SELECT (
			SELECT DISTINCT AC.id AS '@mediaAgentId', AC.name AS '@mediaAgentName',3 AS '@_type_'
			FROM APP_Client AC
				INNER JOIN ( SELECT  AP.ClientId
					FROM IdxAccessPath AP
						INNER JOIN IdxCache C ON C.IdxCacheId = AP.IdxCacheId
					WHERE C.IdxCacheType = 3) A ON A.ClientId = AC.Id
				JOIN SimOperatingSystem sim ON AC.simOperatingSystemId = sim.id
					WHERE (@getSMBSupportedOS = 1 AND sim.type = 'windows' and sim.SubType = 'server')
					OR (@getNFSSupportedOS = 1 AND sim.type = 'Unix' and sim.subtype = 'linux')
		  FOR XML PATH ('mediaAgents'),TYPE
			)
		  FOR XML PATH('App_EdgeDriveIndexServerDiscoverResp')
	END
	ELSE
	BEGIN
		DECLARE @roleName VARCHAR(20) = 'EDGE Drive'
		DECLARE @filterSOLRCloud INT = 0
		IF(@driveType = 4 /*NFS_OBJECT_STORE*/)
			SELECT @roleName = 'NFS Index'
		ELSE IF(@driveType <> 0 /*DEFAULT_EDGE_DRIVE*/)
			SET @filterSOLRCloud = 1 -- filter SOLR Cloud index servers for ObjectStore Clients
		EXEC DM2GetIndexServers @roleName
		IF(@includeCloudType = 1)
		BEGIN
			SELECT (
				SELECT T.serverType AS '@cloudServerType',
						(SELECT DISTINCT T.indexServerClientId AS '@clientId', T.engineName AS '@clientName',3 AS '@_type_'
							FOR XML PATH ('indexServer'),TYPE
					)
					FROM  #getIndexServers T
WHERE @filterSOLRCloud =  0 OR (@filterSOLRCloud = 1 AND T.serverType = 1)
					GROUP BY  T.serverType, T.indexServerClientId, T.engineName
					FOR XML PATH('indexSrvrs'),TYPE
				) FOR XML PATH('App_EdgeDriveIndexServerDiscoverResp'
			)
		END
		ELSE
		BEGIN
			SELECT (
				SELECT DISTINCT T1.indexServerClientId AS '@clientId', T1.engineName AS '@clientName',3 AS '@_type_'
							FROM #getIndexServers T1
WHERE @filterSOLRCloud =  0 OR (@filterSOLRCloud = 1 AND T1.serverType = 1)
							FOR XML PATH ('indexServers'),TYPE
					)
				FOR XML PATH('App_EdgeDriveIndexServerDiscoverResp'
			)
		END
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncEdgeGetIndexServers')
	delete from GxQscripts where name = 'AppSyncEdgeGetIndexServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncEdgeGetIndexServers')
	delete from GXDBVersions where aliasname = 'AppSyncEdgeGetIndexServers'
GO

insert into GXDBVersions values(2, 'AppSyncEdgeGetIndexServers',  '00010005001200140000', 'AppSyncEdgeGetIndexServers', '00010005001200140000')
GO

