

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncDeleteWebFolder.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSyncDeleteWebFolder						|
--	|			Procedure for deleting a Sync Web Folder				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncDeleteWebFolder <<<'

IF EXISTS (select * from sysobjects where name='AppSyncDeleteWebFolder')
	drop procedure AppSyncDeleteWebFolder
IF EXISTS (select * from GxQscripts where name='AppSyncDeleteWebFolder')
	delete from GxQscripts where name = 'AppSyncDeleteWebFolder'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncDeleteWebFolder')
	delete from GXDBVersions where aliasname = 'AppSyncDeleteWebFolder'
GO
print '... Creating Procedure: AppSyncDeleteWebFolder'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncDeleteWebFolder
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @ownerId			INT = 0
	DECLARE @oscClientTbl		TABLE (clientId INT)
	DECLARE @contentTbl         TABLE (clientId INT, subclientId INT)
	DECLARE @workQOutPutTbl		TABLE (errCode INT, errString NVARCHAR(MAX))
	-- Read the XML
	DECLARE @inSyncWebFolderId	INT	= ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
														FROM @i_xmlString.nodes ('App_DeleteSyncWebFolderReq/syncInfos') R(ref)), 0)
	IF @inSyncWebFolderId < 1
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid Web Folder info in delete request.'
		GOTO ERROR_EXIT
	END
	SET @ownerId = ISNULL( (SELECT ownerId FROM App_SyncCloudFolder WITH(READUNCOMMITTED) WHERE syncWebFolderId = @inSyncWebFolderId), 0)
	If @ownerId = 0
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Error : Web Folder does not exist.'
		GOTO ERROR_EXIT
	END
	ELSE IF @ownerId <> @i_userId
	BEGIN
		SET @errorCode = 3
		SET @errorString = 'Error : Unable to delete as user is not the owner.'
		GOTO ERROR_EXIT
	END
-- Get All sources to populate OSC push table
	INSERT INTO @oscClientTbl
	SELECT clientId FROM App_SyncCloudConfig WITH (NOLOCK)
WHERE syncWebFolderId = @inSyncWebFolderId AND syncType & 1 = 1 AND flag & 0x1 <> 0x1
--
-- Get All sources to populate sync content table
	INSERT INTO @contentTbl
	SELECT clientId,subclientId FROM App_SyncCloudConfig WITH (NOLOCK)
WHERE syncWebFolderId = @inSyncWebFolderId AND syncType & 1 = 1 AND flag & 0x1 <> 0x1
	BEGIN TRAN
	-- Update the web folder
	DELETE App_SyncCloudFolder
	WHERE syncWebFolderId = @inSyncWebFolderId
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
--
-- Filter all the sources which are still part of other valid sync folders
	DELETE FROM @oscClientTbl
	WHERE clientId IN (SELECT DISTINCT clientId
					   FROM App_SyncCloudConfig WITH (NOLOCK)
WHERE syncType & 1 = 1 AND flag & 0x1 <> 0x1)
--
	-- Push OSC for the required clients
	DECLARE @oscClientId INT = 0
	DECLARE GetOSCClients CURSOR
	FOR SELECT clientId FROM @oscClientTbl
	OPEN GetOSCClients
	FETCH GetOSCClients INTO @oscClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE @workQOutPutTbl
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 4 /*WORK_TOKEN_OSC*/, 0, 0, @oscClientId, 0, ''
		SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		IF @errorCode <> 0 GOTO ERROR
		FETCH GetOSCClients INTO @oscClientId
	END
	CLOSE GetOSCClients
	DEALLOCATE GetOSCClients
--
-- Push Subclient Changed for the required clients
	DECLARE @subclientChangedClientId INT = 0
	DECLARE @subclientChangedSCId INT = 0
	DECLARE @workQueueXML         XML
    DECLARE @workQueueParam       NVARCHAR(MAX)
	DECLARE GetSCClients CURSOR
	FOR SELECT clientId,subclientId FROM @contentTbl
	OPEN GetSCClients
	FETCH GetSCClients INTO @subclientChangedClientId,@subclientChangedSCId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE @workQOutPutTbl
		SET @workQueueXML = (SELECT @subclientChangedSCId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE)
		SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
		--
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 7 /*WORK_TOKEN_SUBCLIENT_CONTENT*/, 0, 0, @subclientChangedClientId, 0, @workQueueParam
		--
		SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		IF @errorCode <> 0 GOTO ERROR
		FETCH GetSCClients INTO @subclientChangedClientId,@subclientChangedSCId
	END
	CLOSE GetSCClients
	DEALLOCATE GetSCClients
	ERROR:
		IF @errorCode <> 0
			ROLLBACK TRAN
		ELSE
			COMMIT TRAN
	ERROR_EXIT:
		SET @o_xmlString = (SELECT (
									SELECT @errorCode AS '@errorCode', @errorString AS '@errorString'
									FOR XML PATH('response'), TYPE)
							FOR XML PATH('App_DeleteSyncWebFolderResp'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncDeleteWebFolder')
	delete from GxQscripts where name = 'AppSyncDeleteWebFolder'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncDeleteWebFolder')
	delete from GXDBVersions where aliasname = 'AppSyncDeleteWebFolder'
GO

insert into GXDBVersions values(2, 'AppSyncDeleteWebFolder',  '00000000000000000000', 'AppSyncDeleteWebFolder', '00000000000000000000')
GO

