

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncDeleteEdgeSyncFoldersForBackupset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppSyncDeleteEdgeSyncFoldersForBackupset.sp			|
--	|			  Procedure for deleting a edge drive for backupset		|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncDeleteEdgeSyncFoldersForBackupset <<<'

IF EXISTS (select * from sysobjects where name='AppSyncDeleteEdgeSyncFoldersForBackupset')
	drop procedure AppSyncDeleteEdgeSyncFoldersForBackupset
IF EXISTS (select * from GxQscripts where name='AppSyncDeleteEdgeSyncFoldersForBackupset')
	delete from GxQscripts where name = 'AppSyncDeleteEdgeSyncFoldersForBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncDeleteEdgeSyncFoldersForBackupset')
	delete from GXDBVersions where aliasname = 'AppSyncDeleteEdgeSyncFoldersForBackupset'
GO
print '... Creating Procedure: AppSyncDeleteEdgeSyncFoldersForBackupset'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncDeleteEdgeSyncFoldersForBackupset
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_backupSetId INT
-----------------------------------------------------------
AS
  DECLARE @o_errorCode INT
SET NOCOUNT ON
BEGIN
	DECLARE @edgeclientId INT = 0
	DECLARE @edgeSubClientId INT = 0
	DECLARE @syncFolderId INT = 0
	SET @edgeClientId = ISNULL((SELECT TOP 1 clientId FROM APP_Application WHERE backupSet = @i_backupSetId), 0)
	-- Added syncConfigId , syncConfigOptions and syncStatus columns in the table definition
	DECLARE @oscClientTbl TABLE (clientId INT, syncFolderId INT, syncConfigId INT, syncConfigOptions XML, syncStatus INT)
	DECLARE @syncFolderTbl TABLE (syncFolderId INT)
	-- Get all applicable sync folders
	INSERT INTO @syncFolderTbl
	SELECT DISTINCT syncWebFolderId FROM App_SyncCloudConfig
	WHERE subclientId IN (SELECT id FROM APP_Application WHERE backupSet = @i_backupSetId)
	SET @edgeSubClientId = ISNULL((SELECT TOP 1 subclientId FROM App_SyncCloudConfig WHERE syncWebFolderId IN (SELECT syncFolderId FROM @syncFolderTbl)), 0)
	-- Get All applicable clients to populate OSC push table
	-- Get syncConfigId , syncConfigOptions and syncStatus from the result of join of App_SyncCloudConfig and App_SyncCloudStats and insert these additional values to the OSC push table
	INSERT INTO @oscClientTbl
	SELECT  A.clientId, A.syncWebFolderId, A.syncConfigId, A.configOptions,B.syncStatus FROM App_SyncCloudConfig A WITH (NOLOCK)
	JOIN App_SyncCloudStats B
	ON A.syncWebFolderId=B.syncWebFolderId and A.clientId=B.destClientId and A.subclientId=B.sourceSubclientId
	WHERE syncType & 1 = 1 AND synctype <> 4 -- Not unlinked
	AND A.syncWebFolderId IN (SELECT syncFolderId FROM @syncFolderTbl)
	AND A.clientId <> @edgeClientId
	BEGIN TRAN
	--
	-- Delete the web folder
	DELETE App_SyncCloudFolder
	WHERE syncWebFolderId = @syncFolderId
	SELECT @o_errorCode = @@ERROR
	IF @o_errorCode <> 0 GOTO ERROR
	-- Push OSC for the required clients
	DECLARE @oscClientId INT = 0
	DECLARE @oscSyncFolder INT = 0
	DECLARE @oscSyncConfigId INT = 0
	DECLARE @oscSyncConfigOptions XML
	DECLARE @oscSyncStatus INT = 0
	DECLARE @workQueueXML XML
	DECLARE @workTokenParams NVARCHAR(MAX) = ''
	DECLARE @workQOutPutTbl		TABLE (errCode INT, errString NVARCHAR(MAX))
	DECLARE GetOSCClients CURSOR
	FOR SELECT clientId, syncFolderId,syncConfigId, syncConfigOptions,syncStatus FROM @oscClientTbl
	OPEN GetOSCClients
	FETCH GetOSCClients INTO @oscClientId, @oscSyncFolder, @oscSyncConfigId, @oscSyncConfigOptions, @oscSyncStatus
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE FROM @workQOutPutTbl
		-- Added syncStatus and syncConfigOptions which contains the Sync Status and Edge Drive UserName respectively
		SET @workQueueXML = (	SELECT 4 AS '@syncOperation', @oscSyncStatus AS '@status',
										(
										SELECT @edgeClientId AS '@clientId',
										@i_backupSetId AS '@backupsetId',
										@edgeSubClientId AS '@subclientId'
										FOR XML PATH('subclient'), TYPE
										),
										(
										SELECT @oscSyncFolder AS '@syncWebFolderId'
										FOR XML PATH('syncFolder'), TYPE
										),
										(
	                                        SELECT @oscSyncConfigOptions
										)
								FOR XML PATH('TMMsg_SyncConfigWorkQueueReq'), TYPE
							)
		SET @workTokenParams = CAST(@workQueueXML AS NVARCHAR(MAX))
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 17 /*WORK_TOKEN_SYNC_RESTORE_CONFIG*/, 0, 0, @oscClientId, 0, @workTokenParams
		SELECT @o_errorCode = errCode FROM @workQOutPutTbl
		IF @o_errorCode <> 0 GOTO ERROR
		FETCH GetOSCClients INTO @oscClientId, @oscSyncFolder, @oscSyncConfigId, @oscSyncConfigOptions, @oscSyncStatus
	END
	CLOSE GetOSCClients
	DEALLOCATE GetOSCClients
	ERROR:
		IF @o_errorCode <> 0
			ROLLBACK TRAN
		ELSE
			COMMIT TRAN
	ERROR_EXIT:
	SELECT @o_errorCode
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncDeleteEdgeSyncFoldersForBackupset')
	delete from GxQscripts where name = 'AppSyncDeleteEdgeSyncFoldersForBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncDeleteEdgeSyncFoldersForBackupset')
	delete from GXDBVersions where aliasname = 'AppSyncDeleteEdgeSyncFoldersForBackupset'
GO

insert into GXDBVersions values(2, 'AppSyncDeleteEdgeSyncFoldersForBackupset',  '00000000000000000000', 'AppSyncDeleteEdgeSyncFoldersForBackupset', '00000000000000000000')
GO

