

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncCreateConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSyncCreateConfig.sp,v $ $Id: AppSyncCreateConfig.sp,v 1.11.2.6 2018/04/16 20:17:19 bmehta Exp $";
--	+===================================================================+
--	|  					  AppSyncCreateConfig							|
--	|          Procedure for creating a new Sync Web Folder				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncCreateConfig <<<'

IF EXISTS (select * from sysobjects where name='AppSyncCreateConfig')
	drop procedure AppSyncCreateConfig
IF EXISTS (select * from GxQscripts where name='AppSyncCreateConfig')
	delete from GxQscripts where name = 'AppSyncCreateConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncCreateConfig')
	delete from GXDBVersions where aliasname = 'AppSyncCreateConfig'
GO
print '... Creating Procedure: AppSyncCreateConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncCreateConfig
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @syncWebFolderId	INT = 0
    DECLARE @assocCount			INT = 0
	DECLARE @i					INT = 1
	DECLARE @assocXML			XML
	DECLARE @syncType			INT
	DECLARE @syncPath			NVARCHAR(MAX)
	DECLARE @subclientId		INT
	DECLARE @clientId			INT
	DECLARE @syncClientFlag		INT
	DECLARE @configOptions		XML
	DECLARE @scFilterFileID		INT = 0
	DECLARE @contentChanged		INT = 0
	DECLARE @contentTbl			TABLE
	(subclientId INT, isContentchanged INT)
	DECLARE @workQueueXML		XML
	DECLARE @workQueueParam		NVARCHAR(MAX)
	DECLARE @workQOutPutTbl		TABLE (errCode INT, errString NVARCHAR(MAX))
	DECLARE @contentOutPutTbl	TABLE (scFilterFileId INT, isContentChanged INT)
	DECLARE @oscClientTbl		TABLE (clientId INT)
	-- Read the XML
	DECLARE @syncWebFolderName	NVARCHAR(MAX)	= ISNULL (( SELECT ref.value('@syncWebFolderName', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_CreateSyncWebFolderReq/syncInfo/syncWebFolder') R(ref)), '')
	DECLARE @description		NVARCHAR(MAX)	= ISNULL (( SELECT ref.value('@description', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_CreateSyncWebFolderReq/syncInfo') R(ref)), '')
	DECLARE @syncWebFolderFlag	INT				= ISNULL (( SELECT ref.value('@flag', 'NVARCHAR(MAX)')
														FROM @i_xmlString.nodes ('App_CreateSyncWebFolderReq/syncInfo') R(ref)), 0)
	DECLARE @enabled			INT				= ISNULL (( SELECT ref.value('@enabled', 'INT')
														FROM @i_xmlString.nodes ('App_CreateSyncWebFolderReq/syncInfo') R(ref)), 0)
	DECLARE @ownerId			INT				= ISNULL (( SELECT ref.value('@userId', 'INT')
														FROM @i_xmlString.nodes ('App_CreateSyncWebFolderReq/syncInfo/syncOwner') R(ref)), 0)
	-- Create new for the first time.
	-- Name validation
	IF EXISTS (SELECT 1 FROM App_SyncCloudFolder SF WITH(NOLOCK)
					JOIN App_SyncCloudFolders SFV ON SF.syncWebFolderId = SFV.SyncWebFolderId
					WHERE syncWebFolderName = @syncWebFolderName AND ownerId = @ownerId
					AND SFV.FLAG = 0)	--CHECK THAT FOLDER IS NOT A SHARE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Web Folder name already exists for owner.'
		GOTO ERROR_EXIT
	END
	IF (@syncWebFolderFlag & 2 <> 2)
	BEGIN
		--CHECK THAT FOLDER NAME IS NOT ALREADY A TEMPLATE
		IF EXISTS (SELECT 1 FROM (
			SELECT result FROM (SELECT CAST(value AS XML).exist('//./syncWebFolder/@syncWebFolderName[.=sql:variable("@syncWebFolderName")]') AS result FROM GXGlobalParam
				WHERE name = 'Sync Folder Template'
				AND modified=0)R ) A where A.result = 1)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Error : Web Folder name already exists for owner.'
			GOTO ERROR_EXIT
		END
	END
	-- @@TODO
	-- User validation
	BEGIN TRAN
	-- Validation success, create the web folder
	GENERATE_RETRY:
		SET @syncWebFolderId = ABS(CHECKSUM(NEWID())) % 1000000 + 1;
		IF EXISTS (SELECT 1 FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @syncWebFolderId)
			GOTO GENERATE_RETRY
	INSERT INTO App_SyncCloudFolder (syncWebFolderName, description, created, modified, flag, ownerId, syncWebFolderId)
		VALUES(@syncWebFolderName, @description, @nowTime, 0, @syncWebFolderFlag, @ownerId, @syncWebFolderId)
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
	-- Add the sync clients for this folder
	SET @assocCount = @i_xmlString.value('count(//.[@syncType])','INT')
	WHILE (@i <= @assocCount)
	BEGIN
		SET @scFilterFileID = 0
		SET @contentChanged = 0
		SET @workQueueXML = ''
		DELETE FROM @workQOutPutTbl
		DELETE FROM @contentOutPutTbl
		SET @assocXML = @i_xmlString.query('(//.[@syncType])[sql:variable("@i")]')
		SET @syncType = ISNULL (( SELECT ref.value('@syncType', 'INT')
									FROM @assocXML.nodes ('associatedClients') R(ref)), 0)
		SET @syncPath = ISNULL (( SELECT ref.value('@syncPath', 'NVARCHAR(MAX)')
									FROM @assocXML.nodes ('associatedClients') R(ref)), '')
		SET @subclientId = ISNULL (( SELECT ref.value('@subclientId', 'INT')
									FROM @assocXML.nodes ('associatedClients/client') R(ref)), 0)
		SET @clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
									FROM @assocXML.nodes ('associatedClients/client') R(ref)), 0)
		SET @syncClientFlag = ISNULL (( SELECT ref.value('@flag', 'INT')
									FROM @assocXML.nodes ('associatedClients') R(ref)), 0)
		SET @configOptions = ISNULL (@assocXML.query('associatedClients/syncOptions'),'')
		-- Other parameters validation
		IF @syncType = 4
		BEGIN
			GOTO NEXT
		END
		ELSE
		IF @syncType NOT IN (1,2,3) OR @syncPath = ''
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error : Invalid values found in create request.'
			GOTO ERROR
		END
		-- This means it is a source and so check if we need to add backup content.
		IF @syncType & 1 = 1
		BEGIN
			-- Do this only if it not all Content.
IF @syncClientFlag & 0x2 = 0
AND @syncWebFolderFlag & 0x10 = 0
			BEGIN
				--INSERT INTO @contentOutPutTbl
				EXEC AppCheckAndInsertSubclientContent @subclientId, @syncPath, @i_userId, @i_localeId, @scFilterFileID OUTPUT, @contentChanged OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
				IF @errorCode <> 0 GOTO ERROR
				--SELECT @scFilterFileID = scFilterFileId, @contentChanged = isContentChanged, @oldContent = oldContent, @newContent = newContent FROM @contentOutPutTbl
			END
			IF NOT EXISTS (SELECT 1 FROM App_SyncCloudConfig WHERE clientId = @clientId AND syncType & 1 = 1) -- Not already a source
			  AND NOT EXISTS (SELECT 1 FROM @oscClientTbl WHERE clientId = @clientId) -- Not already exists
			BEGIN
				INSERT INTO @oscClientTbl
				VALUES(@clientId)
			END
		END
		INSERT INTO App_SyncCloudConfig(syncWebFolderId, syncPath, clientId, subclientId, syncType, scFilterFileId,  created, flag, configOptions)
		VALUES(@syncWebFolderId, @syncPath, @clientId, @subclientId, @syncType, @scFilterFileID, @nowTime, @syncClientFlag, @configOptions)
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR
		IF @syncType & 1 = 1
AND @syncWebFolderFlag & 0x10 = 0 -- Dont do this for edge drive.
		BEGIN
			-- Submit Workqueue for subclient content change WORK_TOKEN_SUBCLIENT_CONTENT = 7
			SET @workQueueXML = (SELECT @subclientId AS '@subclientID' FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE)
			SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 7 /*WORK_TOKEN_SUBCLIENT_CONTENT*/, 0, 0, @clientId, 0, @workQueueParam
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
			IF @errorCode <> 0 GOTO ERROR
		END
		--ELSE
		--BEGIN
		--	-- TODO - Start a backup
		--	PRINT('Start backup')
		--END
		INSERT INTO @contentTbl
		VALUES(@subclientId, @contentChanged)
	NEXT:
		SET @i  = @i +1
	END
	-- Populate the sync stats table
	INSERT INTO App_SyncCloudStats (syncWebFolderId, destClientId, sourceSubclientId, lastBackupSyncJobId, lastSuccessSyncJobId, currentRestoreJobId, syncStatus)
	SELECT DISTINCT WF.syncWebFolderId, D.clientId, S.subclientId, 0, 0, 0,
	CASE CON.isContentchanged
	WHEN 0 THEN 0 -- If content not changed, then it is already backed up. So syncStatus = 0 ==> NEEDS_RESTORE_AFTER_BACKUP
	WHEN 1 THEN 2 --If content changed, then it is not already backed up. It will be backed up by workflow. So syncStatus = 2 ==> SYNC_SUCCESSFUL
	END
	FROM App_SyncCloudFolder WF
	INNER JOIN App_SyncCloudConfig S ON WF.syncWebFolderId = S.syncWebFolderId AND S.syncType & 1 = 1
	INNER JOIN App_SyncCloudConfig D ON WF.syncWebFolderId = D.syncWebFolderId AND D.syncType & 2 = 2 AND S.syncConfigId <> D.syncConfigId
	INNER JOIN @contentTbl CON ON S.subclientId = CON.subClientId
	LEFT OUTER JOIN App_SyncCloudStats STAT ON S.subclientId = STAT.sourceSubclientId AND D.clientId = STAT.destClientId AND WF.syncWebFolderId = STAT.syncWebFolderId
	WHERE WF.syncWebFolderId = @syncWebFolderId
	AND (STAT.sourceSubclientId IS NULL)
--
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
--
--
	-- Now insert into componentprop to know that we have to run full restores
	--DELETE FROM @contentTbl WHERE isContentchanged > 0
	--INSERT INTO [CommServ].[dbo].[APP_ComponentProp]
 --          ([componentType]
 --          ,[componentId]
 --          ,[propertyTypeId]
 --          ,[dataType]
 --          ,[longVal]
 --          ,[longlongVal]
 --          ,[stringVal]
 --          ,[created]
 --          ,[modified])
	--SELECT 15 --CV_COMPONENT_TYPE_SYNC_WEB_FOLDER
 --          ,CS.sourceSubclientId
 --          , 2001 --CV_COMPONENT_SYNC_PAIR
 --          ,10 --PROPERTY_ULONG
 --          ,CS.destClientId
 --          ,0
 --          ,''
 --          ,(SELECT DBO.GETUNIXTIME(GETUTCDATE()))
 --          ,0
	--FROM App_SyncCloudStats CS  INNER JOIN
	--	@contentTbl CON ON CON.subclientId = CS.sourceSubclientId AND CS.syncWebFolderId = @syncWebFolderId
--
--
IF @syncWebFolderFlag & 0x10 = 0
	BEGIN
		-- Push OSC for the required clients
		DECLARE @oscClientId INT = 0
		DECLARE GetOSCClients CURSOR
		FOR SELECT clientId FROM @oscClientTbl
		OPEN GetOSCClients
		FETCH GetOSCClients INTO @oscClientId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 4, 0, 0, @oscClientId, 0, ''
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
			IF @errorCode <> 0
			BEGIN
				CLOSE GetOSCClients
				DEALLOCATE GetOSCClients
				GOTO ERROR
			END
			FETCH GetOSCClients INTO @oscClientId
		END
		CLOSE GetOSCClients
		DEALLOCATE GetOSCClients
		-- Add a property to indicate that the client has sync1 enabled
		INSERT INTO APP_ClientProp
		SELECT clientId,'Sync1 Feature Enabled',2,'1',@nowTime,0,0
		FROM @oscClientTbl
		LEFT OUTER JOIN APP_ClientProp CP ON CP.componentNameId = clientId AND attrname = 'Sync1 Feature Enabled' AND modified = 0
		WHERE CP.componentNameId IS NULL
	END
ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
ERROR_EXIT:
		SET @o_xmlString = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString'
									 FOR XML PATH('response'), TYPE),
									(SELECT @syncWebFolderId AS '@syncWebFolderId', @syncWebFolderName AS '@syncWebFolderName'
									 FOR XML PATH('syncWebFolder'),TYPE)
							FOR XML PATH('App_CreateSyncWebFolderResp'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncCreateConfig')
	delete from GxQscripts where name = 'AppSyncCreateConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncCreateConfig')
	delete from GXDBVersions where aliasname = 'AppSyncCreateConfig'
GO

insert into GXDBVersions values(2, 'AppSyncCreateConfig',  '00010011000200060000', 'AppSyncCreateConfig', '00010011000200060000')
GO

