

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSyncBlackList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppSyncBlackList							|
--	|       Procedure for blacklisting a Sync laptop for edge drive		|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncBlackList <<<'

IF EXISTS (select * from sysobjects where name='AppSyncBlackList')
	drop procedure AppSyncBlackList
IF EXISTS (select * from GxQscripts where name='AppSyncBlackList')
	delete from GxQscripts where name = 'AppSyncBlackList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncBlackList')
	delete from GXDBVersions where aliasname = 'AppSyncBlackList'
GO
print '... Creating Procedure: AppSyncBlackList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncBlackList
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @workQueueParam		NVARCHAR(MAX)
	DECLARE @workQueueXML		XML
	DECLARE @workQOutPutTbl		TABLE (errCode INT, errString NVARCHAR(MAX))
	DECLARE @oscClientId		INT
	DECLARE @blacklistTranStarted INT = 0
	DECLARE @clients			TABLE(clientId INT)
	DECLARE @subclientId		INT = 0
	DECLARE @operation			INT = 0
DECLARE @UnblacklistFlag	INT = (CAST(0x20 AS INT))| (CAST(0x80 AS INT))
	-- Read the XML
	SELECT
		@operation = ISNULL(ref.value('@operation', 'INT'), 0),
		@subclientId = ISNULL(ref.value('subclient[1]/@subclientId', 'INT'), 0)
	FROM
	@i_xmlString.nodes('/App_BacklistClientsRequest') doc(ref)
	INSERT INTO @clients
	SELECT ref.value('@clientId', 'INT')
	FROM  @i_xmlString.nodes ('App_BacklistClientsRequest/clients') R(ref)
	WHERE ref.value('@clientId', 'INT') IS NOT NULL
	IF @subclientId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid subclient information specified in request.'
		GOTO ERROR_EXIT
	END
	IF @operation = 0
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Invalid operation specified in request.'
		GOTO ERROR_EXIT
	END
	IF NOT EXISTS(	SELECT 1
					FROM App_SyncCloudFolder SF (NOLOCK)
					INNER JOIN App_SyncCloudConfig SC (NOLOCK) ON SF.syncWebFolderId = SC.syncWebFolderId
					INNER JOIN @clients C ON C.clientId = SC.clientId AND SC.syncType = 3 -- Linked client
WHERE SF.flag & 0x10 = 0x10 --Edge Drive
					AND SC.subclientId = @subclientId
				 )
	BEGIN
		SET @errorCode = 3
		SET @errorString = 'Invalid client/subclient information specified in request. Blacklist is supported for edge drive linked laptops only.'
		GOTO ERROR_EXIT
	END
	BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION SyncBlackListTran
		SET @blacklistTranStarted = 1
	END
	IF @operation = 1 --Blacklist it
	BEGIN
		UPDATE SC
SET flag = flag | (CAST(0x20 AS INT)) -- Blacklisted
		FROM App_SyncCloudConfig SC
		INNER JOIN @clients C ON SC.clientId = C.clientId
		WHERE SC.subclientId = @subclientId
	END
	ELSE IF @operation = 2 -- Unblacklist it
	BEGIN
		UPDATE SC
		SET flag = flag & ~(@UnblacklistFlag)
		FROM App_SyncCloudConfig SC
		INNER JOIN @clients C ON SC.clientId = C.clientId
		WHERE SC.subclientId = @subclientId
		-- Add force sync down flag
		UPDATE SC
SET flag = flag | (CAST(0x40 AS INT)) -- Force Sync down
		FROM App_SyncCloudConfig SC
		INNER JOIN @clients C ON SC.clientId = C.clientId
		WHERE SC.subclientId = @subclientId
	END
	IF @operation = 3 --Notify Admin
	BEGIN
		UPDATE SC
SET flag = flag | (CAST(0x80 AS INT)) -- Admin Review
		FROM App_SyncCloudConfig SC
		INNER JOIN @clients C ON SC.clientId = C.clientId
		WHERE SC.subclientId = @subclientId
	END
	-- Push OSC for the clients
	DECLARE GetOSCClients CURSOR
	FOR SELECT clientId FROM @clients
	OPEN GetOSCClients
	FETCH GetOSCClients INTO @oscClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE @workQOutPutTbl
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 4, 0, 0, @oscClientId, 0, ''
		SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		IF @errorCode <> 0
		BEGIN
			CLOSE GetOSCClients
			DEALLOCATE GetOSCClients
			IF (@blacklistTranStarted = 1)
			BEGIN
				ROLLBACK TRANSACTION SyncBlackListTran
				SET @blacklistTranStarted = 0
			END
			SET @errorString = 'Blacklist operatio failed with error : ' + @errorString
			GOTO ERROR_EXIT
		END
		FETCH GetOSCClients INTO @oscClientId
	END
	CLOSE GetOSCClients
	DEALLOCATE GetOSCClients
	IF (@blacklistTranStarted = 1)
	BEGIN
		COMMIT TRANSACTION SyncBlackListTran
		SET @blacklistTranStarted = 0
	END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF (XACT_STATE() <> 0 AND @blacklistTranStarted = 1)
		BEGIN
			ROLLBACK TRANSACTION blacklistTranStarted
			SET @blacklistTranStarted = 0
			SELECT  @errorCode = 1,
					@errorString = 'Black list operation failed with error :' + ERROR_MESSAGE()
		END
	END CATCH
	ERROR_EXIT:
		SET @o_xmlString = (SELECT (
									SELECT @errorCode AS '@errorCode', @errorString AS '@errorString'
									FOR XML PATH('status'), TYPE)
							FOR XML PATH('App_BacklistClientsResponse'), TYPE)
	SELECT @o_xmlString AS o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncBlackList')
	delete from GxQscripts where name = 'AppSyncBlackList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncBlackList')
	delete from GXDBVersions where aliasname = 'AppSyncBlackList'
GO

insert into GXDBVersions values(2, 'AppSyncBlackList',  '00000000000000000000', 'AppSyncBlackList', '00000000000000000000')
GO

