

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSubmitXmlWQ.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  AppSubmitXmlWQ.sp                             			  */
/*                                                                            */
/*  Description :  Creates and Submits xml workqueue token                	  */
/*																			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSubmitXmlWQ.sp,v $ $Id: AppSubmitXmlWQ.sp,v 1.1.2.3 2018/12/06 03:15:16 pnara Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSubmitXmlWQ')
BEGIN
	print '>>> Drop Stored Procedure: AppSubmitXmlWQ <<<'
	drop procedure AppSubmitXmlWQ
END
IF EXISTS (select * from GxQscripts where name='AppSubmitXmlWQ')
	delete from GxQscripts where name = 'AppSubmitXmlWQ'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSubmitXmlWQ')
	delete from GXDBVersions where aliasname = 'AppSubmitXmlWQ'
GO
print '... Creating Procedure: AppSubmitXmlWQ'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSubmitXmlWQ
  @i_inputXML XML
AS
IF @i_inputXML IS NOT NULL
BEGIN
	DECLARE @requestID    INTEGER
	DECLARE @requestGUID uniqueidentifier = NEWID()
	DECLARE @nowTime INTEGER = datediff(second, '01/01/1970', GETUTCDATE())
	INSERT INTO APP_XMLRequestInfo
	VALUES(1 /*userId*/,'',0, @i_inputXML,'',0,@nowTime,0,0,-1,@requestGUID,0)
	SET @requestID = SCOPE_IDENTITY()
	DECLARE @wqXML XML =
	(
		SELECT 	@requestID as '@requestId', CONVERT(VARCHAR(50), @requestGUID) as '@GUID'
		FOR XML PATH('App_AsyncXMLRequestInfo')
	)
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT 2, 27,CONVERT(NVARCHAR(MAX),@wqXML),dbo.GetUnixTime(GETUTCDATE()),0,0,0,-1-- WORK_TOKEN_EXECUTE_XML_REQUEST
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSubmitXmlWQ')
	delete from GxQscripts where name = 'AppSubmitXmlWQ'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSubmitXmlWQ')
	delete from GXDBVersions where aliasname = 'AppSubmitXmlWQ'
GO

insert into GXDBVersions values(2, 'AppSubmitXmlWQ',  '00010001000200030000', 'AppSubmitXmlWQ', '00010001000200030000')
GO

