

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSqlUpdateBackupInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--        This is unpublished proprietary source code of CommVault  Systems, Inc.
--        The copyright notice above does not evidence any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSqlUpdateBackupInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppSqlUpdateBackupInfo <<<'
	drop procedure AppSqlUpdateBackupInfo
END
IF EXISTS (select * from GxQscripts where name='AppSqlUpdateBackupInfo')
	delete from GxQscripts where name = 'AppSqlUpdateBackupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSqlUpdateBackupInfo')
	delete from GXDBVersions where aliasname = 'AppSqlUpdateBackupInfo'
GO
print '... Creating Procedure: AppSqlUpdateBackupInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSqlUpdateBackupInfo
  @ioXmlInput XML OUTPUT
AS
  DECLARE @outputXML XML
-- Logic to update or insert the backup information.
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @ErrNo INT = 1
DECLARE @ErrMsg NVARCHAR(1024) = N''
BEGIN TRY
	DECLARE @OpType INT = ISNULL((Select Tbl.Col.value('@opType', 'int') From @ioXmlInput.nodes('App_SQLDBBackupMetadata') Tbl(Col)), 0)
	IF @OpType = 3 -- Verify and get backup set ID.
	BEGIN
		IF OBJECT_ID('tempdb..#SqlBackupInput') IS NOT NULL DROP TABLE #SqlBackupInput
		CREATE TABLE #SqlBackupInput(appId INT, ckpt_lsn numeric(32,0), sqlNameId INT, first_lsn numeric(32,0), instanceId INT, jobId INT, last_lsn numeric(32,0))
		INSERT INTO #SqlBackupInput
			SELECT ISNULL(Tbl.Col.value('@appId', 'INT'), 0), CAST(ISNULL(Tbl.Col.value('@checkpoint_lsn', 'NVARCHAR(32)'), N'') AS NUMERIC(32,0)),
				ISNULL(Tbl.Col.value('@databaseId', 'INT'), 0), CAST(ISNULL(Tbl.Col.value('@first_lsn', 'NVARCHAR(32)'), N'') AS NUMERIC(32,0)),
				ISNULL(Tbl.Col.value('@instanceId', 'INT'), 0), ISNULL(Tbl.Col.value('@jobId', 'INT'), 0),
				CAST(ISNULL(Tbl.Col.value('@last_lsn', 'NVARCHAR(32)'), N'') AS NUMERIC(32,0))
			FROM @ioXmlInput.nodes('App_SQLDBBackupMetadata/dbInfo') Tbl(Col)
		DECLARE @lastBackupType CHAR = 'L'
		DECLARE @backupSetId INT  = 0
		SELECT TOP 1 @backupSetId  = SDI.id, @lastBackupType  = SDI.type
			FROM sqlDbBackupInfo SDI JOIN #SqlBackupInput SI ON SI.instanceId = SDI.instanceId AND SI.sqlNameId = SDI.sqlNameId
				WHERE CONVERT(numeric(32,0), SDI.last_lsn) <= SI.last_lsn
			ORDER BY CONVERT(numeric(32,0), SDI.last_lsn) DESC
		IF @lastBackupType = 'D' OR @lastBackupType = 'I'
		BEGIN
			SET @outputXML = (SELECT 	1 AS '@operation', @backupSetId AS '@backupSetId', ASCII(@lastBackupType) AS '@backupType'
								FOR XML PATH('App_SQLUpdateBackupResp'))
			SELECT @outputXML
			RETURN
		END
		--   @@ Check if backup entry is being found or not.
		DECLARE @idBackupInfo INT = 0
		SELECT @idBackupInfo = SBI.id FROM sqlDbBackupInfo SBI
			JOIN #SqlBackupInput SI ON SI.jobId = SBI.jobId AND SI.instanceId = SBI.instanceId AND SBI.appId = SI.appId
				AND SBI.type = 'L' AND SBI.last_lsn = SI.first_lsn AND SI.sqlNameId = SBI.sqlNameId
		IF @idBackupInfo = 0
		BEGIN
			SET @outputXML = (SELECT 	1 AS '@operation', @backupSetId AS '@backupSetId', ASCII(@lastBackupType) AS '@backupType'
								FOR XML PATH('App_SQLUpdateBackupResp'))
			SELECT @outputXML
			RETURN
		END
		-- Check if same archfile is being used for the same job.
		IF OBJECT_ID('tempdb..#SqlArchFileCheck') IS NOT NULL DROP TABLE #SqlArchFileCheck
		CREATE TABLE #SqlArchFileCheck(bkpSetId INT, commcellID INT, aFileId INT,  aGroupId INT, jobId INT)
		INSERT INTO #SqlArchFileCheck
			SELECT @idBackupInfo, ISNULL(Tbl.Col.value('@commcellId', 'int'), 0), ISNULL(Tbl.Col.value('@aFileId', 'int'), 0), ISNULL(Tbl.Col.value('@aGroupId', 'INT'), N''),
				(SELECT  ISNULL(iTbl.iCol.value('@jobId', 'INT'), 0) FROM @ioXmlInput.nodes('/App_SQLDBBackupMetadata/dbInfo') as iTbl(iCol))
			FROM  @ioXmlInput.nodes('/App_SQLDBBackupMetadata/archFile') as Tbl(Col)
		IF NOT EXISTS(SELECT 1 FROM sqlArchiveInfo SA JOIN #SqlArchFileCheck SC ON SA.sqlDbBackupFileId = SC.bkpSetId
				AND SA.aFileId = SC.aFileId AND SA.backupJobId = SC.jobId AND SA.commCellId = SC.commcellID)
		BEGIN
			SET @outputXML = (SELECT 	1 AS '@operation', @backupSetId AS '@backupSetId', ASCII(@lastBackupType) AS '@backupType'
								FOR XML PATH('App_SQLUpdateBackupResp'))
			SELECT @outputXML
			RETURN
		END
		-- Check if number of files before and after Last Log is same.
		IF OBJECT_ID('tempdb..#SqlBackupFileInput') IS NOT NULL DROP TABLE #SqlBackupFileInput
		CREATE TABLE #SqlBackupFileInput(filegroupId INT, fileGroupName NVARCHAR(255), logicalFileId INT, logicalFileName NVARCHAR(255), number INT, physicalId INT, physicalFileName NVARCHAR(255))
		INSERT INTO #SqlBackupFileInput
			SELECT ISNULL(Tbl.Col.value('@fileGroupId', 'INT'), 0), ISNULL(Tbl.Col.value('@fileGroupName', 'NVARCHAR(255)'), N''), ISNULL(Tbl.Col.value('@logicalFileId', 'INT'), 0),
				ISNULL(Tbl.Col.value('@logicalFileName', 'NVARCHAR(255)'), N''), ISNULL(Tbl.Col.value('@number', 'INT'), 0), ISNULL(Tbl.Col.value('@physicalFileId', 'INT'), 0),
				ISNULL(Tbl.Col.value('@physicalFileName', 'NVARCHAR(255)'), N'')
			FROM @ioXmlInput.nodes('App_SQLDBBackupMetadata/fileInfo') Tbl(Col)
		--   @@ Check if number of files match with previous entry.
		DECLARE @nFileCOunt INT = 0
		DECLARE @nFileCOuntCurrent INT = 0
		-- Get same file counts.
		SELECT @nFileCOunt = COUNT(*)
			FROM sqlFileBackupInfo FL JOIN #SqlBackupFileInput FLN ON sqlDbBackupInfoId = @idBackupInfo AND FL.sqlNameFgId = FLN.filegroupId
				AND FL.sqlNamePhyId = FLN.physicalId AND FL.sqlNameLogId = FLN.logicalFileId
		SELECT @nFileCOuntCurrent = COUNT(*) FROM #SqlBackupFileInput
		IF NOT (@nFileCOunt <> 0 AND @nFileCOuntCurrent <> 0 AND @nFileCOuntCurrent = @nFileCOunt)
		BEGIN
			SET @outputXML = (SELECT 1 AS '@operation', 0 AS '@backupSetId', ASCII(@lastBackupType) AS '@backupType'
								FOR XML PATH('App_SQLUpdateBackupResp'))
			SELECT @outputXML
			RETURN
		END
		ELSE
		BEGIN
			SET @outputXML = (SELECT 2 AS '@operation', @idBackupInfo AS '@backupSetId', ASCII(@lastBackupType) AS '@backupType'
								FOR XML PATH('App_SQLUpdateBackupResp'))
			SELECT @outputXML
			RETURN
		END
	END
	-- Start Transaction.
	DECLARE @tranCnt INT = @@TRANCOUNT
	IF (@tranCnt > 0)
	BEGIN
		SAVE TRAN AppSqlUpdateBackupInfo_Tran
	END
	ELSE
	BEGIN
		BEGIN TRAN AppSqlUpdateBackupInfo_Tran
	END
	IF @OpType =  1 -- Insert
	BEGIN
		-- New entry into the sqlDbbackupInfo
		IF OBJECT_ID('tempdb..#tempIdBkp') IS NOT NULL DROP TABLE #tempIdBkp
		CREATE TABLE #tempIdBkp(bkpId INT, sqlNameId INT, instanceId INT, fullBkpLsn NVARCHAR(32))
		-- Insert the sqlDbBackupInfo
		--DECLARE @sqlNameId INT = ISNULL((Select Tbl.Col.value('@sqlNameId', 'int') From @ioXmlInput.nodes('App_SQLDBBackupMetadata') Tbl(Col)), 0)
		INSERT INTO sqlDbBackupInfo ([backup_set_id],[majorVersion],[minorVersion],[buildVersion], [database_creation_date],[backup_start_Date], [backup_finish_Date], [type], [instanceId],
			[appId], [backup_size], [dbId], [first_lsn], [last_lsn], [checkpoint_lsn], [full_bkup_lsn], [sqlNameId], [sqlLastLogBackup], [sqlVssFullbackupTime], [is_copy], [backupmethod],
			[backupVendor], [jobId], [replica_id],[group_database_id], [first_recovery_fork_guid], [last_recovery_fork_guid], [differential_base_guid], [database_guid], [fork_point_lsn],
			[differential_base_lsn], [compressed_backup_size], [begins_log_chain], [has_backup_checksums], [database_bkup_lsn])
				OUTPUT inserted.id, inserted.sqlNameId, inserted.instanceId, inserted.full_bkup_lsn INTO #tempIdBkp
			SELECT ISNULL(Tbl.Col.value('@backup_set_id', 'INT'), 0), ISNULL(Tbl.Col.value('@majorVersion', 'INT'), 0), ISNULL(Tbl.Col.value('@minorVersion', 'INT'), 0),
				ISNULL(Tbl.Col.value('@buildVersion', 'INT'), 0), ISNULL(Tbl.Col.value('@database_creation_date', 'INT'), 0), ISNULL(Tbl.Col.value('@backup_start_Date', 'INT'), 0),
				ISNULL(Tbl.Col.value('@backup_finish_Date', 'INT'), 0), ISNULL(Tbl.Col.value('@type', 'CHAR'), 'L'), ISNULL(Tbl.Col.value('@instanceId', 'INT'), 0),
				ISNULL(Tbl.Col.value('@appId', 'INT'), 0), ISNULL(Tbl.Col.value('@backup_size', 'BIGINT'), 0), ISNULL(Tbl.Col.value('@databaseId', 'INT'), 0),
				ISNULL(Tbl.Col.value('@first_lsn', 'NVARCHAR(32)'), N''), ISNULL(Tbl.Col.value('@last_lsn', 'NVARCHAR(32)'), N''), ISNULL(Tbl.Col.value('@checkpoint_lsn', 'NVARCHAR(32)'), N''),
				ISNULL(Tbl.Col.value('@full_bkup_lsn', 'NVARCHAR(32)'), N''), SN.id, 0, ISNULL(Tbl.Col.value('@sqlVssBackupTime', 'NVARCHAR(32)'), N''), 0, 0, 0,
				ISNULL(Tbl.Col.value('@jobId', 'INT'), 0), CAST(ISNULL(Tbl.Col.value('@replica_id', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
				CAST(ISNULL(Tbl.Col.value('@group_database_id', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
				CAST(ISNULL(Tbl.Col.value('@first_recovery_fork_guid', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
				CAST(ISNULL(Tbl.Col.value('@last_recovery_fork_guid', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
				CAST(ISNULL(Tbl.Col.value('@differential_base_guid', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
				CAST(ISNULL(Tbl.Col.value('@database_guid', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
				ISNULL(Tbl.Col.value('@fork_point_lsn', 'NVARCHAR(32)'), N''), ISNULL(Tbl.Col.value('@differential_base_lsn', 'NVARCHAR(32)'), N''),
				ISNULL(Tbl.Col.value('@compressed_backup_size', 'NVARCHAR(32)'), N''), 'N', '', N'0'
			FROM @ioXmlInput.nodes('App_SQLDBBackupMetadata/dbInfo') Tbl(Col)
				JOIN sqlNames2 SN2 ON SN2.name = ISNULL(Tbl.Col.value('@databaseName', 'NVARCHAR(255)'), N'') AND SN2.type = 1
				JOIN sqlNames SN on SN.sqlId = SN2.id AND SN.type = 1
		-- Full Backup LSN update
		-- This one covers the case where FULL was done outside the CV and log chain is not broken.
		IF NOT EXISTS(SELECT 1 FROM sqlDbBackupInfo SI JOIN #tempIdBkp ID ON SI.type = 'D' AND SI.instanceId = ID.instanceId
						AND SI.sqlNameId = ID.sqlNameId AND SI.checkpoint_lsn = ID.fullBkpLsn)
		BEGIN
			UPDATE SI SET SI.database_bkup_lsn = ID.fullBkpLsn FROM sqlDbBackupInfo SI JOIN #tempIdBkp ID ON ID.bkpId = SI.id
			-- Update FULL LSN details.
			-- Possibility of exception on NO FULL : ToDo
			UPDATE SI SET SI.full_bkup_lsn = (SELECT TOP 1 checkpoint_lsn FROM sqlDbBackupInfo SB JOIN #tempIdBkp ID ON
												SB.type = 'D' AND SB.instanceId = ID.instanceId AND SB.sqlNameId = ID.sqlNameId ORDER BY SB.backup_finish_Date DESC)
				FROM sqlDbBackupInfo SI JOIN #tempIdBkp ID ON ID.bkpId = SI.id
		END
		-- Insert the sqlArchiveInfo
		INSERT INTO sqlArchiveInfo
			SELECT (SELECT TOP 1 bkpId FROM #tempIdBkp),
				ISNULL(Tbl.Col.value('@commcellId', 'int'), 0), ISNULL(Tbl.Col.value('@aFileId', 'int'), 0), ISNULL(Tbl.Col.value('@aOffset', 'BIGINT'), N''),
				ISNULL(Tbl.Col.value('@aGroupId', 'INT'), N''),
				(SELECT  ISNULL(iTbl.iCol.value('@appId', 'INT'), 0) FROM @ioXmlInput.nodes('/App_SQLDBBackupMetadata/dbInfo') as iTbl(iCol)),
				ISNULL(Tbl.Col.value('@offsetXml', 'NVARCHAR(MAX)'), N''),
				(SELECT  ISNULL(iTbl.iCol.value('@jobId', 'INT'), 0) FROM @ioXmlInput.nodes('/App_SQLDBBackupMetadata/dbInfo') as iTbl(iCol))
			FROM  @ioXmlInput.nodes('/App_SQLDBBackupMetadata/archFile') as Tbl(Col)
		-- Insert into sqlFileBackupInfo
		INSERT INTO sqlFileBackupInfo
			SELECT (SELECT TOP 1 bkpId FROM #tempIdBkp), ISNULL(Tbl.Col.value('@number', 'int'), 0), ISNULL(Tbl.Col.value('@pageSize', 'bigint'), 0), 0,
				ISNULL(Tbl.Col.value('@type', 'int'), 0), ISNULL(Tbl.Col.value('@fileGroupId', 'INT'), 0), ISNULL(Tbl.Col.value('@physicalFileId', 'INT'), 0),
				ISNULL(Tbl.Col.value('@logicalFileId', 'INT'), 0)
			FROM @ioXmlInput.nodes('/App_SQLDBBackupMetadata/fileInfo') as Tbl(Col)
		IF (@tranCnt = 0)
		BEGIN
			COMMIT TRAN AppSqlUpdateBackupInfo_Tran
		END
		SET @outputXML = (SELECT 	1 AS '@operation', 0 AS '@backupSetId', ASCII(0) AS '@backupType',
							(SELECT 0 AS '@errorCode', N'' AS '@errorMessage' FOR XML PATH('response'), TYPE)
						  FOR XML PATH('App_SQLUpdateBackupResp'))
		SELECT @outputXML
		RETURN
	END
	ELSE IF @OpType =  2 -- Update
	BEGIN
		IF OBJECT_ID('tempdb..#SqlUpdateDbInfo') IS NOT NULL DROP TABLE #SqlUpdateDbInfo
		CREATE TABLE #SqlUpdateDbInfo (sqlDbName NVARCHAR(255), backupId INT, instanceId INT, jobId INT, finishDate INT, ckpt_LSN NUMERIC(32,0), first_LSN NUMERIC(32,0),
			fullBkpLSN NUMERIC(32,0), lastLSN NUMERIC(32,0), appId INT)
		INSERT INTO #SqlUpdateDbInfo
			SELECT ISNULL(Tbl.Col.value('@databaseName', 'NVARCHAR(255)'), 0), ISNULL(Tbl.Col.value('@backup_set_id', 'INT'), 0),  ISNULL(Tbl.Col.value('@instanceId', 'INT'), 0),
				ISNULL(Tbl.Col.value('@jobId', 'INT'), 0), ISNULL(Tbl.Col.value('@backup_finish_Date', 'INT'), 0), ISNULL(Tbl.Col.value('@checkpoint_lsn', 'NVARCHAR(32)'), N''),
				ISNULL(Tbl.Col.value('@first_lsn', 'NVARCHAR(32)'), N''), ISNULL(Tbl.Col.value('@full_bkup_lsn', 'NVARCHAR(32)'), N''), ISNULL(Tbl.Col.value('@last_lsn', 'NVARCHAR(32)'), N''),
				ISNULL(Tbl.Col.value('@appId', 'INT'), 0)
			FROM @ioXmlInput.nodes('App_SQLDBBackupMetadata/dbInfo') Tbl(Col)
		-- Update the backup information.
		UPDATE SBI SET SBI.backup_finish_Date = SI.finishDate, SBI.begins_log_chain = 'Y', SBI.last_lsn = SI.lastLSN
			FROM sqlDbBackupInfo SBI
				JOIN #SqlUpdateDbInfo SI ON SI.jobId = SBI.jobId AND SI.instanceId = SBI.instanceId --AND SBI.appId = SI.appId
					AND SBI.last_lsn = SI.first_LSN AND  SBI.id = SI.backupId
		-- Update the Afile Information.
		UPDATE SV SET SV.DbFile = (SELECT ISNULL(Tbl.Col.value('@offsetXml', 'NVARCHAR(MAX)'), N'') FROM  @ioXmlInput.nodes('/App_SQLDBBackupMetadata/archFile') as Tbl(Col))
			FROM sqlArchiveInfo SV JOIN #SqlUpdateDbInfo SU ON SU.backupId = SV.sqlDbBackupFileId
		IF (@tranCnt = 0)
		BEGIN
			COMMIT TRAN AppSqlUpdateBackupInfo_Tran
		END
		SET @outputXML = (SELECT 	1 AS '@operation', 0 AS '@backupSetId', ASCII(0) AS '@backupType',
							(SELECT 0 AS '@errorCode', N'' AS '@errorMessage' FOR XML PATH('response'), TYPE)
						  FOR XML PATH('App_SQLUpdateBackupResp'))
		SELECT @outputXML
		RETURN
	END
END TRY
BEGIN CATCH
	IF @@trancount <> 0
		ROLLBACK TRAN AppSqlUpdateBackupInfo_Tran
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @ErrNo = ERROR_MESSAGE()
	SET @ErrMsg = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
SET @outputXML = (SELECT 	0 AS '@operation', 0 AS '@backupSetId', ASCII(0) AS '@backupType',
							(SELECT @ErrNo AS '@errorCode', @ErrMsg AS '@errorMessage' FOR XML PATH('response'), TYPE)
						  FOR XML PATH('App_SQLUpdateBackupResp'))
SELECT @outputXML

IF EXISTS (select * from GxQscripts where name = 'AppSqlUpdateBackupInfo')
	delete from GxQscripts where name = 'AppSqlUpdateBackupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSqlUpdateBackupInfo')
	delete from GXDBVersions where aliasname = 'AppSqlUpdateBackupInfo'
GO

insert into GXDBVersions values(2, 'AppSqlUpdateBackupInfo',  '00000000000000000000', 'AppSqlUpdateBackupInfo', '00000000000000000000')
GO

