

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSmtpGatewayReportSetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===========================================================================+
--	|  				AppSmtpGatewayReportSetInfo									|
--	| Procedure for Set/update an APP_EmailContentStoreMailBoxProperties table	|
--	+===========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSmtpGatewayReportSetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppSmtpGatewayReportSetInfo <<<'
	drop procedure AppSmtpGatewayReportSetInfo
END
IF EXISTS (select * from GxQscripts where name='AppSmtpGatewayReportSetInfo')
	delete from GxQscripts where name = 'AppSmtpGatewayReportSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmtpGatewayReportSetInfo')
	delete from GXDBVersions where aliasname = 'AppSmtpGatewayReportSetInfo'
GO
print '... Creating Procedure: AppSmtpGatewayReportSetInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSmtpGatewayReportSetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			DATETIME = GETDATE()
	DECLARE @nowUtcTime			DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix			INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @clientId			INT = 0
	DECLARE @userId				INT = 0
	DECLARE @clientName			NVARCHAR(MAX) = ''
	DECLARE @top10RejectedIps	NVARCHAR(MAX) = ''
	DECLARE @MSGSTATS1HR	INT = 10
	DECLARE @MSGSTATS24HR	INT = 11
	DECLARE @REJSTATS		INT = 12
	DECLARE @SECINMONTH		INT = 2592000
	SELECT
		@clientName =ISNULL(ref.value('@smtpNodeName', 'NVARCHAR(MAX)'), @clientName),
		@top10RejectedIps = cast(ref.query('top10RejectedIps') as NVARCHAR(MAX))
	FROM @i_xmlString.nodes('ExchangeVirtualAgent_SmtpGatewayReport') R(ref)
	-- Get the client ID of the clientName for Assoc Id
	SET @clientId = ISNULL((SELECT TOP 1 id  from APP_Client (NOLOCK) WHERE name = @clientName),0)
	--CREATE TEMP TABLE TO INSERT XML INPUT
	IF object_id('tempdb.dbo.#smtp_XMLDetailsTable') is not null
		DROP TABLE #smtp_XMLDetailsTable
	CREATE TABLE #smtp_XMLDetailsTable
			(AssocId INT NULL DEFAULT 0,mailboxGuid VARCHAR(40) DEFAULT '',mailboxName NVARCHAR(255) NULL DEFAULT '',
			numberOfMsg1Hr INT NULL DEFAULT 0,numberOfMsg24Hr INT NULL DEFAULT 0,flagHr INT NULL DEFAULT 0, LastMsgRecTime NVARCHAR(40) NULL DEFAULT '')
	CREATE CLUSTERED INDEX #smtp_XMLDetailsTable_mailboxGUID_mailboxName_Index1 ON #smtp_XMLDetailsTable ([mailboxGUID], [mailboxName])
	INSERT #smtp_XMLDetailsTable (mailboxGuid, mailboxName, numberOfMsg1Hr,numberOfMsg24Hr, LastMsgRecTime)
			SELECT
				ISNULL(ua.value('@mailboxGuid', 'NVARCHAR(40)'), '') mailboxGuid,
				ISNULL(ua.value('@mailboxName', 'NVARCHAR(MAX)'), '') mailboxName,
				ISNULL(ua.value('@numberOfMessage1Hour', 'INT'), -1) numberOfMsg1Hr,
				ISNULL(ua.value('@numberOfMessage24Hour', 'INT'), -1) numberOfMsg24Hr,
				ISNULL(ua.value('@lastMessageReceiveTime', 'NVARCHAR(40)'),'') LastMsgRecTime
			FROM @i_xmlString.nodes ('ExchangeVirtualAgent_SmtpGatewayReport/messageStats') R(ua)
	UPDATE #smtp_XMLDetailsTable
		SET flagHr = @MSGSTATS1HR
		WHERE numberOfMsg24Hr = -1
	UPDATE #smtp_XMLDetailsTable
		SET flagHr = @MSGSTATS24HR
		WHERE numberOfMsg1Hr = -1
	UPDATE #smtp_XMLDetailsTable
		SET AssocId = EA.assocId
		FROM APP_EmailConfigPolicyAssoc (NOLOCK) AS EA
		JOIN #smtp_XMLDetailsTable AS ST ON ST.mailboxGuid = EA.userGuid AND ST.mailboxName = EA.smtpAdrress AND EA.modified = 0
	--Get rid off entries where we couldn't find SMTP mailbox in table APP_EmailConfigPolicyAssoc
	DELETE FROM #smtp_XMLDetailsTable where AssocId = 0
BEGIN TRAN
	IF @top10RejectedIps <> '' AND @clientId <> 0
	BEGIN
		UPDATE APP_EmailContentStoreMailBoxProperties
			SET modified = @nowUtcUnix
			WHERE componentNameId = @clientId AND attrType = @REJSTATS AND modified = 0
		INSERT INTO APP_EmailContentStoreMailBoxProperties (componentNameId,attrName,attrType,attrVal,created,modified)
			VALUES (@clientId,'Rejected IPs & Count',@REJSTATS,@top10RejectedIps,@nowUtcUnix,0)
		SET @errorCode = @@ERROR
		IF @errorCode != 0
		BEGIN
			GOTO ERROR
		END
	END
	UPDATE APP_EmailContentStoreMailBoxProperties
		SET modified = @nowUtcUnix
		FROM #smtp_XMLDetailsTable AS ST
		WHERE APP_EmailContentStoreMailBoxProperties.componentNameId = ST.AssocId
			AND APP_EmailContentStoreMailBoxProperties.attrType IN (@MSGSTATS24HR,@MSGSTATS1HR)
			AND APP_EmailContentStoreMailBoxProperties.modified = 0
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR
	END
	MERGE  APP_EmailContentStoreMailBoxProperties ET
	USING
	(
		SELECT * FROM #smtp_XMLDetailsTable
	) AS TT ON ET.componentNameId = TT.AssocId AND ET.attrType = TT.flagHR AND ET.modified = 0
	WHEN NOT MATCHED THEN
		INSERT(componentNameId,attrName,attrType,attrVal,created,modified)
		VALUES(
				TT.AssocId,
				TT.LastMsgRecTime,
				TT.flagHR,
				CASE WHEN TT.flagHR = @MSGSTATS1HR THEN TT.numberOfMsg1Hr ELSE TT.numberOfMsg24Hr END,
				@nowUtcUnix,
				0
			);
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR
	END
	--Remove the data older then a Month
	DELETE FROM APP_EmailContentStoreMailBoxProperties
		WHERE attrType IN (@MSGSTATS1HR,@MSGSTATS24HR,@REJSTATS)
			AND modified <> 0
			AND  (@nowUtcUnix - created) >= @SECINMONTH
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR
	END
ERROR:
IF @errorCode <>0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ERROR_EXIT:
	SET @o_xmlString =
	(
		SELECT
		(SELECT @errorCode '@errorCode',
				@errorString '@errorMessage'
				FOR XML PATH ('resp'),TYPE
				)
			FOR XML PATH(''),ROOT('Ida_EmailAssociationsResp')
	)
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#smtp_XMLDetailsTable') is not null
         DROP TABLE #smtp_XMLDetailsTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSmtpGatewayReportSetInfo')
	delete from GxQscripts where name = 'AppSmtpGatewayReportSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmtpGatewayReportSetInfo')
	delete from GXDBVersions where aliasname = 'AppSmtpGatewayReportSetInfo'
GO

insert into GXDBVersions values(2, 'AppSmtpGatewayReportSetInfo',  '00000000000000000000', 'AppSmtpGatewayReportSetInfo', '00000000000000000000')
GO

