

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSmartFolderGetPropertyDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSmartFolderGetPropertyDetails.sp,v $ $Id: AppSmartFolderGetPropertyDetails.sp,v 1.1.48.2 2018/03/22 01:33:48 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSmartFolderGetPropertyDetails"
--	|	This Procedure is used to handle the different request for VM Allocation Policy
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSmartFolderGetPropertyDetails <<<'

IF EXISTS (select * from sysobjects where name='AppSmartFolderGetPropertyDetails')
	drop procedure AppSmartFolderGetPropertyDetails
IF EXISTS (select * from GxQscripts where name='AppSmartFolderGetPropertyDetails')
	delete from GxQscripts where name = 'AppSmartFolderGetPropertyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartFolderGetPropertyDetails')
	delete from GXDBVersions where aliasname = 'AppSmartFolderGetPropertyDetails'
GO
print '... Creating Procedure: AppSmartFolderGetPropertyDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSmartFolderGetPropertyDetails
-- Input arguments
  @i_userId INT, 
  @i_localeId INT, 
  @i_folderType INT,
  @i_propId INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_propData XML;
IF (@i_propId = '0')
BEGIN
	--Send the list of all the properties
	DECLARE @temp_prop_table TABLE (id integer , ptype integer, name nvarchar(512), label nvarchar(512), lcMsgId integer,
										 			funcName nvarchar(512), complex integer)
	insert into @temp_prop_table   select id, ptype, name, label, localeMsgId, funcName, complex from [dbo].[App_SmartFolderProperty] where folderType = @i_folderType
	insert into @temp_prop_table   select id, ptype, name, label, localeMsgId, funcName, complex  from [dbo].[App_SmartFolderUserProperty] where (enabled = 1) And folderType = @i_folderType
	SET @r_propData =  ISNULL((SELECT id AS '@id', pType as '@propType', name as '@name',
				case when (lcMsgId=0) then label else dbo.fn_EvFormatEventMsgText(0,@i_localeId, lcMsgId, 0,2) end AS '@label',
											funcName as '@funcName', complex as '@isComplex' FROM @temp_prop_table order by label
										FOR XML PATH('props'), ROOT('App_SmartFolderPropListResp')
										), '<App_SmartFolderPropListResp/>')
END
ELSE
BEGIN
	--Details of a property
if (@i_propId < 100000)
	BEGIN
		SET @r_propData = ISNULL ((
											SELECT id AS '@id', pType as '@propType',  name as '@name',
											case when (localeMsgId=0) then label else dbo.fn_EvFormatEventMsgText(0,@i_localeId, localeMsgId, 0,2) end AS '@label',
											funcName as '@funcName', complex as '@isComplex'
											from dbo.App_SmartFolderProperty where id = @i_propId
											FOR XML PATH('App_SmartFolderProperty'), TYPE),
											'<App_SmartFolderProperty/>')
	END
	ELSE
	BEGIN
		SET @r_propData = ISNULL ((
											SELECT id AS '@id', pType as '@propType',  name as '@name',
											case when (localeMsgId=0) then label else dbo.fn_EvFormatEventMsgText(0,@i_localeId, localeMsgId, 0,2) end AS '@label',
											funcName as '@funcName', complex as '@isComplex'
											from dbo.App_SmartFolderUserProperty where id = @i_propId
											FOR XML PATH('App_SmartFolderProperty'), TYPE),
											'<App_SmartFolderProperty/>')
	END
END
SELECT @r_propData;
GO

IF EXISTS (select * from GxQscripts where name = 'AppSmartFolderGetPropertyDetails')
	delete from GxQscripts where name = 'AppSmartFolderGetPropertyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartFolderGetPropertyDetails')
	delete from GXDBVersions where aliasname = 'AppSmartFolderGetPropertyDetails'
GO

insert into GXDBVersions values(2, 'AppSmartFolderGetPropertyDetails',  '00010001004800020000', 'AppSmartFolderGetPropertyDetails', '00010001004800020000')
GO

