

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSmartFolderEntityAssocs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSmartFolderEntityAssocs.sp,v $ $Id: AppSmartFolderEntityAssocs.sp,v 1.2.48.2 2018/03/22 01:42:17 jiechen Exp $"
--
--  +========================================================================+
--  | Stored Precedure: AppSmartFolderEntityAssocs()
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSmartFolderEntityAssocs <<<'

IF EXISTS (select * from sysobjects where name='AppSmartFolderEntityAssocs')
	drop procedure AppSmartFolderEntityAssocs
IF EXISTS (select * from GxQscripts where name='AppSmartFolderEntityAssocs')
	delete from GxQscripts where name = 'AppSmartFolderEntityAssocs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartFolderEntityAssocs')
	delete from GXDBVersions where aliasname = 'AppSmartFolderEntityAssocs'
GO
print '... Creating Procedure: AppSmartFolderEntityAssocs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSmartFolderEntityAssocs
  @i_userId INT,
  @i_expandLevel INT,
  @i_assocXml XML
AS
  DECLARE @o_folderId INT
  DECLARE @o_clientGrp INT
  DECLARE @o_clientId INT
  DECLARE @o_appTypeId INT
  DECLARE @o_instanceId INT
  DECLARE @o_backupsetId INT
  DECLARE @o_appId INT
  DECLARE @o_status INT
  DECLARE @o_refTime INT
  DECLARE @o_entityType INT
DECLARE @ErrorMessage		NVARCHAR(4000)
DECLARE @ErrorSeverity		INT
DECLARE @ErrorState			INT
DECLARE @releaseId			INT
DECLARE @allAssociations	INT
DECLARE @commcellParam		INT
DECLARE @capability			INT
DECLARE @ERROR_STATE		INT
DECLARE @ERROR_SEVERITY		INT
DECLARE @outPutEntityXml XML
SET	@ERROR_STATE		=	1
SET @ERROR_SEVERITY		=	10
SET @ErrorSeverity		=	0
SET @ErrorState			=	0
SET @ErrorMessage		=	''
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @folderTbl TABLE
	(
		folderId	INT,
		clientGrp	INT,
		clientId	INT,
		appTypeId	INT,
		instanceId	INT,
		backupsetId INT,
		appId		INT,
		status		INT,
		refTime		INT,
		entityType	INT
	)
	DECLARE @includeEntity TABLE
	(
		entityType	INT,
		commcellId	INT,
		folderId	INT,
		clientId	INT,
		appType		INT,
		instanceId	INT,
		backupsetId INT,
		subclientId	INT,
		clientGrp	INT,
		exclude		INT
	)
	DECLARE @excludeEntity TABLE
	(
		entityType	INT,
		commcellId	INT,
		folderId	INT,
		clientId	INT,
		appType		INT,
		instanceId	INT,
		backupsetId INT,
		subclientId INT,
		clientGrp	INT,
		exclude		INT
	)
	IF OBJECT_ID('tempdb.dbo.#associatedEntitiesWithCapability') IS NOT null
	   DROP TABLE #associatedEntitiesWithCapability
	create table #associatedEntitiesWithCapability ( [capabilities] bigint NOT null, [flag] int NOT null default 0, [commCellId] int NOT null, [clientGroupId] int NOT null, [clientId] int NOT null, [appTypeId] int NOT null, [instanceId] int NOT null, [backupsetId] int NOT null, [subClientId] int NOT null, [mediaAgentId] int NOT null, [libraryId] int NOT null, [archGroupId] int NOT null, [vtContainerId] int NOT null, [vtPolicyId] int NOT null, [vtShelfId] int NOT null, [reviewSetId] int NOT null default 0, [querySetId] int NOT null default 0, [downloadSetId] int NOT null default 0, [ermId] int NOT null default 0, [legalHoldId] int NOT null default 0, [tagId] int NOT null default 0, [cdPolicyId] int NOT null default 0, [complianceReportId] int NOT null default 0, [taskId]        int	NOT null default 0, [workflowId] int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId] int	NOT null default 0, [cloudId] int	NOT null default 0, [userGroupId] int	NOT null default 0, [providerId] int	NOT null default 0, [entityId1] int	NOT null default 0, [entityId2] int	NOT null default 0, [entityId3] int	NOT null default 0, [entityId4] int	NOT null default 0, [entityId5] int	NOT null default 0, [entityId6] int	NOT null default 0, [entityId7] int	NOT null default 0, [entityId8] int	NOT null default 0, [entityId9] int	NOT null default 0)
	INSERT INTO @includeEntity
	SELECT
		ISNULL(Tbl.Col.value('@_type_', 'int'),0) ,
		ISNULL(Tbl.Col.value('@commCellId', 'int'),2) ,
		ISNULL(Tbl.Col.value('@folderId', 'int'),0) ,
		ISNULL(Tbl.Col.value('@clientId', 'int'),0),
		ISNULL(Tbl.Col.value('@applicationId', 'int'),0) ,
		ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
		ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
		ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
		ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0),
		ISNULL(Tbl.Col.value('(flags/@exclude)[1]', 'int'),0)
		FROM @i_assocXml.nodes('entity') as Tbl(Col)
	-- exclude entity should contain exlcude list
	INSERT INTO @excludeEntity
	SELECT * FROM @includeEntity WHERE exclude = 1
	-- Include entity should contain only include list
	DELETE FROM @includeEntity WHERE exclude = 1
	-- Populate the subclient information from includeEntity
	INSERT INTO @folderTbl
	--All clients
	SELECT 0, 0, A.clientId, A.appTypeId, A.instance, A.backupset, A.id, A.subclientStatus, 0, 0 FROM APP_Application as A, @includeEntity B
WHERE B.entityType in(1 , 2)
	-- Include all CLIENTGROUPS
	UNION
	SELECT 0, 0, A.clientId, A.appTypeId, A.instance, A.backupset, A.id, A.subclientStatus, 0, 0 FROM APP_Application as A, @includeEntity B, APP_ClientGroupAssoc C
WHERE B.entityType = 27 AND A.clientId = C.clientId
	--CLIENT GROUP
	UNION
	SELECT 0, 0, A.clientId, A.appTypeId, A.instance, A.backupset, A.id, A.subclientStatus, 0, 0 FROM APP_Application as A, @includeEntity B
WHERE B.entityType = 28
	AND A.clientId in(SELECT DISTINCT (clientId) FROM APP_ClientGroupAssoc where clientgroupid = B.clientGrp)
	--CLIENT
	UNION
	SELECT 0, 0, A.clientId, A.appTypeId, A.instance, A.backupset, A.id, A.subclientStatus, 0, 0 FROM APP_Application as A, @includeEntity B
WHERE B.entityType = 3
	AND A.clientId = B.clientId
	--APPTYPE
	UNION
	SELECT 0, 0, A.clientId, A.appTypeId, A.instance, A.backupset, A.id, A.subclientStatus, 0, 0 FROM APP_Application as A, @includeEntity B
WHERE B.entityType = 4
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	--INSTANCE
	UNION
	SELECT 0, 0, A.clientId, A.appTypeId, A.instance, A.backupset, A.id, A.subclientStatus, 0, 0 FROM APP_Application as A, @includeEntity B
WHERE B.entityType = 5
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	AND A.instance = B.instanceId
	--BACKUPSET
	UNION
	SELECT 0, 0, A.clientId, A.appTypeId, A.instance, A.backupset, A.id, A.subclientStatus, 0, 0 FROM APP_Application as A, @includeEntity B
WHERE B.entityType = 6
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	AND A.instance = B.instanceId
	AND A.backupset = B.backupsetId
	--SUBCLIENT
	UNION
	SELECT 0, 0, A.clientId, A.appTypeId, A.instance, A.backupset, A.id, A.subclientStatus, 0, 0 FROM APP_Application as A, @includeEntity B
WHERE B.entityType = 7
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	AND A.instance = B.instanceId
	AND A.backupset = B.backupsetId
	AND A.id = B.subclientId
	-- Filter the dummy, hidden subclient
	DELETE FROM @folderTbl where (
--				(( status & 2 ) = 2)   -- CV_STATUS_UNINSTALLED
--				OR (( status & 4 ) = 4)   -- CV_STATUS_DELETED
				(( status & 16 ) = 16)  -- CV_STATUS_DUMMY
				OR (( status & 32 ) = 32)  -- CV_STATUS_HIDDEN
				)
/*
		-- Delete DDB and SILO subclients
		DELETE @folderTbl
		FROM @folderTbl A, App_SubClientProp B where
		A.appId = B.ComponentNameId and B.AttrName in('SILO Copy ID', 'DDB Backup') and B.modified = 0
		-- Delete SnapBackup subclients or snapBackup enable any time
		DELETE @folderTbl
		FROM @folderTbl A, App_SubClientProp B where
		A.appId = B.ComponentNameId and B.AttrName in('Enable Snap Backups')
SET @capability = 22
		SET @commcellParam = 2
		EXEC sec_getUserObjects @i_userId, 0, 0, '#associatedEntitiesWithCapability'
		-- Delete those entities on which user doesn't have out of place restore capability
		DELETE FROM #associatedEntitiesWithCapability where ((capabilities & POWER(2, @capability - 1)) = 0)
		-- Now we have come to Entities(clientGrp/client/appType/instance/bs/sc), we can remove associations not involving these. like lib, ma, sp etc
		delete #associatedEntitiesWithCapability
		WHERE 	mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 or vtContainerId <> 0 or vtPolicyId <> 0 or vtShelfId <> 0
		OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
		OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
		OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
		OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
		OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
		if exists(select 1 from #associatedEntitiesWithCapability
						WHERE commCellId = @commcellParam
						AND (
clientId = -10
OR appTypeId = -10
OR instanceId = -10
OR backupSetId = -10
OR subClientId = -10
						)
						AND ((capabilities & POWER(2, @capability - 1)) > 0)
						)
		begin
			SET @allAssociations = 1
		end
		if exists(select 1 from #associatedEntitiesWithCapability
						WHERE commCellId = @commcellParam
						AND clientId    = 0
						AND appTypeId   = 0
						AND instanceId  = 0
						AND backupSetId = 0
						AND subClientId = 0
						AND ((capabilities & POWER(2, @capability - 1)) > 0)
						)
		begin
			SET @allAssociations = 1
		end
	*/
	-- Security Checks if any.
	SET @allAssociations = 1
if @i_expandLevel = 28
	begin
			DELETE FROM @folderTbl
			Where @allAssociations =0 AND
			clientGrp Not In(select AEWC.clientGroupId from #associatedEntitiesWithCapability AEWC Where ((AEWC.capabilities & POWER(2, @capability - 1)) > 0))
	end
	-- Filter based upon user capability
if @i_expandLevel = 3 OR @i_expandLevel = 2
	begin
			DELETE FROM @folderTbl
			Where @allAssociations =0 AND
			ClientId Not In(select AEWC.clientId from #associatedEntitiesWithCapability AEWC Where ((AEWC.capabilities & POWER(2, @capability - 1)) > 0))
	end
else if @i_expandLevel = 4
	begin
			DELETE @folderTbl
			FROM @folderTbl T
			Where not exists
			(
				select *From #associatedEntitiesWithCapability AEWC where
				@allAssociations =1 OR
					(
						AEWC.clientId = T.clientId and (AEWC.appTypeId = T.appTypeId or AEWC.appTypeId=0)
						and ((capabilities & POWER(2, @capability - 1)) > 0)
					)
			)
	end
else if @i_expandLevel = 5
	begin
			DELETE @folderTbl
			FROM @folderTbl T
			Where not exists
				(
				select *From #associatedEntitiesWithCapability AEWC where
				@allAssociations =1 OR
					(
						AEWC.clientId = T.clientId
						and (AEWC.appTypeId = T.appTypeId or AEWC.appTypeId=0)
						and (AEWC.instanceId = T.instanceId or AEWC.instanceId=0)
						and ((capabilities & POWER(2, @capability - 1)) > 0)
					)
			)
	end
else if @i_expandLevel = 6
	begin
			DELETE @folderTbl
			FROM @folderTbl T
			Where not exists
				(
				select *From #associatedEntitiesWithCapability AEWC where
				@allAssociations =1 OR
					(
						AEWC.clientId = T.clientId
						and (AEWC.appTypeId = T.appTypeId or AEWC.appTypeId=0)
						and (AEWC.instanceId = T.instanceId or AEWC.instanceId=0)
						and (AEWC.backupsetId = T.backupsetId or AEWC.backupsetId=0)
						and ((capabilities & POWER(2, @capability - 1)) > 0)
					)
			)
	end
else if @i_expandLevel = 7
	begin
			DELETE @folderTbl
			FROM @folderTbl T
			Where not exists
				(
				select *From #associatedEntitiesWithCapability AEWC where
				@allAssociations =1 OR
					(
						AEWC.clientId = T.clientId
						and (AEWC.appTypeId = T.appTypeId or AEWC.appTypeId=0)
						and (AEWC.instanceId = T.instanceId or AEWC.instanceId=0)
						and (AEWC.backupsetId = T.backupsetId or AEWC.backupsetId=0)
						and (AEWC.subclientId = T.appId or AEWC.subclientId=0)
						and ((capabilities & POWER(2, @capability - 1)) > 0)
					)
			)
	end
if @i_expandLevel = 28
	begin
			SET @outPutEntityXml = (select DISTINCT
			C.modified as '@modifiedTime',
			C.id as 'entity/@clientGroupId',
28 as 'entity/@_type_',
			C.name as 'entity/@clientGroupName',
(case when (C.status & 0x00004)<> 0 then 1 else 0 end) as 'entity/flags/@deleted',
(case when (C.status & 0x00002)<> 0 then 1 else 0 end) as 'entity/flags/@disabled'
			from @folderTbl T, APP_ClientGroup C
			where C.id = T.clientGrp
			order by C.modified desc
			FOR XML PATH('responses'), root('App_SmartFolderGenericResponseList'))
	end
else if @i_expandLevel = 3 OR @i_expandLevel = 2
	begin
			SET @outPutEntityXml = (select DISTINCT
			C.modified as '@modifiedTime',
			C.id as 'entity/@clientId',
3 as 'entity/@_type_',
			C.name as 'entity/@clientName',
(case when (C.status & 0x00004)<> 0 then 1 else 0 end) as 'entity/flags/@deleted',
(case when (C.status & 0x00002)<> 0 then 1 else 0 end) as 'entity/flags/@disabled'
			from @folderTbl T, APP_Client C
			where C.id = T.clientId
			order by C.modified desc
			FOR XML PATH('responses'), root('App_SmartFolderGenericResponseList'))
	end
else if @i_expandLevel = 4
	begin
			SET @outPutEntityXml = (select DISTINCT
			C.id as 'entity/@clientId',
			C.name as 'entity/@clientName',
			@i_expandLevel as 'entity/@_type_',
			Ida.type as 'entity/@applicationId',
			Ida.name as 'entity/@appName',
			IdaName.id as 'entity/@appGroupId', -- appGroupId used for avoiding exception in GUI. Not to be used. Select done mainly for Order by Clause
(case when (IdaName.status & 0x00004)<> 0 then 1 else 0 end) as 'entity/flags/@deleted',
(case when (IdaName.status & 0x00002)<> 0 then 1 else 0 end) as 'entity/flags/@disabled'
			from @folderTbl T,
			APP_Client C, APP_IDAName IdaName, APP_iDAType Ida
			where C.id = T.clientId
			and IdaName.clientId = C.id
			and IdaName.appTypeId = T.appTypeId
			and Ida.type = IdaName.appTypeId
			Order by IdaName.id desc
			FOR XML PATH('responses'), root('App_SmartFolderGenericResponseList'))
	end
else if @i_expandLevel = 5
	begin
			SET @outPutEntityXml = (select DISTINCT
			Inst.modified as '@modifiedTime',
			C.id as 'entity/@clientId',
			C.name as 'entity/@clientName',
			@i_expandLevel as 'entity/@_type_',
			Ida.type as 'entity/@applicationId',
			Ida.name as 'entity/@appName',
			Inst.id as 'entity/@instanceId',
			dbo.EncodeInvalidXMLChar(Inst.name) as 'entity/@instanceName',
(case when (Inst.status & 0x00004)<> 0 then 1 else 0 end) as 'entity/flags/@deleted',
(case when (Inst.status & 0x00002)<> 0 then 1 else 0 end) as 'entity/flags/@disabled'
			from @folderTbl T,
			APP_Client C, APP_InstanceName Inst, APP_iDAType Ida
			where C.id = T.clientId
			and Ida.type = T.appTypeId
			and Inst.id = T.instanceId
			and Ida.type = Ida.type
			order by Inst.modified desc
			FOR XML PATH('responses'), root('App_SmartFolderGenericResponseList'))
	end
else if @i_expandLevel = 6
	begin
	SET @outPutEntityXml = (select DISTINCT
			BK.modified as '@modifiedTime',
			C.id as 'entity/@clientId',
			C.name as 'entity/@clientName',
			@i_expandLevel as 'entity/@_type_',
			Ida.type as 'entity/@applicationId',
			Ida.name as 'entity/@appName',
			Inst.id as 'entity/@instanceId',
			dbo.EncodeInvalidXMLChar(Inst.name) as 'entity/@instanceName',
			BK.id as 'entity/@backupsetId',
			BK.name as 'entity/@backupsetName',
(case when (BK.status & 0x00004)<> 0 then 1 else 0 end) as 'entity/flags/@deleted',
(case when (BK.status & 0x00002)<> 0 then 1 else 0 end) as 'entity/flags/@disabled'
			from @folderTbl T,
			APP_Client C, APP_iDAType Ida, APP_InstanceName Inst,APP_BackupSetName BK
			where C.id = T.clientId
			and Ida.type = T.appTypeId
			and Inst.id = T.instanceId
			and BK.id = T.backupsetId
			order by BK.modified desc
			FOR XML PATH('responses'), root('App_SmartFolderGenericResponseList'))
	end
else if @i_expandLevel = 7
	begin
	SET @outPutEntityXml = (select DISTINCT
			(case when T.refTime>0 then T.refTime else 0 end) as '@modifiedTime',
			C.id as 'entity/@clientId',
			C.name as 'entity/@clientName',
			Ida.type as 'entity/@applicationId',
			Ida.name as 'entity/@appName',
			Inst.id as 'entity/@instanceId',
			@i_expandLevel as 'entity/@_type_',
			dbo.EncodeInvalidXMLChar(Inst.name) as 'entity/@instanceName',
			BK.id as 'entity/@backupsetId',
			BK.name as 'entity/@backupsetName',
			SC.id as 'entity/@subclientId',
			SC.subclientName as 'entity/@subclientName',
(case when (SC.subclientStatus & 0x00004)<> 0 then 1 else 0 end) as 'entity/flags/@deleted',
(case when (SC.subclientStatus & 0x00002)<> 0 then 1 else 0 end) as 'entity/flags/@disabled'
			from @folderTbl T,
			APP_Client C, APP_iDAType Ida, APP_InstanceName Inst,APP_BackupSetName BK,APP_Application SC
			where C.id = T.clientId
			and Ida.type = T.appTypeId
			and Inst.id = T.instanceId
			and BK.id = T.backupsetId
			and Sc.id = T.appId
			Order by (case when T.refTime>0 then T.refTime else 0 end)
			FOR XML PATH('responses'), root('App_SmartFolderGenericResponseList'))
	end
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @outPutEntityXml = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
END CATCH
SELECT @outPutEntityXml
DROP TABLE #associatedEntitiesWithCapability
--IF @ErrorSeverity <> 0 OR @ErrorState <> 0
--	RAISERROR(@ErrorMessage,@ErrorSeverity,@ErrorState)
END
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSmartFolderEntityAssocs')
	delete from GxQscripts where name = 'AppSmartFolderEntityAssocs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSmartFolderEntityAssocs')
	delete from GXDBVersions where aliasname = 'AppSmartFolderEntityAssocs'
GO

insert into GXDBVersions values(2, 'AppSmartFolderEntityAssocs',  '00010002004800020000', 'AppSmartFolderEntityAssocs', '00010002004800020000')
GO

